/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class EntityGiant
extends EntityFriendlyCreature {
    public EntityGiant(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 12.0f);
        this.field_70138_W = 3.0f;
        this.isOffensive = true;
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 48.0f, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
        this.field_70728_aV = 50;
        this.field_70158_ak = true;
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    protected int getTimeBetweenSteps() {
        return 10;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER5;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 3;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (!(stack != null || this.field_70170_p.field_72995_K || this.isWild() || player != this.getOwner() && !player.func_184191_r((Entity)this))) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int i = this.func_184188_bt().indexOf(passenger);
            float f3 = this.field_70761_aq * (float)Math.PI / 180.0f;
            float f11 = MathHelper.func_76126_a((float)f3);
            float f4 = MathHelper.func_76134_b((float)f3);
            if (i == 2) {
                passenger.func_70107_b(this.field_70165_t - (double)(f4 * 2.25f), this.field_70163_u + (this.isHero() ? 9.0 : 8.5), this.field_70161_v - (double)(f11 * 2.25f));
            }
            if (i == 1) {
                passenger.func_70107_b(this.field_70165_t + (double)(f4 * 2.25f), this.field_70163_u + (this.isHero() ? 9.0 : 8.5), this.field_70161_v + (double)(f11 * 2.25f));
            }
            if (i == 0) {
                passenger.func_70107_b(this.field_70165_t, this.field_70163_u + (this.isHero() ? 12.0 : 11.5), this.field_70161_v);
            }
        }
    }

    public float func_70047_e() {
        return 10.440001f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(15.0);
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = 10.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.1f;
            this.field_184619_aG += this.field_70721_aZ;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(2.0, 0.0, 2.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity)) continue;
                this.func_70652_k(entity);
                double d01 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
                double d11 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
                double d2 = entity.field_70165_t - d01;
                double d3 = entity.field_70161_v - d11;
                double d4 = d2 * d2 + d3 * d3;
                entity.func_70024_g(d2 / d4 * 6.0, 0.25, d3 / d4 * 6.0);
                if (!(entity.field_70131_O >= 1.0f)) continue;
                this.func_70024_g(-(d2 / d4 * 1.25), 0.25, -(d3 / d4 * 1.25));
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        if (this.isHero() && !this.isWild() && this.field_70170_p.field_72995_K) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 3.0f * 2.0f) - 3.0 - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 12.0f) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 3.0f * 2.0f) - 3.0 - d2 * d3, d0, (double)0.1f, d2, new int[0]);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.getSpecialAttackTimer() <= 0 && this.field_70122_E && this.isHero()) {
            this.performSpecialAttack();
        }
        this.field_70138_W = 3.0f;
        super.func_70636_d();
        if (this.field_70159_w != 0.0 && this.field_70179_y != 0.0 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.field_70173_aa % 60 == 0) {
            this.func_70652_k((Entity)this.func_70638_az());
        }
    }

    @Override
    public void performSpecialAttack() {
        this.field_70181_x = 2.0;
        this.func_184185_a(ModSoundEvents.golemSpecial, 10.0f, 0.75f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.setSpecialAttackTimer(500);
            this.func_184185_a(ModSoundEvents.golemSmash, 10.0f, 0.9f);
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u - 3.0, this.field_70161_v, 6.0f, false);
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(48.0, 3.0, 48.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null) continue;
                    if (!this.isOnSameTeam(entity)) {
                        entity.field_70181_x += 3.0;
                        if (entity instanceof IMob) {
                            entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this), 50.0f);
                        } else {
                            entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this), 25.0f);
                        }
                        entity.field_70160_al = true;
                        float f = MathHelper.func_76133_a((double)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) + -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        entity.field_70159_w /= 2.0;
                        entity.field_70179_y /= 2.0;
                        entity.field_70159_w -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                        entity.field_70179_y -= (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                    }
                    if (entity.func_70089_S() || this.isWild()) continue;
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was blown up by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
        }
    }

    @Override
    public Entity func_184179_bs() {
        return super.func_184179_bs();
    }

    public boolean func_184186_bw() {
        return super.func_184186_bw();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187566_ao, 3.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.75f);
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 5.0f;
    }

    protected Item func_146068_u() {
        return Items.field_151078_bh;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        int j = this.field_70146_Z.nextInt(13) + this.field_70146_Z.nextInt(1 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151008_G, 1);
        }
        j = this.field_70146_Z.nextInt(13) + this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151078_bh, 1);
        }
        if (p_70628_1_ && (this.field_70146_Z.nextInt(5) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
            this.func_145779_a(Items.field_151042_j, 1);
        }
        if (p_70628_1_ && (this.field_70146_Z.nextInt(5) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
            this.func_145779_a(Items.field_151172_bF, 1);
        }
        if (p_70628_1_ && (this.field_70146_Z.nextInt(5) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
            this.func_145779_a(Items.field_151174_bG, 1);
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                this.func_145779_a(Items.field_151037_a, 1);
                break;
            }
            case 1: {
                this.func_145779_a(Items.field_151040_l, 1);
                break;
            }
            case 2: {
                this.func_145779_a((Item)Items.field_151028_Y, 1);
            }
        }
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.5f;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.fleshHitCrushHeavy;
    }
}

