/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier5.dragonphases.EntityDragonFireballOther;
import net.minecraft.entity.helpful.tier5.dragonphases.IPhase;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseList;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseManager;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenEndPodium;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEnderDragon
extends EntityFriendlyCreature
implements IEntityMultiPart {
    public static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(EntityEnderDragon.class, (DataSerializer)DataSerializers.field_187192_b);
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public EntityDragonPart[] dragonPartArray;
    public EntityDragonPart dragonPartHead;
    public EntityDragonPart dragonPartNeck;
    public EntityDragonPart dragonPartBody;
    public EntityDragonPart dragonPartTail1;
    public EntityDragonPart dragonPartTail2;
    public EntityDragonPart dragonPartTail3;
    public EntityDragonPart dragonPartWing1;
    public EntityDragonPart dragonPartWing2;
    public float prevAnimTime;
    public float animTime;
    public boolean slowed;
    public int deathTicks;
    public EntityEnderCrystal healingEnderCrystal;
    private final PhaseManager phaseManager;
    private int field_184678_bK = 200;
    private int field_184679_bL;
    private final PathPoint[] pathPoints = new PathPoint[24];
    private final int[] neighbors = new int[24];
    private final PathHeap pathFindQueue = new PathHeap();
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer((ITextComponent)new TextComponentTranslation(this.func_70005_c_(), new Object[0]), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(false);

    public EntityEnderDragon(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.dragonPartHead = new EntityDragonPart((IEntityMultiPart)this, "head", 6.0f, 6.0f);
        this.dragonPartNeck = new EntityDragonPart((IEntityMultiPart)this, "neck", 6.0f, 6.0f);
        this.dragonPartBody = new EntityDragonPart((IEntityMultiPart)this, "body", 8.0f, 8.0f);
        this.dragonPartTail1 = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.dragonPartTail2 = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.dragonPartTail3 = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.dragonPartWing1 = new EntityDragonPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
        this.dragonPartWing2 = new EntityDragonPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
        this.dragonPartArray = new EntityDragonPart[]{this.dragonPartHead, this.dragonPartNeck, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2};
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(16.0f, 8.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
        this.phaseManager = new PhaseManager(this);
        this.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
        if (this.getOwner() == null) {
            double d0 = 512.0;
            List list = this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(d0, 6.0, d0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityPlayer entity = (EntityPlayer)list.get(i1);
                    if (entity == null) continue;
                    this.setOwnerId(entity.func_110124_au());
                }
            } else {
                this.setOwnerId(null);
            }
        }
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER5;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(256.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(18.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PHASE, (Object)PhaseList.HOLDING_PATTERN.getId());
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
        this.phaseManager.setPhase(PhaseList.DYING);
        this.func_70609_aI();
    }

    public float func_70047_e() {
        return 2.325f;
    }

    public double[] getMovementOffsets(int p_70974_1_, float p_70974_2_) {
        if (this.func_110143_aJ() <= 0.0f) {
            p_70974_2_ = 0.0f;
        }
        p_70974_2_ = 1.0f - p_70974_2_;
        int i = this.ringBufferIndex - p_70974_1_ & 0x3F;
        int j = this.ringBufferIndex - p_70974_1_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = MathHelper.func_76138_g((double)(this.ringBuffer[j][0] - d0));
        adouble[0] = d0 + d1 * (double)p_70974_2_;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_70974_2_;
        adouble[2] = this.ringBuffer[i][2] + (this.ringBuffer[j][2] - this.ringBuffer[i][2]) * (double)p_70974_2_;
        return adouble;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (!(stack != null || this.field_70170_p.field_72995_K || this.isWild() || player != this.getOwner() && !player.func_184191_r((Entity)this))) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    public double func_70042_X() {
        return 3.25;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 5;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int i = this.func_184188_bt().indexOf(passenger);
            float f4 = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180) - this.field_70704_bt * 0.01f));
            float f20 = -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180) - this.field_70704_bt * 0.01f));
            float f14 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
            float f16 = -MathHelper.func_76134_b((float)f14);
            float f18 = -MathHelper.func_76126_a((float)f14);
            float f5 = this.func_184662_q(1.0f);
            if (i > 0) {
                passenger.func_70107_b(this.field_70165_t - (double)(f4 * ((float)i * 0.6f) * f16), this.field_70163_u + (double)this.func_70047_e() + 1.0 + (double)f5 + (double)(f18 * (float)i), this.field_70161_v - (double)(f20 * ((float)i * 0.6f) * f16));
            } else {
                passenger.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.25, this.field_70161_v);
            }
        }
    }

    @Override
    public void performSpecialAttack() {
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.setSpecialAttackTimer(2000);
    }

    public void func_70625_a(Entity entityIn, float p_70625_2_, float p_70625_3_) {
        double d1;
        double d0 = entityIn.field_70165_t - this.field_70165_t;
        double d2 = entityIn.field_70161_v - this.field_70161_v;
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entityIn;
            d1 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            d1 = (entityIn.func_174813_aQ().field_72338_b + entityIn.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        this.field_70125_A = this.updateRotation(this.field_70125_A, f1, p_70625_3_);
        this.field_70759_as = this.updateRotation(this.field_70759_as, f, p_70625_2_);
    }

    private float updateRotation(float p_70663_1_, float p_70663_2_, float p_70663_3_) {
        float f = MathHelper.func_76142_g((float)(p_70663_2_ - p_70663_1_));
        if (f > p_70663_3_) {
            f = p_70663_3_;
        }
        if (f < -p_70663_3_) {
            f = -p_70663_3_;
        }
        return p_70663_1_ + f;
    }

    @Override
    public void func_70636_d() {
        int i1;
        double d3;
        double d2;
        double d1;
        double d0;
        if (this.isWild()) {
            if (this.field_70170_p.field_72995_K) {
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d3 = 10.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.TOWN_AURA, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
            }
        } else {
            if (this.func_70638_az() != null) {
                this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 60.0f);
            } else if (!this.isWild()) {
                this.field_70759_as = this.field_70177_z;
            }
            this.convertionInt = 0;
            if (this.isHero() && this.field_70170_p.field_72995_K) {
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d3 = 10.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.dragonPartBody.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.dragonPartBody.field_70130_N * 2.0f) - (double)this.dragonPartBody.field_70130_N - d0 * d3, this.dragonPartBody.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.dragonPartBody.field_70131_O) - d1 * d3, this.dragonPartBody.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.dragonPartBody.field_70130_N * 2.0f) - (double)this.dragonPartBody.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.dragonPartHead.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.dragonPartHead.field_70130_N * 2.0f) - (double)this.dragonPartHead.field_70130_N - d0 * d3, this.dragonPartHead.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.dragonPartHead.field_70131_O) - d1 * d3, this.dragonPartHead.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.dragonPartHead.field_70130_N * 2.0f) - (double)this.dragonPartHead.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.dragonPartNeck.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.dragonPartNeck.field_70130_N * 2.0f) - (double)this.dragonPartNeck.field_70130_N - d0 * d3, this.dragonPartNeck.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.dragonPartNeck.field_70131_O) - d1 * d3, this.dragonPartNeck.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.dragonPartNeck.field_70130_N * 2.0f) - (double)this.dragonPartNeck.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.dragonPartWing1.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.dragonPartWing1.field_70130_N * 2.0f) - (double)this.dragonPartWing1.field_70130_N - d0 * d3, this.dragonPartWing1.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.dragonPartWing1.field_70131_O) - d1 * d3, this.dragonPartWing1.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.dragonPartWing1.field_70130_N * 2.0f) - (double)this.dragonPartWing1.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.dragonPartWing2.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.dragonPartWing2.field_70130_N * 2.0f) - (double)this.dragonPartWing2.field_70130_N - d0 * d3, this.dragonPartWing2.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.dragonPartWing2.field_70131_O) - d1 * d3, this.dragonPartWing2.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.dragonPartWing2.field_70130_N * 2.0f) - (double)this.dragonPartWing2.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.dragonPartTail1.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.dragonPartTail1.field_70130_N * 2.0f) - (double)this.dragonPartTail1.field_70130_N - d0 * d3, this.dragonPartTail1.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.dragonPartTail1.field_70131_O) - d1 * d3, this.dragonPartTail1.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.dragonPartTail1.field_70130_N * 2.0f) - (double)this.dragonPartTail1.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.dragonPartTail2.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.dragonPartTail2.field_70130_N * 2.0f) - (double)this.dragonPartTail2.field_70130_N - d0 * d3, this.dragonPartTail2.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.dragonPartTail2.field_70131_O) - d1 * d3, this.dragonPartTail2.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.dragonPartTail2.field_70130_N * 2.0f) - (double)this.dragonPartTail2.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.dragonPartTail3.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.dragonPartTail3.field_70130_N * 2.0f) - (double)this.dragonPartTail3.field_70130_N - d0 * d3, this.dragonPartTail3.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.dragonPartTail3.field_70131_O) - d1 * d3, this.dragonPartTail3.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.dragonPartTail3.field_70130_N * 2.0f) - (double)this.dragonPartTail3.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
            }
        }
        if (this.getOwner() == null) {
            d0 = 512.0;
            List list = this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(d0, 6.0, d0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
            if (list != null && !list.isEmpty()) {
                for (i1 = 0; i1 < list.size(); ++i1) {
                    EntityPlayer entity = (EntityPlayer)list.get(i1);
                    if (entity == null) continue;
                    this.setOwnerId(entity.func_110124_au());
                }
            } else {
                this.setOwnerId(null);
            }
        }
        if (this.field_70146_Z.nextInt(5) == 0 && !this.isWild() && this.getOwner().func_70643_av() != null && this.isOffensive) {
            this.func_70624_b(this.getOwner().func_70643_av());
        }
        this.field_70145_X = true;
        if (this.func_70093_af()) {
            this.bossInfo.func_186758_d(false);
        } else if (this.func_70089_S()) {
            this.bossInfo.func_186758_d(true);
        }
        this.func_70105_a(16.0f, 3.6f);
        this.field_70122_E = false;
        this.field_70160_al = true;
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.field_70173_aa % 5 == 0) {
            this.slowed = false;
        }
        if (this.moralRaisedTimer <= 0) {
            this.moralRaisedTimer = 0;
        }
        if (this.moralRaisedTimer > 0) {
            --this.moralRaisedTimer;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70606_j(this.func_110143_aJ());
            if (!this.func_174814_R()) {
                float f = MathHelper.func_76134_b((float)(this.animTime * ((float)Math.PI * 2)));
                float f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * ((float)Math.PI * 2)));
                if (f1 <= -0.3f && f >= -0.3f) {
                    if (this.func_70093_af()) {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    } else {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    }
                }
                if (!this.phaseManager.getCurrentPhase().getIsStationary() && --this.field_184678_bK < 0) {
                    if (this.func_70093_af()) {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    } else {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    }
                    this.field_184678_bK = 200 + this.field_70146_Z.nextInt(200);
                }
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.getSpecialAttackTimer() > 0) {
            if (this.moralRaisedTimer > 200) {
                this.setSpecialAttackTimer(this.getSpecialAttackTimer() - 2);
            } else {
                this.setSpecialAttackTimer(this.getSpecialAttackTimer() - 1);
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            float f13 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f15 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f17 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)f13, this.field_70163_u + 2.0 + (double)f15, this.field_70161_v + (double)f17, 0.0, 0.0, 0.0, new int[0]);
        } else {
            EntityDragonFireballOther entitydragonfireball;
            double d11;
            double d10;
            double d9;
            double d8;
            double d7;
            List list;
            if (!this.getPhaseManager().getCurrentPhase().getIsStationary() && this.getPhaseManager().getCurrentPhase() != PhaseList.CHARGING_PLAYER && this.getPhaseManager().getCurrentPhase() != PhaseList.STRAFE_PLAYER && this.getPhaseManager().getCurrentPhase() != PhaseList.TAKEOFF && this.func_70638_az() != null && this.field_70173_aa % 20 == 0 && this.func_70681_au().nextInt(5) == 0) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.getPhaseManager().setPhase(PhaseList.CHARGING_PLAYER);
                        this.getPhaseManager().getPhase(PhaseList.CHARGING_PLAYER).func_188668_a(new Vec3d(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
                        break;
                    }
                    case 1: {
                        this.getPhaseManager().setPhase(PhaseList.STRAFE_PLAYER);
                        this.getPhaseManager().getPhase(PhaseList.STRAFE_PLAYER).func_188686_a(this.func_70638_az());
                        break;
                    }
                    case 2: {
                        this.getPhaseManager().setPhase(PhaseList.TAKEOFF);
                    }
                }
            }
            if (this.isHero() && this.getSpecialAttackTimer() > 1980 && (list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(256.0, 256.0, 256.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty()) {
                for (int i12 = 0; i12 < list.size(); ++i12) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i12);
                    if (entity == null || this.isOnSameTeam(entity)) continue;
                    double d6 = this.field_70165_t + (this.field_70146_Z.nextDouble() * 32.0 - 16.0);
                    d7 = this.field_70163_u + 64.0 + (this.field_70146_Z.nextDouble() * 32.0 - 16.0);
                    d8 = this.field_70161_v + (this.field_70146_Z.nextDouble() * 32.0 - 16.0);
                    d9 = entity.field_70165_t - d6;
                    d10 = entity.field_70163_u + (double)(entity.field_70131_O / 2.0f) - (d7 + (double)(this.field_70131_O / 2.0f));
                    d11 = entity.field_70161_v - d8;
                    this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
                    entitydragonfireball = new EntityDragonFireballOther(this.field_70170_p, (EntityLivingBase)this, d9, d10, d11);
                    entitydragonfireball.field_70165_t = d6;
                    entitydragonfireball.field_70163_u = d7;
                    entitydragonfireball.field_70161_v = d8;
                    this.field_70170_p.func_72838_d((Entity)entitydragonfireball);
                    entitydragonfireball.shouldMakeCloud = false;
                }
            }
            if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
                this.performSpecialAttack();
            }
            if (this.func_184207_aI() && this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
                EntityPlayer passenger = (EntityPlayer)this.func_184179_bs();
                this.getPhaseManager().setPhase(PhaseList.LANDING);
                this.field_70177_z = passenger.field_70177_z - 180.0f;
                this.field_70125_A = passenger.field_70125_A;
                for (int i = 0; i < 256; ++i) {
                    double d12 = 0.005;
                    if (this.moralRaisedTimer > 200) {
                        d12 *= 2.0;
                    }
                    Vec3d vec3 = passenger.func_70676_i(1.0f);
                    if (passenger.field_70701_bs > 0.0f) {
                        this.func_70107_b(this.field_70165_t + vec3.field_72450_a * d12, this.field_70163_u + vec3.field_72448_b * d12, this.field_70161_v + vec3.field_72449_c * d12);
                    }
                    if (!(passenger.field_70701_bs < 0.0f)) continue;
                    this.func_70107_b(this.field_70165_t - vec3.field_72450_a * d12, this.field_70163_u - vec3.field_72448_b * d12, this.field_70161_v - vec3.field_72449_c * d12);
                }
            }
            if (!this.isWild() && this.getOwner().func_70051_ag()) {
                this.func_70031_b(true);
            } else {
                this.func_70031_b(false);
            }
            if (!this.isWild() && this.getOwner().func_70093_af()) {
                this.func_70095_a(true);
            } else {
                this.func_70095_a(false);
            }
            if (this.func_70093_af() && !this.getPhaseManager().getCurrentPhase().getIsStationary() && this.field_70146_Z.nextInt(100) == 0) {
                this.getPhaseManager().setPhase(PhaseList.LANDING_APPROACH);
            }
            if (!this.getPhaseManager().getCurrentPhase().getIsStationary() && this.getOwner() != null && this.getOwner().func_110143_aJ() <= 6.0f && this.func_70681_au().nextInt(20) == 0) {
                this.getPhaseManager().setPhase(PhaseList.STRAFE_PLAYER);
                this.getPhaseManager().getPhase(PhaseList.STRAFE_PLAYER).func_188686_a(this.getOwner());
            }
            if (this.field_70173_aa % 40 == 0) {
                if (this.func_70638_az() == null) {
                    this.func_70691_i(5.0f);
                } else {
                    this.func_70691_i(1.0f);
                }
            }
            if (this.getOwner() == null) {
                if (this.field_70146_Z.nextInt(100) == 0 && this.field_70173_aa % 1 == 0) {
                    double d02 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                    List list2 = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(d02, d02, d02), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                    if (list2 != null && !list2.isEmpty()) {
                        for (i1 = 0; i1 < list2.size(); ++i1) {
                            Entity entity = (Entity)list2.get(i1);
                            if (!(entity instanceof EntityPlayer)) continue;
                            this.setOwnerId(entity.func_110124_au());
                        }
                    }
                }
            } else if (this.func_70068_e((Entity)this.getOwner()) >= 48400.0) {
                this.func_70012_b(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v, this.field_70177_z, this.field_70125_A);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70638_az().func_70685_l((Entity)this) && this.field_70146_Z.nextInt(160) == 0) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.dragonPartWing1.field_70165_t - 0.5, this.dragonPartWing1.field_70163_u, this.dragonPartWing1.field_70161_v - 0.5, true));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.dragonPartWing2.field_70165_t - 0.5, this.dragonPartWing2.field_70163_u, this.dragonPartWing2.field_70161_v - 0.5, true));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t - 0.5, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v - 0.5, false));
                this.func_70638_az().func_70097_a(DamageSource.field_188406_j.func_82726_p(), 20.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70638_az().func_70685_l((Entity)this) && this.field_70146_Z.nextInt(160) == 0) {
                double d14 = 8.0;
                Vec3d vec3d2 = this.func_70676_i(1.0f);
                double d6 = this.dragonPartHead.field_70165_t;
                d7 = this.field_70163_u + (double)(this.field_70131_O / 2.0f);
                d8 = this.dragonPartHead.field_70161_v;
                d9 = this.func_70638_az().field_70165_t - d6;
                d10 = this.func_70638_az().field_70163_u + 2.0 - d7;
                d11 = this.func_70638_az().field_70161_v - d8;
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
                entitydragonfireball = new EntityDragonFireballOther(this.field_70170_p, (EntityLivingBase)this, d9, d10, d11);
                entitydragonfireball.field_70165_t = d6;
                entitydragonfireball.field_70163_u = d7;
                entitydragonfireball.field_70161_v = d8;
                this.field_70170_p.func_72838_d((Entity)entitydragonfireball);
            }
            if (this.field_70146_Z.nextInt(2) == 0 && !this.isWild() && this.getOwner().func_70643_av() != null) {
                this.func_70624_b(this.getOwner().func_70643_av());
            }
            if (!(this.func_70638_az() == null || this.func_70638_az().func_70089_S() && this.isOffensive && !this.isOnSameTeam(this.func_70638_az()))) {
                this.func_70624_b(null);
            }
            if (this.getOwner() != null && this.func_70638_az() == null && this.field_70146_Z.nextInt(10) == 0) {
                double d03 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                List list3 = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(d03, d03, d03), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                if (list3 != null && !list3.isEmpty()) {
                    for (int i13 = 0; i13 < list3.size(); ++i13) {
                        Entity entity = (Entity)list3.get(i13);
                        if (entity != null && entity.func_70089_S() && this.func_70685_l(entity) && !this.isOnSameTeam((EntityLivingBase)entity) && this.func_70068_e((Entity)this.getOwner()) < 2000.0) {
                            this.func_70624_b((EntityLivingBase)entity);
                            continue;
                        }
                        list3.remove(entity);
                    }
                }
            }
            this.updateDragonEnderCrystal();
            float f12 = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
            this.animTime = this.func_184207_aI() ? (this.animTime += f12 * 0.5f) : (this.phaseManager.getCurrentPhase().getIsStationary() || this.getPhaseManager().getCurrentPhase() == PhaseList.CHARGING_PLAYER ? (this.func_70093_af() ? (this.animTime += 0.05f) : (this.animTime += 0.1f)) : (this.slowed ? (this.animTime += f12 * 0.5f) : (this.animTime += (f12 *= (float)Math.pow(2.0, this.field_70181_x)))));
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            if (this.func_175446_cd()) {
                this.animTime = 0.5f;
            } else {
                if (this.ringBufferIndex < 0) {
                    for (int i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.field_70177_z;
                        this.ringBuffer[i][1] = this.field_70163_u;
                    }
                }
                if (++this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
                this.ringBuffer[this.ringBufferIndex][1] = this.field_70163_u;
                if (this.field_70170_p.field_72995_K) {
                    if (this.field_70716_bi > 0) {
                        double d5 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
                        double d04 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
                        double d13 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
                        double d22 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                        this.field_70177_z = (float)((double)this.field_70177_z + d22 / (double)this.field_70716_bi);
                        this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                        --this.field_70716_bi;
                        this.func_70107_b(d5, d04, d13);
                        this.func_70101_b(this.field_70177_z, this.field_70125_A);
                    }
                    this.phaseManager.getCurrentPhase().doClientRenderEffects();
                } else {
                    Vec3d vec3d;
                    IPhase iphase = this.phaseManager.getCurrentPhase();
                    if (!this.isWild()) {
                        iphase.doLocalUpdate();
                    }
                    if (this.phaseManager.getCurrentPhase() != iphase) {
                        iphase = this.phaseManager.getCurrentPhase();
                        iphase.doLocalUpdate();
                    }
                    if ((vec3d = iphase.getTargetLocation()) != null) {
                        double d6 = vec3d.field_72450_a - this.field_70165_t;
                        d7 = vec3d.field_72448_b - this.field_70163_u;
                        d8 = vec3d.field_72449_c - this.field_70161_v;
                        if (this.func_184207_aI()) {
                            double look = 2.0;
                            Vec3d vec3 = this.func_70676_i(1.0f);
                            d6 = this.field_70165_t + vec3d.field_72450_a * look;
                            d7 = this.field_70163_u + vec3d.field_72448_b * look;
                            d8 = this.field_70165_t + vec3d.field_72449_c * look;
                        }
                        double d32 = d6 * d6 + d7 * d7 + d8 * d8;
                        float f6 = iphase.getMaxRiseOrFall();
                        d7 = MathHelper.func_151237_a((double)(d7 / (double)MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8))), (double)(-f6), (double)f6);
                        this.field_70181_x += d7 * (double)0.1f;
                        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                        double d4 = MathHelper.func_151237_a((double)MathHelper.func_76138_g((double)(180.0 - MathHelper.func_181159_b((double)d6, (double)d8) * 57.29577951308232 - (double)this.field_70177_z)), (double)-50.0, (double)50.0);
                        Vec3d vec3d1 = new Vec3d(vec3d.field_72450_a - this.field_70165_t, vec3d.field_72448_b - this.field_70163_u, vec3d.field_72449_c - this.field_70161_v).func_72432_b();
                        Vec3d vec3d2 = new Vec3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), this.field_70181_x, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))))).func_72432_b();
                        float f8 = Math.max(((float)vec3d2.func_72430_b(vec3d1) + 0.5f) / 1.5f, 0.0f);
                        this.field_70704_bt *= 0.8f;
                        this.field_70704_bt = (float)((double)this.field_70704_bt + d4 * (double)iphase.getYawFactor());
                        this.field_70177_z += this.field_70704_bt * 0.1f;
                        float f9 = (float)(2.0 / (d32 + 1.0));
                        float f10 = 0.06f;
                        this.func_70060_a(0.0f, -1.0f, f10 * (f8 * f9 + (1.0f - f9)));
                        if (this.getPhaseManager().getCurrentPhase() == PhaseList.CHARGING_PLAYER) {
                            if (this.func_70093_af()) {
                                this.func_70091_d(this.field_70159_w * 0.25, this.field_70181_x * 0.25, this.field_70179_y * 0.25);
                            } else if (this.moralRaisedTimer > 200) {
                                this.func_70091_d(this.field_70159_w * 10.0, this.field_70181_x * 10.0, this.field_70179_y * 10.0);
                            } else {
                                this.func_70091_d(this.field_70159_w * 5.0, this.field_70181_x * 5.0, this.field_70179_y * 5.0);
                            }
                        } else {
                            if (this.func_70093_af()) {
                                this.func_70091_d(this.field_70159_w * 0.25, this.field_70181_x * 0.25, this.field_70179_y * 0.25);
                            }
                            if (this.moralRaisedTimer > 200) {
                                this.func_70091_d(this.field_70159_w * 2.0, this.field_70181_x * 2.0, this.field_70179_y * 2.0);
                            } else {
                                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                            }
                        }
                        Vec3d vec3d3 = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
                        float f11 = ((float)vec3d3.func_72430_b(vec3d2) + 1.0f) / 2.0f;
                        f11 = 0.8f + 0.15f * f11;
                        if (this.func_184207_aI()) {
                            f11 = 0.91f;
                        }
                        this.field_70159_w *= (double)f11;
                        this.field_70179_y *= (double)f11;
                        this.field_70181_x *= (double)0.91f;
                    }
                }
                this.field_70761_aq = this.field_70177_z;
                this.dragonPartHead.field_70131_O = 3.0f;
                this.dragonPartHead.field_70130_N = 3.0f;
                this.dragonPartNeck.field_70131_O = 3.0f;
                this.dragonPartNeck.field_70130_N = 3.0f;
                this.dragonPartTail1.field_70131_O = 2.0f;
                this.dragonPartTail1.field_70130_N = 2.0f;
                this.dragonPartTail2.field_70131_O = 2.0f;
                this.dragonPartTail2.field_70130_N = 2.0f;
                this.dragonPartTail3.field_70131_O = 2.0f;
                this.dragonPartTail3.field_70130_N = 2.0f;
                this.dragonPartBody.field_70131_O = 3.0f;
                this.dragonPartBody.field_70130_N = 5.0f;
                this.dragonPartWing1.field_70131_O = 2.0f;
                this.dragonPartWing1.field_70130_N = 4.0f;
                this.dragonPartWing2.field_70131_O = 3.0f;
                this.dragonPartWing2.field_70130_N = 4.0f;
                float f14 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = MathHelper.func_76134_b((float)f14);
                float f18 = MathHelper.func_76126_a((float)f14);
                float f2 = this.field_70177_z * ((float)Math.PI / 180);
                float f19 = MathHelper.func_76126_a((float)f2);
                float f3 = MathHelper.func_76134_b((float)f2);
                this.dragonPartBody.func_70071_h_();
                this.dragonPartBody.func_70012_b(this.field_70165_t + (double)(f19 * 0.5f), this.field_70163_u, this.field_70161_v - (double)(f3 * 0.5f), 0.0f, 0.0f);
                this.dragonPartWing1.func_70071_h_();
                this.dragonPartWing1.func_70012_b(this.field_70165_t + (double)(f3 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v + (double)(f19 * 4.5f), 0.0f, 0.0f);
                this.dragonPartWing2.func_70071_h_();
                this.dragonPartWing2.func_70012_b(this.field_70165_t - (double)(f3 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v - (double)(f19 * 4.5f), 0.0f, 0.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartBody.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0)));
                    this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing1.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
                    this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing2.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
                    this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail1.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0)));
                    this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail2.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0)));
                    this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail3.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0)));
                    this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0).func_72317_d(0.0, -2.0, 0.0)));
                    this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartNeck.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0).func_72317_d(0.0, -2.0, 0.0)));
                }
                double[] adouble = this.getMovementOffsets(5, 1.0f);
                float f4 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180) - this.field_70704_bt * 0.01f));
                float f20 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180) - this.field_70704_bt * 0.01f));
                this.dragonPartHead.func_70071_h_();
                this.dragonPartNeck.func_70071_h_();
                float f5 = this.func_184662_q(1.0f);
                this.dragonPartHead.func_70012_b(this.field_70165_t + (double)(f4 * 9.0f * f16), this.field_70163_u + (double)f5 + (double)(f18 * 9.0f), this.field_70161_v - (double)(f20 * 6.5f * f16), 0.0f, 0.0f);
                this.dragonPartNeck.func_70012_b(this.field_70165_t + (double)(f4 * 4.0f * f16), this.field_70163_u + (double)f5 + (double)(f18 * 4.0f), this.field_70161_v - (double)(f20 * 5.5f * f16), 0.0f, 0.0f);
                for (int j = 0; j < 3; ++j) {
                    EntityDragonPart entitydragonpart = null;
                    if (j == 0) {
                        entitydragonpart = this.dragonPartTail1;
                    }
                    if (j == 1) {
                        entitydragonpart = this.dragonPartTail2;
                    }
                    if (j == 2) {
                        entitydragonpart = this.dragonPartTail3;
                    }
                    double[] adouble1 = this.getMovementOffsets(12 + j * 2, 1.0f);
                    float f21 = this.field_70177_z * ((float)Math.PI / 180) + this.simplifyAngle(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f22 = MathHelper.func_76126_a((float)f21);
                    float f7 = MathHelper.func_76134_b((float)f21);
                    float f23 = 1.5f;
                    float f24 = (float)(j + 1) * 2.0f;
                    entitydragonpart.func_70071_h_();
                    entitydragonpart.func_70012_b(this.field_70165_t - (double)((f19 * f23 + f22 * f24) * f16), this.field_70163_u + (adouble1[1] - adouble[1]) - (double)((f24 + f23) * f18) + 1.5, this.field_70161_v + (double)((f3 * f23 + f7 * f24) * f16), 0.0f, 0.0f);
                }
                this.destroyBlocksInAABB(this.dragonPartHead.func_174813_aQ());
                this.destroyBlocksInAABB(this.dragonPartNeck.func_174813_aQ());
                this.destroyBlocksInAABB(this.dragonPartBody.func_174813_aQ());
                this.destroyBlocksInAABB(this.dragonPartWing1.func_174813_aQ());
                this.destroyBlocksInAABB(this.dragonPartWing2.func_174813_aQ());
                this.destroyBlocksInAABB(this.dragonPartTail1.func_174813_aQ());
                this.destroyBlocksInAABB(this.dragonPartTail2.func_174813_aQ());
                this.destroyBlocksInAABB(this.dragonPartTail3.func_174813_aQ());
            }
        }
    }

    private float func_184662_q(float p_184662_1_) {
        double d0 = 0.0;
        if (this.phaseManager.getCurrentPhase().getIsStationary() || this.getPhaseManager().getCurrentPhase() == PhaseList.HOVER) {
            d0 = -1.0;
        } else {
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            double[] adouble1 = this.getMovementOffsets(0, 1.0f);
            d0 = adouble[1] - adouble1[0];
        }
        return (float)d0;
    }

    private void updateDragonEnderCrystal() {
        if (this.healingEnderCrystal != null) {
            if (this.healingEnderCrystal.field_70128_L) {
                this.healingEnderCrystal = null;
            } else if (this.field_70173_aa % 5 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(2.0f);
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            List list = this.field_70170_p.func_72872_a(EntityEnderCrystal.class, this.func_174813_aQ().func_186662_g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.func_70068_e((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.healingEnderCrystal = entityendercrystal;
        }
    }

    private void collideWithEntities(List p_70970_1_) {
        double d0 = (this.dragonPartBody.func_174813_aQ().field_72340_a + this.dragonPartBody.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.dragonPartBody.func_174813_aQ().field_72339_c + this.dragonPartBody.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (entity instanceof EntityDragon || entity instanceof EntityDragonPart && ((EntityDragonPart)entity).field_70259_a instanceof EntityDragon) {
                entity.func_70097_a(DamageSource.func_92087_a((Entity)(this.isWild() ? this : this.getOwner())), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            }
            if (!(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity)) continue;
            if (entity.field_70172_ad <= 10) {
                this.func_70652_k(entity);
            }
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 8.0, 0.25, d3 / d4 * 8.0);
            this.slowed = true;
        }
    }

    private void attackEntitiesInList(List p_70971_1_) {
        for (int i = 0; i < p_70971_1_.size(); ++i) {
            Entity entity = (Entity)p_70971_1_.get(i);
            if (this.field_70170_p.field_72995_K || entity.field_70172_ad > 10 || !(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity)) continue;
            this.func_70652_k(entity);
            this.func_184185_a(SoundEvents.field_187685_dH, 5.0f, 0.5f);
            this.slowed = true;
        }
    }

    private float simplifyAngle(double p_70973_1_) {
        return (float)MathHelper.func_76138_g((double)p_70973_1_);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || iblockstate.func_185904_a() == Material.field_151581_o) continue;
                    if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag = true;
                        continue;
                    }
                    if (block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this)) {
                        if (block != Blocks.field_150357_h && block != Blocks.field_150377_bs && block != Blocks.field_150343_Z && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_150411_aY && block != Blocks.field_185775_db) {
                            if (this.field_70170_p.field_72995_K) continue;
                            flag1 = this.field_70170_p.func_175698_g(blockpos) || flag1;
                            continue;
                        }
                        flag = true;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d0 = p_70972_1_.field_72340_a + (p_70972_1_.field_72336_d - p_70972_1_.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d1 = p_70972_1_.field_72338_b + (p_70972_1_.field_72337_e - p_70972_1_.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d2 = p_70972_1_.field_72339_c + (p_70972_1_.field_72334_f - p_70972_1_.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    public boolean func_70965_a(EntityDragonPart p_70965_1_, DamageSource p_70965_2_, float p_70965_3_) {
        if (p_70965_1_ != this.dragonPartHead) {
            p_70965_3_ = p_70965_3_ / 4.0f + 1.0f;
        }
        if (p_70965_2_ != DamageSource.field_76371_c && p_70965_2_ != DamageSource.field_76372_a && p_70965_2_ != DamageSource.field_76370_b && p_70965_2_ != DamageSource.field_76369_e && p_70965_2_ != DamageSource.field_76376_m && p_70965_2_ != DamageSource.field_76380_i && p_70965_2_ != DamageSource.field_76367_g && p_70965_2_ != DamageSource.field_180137_b && p_70965_2_ != DamageSource.field_82727_n && p_70965_2_ != DamageSource.field_76368_d) {
            if (p_70965_2_.func_76352_a()) {
                this.func_184185_a(this.getPierceHurtSound(), 3.0f, 1.0f);
            } else if (p_70965_3_ >= 7.0f || p_70965_2_.func_94541_c() || p_70965_2_ == DamageSource.field_82728_o || p_70965_2_.func_76357_e() || p_70965_2_.func_151517_h() || p_70965_2_.func_82725_o() || p_70965_2_ == DamageSource.field_76379_h || p_70965_2_ == DamageSource.field_76371_c) {
                this.func_184185_a(this.getCrushHurtSound(), 3.0f, 1.0f);
            } else {
                this.func_184185_a(this.getRegularHurtSound(), 3.0f, 1.0f);
            }
            this.attackDragonFrom(p_70965_2_, p_70965_3_);
        }
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
            if (!this.isWild() && source.func_76346_g() == this.getOwner()) {
                this.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
            } else {
                this.func_70624_b((EntityLivingBase)source.func_76346_g());
                if (this.field_70146_Z.nextInt(2) == 0) {
                    this.getPhaseManager().setPhase(PhaseList.CHARGING_PLAYER);
                    this.getPhaseManager().getPhase(PhaseList.CHARGING_PLAYER).func_188668_a(new Vec3d(source.func_76346_g().field_70165_t, source.func_76346_g().field_70163_u, source.func_76346_g().field_70161_v));
                }
            }
        }
        return this.attackDragonFrom(source, amount);
    }

    protected boolean attackDragonFrom(DamageSource p_82195_1_, float p_82195_2_) {
        if (this.func_110143_aJ() <= 0.0f) {
            this.phaseManager.setPhase(PhaseList.DYING);
        }
        if (p_82195_1_ == DamageSource.field_188407_q) {
            return false;
        }
        return super.func_70097_a(p_82195_1_, p_82195_2_);
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int j;
                for (int i = 1000; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 1) {
                this.field_70170_p.func_175669_a(1028, new BlockPos((Entity)this), 0);
                this.func_184185_a(SoundEvents.field_187522_aL, Float.MAX_VALUE, 1.0f);
                if (this.getOwner() != null) {
                    ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("Your Ender Dragon has fallen in battle.", new Object[0]));
                }
            }
        }
        this.func_70091_d(0.0, 0.1f, 0.0);
        this.field_70761_aq = this.field_70177_z += 20.0f;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 2000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v, j));
            }
            this.func_70099_a(new ItemStack(Blocks.field_150380_bt), 8.0f);
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 5), 8.0f);
            this.func_145778_a(Items.field_185160_cR, 1, 8.0f);
            this.func_70106_y();
        }
    }

    private void func_184668_a(int p_184668_1_) {
        while (p_184668_1_ > 0) {
            int i = EntityXPOrb.func_70527_a((int)p_184668_1_);
            p_184668_1_ -= i;
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
        }
    }

    public int initPathPoints() {
        if (this.pathPoints[0] == null) {
            int i = 0;
            int j = 0;
            int k = 0;
            int l = 0;
            for (int i1 = 0; i1 < 24; ++i1) {
                int j1 = 5;
                if (i1 < 12) {
                    i = (int)(60.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i1))));
                    k = (int)(60.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i1))));
                } else if (i1 < 20) {
                    l = i1 - 12;
                    i = (int)(40.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)l))));
                    k = (int)(40.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)l))));
                    j1 += 10;
                } else {
                    l = i1 - 20;
                    i = (int)(20.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)l))));
                    k = (int)(20.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)l))));
                }
                j = Math.max(this.field_70170_p.func_181545_F() + 10, this.field_70170_p.func_175672_r(new BlockPos(i, 0, k)).func_177956_o() + j1);
                this.pathPoints[i1] = new PathPoint(i, j, k);
            }
            this.neighbors[0] = 6146;
            this.neighbors[1] = 8197;
            this.neighbors[2] = 8202;
            this.neighbors[3] = 16404;
            this.neighbors[4] = 32808;
            this.neighbors[5] = 32848;
            this.neighbors[6] = 65696;
            this.neighbors[7] = 131392;
            this.neighbors[8] = 131712;
            this.neighbors[9] = 263424;
            this.neighbors[10] = 526848;
            this.neighbors[11] = 525313;
            this.neighbors[12] = 1581057;
            this.neighbors[13] = 3166214;
            this.neighbors[14] = 2138120;
            this.neighbors[15] = 6373424;
            this.neighbors[16] = 4358208;
            this.neighbors[17] = 12910976;
            this.neighbors[18] = 9044480;
            this.neighbors[19] = 9706496;
            this.neighbors[20] = 15216640;
            this.neighbors[21] = 0xD0E000;
            this.neighbors[22] = 11763712;
            this.neighbors[23] = 0x7E0000;
        }
        return this.getNearestPpIdx(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public int getNearestPpIdx(double x, double y, double z) {
        int j;
        float f = 10000.0f;
        int i = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
        for (int k = j = 12; k < 24; ++k) {
            float f1;
            if (this.pathPoints[k] == null || !((f1 = this.pathPoints[k].func_75832_b(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    public Path findPath(int startIdx, int finishIdx, PathPoint andThen) {
        for (int i = 0; i < 24; ++i) {
            PathPoint pathpoint = this.pathPoints[i];
            pathpoint.field_75842_i = false;
            pathpoint.field_75834_g = 0.0f;
            pathpoint.field_75836_e = 0.0f;
            pathpoint.field_75833_f = 0.0f;
            pathpoint.field_75841_h = null;
            pathpoint.field_75835_d = -1;
        }
        PathPoint pathpoint4 = this.pathPoints[startIdx];
        PathPoint pathpoint5 = this.pathPoints[finishIdx];
        pathpoint4.field_75836_e = 0.0f;
        pathpoint4.field_75834_g = pathpoint4.field_75833_f = pathpoint4.func_75829_a(pathpoint5);
        this.pathFindQueue.func_75848_a();
        this.pathFindQueue.func_75849_a(pathpoint4);
        PathPoint pathpoint1 = pathpoint4;
        int j = 12;
        while (!this.pathFindQueue.func_75845_e()) {
            PathPoint pathpoint2 = this.pathFindQueue.func_75844_c();
            if (pathpoint2.equals((Object)pathpoint5)) {
                if (andThen != null) {
                    andThen.field_75841_h = pathpoint5;
                    pathpoint5 = andThen;
                }
                return this.makePath(pathpoint4, pathpoint5);
            }
            if (pathpoint2.func_75829_a(pathpoint5) < pathpoint1.func_75829_a(pathpoint5)) {
                pathpoint1 = pathpoint2;
            }
            pathpoint2.field_75842_i = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.pathPoints[l] != pathpoint2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.neighbors[k] & 1 << i1) <= 0) continue;
                PathPoint pathpoint3 = this.pathPoints[i1];
                if (pathpoint3.field_75842_i) continue;
                float f = pathpoint2.field_75836_e + pathpoint2.func_75829_a(pathpoint3);
                if (pathpoint3.func_75831_a() && !(f < pathpoint3.field_75836_e)) continue;
                pathpoint3.field_75841_h = pathpoint2;
                pathpoint3.field_75836_e = f;
                pathpoint3.field_75833_f = pathpoint3.func_75829_a(pathpoint5);
                if (pathpoint3.func_75831_a()) {
                    this.pathFindQueue.func_75850_a(pathpoint3, pathpoint3.field_75836_e + pathpoint3.field_75833_f);
                    continue;
                }
                pathpoint3.field_75834_g = pathpoint3.field_75836_e + pathpoint3.field_75833_f;
                this.pathFindQueue.func_75849_a(pathpoint3);
            }
        }
        if (pathpoint1 == pathpoint4) {
            return null;
        }
        if (andThen != null) {
            andThen.field_75841_h = pathpoint1;
            pathpoint1 = andThen;
        }
        return this.makePath(pathpoint4, pathpoint1);
    }

    private Path makePath(PathPoint start, PathPoint finish) {
        int i = 1;
        PathPoint pathpoint = finish;
        while (pathpoint.field_75841_h != null) {
            ++i;
            pathpoint = pathpoint.field_75841_h;
        }
        PathPoint[] apathpoint = new PathPoint[i];
        PathPoint pathpoint1 = finish;
        apathpoint[--i] = finish;
        while (pathpoint1.field_75841_h != null) {
            pathpoint1 = pathpoint1.field_75841_h;
            apathpoint[--i] = pathpoint1;
        }
        return new Path(apathpoint);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("DragonPhase", this.phaseManager.getCurrentPhase().getPhaseList().getId());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("DragonPhase")) {
            this.phaseManager.setPhase(PhaseList.getById(tagCompund.func_74762_e("DragonPhase")));
        }
    }

    @Override
    protected void func_70623_bb() {
    }

    public Entity[] func_70021_al() {
        return this.dragonPartArray;
    }

    public boolean func_70067_L() {
        return true;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    protected void func_85033_bc() {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187526_aP;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187533_aW;
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_184667_a(int p_184667_1_, double[] p_184667_2_, double[] p_184667_3_) {
        double d0;
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseList<? extends IPhase> phaselist = iphase.getPhaseList();
        if (phaselist != PhaseList.LANDING && phaselist != PhaseList.TAKEOFF) {
            d0 = iphase.getIsStationary() ? (double)p_184667_1_ : (p_184667_1_ == 6 ? 0.0 : p_184667_3_[1] - p_184667_2_[1]);
        } else {
            BlockPos blockpos = this.field_70170_p.func_175672_r(WorldGenEndPodium.field_186139_a);
            if (this.getOwner() != null) {
                blockpos = new BlockPos((Entity)this.getOwner());
            }
            float f = Math.max(MathHelper.func_76133_a((double)this.func_174831_c(blockpos)) / 4.0f, 1.0f);
            d0 = (float)p_184667_1_ / f;
        }
        return (float)d0;
    }

    public Vec3d func_184665_a(float p_184665_1_) {
        Vec3d vec3d;
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseList<? extends IPhase> phaselist = iphase.getPhaseList();
        if (phaselist != PhaseList.LANDING && phaselist != PhaseList.TAKEOFF) {
            if (iphase.getIsStationary()) {
                float f4 = this.field_70125_A;
                float f5 = 1.5f;
                this.field_70125_A = -6.0f * f5 * 5.0f;
                vec3d = this.func_70676_i(p_184665_1_);
                this.field_70125_A = f4;
            } else {
                vec3d = this.func_70676_i(p_184665_1_);
            }
        } else {
            BlockPos blockpos = this.field_70170_p.func_175672_r(WorldGenEndPodium.field_186139_a);
            if (this.getOwner() != null) {
                blockpos = new BlockPos((Entity)this.getOwner());
            }
            float f = Math.max(MathHelper.func_76133_a((double)this.func_174831_c(blockpos)) / 4.0f, 1.0f);
            float f1 = 6.0f / f;
            float f2 = this.field_70125_A;
            float f3 = 1.5f;
            this.field_70125_A = -f1 * f3 * 5.0f;
            vec3d = this.func_70676_i(p_184665_1_);
            this.field_70125_A = f2;
        }
        return vec3d;
    }

    public void onCrystalDestroyed(EntityEnderCrystal crystal, BlockPos pos, DamageSource dmgSrc) {
        EntityPlayer entityplayer = dmgSrc.func_76346_g() instanceof EntityPlayer ? (EntityPlayer)dmgSrc.func_76346_g() : this.field_70170_p.func_184139_a(pos, 64.0, 64.0);
        if (crystal == this.healingEnderCrystal) {
            this.func_70965_a(this.dragonPartHead, DamageSource.func_188405_b((EntityLivingBase)entityplayer), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(crystal, pos, dmgSrc, entityplayer);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (PHASE.equals(key) && this.field_70170_p.field_72995_K) {
            this.phaseManager.setPhase(PhaseList.getById((Integer)this.func_184212_Q().func_187225_a(PHASE)));
        }
        super.func_184206_a(key);
    }

    public PhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.fleshHitCrushHeavy;
    }
}

