/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.UUID;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWitch
extends EntityFriendlyCreature
implements IRangedAttackMob {
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Drinking speed penalty", -0.25, 0).func_111168_a(false);
    private static final DataParameter<Boolean> IS_AGGRESSIVE = EntityDataManager.func_187226_a(EntityWitch.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Item[] witchDrops = new Item[]{Items.field_151114_aO, Items.field_151102_aT, Items.field_151137_ax, Items.field_151070_bp, Items.field_151069_bo, Items.field_151016_H, Items.field_151055_y, Items.field_151055_y};
    private int witchAttackTimer;

    public EntityWitch(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 1.95f);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 24.0f, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 5, 30, 10.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_AGGRESSIVE, (Object)false);
    }

    @Override
    public boolean func_70601_bi() {
        return this.isValidLightLevel() && super.func_70601_bi();
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER4;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187920_gt;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187923_gw;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187921_gu;
    }

    public void setAggressive(boolean aggressive) {
        this.func_184212_Q().func_187227_b(IS_AGGRESSIVE, (Object)aggressive);
    }

    public boolean func_184730_o() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_AGGRESSIVE);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(26.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void performSpecialAttack() {
        this.func_184185_a(ModSoundEvents.witchSpecial, 10.0f, 1.0f);
        this.setSpecialAttackTimer(1200);
    }

    @Override
    public void func_70636_d() {
        List list;
        if (this.isHero() && this.getSpecialAttackTimer() == 1180 && (list = this.field_70170_p.func_175647_a(EntityLiving.class, this.func_174813_aQ().func_72314_b(24.0, 24.0, 24.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityLiving entity = (EntityLiving)list.get(i1);
                if (entity == null || !entity.func_184222_aU() || entity instanceof EntityFriendlyCreature || this.isOnSameTeam((EntityLivingBase)entity)) continue;
                EntityPig entityzombie = new EntityPig(this.field_70170_p);
                entityzombie.func_82149_j((Entity)entity);
                this.field_70170_p.func_72900_e((Entity)entity);
                entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), null);
                entityzombie.func_70656_aK();
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_72838_d((Entity)entityzombie);
            }
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 256.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184730_o()) {
                if (this.witchAttackTimer-- <= 0) {
                    List list2;
                    this.setAggressive(false);
                    ItemStack itemstack = this.func_184614_ca();
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                    if (itemstack != null && itemstack.func_77973_b() == Items.field_151068_bn && (list2 = PotionUtils.func_185189_a((ItemStack)itemstack)) != null) {
                        for (PotionEffect potioneffect : list2) {
                            this.func_70690_d(new PotionEffect(potioneffect));
                        }
                    }
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(MODIFIER);
                }
            } else {
                PotionType potiontype = null;
                if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(MobEffects.field_76427_o)) {
                    potiontype = PotionTypes.field_185249_u;
                } else if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70027_ad() && !this.func_70644_a(MobEffects.field_76426_n)) {
                    potiontype = PotionTypes.field_185242_n;
                } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                    potiontype = PotionTypes.field_185251_w;
                } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(MobEffects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                    potiontype = PotionTypes.field_185245_q;
                }
                if (potiontype != null) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype));
                    this.witchAttackTimer = this.func_184614_ca().func_77988_m();
                    this.setAggressive(true);
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    iattributeinstance.func_111124_b(MODIFIER);
                    iattributeinstance.func_111121_a(MODIFIER);
                }
            }
            if (this.getOwner() != null && this.field_70170_p.func_72890_a((Entity)this, 128.0) != null && this.field_70170_p.func_72890_a((Entity)this, 128.0) == this.getOwner() && this.func_70068_e((Entity)this.getOwner()) < 128.0 && this.field_70146_Z.nextInt(200) == 0) {
                this.func_82196_d(this.getOwner(), 0.0f);
                this.func_70671_ap().func_75651_a((Entity)this.getOwner(), 180.0f, 30.0f);
            }
            if (this.field_70146_Z.nextFloat() < 7.5E-4f) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)15);
            }
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 15) {
            for (int i = 0; i < this.field_70146_Z.nextInt(35) + 10; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)0.13f, this.func_174813_aQ().field_72337_e + 0.5 + this.field_70146_Z.nextGaussian() * (double)0.13f, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    protected float func_70672_c(DamageSource p_70672_1_, float p_70672_2_) {
        p_70672_2_ = super.func_70672_c(p_70672_1_, p_70672_2_);
        if (p_70672_1_.func_76346_g() == this) {
            p_70672_2_ = 0.0f;
        }
        if (p_70672_1_.func_82725_o()) {
            p_70672_2_ = (float)((double)p_70672_2_ * 0.15);
        }
        return p_70672_2_;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int j = this.field_70146_Z.nextInt(3) + 1;
        for (int k = 0; k < j; ++k) {
            int l = this.field_70146_Z.nextInt(3);
            Item item = witchDrops[this.field_70146_Z.nextInt(witchDrops.length)];
            if (p_70628_2_ > 0) {
                l += this.field_70146_Z.nextInt(p_70628_2_ + 1);
            }
            for (int i1 = 0; i1 < l; ++i1) {
                this.func_145779_a(item, 1);
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        if (!this.func_184730_o()) {
            double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
            double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
            double d2 = d0 - this.field_70163_u;
            double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
            PotionType potiontype = PotionTypes.field_185253_y;
            if (this.isOnSameTeam(target)) {
                switch (this.field_70146_Z.nextInt(9)) {
                    case 0: {
                        potiontype = PotionTypes.field_185251_w;
                        break;
                    }
                    case 1: {
                        potiontype = PotionTypes.field_185242_n;
                        break;
                    }
                    case 2: {
                        potiontype = PotionTypes.field_185235_g;
                        break;
                    }
                    case 3: {
                        potiontype = PotionTypes.field_185249_u;
                        break;
                    }
                    case 4: {
                        potiontype = PotionTypes.field_185222_E;
                        break;
                    }
                    case 5: {
                        potiontype = PotionTypes.field_185245_q;
                        break;
                    }
                    case 6: {
                        potiontype = PotionTypes.field_185225_H;
                        break;
                    }
                    case 7: {
                        potiontype = PotionTypes.field_185240_l;
                        break;
                    }
                    case 8: {
                        potiontype = PotionTypes.field_185237_i;
                    }
                }
            }
            if (target.func_70662_br()) {
                potiontype = PotionTypes.field_185251_w;
            } else if (target != this.getOwner() && !target.func_70662_br() && (target instanceof EntityWitch || target instanceof net.minecraft.entity.monster.EntityWitch)) {
                target.func_70097_a(DamageSource.field_76368_d, 5.0f);
                potiontype = PotionTypes.field_185233_e;
                target.field_70172_ad = 0;
                target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 100, 4));
            } else if (!target.func_70644_a(MobEffects.field_76421_d) && target != this.getOwner()) {
                potiontype = PotionTypes.field_185247_s;
            } else if (!(!(target.func_110143_aJ() >= 2.0f) || target == this.getOwner() || target.func_70662_br() || target instanceof net.minecraft.entity.helpful.tier3.EntitySpider || target instanceof EntitySpider || target.func_70644_a(MobEffects.field_76436_u))) {
                potiontype = PotionTypes.field_185219_B;
            } else if (!target.func_70644_a(MobEffects.field_76437_t) && target != this.getOwner()) {
                potiontype = PotionTypes.field_185227_J;
            }
            EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potiontype));
            entitypotion.field_70125_A -= -20.0f;
            entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
            this.func_70642_aH();
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            this.field_70170_p.func_72838_d((Entity)entitypotion);
        }
    }

    public float func_70047_e() {
        return 1.62f;
    }
}

