/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.UUID;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier4.EntityShulkerBulletFriendly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityShulker
extends EntityFriendlyCreature {
    private static final UUID COVERED_ARMOR_BONUS_ID = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier COVERED_ARMOR_BONUS_MODIFIER = new AttributeModifier(COVERED_ARMOR_BONUS_ID, "Covered armor bonus", 20.0, 0).func_111168_a(false);
    protected static final DataParameter<EnumFacing> ATTACHED_FACE = EntityDataManager.func_187226_a(EntityShulker.class, (DataSerializer)DataSerializers.field_187202_l);
    protected static final DataParameter<Optional<BlockPos>> ATTACHED_BLOCK_POS = EntityDataManager.func_187226_a(EntityShulker.class, (DataSerializer)DataSerializers.field_187201_k);
    protected static final DataParameter<Byte> PEEK_TICK = EntityDataManager.func_187226_a(EntityShulker.class, (DataSerializer)DataSerializers.field_187191_a);
    private float field_184705_bx;
    private float field_184706_by;
    private BlockPos field_184707_bz;
    private int field_184708_bA;

    public EntityShulker(World p_i46779_1_) {
        super(p_i46779_1_);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.isOffensive = true;
        this.field_70178_ae = true;
        this.field_184707_bz = null;
        this.field_70728_aV = 5;
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER4;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.field_70761_aq = 180.0f;
        this.field_70760_ar = 180.0f;
        this.field_70177_z = 180.0f;
        this.field_70126_B = 180.0f;
        this.field_70759_as = 180.0f;
        this.field_70758_at = 180.0f;
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIAttack());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIPeek());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187773_eO;
    }

    public void func_70642_aH() {
        if (!this.func_184686_df()) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187781_eS;
    }

    protected SoundEvent func_184601_bQ() {
        return this.func_184686_df() ? SoundEvents.field_187785_eU : SoundEvents.field_187783_eT;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACHED_FACE, (Object)EnumFacing.DOWN);
        this.field_70180_af.func_187214_a(ATTACHED_BLOCK_POS, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(PEEK_TICK, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected EntityBodyHelper func_184650_s() {
        return new BodyHelper((EntityLivingBase)this);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)EnumFacing.func_82600_a((int)tagCompund.func_74771_c("AttachFace")));
        this.field_70180_af.func_187227_b(PEEK_TICK, (Object)tagCompund.func_74771_c("Peek"));
        if (tagCompund.func_74764_b("APX")) {
            int i = tagCompund.func_74762_e("APX");
            int j = tagCompund.func_74762_e("APY");
            int k = tagCompund.func_74762_e("APZ");
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)new BlockPos(i, j, k)));
        } else {
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.absent());
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74774_a("AttachFace", (byte)((EnumFacing)this.field_70180_af.func_187225_a(ATTACHED_FACE)).func_176745_a());
        tagCompound.func_74774_a("Peek", ((Byte)this.field_70180_af.func_187225_a(PEEK_TICK)).byteValue());
        BlockPos blockpos = this.func_184699_da();
        if (blockpos != null) {
            tagCompound.func_74768_a("APX", blockpos.func_177958_n());
            tagCompound.func_74768_a("APY", blockpos.func_177956_o());
            tagCompound.func_74768_a("APZ", blockpos.func_177952_p());
        }
    }

    public void func_70071_h_() {
        BlockPos blockpos;
        super.func_70071_h_();
        if (this.field_70725_aQ > 0) {
            this.field_70181_x = -0.6;
        }
        if (this.field_70725_aQ == 1) {
            this.func_184185_a(ModSoundEvents.buildingDeath, 2.0f, 1.0f);
            for (int k = 0; k < 200; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.1;
                double d0 = this.field_70146_Z.nextGaussian() * 0.1;
                double d1 = this.field_70146_Z.nextGaussian() * 0.1;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, -0.25, d1, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, -0.25, d1, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, 0.25, d1, new int[0]);
            }
        }
        if ((blockpos = (BlockPos)((Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS)).orNull()) == null && !this.field_70170_p.field_72995_K && this.func_70089_S()) {
            blockpos = new BlockPos((Entity)this);
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos));
        }
        if (this.func_184218_aH()) {
            float f;
            blockpos = null;
            this.field_70177_z = f = this.func_184187_bx().field_70177_z;
            this.field_70761_aq = f;
            this.field_70760_ar = f;
            this.field_184708_bA = 0;
        } else if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            BlockPos blockpos2;
            BlockPos blockpos1;
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != Blocks.field_150350_a) {
                if (iblockstate.func_177230_c() == Blocks.field_180384_M) {
                    EnumFacing enumfacing = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockPistonBase.field_176387_N);
                    blockpos = blockpos.func_177972_a(enumfacing);
                    this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos));
                } else if (iblockstate.func_177230_c() == Blocks.field_150332_K) {
                    EnumFacing enumfacing3 = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockPistonExtension.field_176387_N);
                    blockpos = blockpos.func_177972_a(enumfacing3);
                    this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos));
                } else {
                    this.teleportShulkerToBlock();
                }
            }
            if (!this.field_70170_p.func_175677_d(blockpos1 = blockpos.func_177972_a(this.func_184696_cZ()), false)) {
                boolean flag = false;
                for (EnumFacing enumfacing1 : EnumFacing.values()) {
                    blockpos1 = blockpos.func_177972_a(enumfacing1);
                    if (!this.field_70170_p.func_175677_d(blockpos1, false)) continue;
                    this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)enumfacing1);
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.teleportShulkerToBlock();
                }
            }
            if (this.field_70170_p.func_175677_d(blockpos2 = blockpos.func_177972_a(this.func_184696_cZ().func_176734_d()), false)) {
                this.teleportShulkerToBlock();
            }
            if (this.field_70170_p.func_72890_a((Entity)this, 512.0) != null && this.field_70170_p.func_72890_a((Entity)this, 512.0) == this.getOwner() && this.func_70068_e((Entity)this.getOwner()) > 512.0) {
                this.teleportTo(this.getOwner().field_70165_t, this.getOwner().field_70163_u + 2.0, this.getOwner().field_70161_v);
                this.teleportShulkerToBlock();
            }
        }
        float f1 = (float)this.func_184684_db() * 0.01f;
        this.field_184705_bx = this.field_184706_by;
        if (this.field_184706_by > f1) {
            this.field_184706_by = MathHelper.func_76131_a((float)(this.field_184706_by - 0.05f), (float)f1, (float)1.0f);
        } else if (this.field_184706_by < f1) {
            this.field_184706_by = MathHelper.func_76131_a((float)(this.field_184706_by + 0.05f), (float)0.0f, (float)f1);
        }
        if (blockpos != null) {
            List list;
            if (this.field_70170_p.field_72995_K) {
                if (this.field_184708_bA > 0 && this.field_184707_bz != null) {
                    --this.field_184708_bA;
                } else {
                    this.field_184707_bz = blockpos;
                }
            }
            if (this.func_70089_S()) {
                this.field_70169_q = this.field_70165_t = (double)blockpos.func_177958_n() + 0.5;
                this.field_70142_S = this.field_70165_t;
                this.field_70167_r = this.field_70163_u = (double)blockpos.func_177956_o();
                this.field_70137_T = this.field_70163_u;
                this.field_70166_s = this.field_70161_v = (double)blockpos.func_177952_p() + 0.5;
                this.field_70136_U = this.field_70161_v;
            }
            double d3 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.field_184706_by) * (float)Math.PI)) * 0.5;
            double d4 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.field_184705_bx) * (float)Math.PI)) * 0.5;
            double d5 = d3 - d4;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            EnumFacing enumfacing2 = this.func_184696_cZ();
            switch (enumfacing2) {
                default: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0 + d3, this.field_70161_v + 0.5));
                    d1 = d5;
                    break;
                }
                case UP: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u - d3, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d1 = -d5;
                    break;
                }
                case NORTH: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5 + d3));
                    d2 = d5;
                    break;
                }
                case SOUTH: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5 - d3, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d2 = -d5;
                    break;
                }
                case WEST: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5 + d3, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d0 = d5;
                    break;
                }
                case EAST: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5 - d3, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d0 = -d5;
                }
            }
            if (d5 > 0.0 && !(list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())).isEmpty()) {
                for (Entity entity : list) {
                    if (entity instanceof EntityShulker || entity.field_70145_X) continue;
                    entity.func_70091_d(d0, d1, d2);
                }
            }
        }
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.field_70180_af != null && this.field_70173_aa != 0) {
            Optional optional = (Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS);
            Optional optional1 = Optional.of((Object)new BlockPos(x, y, z));
            if (!optional1.equals((Object)optional)) {
                this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)optional1);
                this.field_70180_af.func_187227_b(PEEK_TICK, (Object)0);
                this.field_70160_al = true;
            }
        }
    }

    protected boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.teleportTo_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187791_eX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187791_eX, 1.0f, 1.0f);
        }
        return true;
    }

    protected boolean teleportShulkerToBlock() {
        if (!this.func_175446_cd() && this.func_70089_S()) {
            BlockPos blockpos = new BlockPos((Entity)this);
            for (int i = 0; i < 5; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(12 - this.field_70146_Z.nextInt(24), 12 - this.field_70146_Z.nextInt(24), 12 - this.field_70146_Z.nextInt(24));
                if (blockpos1.func_177956_o() <= 0 || !this.field_70170_p.func_175623_d(blockpos1) || !this.field_70170_p.func_175673_a(this.field_70170_p.func_175723_af(), (Entity)this) || !this.field_70170_p.func_184144_a((Entity)this, new AxisAlignedBB(blockpos1)).isEmpty()) continue;
                boolean flag = false;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    if (!this.field_70170_p.func_175677_d(blockpos1.func_177972_a(enumfacing), false)) continue;
                    this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)enumfacing);
                    flag = true;
                    break;
                }
                if (!flag) continue;
                this.func_184185_a(SoundEvents.field_187791_eX, 2.0f, 0.95f);
                this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos1));
                this.field_70180_af.func_187227_b(PEEK_TICK, (Object)0);
                this.func_70624_b(null);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void performSpecialAttack() {
        List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(48.0, 48.0, 48.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
        if (list != null && !list.isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                if (entity == null || this.isOnSameTeam(entity)) continue;
                EntityShulkerBulletFriendly entityshulkerbullet = new EntityShulkerBulletFriendly(this.field_70170_p, this, (Entity)entity, this.func_184696_cZ().func_176740_k());
                this.field_70170_p.func_72838_d((Entity)entityshulkerbullet);
                this.func_184185_a(SoundEvents.field_187789_eW, 3.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.7f);
            }
        }
        this.setSpecialAttackTimer(800);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        if (!this.isWild() && this.func_70068_e((Entity)this.getOwner()) >= 2304.0) {
            this.field_70173_aa = 0;
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 2.0f / this.field_70131_O);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 2.0f / this.field_70131_O);
            this.func_70661_as().func_75499_g();
            this.func_70012_b(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v, this.field_70177_z, this.field_70125_A);
        }
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70177_z = 180.0f;
        this.field_70160_al = false;
        this.field_70122_E = true;
        this.func_70031_b(false);
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 512.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        BlockPos blockpos;
        if (ATTACHED_BLOCK_POS.equals(key) && this.field_70170_p.field_72995_K && !this.func_184218_aH() && (blockpos = this.func_184699_da()) != null) {
            if (this.field_184707_bz == null) {
                this.field_184707_bz = blockpos;
            } else {
                this.field_184708_bA = 6;
            }
            if (this.func_70089_S()) {
                this.field_70169_q = this.field_70165_t = (double)blockpos.func_177958_n() + 0.5;
                this.field_70142_S = this.field_70165_t;
                this.field_70167_r = this.field_70163_u = (double)blockpos.func_177956_o();
                this.field_70137_T = this.field_70163_u;
                this.field_70166_s = this.field_70161_v = (double)blockpos.func_177952_p() + 0.5;
                this.field_70136_U = this.field_70161_v;
            }
        }
        super.func_184206_a(key);
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean p_180426_10_) {
        this.field_70716_bi = 0;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (this.func_184686_df() && (entity = source.func_76364_f()) instanceof EntityArrow) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5) {
                this.teleportShulkerToBlock();
            }
            return true;
        }
        return false;
    }

    private boolean func_184686_df() {
        return this.func_184684_db() == 0;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public EnumFacing func_184696_cZ() {
        return (EnumFacing)this.field_70180_af.func_187225_a(ATTACHED_FACE);
    }

    public BlockPos func_184699_da() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS)).orNull();
    }

    public void func_184694_g(BlockPos p_184694_1_) {
        this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.fromNullable((Object)p_184694_1_));
    }

    public int func_184684_db() {
        return ((Byte)this.field_70180_af.func_187225_a(PEEK_TICK)).byteValue();
    }

    public void func_184691_a(int p_184691_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(COVERED_ARMOR_BONUS_MODIFIER);
            if (p_184691_1_ == 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(COVERED_ARMOR_BONUS_MODIFIER);
                this.func_184185_a(SoundEvents.field_187779_eR, 1.0f, 1.0f);
            } else {
                this.func_184185_a(SoundEvents.field_187787_eV, 1.0f, 1.0f);
            }
        }
        this.field_70180_af.func_187227_b(PEEK_TICK, (Object)((byte)p_184691_1_));
    }

    @SideOnly(value=Side.CLIENT)
    public float func_184688_a(float p_184688_1_) {
        return this.field_184705_bx + (this.field_184706_by - this.field_184705_bx) * p_184688_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_184693_dc() {
        return this.field_184708_bA;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos func_184692_dd() {
        return this.field_184707_bz;
    }

    public float func_70047_e() {
        return 0.5f;
    }

    public int func_70646_bf() {
        return 180;
    }

    public int func_184649_cE() {
        return 180;
    }

    public void func_70108_f(Entity entityIn) {
        this.teleportShulkerToBlock();
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_184697_de() {
        return this.field_184707_bz != null && this.func_184699_da() != null;
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        if (super.func_70652_k(p_70652_1_)) {
            ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 200));
            return true;
        }
        return false;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.woodHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.woodHitCrush;
    }

    class BodyHelper
    extends EntityBodyHelper {
        public BodyHelper(EntityLivingBase p_i47062_2_) {
            super(p_i47062_2_);
        }

        public void func_75664_a() {
        }
    }

    class AIPeek
    extends EntityAIBase {
        private int field_188522_b;

        private AIPeek() {
        }

        public boolean func_75250_a() {
            return EntityShulker.this.func_70638_az() == null && EntityShulker.this.field_70146_Z.nextInt(20) == 0 || EntityShulker.this.func_70093_af();
        }

        public boolean func_75253_b() {
            return EntityShulker.this.func_70638_az() == null && this.field_188522_b > 0;
        }

        public void func_75249_e() {
            this.field_188522_b = EntityShulker.this.func_70093_af() ? 100 : 40 * (1 + EntityShulker.this.field_70146_Z.nextInt(3));
            EntityShulker.this.func_184691_a(30);
        }

        public void func_75251_c() {
            if (EntityShulker.this.func_70638_az() == null) {
                this.field_188522_b = 0;
                EntityShulker.this.func_184691_a(0);
            }
        }

        public void func_75246_d() {
            --this.field_188522_b;
        }
    }

    class AIAttack
    extends EntityAIBase {
        private int field_188520_b;

        public AIAttack() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            EntityShulker.this.func_184691_a(100);
            this.field_188520_b = 20;
        }

        public void func_75251_c() {
            EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
            if (entitylivingbase != null && entitylivingbase.func_110143_aJ() <= 0.0f) {
                EntityShulker.this.func_184691_a(0);
                EntityShulker.this.func_70624_b(null);
            }
        }

        public void func_75246_d() {
            --this.field_188520_b;
            EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
            EntityShulker.this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, 180.0f);
            double d0 = EntityShulker.this.func_70068_e((Entity)entitylivingbase);
            if (d0 < 1024.0) {
                if (this.field_188520_b <= 0) {
                    this.field_188520_b = EntityShulker.this.moralRaisedTimer > 200 ? 5 : 20 + EntityShulker.this.field_70146_Z.nextInt(80);
                    if (d0 < 16.0) {
                        EntityShulker.this.func_184185_a(SoundEvents.field_187789_eW, 2.0f, (EntityShulker.this.field_70146_Z.nextFloat() - EntityShulker.this.field_70146_Z.nextFloat()) * 0.2f + 1.25f);
                        EntityShulker.this.func_70652_k((Entity)entitylivingbase);
                        if (d0 < 12.0) {
                            EntityShulker.this.teleportShulkerToBlock();
                        }
                    } else {
                        EntityShulkerBulletFriendly entityshulkerbullet = new EntityShulkerBulletFriendly(EntityShulker.this.field_70170_p, EntityShulker.this, (Entity)entitylivingbase, EntityShulker.this.func_184696_cZ().func_176740_k());
                        EntityShulker.this.field_70170_p.func_72838_d((Entity)entityshulkerbullet);
                        EntityShulker.this.func_184185_a(SoundEvents.field_187789_eW, 2.0f, (EntityShulker.this.field_70146_Z.nextFloat() - EntityShulker.this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    }
                }
            } else {
                EntityShulker.this.func_70624_b(null);
            }
            super.func_75246_d();
        }
    }
}

