/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import java.util.UUID;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityPigZombie
extends EntityZombie {
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.075, 0).func_111168_a(false);
    private int angerLevel;
    private int randomSoundDelay = 40;
    private UUID angerTargetUUID;

    public EntityPigZombie(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.randomSoundDelay = 0;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    protected int getTimeBetweenSteps() {
        return 10;
    }

    @Override
    public void performSpecialAttack() {
        this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 5.0f);
        this.func_184185_a(ModSoundEvents.pigmanSpecial, this.func_70599_aP(), 1.0f);
        this.setSpecialAttackTimer(500);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 4.0 && this.field_70173_aa % 1 == 0 && this.moralRaisedTimer > 200) {
            this.func_70652_k((Entity)this.func_70638_az());
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70068_e((Entity)this.func_70638_az()) < (double)this.func_70638_az().field_70130_N + 9.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.func_70664_aZ();
            this.func_70638_az().field_70181_x += 2.0;
            this.func_184185_a(ModSoundEvents.pigmanSpecial, this.func_70599_aP(), 1.0f);
            this.performSpecialAttack();
        }
    }

    @Override
    protected void func_70619_bc() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.isAngry()) {
            if (!iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                this.func_70031_b(true);
                iattributeinstance.func_111121_a(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
        } else if (iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
            this.func_70031_b(false);
            iattributeinstance.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_184185_a(SoundEvents.field_187936_hj, 10000.0f, this.func_70647_i() * 1.8f);
        }
        if (this.moralRaisedTimer > 200) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 20, 9));
            this.angerLevel = 600;
            this.func_184185_a(SoundEvents.field_187936_hj, 1.0f, this.func_70647_i() * 1.8f);
            this.field_70172_ad = 0;
            this.field_70721_aZ *= 6.0f;
        }
        super.func_70619_bc();
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74777_a("Anger", (short)this.angerLevel);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.angerLevel = tagCompund.func_74765_d("Anger");
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase) {
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(source, amount);
    }

    public void becomeAngryAt(Entity p_70835_1_) {
        this.angerLevel = 600;
        this.randomSoundDelay = this.field_70146_Z.nextInt(150);
        if (p_70835_1_ instanceof EntityLivingBase && !this.isOnSameTeam((EntityLivingBase)p_70835_1_)) {
            this.func_70624_b((EntityLivingBase)p_70835_1_);
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187935_hi;
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187938_hl;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187937_hk;
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        this.func_82160_b(true, 500);
        int j = this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151078_bh, 1);
        }
        j = this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151074_bl, 1);
        }
    }

    public boolean interact(EntityPlayer player) {
        return false;
    }

    protected void addRandomArmor() {
        this.func_145779_a(Items.field_151043_k, 1);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.field_70146_Z.nextFloat() < 0.75f) {
            float f;
            int i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.75f : 0.5f;
            if (this.field_70146_Z.nextFloat() < 0.25f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.25f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.25f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (itemstack != null || (item = EntityPigZombie.func_184636_a((EntityEquipmentSlot)entityequipmentslot, (int)i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack(item));
            }
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
        if (this.func_70681_au().nextInt(2) > 0) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151010_B));
        }
        this.setToNotVillager();
        return livingdata;
    }
}

