/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGuardian
extends EntityFriendlyCreature {
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(EntityGuardian.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityGuardian.class, (DataSerializer)DataSerializers.field_187192_b);
    private float field_175482_b;
    private float field_175484_c;
    private float tailSwiping;
    private float spineExtention;
    private float field_175486_bm;
    private EntityLivingBase targetedEntity;
    private int field_175479_bo;
    private boolean field_175480_bp;
    private EntityAIWander wander;

    public EntityGuardian(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.field_70728_aV = 10;
        this.func_70105_a(1.0f, 1.0f);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIGuardianAttack());
        EntityAIMoveTowardsRestriction entityaimovetowardsrestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)entityaimovetowardsrestriction);
        this.wander = new EntityAIWander((EntityCreature)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wander);
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.wander.func_75248_a(3);
        entityaimovetowardsrestriction.func_75248_a(3);
        this.field_70765_h = new GuardianMoveHelper(this);
        this.field_175484_c = this.field_175482_b = this.field_70146_Z.nextFloat();
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.isElder() ? I18n.func_74838_a((String)"entity.ageofminecraft.ElderGuardianHelpful.name") : super.func_70005_c_();
    }

    @Override
    public EnumEntityTier getTier() {
        return this.isElder() ? EnumEntityTier.TIER5 : EnumEntityTier.TIER4;
    }

    public float func_70603_bj() {
        return this.isElder() ? 2.35f : 1.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setElder(tagCompund.func_74767_n("Elder"));
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Elder", this.isElder());
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    private boolean isSyncedFlagSet(int flagId) {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & flagId) != 0;
    }

    private void setSyncedFlag(int flagId, boolean state) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        if (state) {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 | flagId)));
        } else {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 & ~flagId)));
        }
    }

    public boolean func_175472_n() {
        return this.isSyncedFlagSet(2);
    }

    private void func_175476_l(boolean p_175476_1_) {
        this.setSyncedFlag(2, p_175476_1_);
    }

    public int func_175464_ck() {
        return this.isElder() ? 60 : 80;
    }

    public boolean isElder() {
        return this.isSyncedFlagSet(4);
    }

    public void setElder(boolean p_175467_1_) {
        this.setSyncedFlag(4, p_175467_1_);
        if (p_175467_1_) {
            this.func_70105_a(2.35f, 2.35f);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(22.0);
            this.func_70691_i(80.0f);
            this.func_110163_bv();
            if (this.wander != null) {
                this.wander.func_179479_b(400);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setElder() {
        this.setElder(true);
        this.spineExtention = 1.0f;
        this.field_175486_bm = 1.0f;
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (STATUS.equals(key)) {
            if (this.isElder()) {
                this.func_70105_a(2.35f, 2.35f);
            }
        } else if (TARGET_ENTITY.equals(key)) {
            this.field_175479_bo = 0;
            this.targetedEntity = null;
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isElder() ? SoundEvents.field_187512_aB : SoundEvents.field_187670_cb;
    }

    protected SoundEvent func_184601_bQ() {
        return this.isElder() ? SoundEvents.field_187517_aG : SoundEvents.field_187687_ch;
    }

    protected SoundEvent func_184615_bR() {
        return this.isElder() ? SoundEvents.field_187515_aE : SoundEvents.field_187678_ce;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public float func_70047_e() {
        return this.isElder() && this.field_70122_E && !this.func_70090_H() ? this.field_70131_O * 0.8f : this.field_70131_O * 0.5f;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70725_aQ > 0) {
            this.field_70181_x = -0.6;
        }
        if (this.isElder()) {
            this.func_70105_a(2.35f, 2.35f);
        } else {
            this.func_70105_a(1.0f, 1.0f);
        }
        this.func_70031_b(false);
        if (this.getOwner() != null && this.func_70068_e((Entity)this.getOwner()) >= 2304.0) {
            this.field_70173_aa = 0;
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 2.0f / this.field_70131_O);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 2.0f / this.field_70131_O);
            this.func_70661_as().func_75499_g();
            this.func_70012_b(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v, this.field_70177_z, this.field_70125_A);
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_175484_c = this.field_175482_b;
            if (!this.func_70090_H() && !this.isElder()) {
                this.tailSwiping = 1.0f;
                this.field_175480_bp = this.field_70181_x < 0.0 && this.field_70170_p.func_175677_d(new BlockPos((Entity)this).func_177977_b(), false);
            } else {
                this.tailSwiping = this.func_175472_n() ? (this.tailSwiping < 0.5f ? 4.0f : (this.tailSwiping += (0.5f - this.tailSwiping) * 0.1f)) : (this.tailSwiping += (0.125f - this.tailSwiping) * 0.2f);
            }
            this.field_175482_b += this.tailSwiping;
            this.field_175486_bm = this.spineExtention;
            this.spineExtention = !this.func_70090_H() ? (this.isElder() ? (this.field_70122_E ? (this.spineExtention += (0.7f - this.spineExtention) * 0.05f) : (this.spineExtention += (-0.6f - this.spineExtention) * 0.25f)) : this.field_70146_Z.nextFloat() - 0.5f) : (this.func_175472_n() ? (this.spineExtention += (-0.6f - this.spineExtention) * 0.25f) : (this.spineExtention += (0.25f - this.spineExtention) * 0.06f));
            if (this.func_175472_n() && this.func_70090_H()) {
                Vec3d vec3 = this.func_70676_i(0.0f);
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3.field_72450_a * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - vec3.field_72448_b * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3.field_72449_c * 1.5, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (this.hasTargetedEntity()) {
                EntityLivingBase entitylivingbase;
                if (this.field_175479_bo < this.func_175464_ck()) {
                    ++this.field_175479_bo;
                }
                if ((entitylivingbase = this.getTargetedEntity()) != null) {
                    this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
                    this.func_70671_ap().func_75649_a();
                    double d5 = this.func_175477_p(0.0f);
                    double d0 = entitylivingbase.field_70165_t - this.field_70165_t;
                    double d1 = entitylivingbase.field_70163_u + (double)(entitylivingbase.field_70131_O * 0.5f) - (this.field_70163_u + (double)this.func_70047_e());
                    double d2 = entitylivingbase.field_70161_v - this.field_70161_v;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_70146_Z.nextDouble();
                    while (d4 < d3) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.field_70163_u + d1 * d4 + (double)this.func_70047_e(), this.field_70161_v + d2 * d4, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E && !this.func_70093_af() && (!this.isElder() || this.isElder() && this.field_70172_ad > 0) && this.field_70173_aa % 5 == 0) {
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            this.func_70664_aZ();
        }
        if (this.hasTargetedEntity()) {
            this.field_70177_z = this.field_70759_as;
            if (!this.field_70128_L && this.field_70173_aa % 10 == 0) {
                float f = this.func_175477_p(0.0f);
                float pitch = 0.7f + 0.5f * f;
                this.func_184185_a(SoundEvents.field_187675_cd, 1.0f, pitch);
                if (this.getSpecialAttackTimer() <= 0) {
                    this.func_184185_a(SoundEvents.field_187675_cd, 3.0f, 0.5f);
                }
            }
        }
        if (this.field_70173_aa % 20 == 0) {
            this.func_175476_l(false);
        }
        if (this.field_70170_p.func_72890_a((Entity)this, 256.0) != null && this.field_70170_p.func_72890_a((Entity)this, 256.0) == this.getOwner() && this.func_70068_e((Entity)this.getOwner()) > 256.0) {
            this.func_70661_as().func_75499_g();
            if (this.func_70090_H()) {
                this.func_175476_l(true);
                double d01 = this.getOwner().field_70165_t - this.field_70165_t;
                double d11 = this.getOwner().field_70163_u - this.field_70163_u;
                double d21 = this.getOwner().field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
                this.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + this.field_70159_w * 0.5;
                this.field_70181_x = d11 / (double)f2 * 0.5 * 0.5 + this.field_70181_x * 0.5;
                this.field_70179_y = d21 / (double)f2 * 0.5 * 0.5 + this.field_70179_y * 0.5;
                this.func_70671_ap().func_75651_a((Entity)this.getOwner(), 180.0f, 180.0f);
                this.func_175476_l(true);
            } else if (this.field_70122_E && !this.func_184207_aI()) {
                double d01 = this.getOwner().field_70165_t - this.field_70165_t;
                double d11 = this.getOwner().field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
                this.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + this.field_70159_w * 0.5;
                this.field_70179_y = d11 / (double)f2 * 0.5 * 0.5 + this.field_70179_y * 0.5;
                this.func_70625_a((Entity)this.getOwner(), 180.0f, 30.0f);
                this.func_70664_aZ();
            }
        }
        super.func_70636_d();
    }

    public double func_70042_X() {
        return this.isElder() ? (double)this.field_70131_O * 1.1 : (this.field_70122_E && !this.func_70090_H() && !this.func_180799_ab() ? (double)this.field_70131_O * 1.4 : (double)this.field_70131_O * 0.95);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    protected void func_70664_aZ() {
        this.field_70181_x += 0.6;
        this.func_184185_a(SoundEvents.field_187684_cg, 1.0f, 1.0f);
        this.field_70122_E = false;
        this.field_70160_al = true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_175471_a(float p_175471_1_) {
        return this.field_175484_c + (this.field_175482_b - this.field_175484_c) * p_175471_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_175469_o(float p_175469_1_) {
        return this.field_175486_bm + (this.spineExtention - this.field_175486_bm) * p_175469_1_;
    }

    public float func_175477_p(float p_175477_1_) {
        return ((float)this.field_175479_bo + p_175477_1_) / (float)this.func_175464_ck();
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.isElder()) {
            boolean flag = true;
            boolean flag1 = true;
            boolean flag2 = true;
            boolean flag3 = true;
            if (this.field_70173_aa % 20 == 0) {
                List list = this.field_70170_p.func_175661_b(EntityPlayerMP.class, new Predicate(){

                    public boolean func_179913_a(EntityPlayerMP p_179913_1_) {
                        return EntityGuardian.this.func_70068_e((Entity)p_179913_1_) < 2500.0;
                    }

                    public boolean apply(Object p_apply_1_) {
                        return this.func_179913_a((EntityPlayerMP)p_apply_1_);
                    }
                });
                for (EntityPlayerMP entityplayermp : list) {
                    Potion potion;
                    if (entityplayermp.func_70644_a(potion = this.getOwner() != null && entityplayermp == this.getOwner() ? MobEffects.field_76422_e : MobEffects.field_76419_f) && entityplayermp.func_70660_b(potion).func_76458_c() >= 3 && entityplayermp.func_70660_b(potion).func_76459_b() >= 1000) continue;
                    entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(10, 0.0f));
                    entityplayermp.func_70690_d(new PotionEffect(potion, 6000, 3));
                    this.func_70671_ap().func_75651_a((Entity)entityplayermp, 180.0f, (float)this.func_70646_bf());
                }
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        return this.isElder() ? LootTableList.field_186441_w : LootTableList.field_186440_v;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (!this.func_175472_n() && !source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)source.func_76364_f();
                if (!source.func_94541_c() && (!entitylivingbase.func_184191_r((Entity)this) || this.getOwner() != null && entitylivingbase == this.getOwner())) {
                    entitylivingbase.func_70097_a(DamageSource.func_92087_a((Entity)this), 2.0f);
                    this.func_184185_a(SoundEvents.field_187903_gc, this.func_70599_aP(), this.func_70647_i());
                }
            }
            if (this.wander != null) {
                this.wander.func_179480_f();
            }
            return true;
        }
        return false;
    }

    public int func_70646_bf() {
        return this.isElder() && this.field_70122_E ? 5 : 180;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H() && this.field_70725_aQ <= 0) {
                this.func_70060_a(strafe, forward, 0.1f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.9f;
                this.field_70181_x *= (double)0.9f;
                this.field_70179_y *= (double)0.9f;
                if (!this.func_175472_n() && this.func_70638_az() == null) {
                    this.field_70181_x -= 0.005;
                }
            } else {
                super.func_70612_e(strafe, forward);
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    class GuardianMoveHelper
    extends EntityMoveHelper {
        private EntityGuardian entityGuardian;

        public GuardianMoveHelper(EntityGuardian guardian) {
            super((EntityLiving)guardian);
            this.entityGuardian = guardian;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.entityGuardian.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.entityGuardian.field_70165_t;
                double d1 = this.field_75647_c - this.entityGuardian.field_70163_u;
                double d2 = this.field_75644_d - this.entityGuardian.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
                this.entityGuardian.field_70761_aq = this.entityGuardian.field_70177_z = this.func_75639_a(this.entityGuardian.field_70177_z, f, 30.0f);
                float f1 = (float)(this.field_75645_e * this.entityGuardian.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entityGuardian.func_70659_e(this.entityGuardian.func_70689_ay() + (f1 - this.entityGuardian.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityGuardian.field_70177_z * (float)Math.PI / 180.0f);
                double d6 = Math.sin(this.entityGuardian.field_70177_z * (float)Math.PI / 180.0f);
                this.entityGuardian.field_70159_w += d4 * d5;
                this.entityGuardian.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.75) * 0.05;
                this.entityGuardian.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.entityGuardian.field_70181_x += (double)this.entityGuardian.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.entityGuardian.func_70671_ap();
                double d7 = this.entityGuardian.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.entityGuardian.func_70047_e() + this.entityGuardian.field_70163_u + d1 / d3 * 1.0;
                double d9 = this.entityGuardian.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.entityGuardian.func_175476_l(true);
            } else {
                this.entityGuardian.func_70659_e(0.0f);
                this.entityGuardian.func_175476_l(false);
            }
        }
    }

    class AIGuardianAttack
    extends EntityAIBase {
        private EntityGuardian guardian;
        private int tickCounter;

        public AIGuardianAttack() {
            this.guardian = EntityGuardian.this;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.guardian.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.guardian.func_70638_az() != null && this.tickCounter < this.guardian.func_175464_ck();
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.guardian.func_70661_as().func_75499_g();
            this.guardian.func_70671_ap().func_75651_a((Entity)this.guardian.func_70638_az(), 180.0f, (float)this.guardian.func_70646_bf());
            this.guardian.field_70160_al = true;
        }

        public void func_75251_c() {
            this.guardian.setTargetedEntity(0);
            this.guardian.func_70624_b(null);
            this.guardian.wander.func_179480_f();
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.guardian.func_70638_az();
            this.guardian.func_70661_as().func_75499_g();
            this.guardian.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, (float)this.guardian.func_70646_bf());
            if (!this.guardian.func_70685_l((Entity)entitylivingbase)) {
                this.guardian.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.guardian.moralRaisedTimer > 200) {
                    ++this.tickCounter;
                }
                if (this.tickCounter > 30) {
                    this.guardian.func_184185_a(SoundEvents.field_187675_cd, 1.0f, 1.25f);
                } else if (this.tickCounter <= 20 && this.tickCounter > 10) {
                    this.guardian.func_184185_a(SoundEvents.field_187675_cd, 1.0f, 1.0f);
                } else if (this.tickCounter <= 10 && this.tickCounter > 0) {
                    this.guardian.func_184185_a(SoundEvents.field_187675_cd, 1.0f, 0.75f);
                }
                if (this.tickCounter == 0) {
                    this.guardian.setTargetedEntity(this.guardian.func_70638_az().func_145782_y());
                    this.guardian.field_70170_p.func_72960_a((Entity)this.guardian, (byte)21);
                } else if (this.tickCounter >= this.guardian.func_175464_ck() && (entitylivingbase.field_70172_ad == 0 || this.guardian.isElder())) {
                    float f = 1.0f;
                    if (this.guardian.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        f += 2.0f;
                    }
                    if (this.guardian.isElder()) {
                        f += 2.0f;
                    }
                    this.guardian.func_70652_k((Entity)entitylivingbase);
                    if (this.guardian.isHero() && this.guardian.getSpecialAttackTimer() <= 0) {
                        entitylivingbase.field_70172_ad = 0;
                        this.guardian.field_70170_p.func_72885_a((Entity)this.guardian, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + (double)(entitylivingbase.field_70131_O / 2.0f), entitylivingbase.field_70161_v, 2.0f, true, false);
                        entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.guardian), (float)this.guardian.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 3.0f);
                        this.guardian.setSpecialAttackTimer(600);
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

