/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier4.EntityLargeFireballOther;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EntityGhast
extends EntityFriendlyCreature {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityGhast.class, (DataSerializer)DataSerializers.field_187198_h);
    private int explosionStrength = 1;

    public EntityGhast(World worldIn) {
        super(worldIn);
        this.func_70105_a(4.5f, 4.5f);
        this.field_70178_ae = true;
        this.field_70728_aV = 5;
        this.isOffensive = true;
        this.field_70765_h = new GhastMoveHelper(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 100.0f, 16.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround());
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER4;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 1;
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    @Override
    public void performSpecialAttack() {
        this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), this.func_70647_i());
        this.setSpecialAttackTimer(800);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.getOwner() != null && !this.func_70685_l((Entity)this.func_70638_az()) && this.field_70146_Z.nextInt(80) == 0) {
            this.setAttacking(true);
            this.func_184581_c(null);
        }
        this.field_70122_E = false;
        this.field_70160_al = true;
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
            EntityPlayer passenger = (EntityPlayer)this.func_184179_bs();
            this.field_70177_z = passenger.field_70177_z;
            this.field_70125_A = passenger.field_70125_A;
            this.func_70612_e(passenger.field_70702_br * (passenger.func_70051_ag() ? 4.0f : 2.0f), passenger.field_70701_bs * (passenger.func_70051_ag() ? 4.0f : 2.0f));
            if (Keyboard.isKeyDown((int)34)) {
                double d = this.field_70181_x = passenger.func_70051_ag() ? -0.2 : -0.1;
            }
            if (Keyboard.isKeyDown((int)57)) {
                double d = this.field_70181_x = passenger.func_70051_ag() ? 0.2 : 0.1;
            }
        }
        if (this.getOwner() != null && this.func_70638_az() == null && this.field_70173_aa % 10 == 0) {
            double d0 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(d0, d0, d0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (entity != null && entity.func_70089_S() && this.func_70685_l(entity) && !this.isOnSameTeam((EntityLivingBase)entity) && entity.func_70068_e((Entity)this.getOwner()) <= 256.0) {
                        this.func_70624_b((EntityLivingBase)entity);
                        continue;
                    }
                    list.remove(entity);
                }
            }
        }
    }

    public int getFireballStrength() {
        return this.explosionStrength;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70090_H()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.95f;
            float f1 = 0.16277136f / (f * f * f);
            this.func_70060_a(strafe, forward, 0.02f);
            f = 0.95f;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(17.0);
        this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(40.0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187555_bJ;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151073_bk, 1);
        }
        j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151016_H, 1);
        }
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 10.0f;
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("ExplosionPower", this.explosionStrength);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("ExplosionPower", 99)) {
            this.explosionStrength = tagCompund.func_74762_e("ExplosionPower");
        }
    }

    public float func_70047_e() {
        return 2.6f;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.95;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (!(stack != null || this.field_70170_p.field_72995_K || this.isWild() || player != this.getOwner() && !player.func_184191_r((Entity)this))) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.fleshHitCrushHeavy;
    }

    static class GhastMoveHelper
    extends EntityMoveHelper {
        private EntityGhast parentEntity;
        private int courseChangeCooldown;

        public GhastMoveHelper(EntityGhast ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        if (this.parentEntity.getOwner() != null && this.parentEntity.func_70068_e((Entity)this.parentEntity.getOwner()) > 4096.0 && this.parentEntity.guardBlock == null) {
                            this.parentEntity.field_70159_w += d0 / d3 * 0.3;
                            this.parentEntity.field_70181_x += d1 / d3 * 0.3;
                            this.parentEntity.field_70179_y += d2 / d3 * 0.3;
                        } else if (this.parentEntity.func_184179_bs() != null) {
                            this.parentEntity.field_70159_w += d0 / d3 * 0.15;
                            this.parentEntity.field_70181_x += d1 / d3 * 0.15;
                            this.parentEntity.field_70179_y += d2 / d3 * 0.15;
                        } else if (this.parentEntity.moralRaisedTimer > 200) {
                            this.parentEntity.field_70159_w += d0 / d3 * 0.2;
                            this.parentEntity.field_70181_x += d1 / d3 * 0.2;
                            this.parentEntity.field_70179_y += d2 / d3 * 0.2;
                        } else {
                            this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                            this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                            this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                        }
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private EntityGhast ghast;

        public AIRandomFly(EntityGhast ghast) {
            this.ghast = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.ghast.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.ghast.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.ghast.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.ghast.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.ghast.func_70681_au();
            if (this.ghast.getOwner() != null) {
                if (this.ghast.func_184179_bs() != null) {
                    double d8 = 8.0;
                    Vec3d vec3 = this.ghast.func_184179_bs().func_70676_i(1.0f);
                    double dx = vec3.field_72450_a * d8;
                    double dy = vec3.field_72448_b * d8;
                    double dz = vec3.field_72449_c * d8;
                    double d0 = this.ghast.field_70165_t + dx;
                    double d1 = this.ghast.field_70163_u + dy;
                    double d2 = this.ghast.field_70161_v + dz;
                    this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                } else if (this.ghast.getOwner().func_70093_af()) {
                    double d0 = this.ghast.getOwner().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
                    double d1 = this.ghast.getOwner().field_70163_u + 8.0 + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
                    double d2 = this.ghast.getOwner().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
                    this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                } else {
                    double d0 = this.ghast.getOwner().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d1 = this.ghast.getOwner().field_70163_u + 64.0 + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d2 = this.ghast.getOwner().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                }
            } else {
                double d0 = this.ghast.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d1 = this.ghast.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d2 = this.ghast.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            }
        }
    }

    class AILookAround
    extends EntityAIBase {
        private EntityGhast parentEntity;

        public AILookAround() {
            this.parentEntity = EntityGhast.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_184179_bs() != null) {
                this.parentEntity.field_70126_B = this.parentEntity.field_70177_z = this.parentEntity.func_184179_bs().field_70177_z;
                this.parentEntity.field_70125_A = 0.0f;
                this.parentEntity.func_70101_b(this.parentEntity.field_70177_z, this.parentEntity.field_70125_A);
                this.parentEntity.field_70759_as = this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z;
            } else if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70177_z = this.parentEntity.field_70759_as = -((float)Math.atan2(this.parentEntity.field_70159_w, this.parentEntity.field_70179_y)) * 180.0f / (float)Math.PI;
                this.parentEntity.field_70761_aq = this.parentEntity.field_70759_as;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = this.parentEntity.field_70759_as;
                this.parentEntity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, 30.0f);
            }
        }
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private EntityGhast ghast;
        public int attackTimer;

        public AIFireballAttack(EntityGhast ghast) {
            this.ghast = ghast;
        }

        public boolean func_75250_a() {
            return this.ghast.func_70638_az() != null && !this.ghast.func_70093_af();
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.ghast.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.ghast.func_70638_az();
            double d0 = 100.0;
            if (entitylivingbase != null && entitylivingbase.func_70068_e((Entity)this.ghast) < d0 * d0 && this.ghast.func_70685_l((Entity)entitylivingbase)) {
                World world = this.ghast.field_70170_p;
                ++this.attackTimer;
                if (this.ghast.moralRaisedTimer > 200) {
                    ++this.attackTimer;
                }
                if (this.attackTimer == 10) {
                    this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.8f + this.ghast.func_70681_au().nextFloat() * 0.4f);
                }
                if (this.attackTimer == 20) {
                    float dm;
                    double d1 = 4.0;
                    Vec3d vec3 = this.ghast.func_70676_i(1.0f);
                    double d2 = entitylivingbase.field_70165_t - (this.ghast.field_70165_t + vec3.field_72450_a * d1);
                    double d3 = entitylivingbase.field_70163_u + 2.0 - (this.ghast.field_70163_u + (double)(this.ghast.field_70131_O / 2.0f));
                    double d4 = entitylivingbase.field_70161_v - (this.ghast.field_70161_v + vec3.field_72449_c * d1);
                    EntityLargeFireballOther entitylargefireball = new EntityLargeFireballOther(world, (EntityLivingBase)this.ghast, d2, d3, d4);
                    entitylargefireball.field_92057_e = this.ghast.getFireballStrength();
                    entitylargefireball.field_70165_t = this.ghast.field_70165_t + vec3.field_72450_a * d1;
                    entitylargefireball.field_70163_u = this.ghast.field_70163_u + 1.0;
                    entitylargefireball.field_70161_v = this.ghast.field_70161_v + vec3.field_72449_c * d1;
                    entitylargefireball.damage = dm = (float)this.ghast.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                    if (this.ghast.isHero() && this.ghast.getSpecialAttackTimer() <= 0) {
                        this.ghast.func_184185_a(SoundEvents.field_187557_bK, 10.0f, 0.5f);
                        world.func_72838_d((Entity)entitylargefireball);
                        entitylargefireball.damage = dm * 10.0f;
                        entitylargefireball.field_92057_e = this.ghast.getFireballStrength() * 6;
                        this.ghast.setSpecialAttackTimer(1000);
                        this.attackTimer = -100;
                    } else {
                        this.ghast.func_184185_a(SoundEvents.field_187557_bK, 10.0f, 1.0f);
                        world.func_72838_d((Entity)entitylargefireball);
                        this.attackTimer = this.ghast.moralRaisedTimer > 200 ? -20 : -40;
                    }
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.ghast.setAttacking(this.attackTimer > 10);
        }
    }
}

