/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EntityEnderman
extends EntityFriendlyCreature {
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", (double)0.15f, 0).func_111168_a(false);
    private static final Set<Block> carriableBlocks = Sets.newIdentityHashSet();
    private static final DataParameter<Optional<IBlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(EntityEnderman.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityEnderman.class, (DataSerializer)DataSerializers.field_187198_h);
    private int field_184720_bx = 0;
    private int field_184721_by = 0;
    protected float jumpPower;

    public EntityEnderman(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 2.875f);
        this.field_70138_W = 1.0f;
        this.isOffensive = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_CACTUS, -1.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIPlaceBlock(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AITakeBlock(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.5, 48.0f, 12.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(15.0);
    }

    @Override
    public int timesToConvert() {
        return 27;
    }

    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (entitylivingbaseIn == null) {
            this.field_184721_by = 0;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)false);
            iattributeinstance.func_111124_b(attackingSpeedBoostModifier);
        } else {
            this.field_184721_by = this.field_70173_aa;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)true);
            if (!iattributeinstance.func_180374_a(attackingSpeedBoostModifier)) {
                iattributeinstance.func_111121_a(attackingSpeedBoostModifier);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER4;
    }

    @Override
    public boolean func_70601_bi() {
        return this.isValidLightLevel() && super.func_70601_bi();
    }

    public void func_184716_o() {
        if (this.field_70173_aa >= this.field_184720_bx + 400) {
            this.field_184720_bx = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.isScreaming() && this.field_70170_p.field_72995_K) {
            this.func_184716_o();
        }
        super.func_184206_a(key);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        IBlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            tagCompound.func_74777_a("carried", (short)Block.func_149682_b((Block)iblockstate.func_177230_c()));
            tagCompound.func_74777_a("carriedData", (short)iblockstate.func_177230_c().func_176201_c(iblockstate));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        IBlockState iblockstate = tagCompund.func_150297_b("carried", 8) ? Block.func_149684_b((String)tagCompund.func_74779_i("carried")).func_176203_a(tagCompund.func_74765_d("carriedData") & 0xFFFF) : Block.func_149729_e((int)tagCompund.func_74765_d("carried")).func_176203_a(tagCompund.func_74765_d("carriedData") & 0xFFFF);
        if (iblockstate == null || iblockstate.func_177230_c() == null || iblockstate.func_185904_a() == Material.field_151579_a) {
            iblockstate = null;
        }
        this.setHeldBlockState(iblockstate);
    }

    public float func_70047_e() {
        return 2.55f;
    }

    @Override
    public void performSpecialAttack() {
        List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(128.0, 128.0, 128.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
        if (list != null && !list.isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                if (entity == null || this.isOnSameTeam(entity)) continue;
                this.teleportToEntity((Entity)entity);
                this.func_70652_k((Entity)entity);
            }
        }
        this.setSpecialAttackTimer(1200);
    }

    @Override
    public void func_70636_d() {
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70068_e((Entity)this.func_70638_az()) < 512.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.func_70638_az() != null) {
            this.field_70180_af.func_187227_b(SCREAMING, (Object)true);
            if (this.field_70173_aa % 250 == 0) {
                this.func_184185_a(SoundEvents.field_187533_aW, this.func_70093_af() ? 1.0f : 10.0f, 1.0f);
            }
            if (this.func_70638_az().field_70131_O <= 2.5f && this.func_70638_az().func_184222_aU() && this.func_70638_az() instanceof EntityLiving) {
                ((EntityLiving)this.func_70638_az()).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 9));
                ((EntityLiving)this.func_70638_az()).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 0));
                ((EntityLiving)this.func_70638_az()).func_70671_ap().func_75650_a(this.func_70638_az().field_70165_t + (this.field_70146_Z.nextDouble() * 30.0 - 15.0), this.func_70638_az().field_70163_u + (this.field_70146_Z.nextDouble() * 30.0 - 15.0), this.func_70638_az().field_70161_v + (this.field_70146_Z.nextDouble() * 30.0 - 15.0), 180.0f, 180.0f);
                ((EntityLiving)this.func_70638_az()).func_70624_b(null);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (this.getOwner() != null && this.func_70068_e((Entity)this.getOwner()) > 4096.0 && !this.field_70170_p.field_72995_K) {
            this.func_70624_b(null);
            this.func_70661_as().func_75499_g();
            this.teleportTo(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v);
        }
        if (this.func_70643_av() != null && this.func_70681_au().nextInt(20) == 0) {
            if (this.func_70643_av().func_70068_e((Entity)this) < 2.0 && !this.field_70170_p.field_72995_K) {
                this.teleportRandomly();
            }
            if (this.func_70643_av().func_70068_e((Entity)this) > 128.0 && !this.field_70170_p.field_72995_K) {
                this.teleportToEntity((Entity)this.func_70643_av());
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        if (this.func_70026_G()) {
            this.teleportRandomly();
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        if (this.field_70170_p.func_72935_r() || this.func_70026_G()) {
            this.func_70642_aH();
        }
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean func_184595_k(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (this instanceof EntityCreature) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    protected Item func_146068_u() {
        return Items.field_151079_bi;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (!(stack != null || this.field_70170_p.field_72995_K || this.isWild() || player != this.getOwner() && !player.func_184191_r((Entity)this))) {
            IBlockState iblockstate = this.getHeldBlockState();
            if (iblockstate != null) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(new ItemStack(iblockstate.func_177230_c(), 1, iblockstate.func_177230_c().func_176201_c(iblockstate)), 0.0f);
                }
                this.setHeldBlockState(null);
            } else if (!player.func_70093_af() && iblockstate == null) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151061_bv && player == this.getOwner()) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            this.func_184204_a(1);
            player.func_184204_a(1);
            return true;
        }
        return false;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double d8 = 0.5;
            Vec3d vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            double dz = vec3.field_72449_c * d8;
            passenger.func_70107_b(this.field_70165_t + dx, this.field_70163_u + 0.25, this.field_70161_v + dz);
            passenger.field_70143_R *= 0.0f;
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70177_z = this.field_70759_as = entitylivingbase.field_70177_z;
            this.field_70126_B = this.field_70759_as;
            this.field_70125_A = 0.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 1.5f);
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (Keyboard.isKeyDown((int)57) && this.field_70122_E) {
                this.field_70181_x += 1.0;
                this.jumpPower = 0.0f;
                ForgeHooks.onLivingJump((EntityLivingBase)this);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.01f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        Item item = this.func_146068_u();
        if (item != null) {
            int j = this.field_70146_Z.nextInt(2 + p_70628_2_);
            for (int k = 0; k < j; ++k) {
                this.func_145779_a(item, 1);
            }
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        IBlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            this.func_70099_a(new ItemStack(iblockstate.func_177230_c(), 1, iblockstate.func_177230_c().func_176201_c(iblockstate)), 0.0f);
        }
    }

    public void setHeldBlockState(IBlockState state) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, (Object)Optional.fromNullable((Object)state));
    }

    public IBlockState getHeldBlockState() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orNull();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        if (this.func_180431_b(source) || source.func_76346_g() instanceof EntityCreeper || source instanceof EntityDamageSourceIndirect || source.func_94541_c() || source.func_76352_a()) {
            for (int i = 0; i < 64; ++i) {
                this.teleportRandomly();
            }
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76363_c()) {
            this.teleportRandomly();
        }
        return flag;
    }

    public static void setCarriable(Block block, boolean canCarry) {
        if (canCarry) {
            carriableBlocks.add(block);
        } else {
            carriableBlocks.remove(block);
        }
    }

    public static boolean getCarriable(Block block) {
        return carriableBlocks.contains(block);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    @SideOnly(value=Side.CLIENT)
    public void setJumpPower(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean canJump() {
        return this.func_184207_aI();
    }

    public void func_184775_b(int p_184775_1_) {
    }

    public void func_184777_r_() {
    }

    public void handleStartJump(int p_184775_1_) {
    }

    public void handleStopJump() {
    }

    static {
        carriableBlocks.add((Block)Blocks.field_150349_c);
        carriableBlocks.add(Blocks.field_150346_d);
        carriableBlocks.add((Block)Blocks.field_150354_m);
        carriableBlocks.add(Blocks.field_150322_A);
        carriableBlocks.add(Blocks.field_180395_cM);
        carriableBlocks.add(Blocks.field_150322_A);
        carriableBlocks.add(Blocks.field_150406_ce);
        carriableBlocks.add(Blocks.field_150405_ch);
        carriableBlocks.add(Blocks.field_150407_cf);
        carriableBlocks.add(Blocks.field_150351_n);
        carriableBlocks.add((Block)Blocks.field_150328_O);
        carriableBlocks.add((Block)Blocks.field_150327_N);
        carriableBlocks.add((Block)Blocks.field_150338_P);
        carriableBlocks.add((Block)Blocks.field_150337_Q);
        carriableBlocks.add(Blocks.field_150344_f);
        carriableBlocks.add(Blocks.field_150364_r);
        carriableBlocks.add(Blocks.field_150363_s);
        carriableBlocks.add(Blocks.field_185766_cS);
        carriableBlocks.add(Blocks.field_185765_cR);
        carriableBlocks.add(Blocks.field_150335_W);
        carriableBlocks.add((Block)Blocks.field_150434_aF);
        carriableBlocks.add(Blocks.field_150435_aG);
        carriableBlocks.add(Blocks.field_150423_aK);
        carriableBlocks.add(Blocks.field_150440_ba);
        carriableBlocks.add(Blocks.field_189880_di);
        carriableBlocks.add(Blocks.field_189878_dg);
        carriableBlocks.add(Blocks.field_150385_bj);
        carriableBlocks.add(Blocks.field_189877_df);
        carriableBlocks.add((Block)Blocks.field_150391_bh);
        carriableBlocks.add(Blocks.field_150424_aL);
        carriableBlocks.add(Blocks.field_150447_bR);
        carriableBlocks.add((Block)Blocks.field_150479_bC);
        carriableBlocks.add(Blocks.field_150473_bD);
        carriableBlocks.add(Blocks.field_150404_cg);
        carriableBlocks.add(Blocks.field_150432_aD);
        carriableBlocks.add(Blocks.field_185778_de);
        carriableBlocks.add(Blocks.field_150367_z);
        carriableBlocks.add(Blocks.field_189879_dh);
        carriableBlocks.add(Blocks.field_150359_w);
        carriableBlocks.add(Blocks.field_150410_aZ);
        carriableBlocks.add(Blocks.field_150426_aN);
        carriableBlocks.add(Blocks.field_150425_aM);
        carriableBlocks.add((Block)Blocks.field_150362_t);
        carriableBlocks.add((Block)Blocks.field_150361_u);
        carriableBlocks.add(Blocks.field_150403_cj);
        carriableBlocks.add(Blocks.field_150365_q);
        carriableBlocks.add(Blocks.field_150366_p);
        carriableBlocks.add(Blocks.field_150369_x);
        carriableBlocks.add(Blocks.field_150450_ax);
        carriableBlocks.add(Blocks.field_150352_o);
        carriableBlocks.add(Blocks.field_150482_ag);
        carriableBlocks.add(Blocks.field_150412_bA);
    }

    static class AITakeBlock
    extends EntityAIBase {
        private final EntityEnderman enderman;

        public AITakeBlock(EntityEnderman p_i45841_1_) {
            this.enderman = p_i45841_1_;
        }

        public boolean func_75250_a() {
            return this.enderman.getHeldBlockState() == null;
        }

        public void func_75246_d() {
            boolean flag;
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 3.0 + random.nextDouble() * 6.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u - 1.0 + random.nextDouble() * 4.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 3.0 + random.nextDouble() * 6.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            RayTraceResult raytraceresult = world.func_147447_a(new Vec3d((double)((float)MathHelper.func_76128_c((double)this.enderman.field_70165_t) + 0.5f), (double)((float)j + 0.5f), (double)((float)MathHelper.func_76128_c((double)this.enderman.field_70161_v) + 0.5f)), new Vec3d((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f)), false, true, false);
            boolean bl = flag = raytraceresult != null && raytraceresult.func_178782_a().equals((Object)blockpos);
            if (carriableBlocks.contains(block) && flag) {
                this.enderman.func_184609_a(EnumHand.MAIN_HAND);
                this.enderman.func_184609_a(EnumHand.OFF_HAND);
                this.enderman.func_70671_ap().func_75650_a((double)i, (double)j, (double)k, 180.0f, 40.0f);
                this.enderman.field_70170_p.func_175718_b(1021, blockpos, 0);
                this.enderman.field_70170_p.func_175718_b(2001, blockpos, Block.func_149682_b((Block)block));
                this.enderman.setHeldBlockState(iblockstate);
                world.func_175698_g(blockpos);
            }
        }
    }

    static class AIPlaceBlock
    extends EntityAIBase {
        private final EntityEnderman enderman;

        public AIPlaceBlock(EntityEnderman p_i45843_1_) {
            this.enderman = p_i45843_1_;
        }

        public boolean func_75250_a() {
            return this.enderman.getHeldBlockState() != null && this.enderman.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            IBlockState iblockstate1 = world.func_180495_p(blockpos.func_177977_b());
            IBlockState iblockstate2 = this.enderman.getHeldBlockState();
            if (iblockstate2 != null && this.func_188518_a(world, blockpos, iblockstate2.func_177230_c(), iblockstate, iblockstate1)) {
                this.enderman.field_70170_p.func_175718_b(2001, blockpos, Block.func_149682_b((Block)iblockstate2.func_177230_c()));
                world.func_180501_a(blockpos, iblockstate2, 3);
                this.enderman.setHeldBlockState(null);
            }
        }

        private boolean func_188518_a(World p_188518_1_, BlockPos p_188518_2_, Block p_188518_3_, IBlockState p_188518_4_, IBlockState p_188518_5_) {
            return p_188518_5_.func_185904_a() == Material.field_151579_a ? false : (p_188518_4_.func_185904_a() != Material.field_151579_a ? false : (!p_188518_3_.func_176196_c(p_188518_1_, p_188518_2_) ? false : p_188518_5_.func_185917_h()));
        }
    }
}

