/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier4.EntitySmallFireballOther;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlaze
extends EntityFriendlyCreature {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private static final DataParameter<Byte> ON_FIRE = EntityDataManager.func_187226_a(EntityBlaze.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityBlaze(World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.isOffensive = true;
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 32.0f, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER4;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ON_FIRE, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187600_C;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    @Override
    public void performSpecialAttack() {
        this.setSpecialAttackTimer(800);
    }

    @Override
    public void func_70636_d() {
        if (this.isHero() && this.getSpecialAttackTimer() > 790) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null || this.isOnSameTeam(entity)) continue;
                    entity.field_70172_ad = 0;
                    entity.func_70097_a(DamageSource.field_76372_a, 2.0f);
                    entity.func_70015_d(60);
                    if (entity.func_70089_S() || this.isWild()) continue;
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was scorched by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 256.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.isHero() && this.getSpecialAttackTimer() > 790) {
                for (int i = 0; i < 3000; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, new int[0]);
                }
            }
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), this.func_70599_aP(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                if (this.func_70093_af()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                    continue;
                }
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        EntityLivingBase entitylivingbase;
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((entitylivingbase = this.func_70638_az()) != null && entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
            this.field_70181_x += ((double)0.3f - this.field_70181_x) * (double)0.3f;
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected Item func_146068_u() {
        return Items.field_151072_bj;
    }

    public boolean func_70027_ad() {
        return this.func_70845_n();
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int j = this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151072_bj, 1);
        }
    }

    public boolean func_70845_n() {
        return ((Byte)this.field_70180_af.func_187225_a(ON_FIRE) & 1) != 0;
    }

    public void setOnFire(boolean onFire) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ON_FIRE);
        b0 = onFire ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ON_FIRE, (Object)b0);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.metalHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.metalHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.metalHitCrush;
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private EntityBlaze blaze;
        private int field_179467_b;
        private int field_179468_c;

        public AIFireballAttack(EntityBlaze blazeIn) {
            this.blaze = blazeIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.field_179467_b = 0;
        }

        public void func_75251_c() {
            this.blaze.setOnFire(false);
        }

        public void func_75246_d() {
            --this.field_179468_c;
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            double d0 = this.blaze.func_70068_e((Entity)entitylivingbase);
            if (d0 < 6.0) {
                if (this.field_179468_c <= 0) {
                    this.field_179468_c = 20;
                    this.blaze.func_70652_k((Entity)entitylivingbase);
                }
                this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            } else if (d0 < 1024.0) {
                double d1 = entitylivingbase.field_70165_t - this.blaze.field_70165_t;
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 5.0f) - (this.blaze.field_70163_u + (double)(this.blaze.field_70131_O / 5.0f));
                double d3 = entitylivingbase.field_70161_v - this.blaze.field_70161_v;
                if (this.field_179468_c <= 0) {
                    ++this.field_179467_b;
                    if (this.field_179467_b == 1) {
                        this.field_179468_c = this.blaze.moralRaisedTimer > 200 ? 1 : 60;
                        this.blaze.setOnFire(true);
                    } else if (this.field_179467_b <= 4) {
                        this.field_179468_c = this.blaze.moralRaisedTimer > 200 ? 2 : 6;
                    } else {
                        this.field_179468_c = this.blaze.moralRaisedTimer > 200 ? 1 : 100;
                        this.field_179467_b = 0;
                        this.blaze.setOnFire(false);
                    }
                    if (this.field_179467_b > 1) {
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                        this.blaze.field_70170_p.func_180498_a((EntityPlayer)null, 1018, new BlockPos((int)this.blaze.field_70165_t, (int)this.blaze.field_70163_u, (int)this.blaze.field_70161_v), 0);
                        for (int i = 0; i < 1; ++i) {
                            EntitySmallFireballOther entitysmallfireball = new EntitySmallFireballOther(this.blaze.field_70170_p, (EntityLivingBase)this.blaze, d1 + this.blaze.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.blaze.func_70681_au().nextGaussian() * (double)f);
                            entitysmallfireball.field_70163_u = this.blaze.field_70163_u + (double)(this.blaze.field_70131_O / 2.0f) + 0.5;
                            this.blaze.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                            float dm = (float)this.blaze.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                            entitysmallfireball.damage = dm * 0.6f;
                        }
                    }
                }
                this.blaze.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 30.0f);
                if (d0 < 1024.0 && !this.blaze.field_70122_E) {
                    if (this.blaze.moralRaisedTimer > 200) {
                        this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.5);
                    } else {
                        this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
                    }
                }
            } else {
                this.blaze.func_70661_as().func_75499_g();
                if (this.blaze.moralRaisedTimer > 200) {
                    this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.5);
                } else {
                    this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
                }
            }
            super.func_75246_d();
        }
    }
}

