/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.ai.EntityAIZombieAllyAttack;
import net.minecraft.entity.helpful.tier1.EntityChicken;
import net.minecraft.entity.helpful.tier4.EntityPigZombie;
import net.minecraft.entity.helpful.tier6.EntityWitherStorm;
import net.minecraft.entity.helpful.tier6.EntityWitherStormHead;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacle;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacleDevourer;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityZombie
extends EntityFriendlyCreature {
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> IS_HUSK = EntityDataManager.func_187226_a(EntityZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VILLAGER_TYPE = EntityDataManager.func_187226_a(EntityZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CONVERTING = EntityDataManager.func_187226_a(EntityZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private int conversionTime;
    private boolean isBreakDoorsTaskSet = false;
    private float zombieWidth = -1.0f;
    private float zombieHeight;
    private int helmetCount = 1;

    public EntityZombie(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.1, 24.0f, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIZombieAllyAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
        this.func_70105_a(0.5f, 1.95f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_HUSK, (Object)false);
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
        this.func_184212_Q().func_187214_a(VILLAGER_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(CONVERTING, (Object)false);
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)false);
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.isHusk() ? I18n.func_74838_a((String)"entity.ageofminecraft.HuskHelpful.name") : super.func_70005_c_();
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER3;
    }

    @Override
    public boolean func_70601_bi() {
        return this.isValidLightLevel() && super.func_70601_bi();
    }

    @Override
    protected int getTimeBetweenSteps() {
        return 15;
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }

    public boolean isHusk() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_HUSK);
    }

    public void setHusk(boolean childZombie) {
        this.func_184212_Q().func_187227_b(IS_HUSK, (Object)childZombie);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void setChild(boolean childZombie) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)childZombie);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(babySpeedBoostModifier);
            if (childZombie) {
                iattributeinstance.func_111121_a(babySpeedBoostModifier);
            }
        }
        this.setChildSize(childZombie);
    }

    public boolean isVillager() {
        return (Integer)this.func_184212_Q().func_187225_a(VILLAGER_TYPE) > 0;
    }

    public int getVillagerType() {
        return (Integer)this.func_184212_Q().func_187225_a(VILLAGER_TYPE) - 1;
    }

    public void setVillagerType(int villagerType) {
        this.func_184212_Q().func_187227_b(VILLAGER_TYPE, (Object)(villagerType + 1));
    }

    public void setToNotVillager() {
        this.func_184212_Q().func_187227_b(VILLAGER_TYPE, (Object)0);
    }

    protected void func_184590_k(float p_184590_1_) {
        this.field_70718_bc = 40;
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
        this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 30, 1));
    }

    public boolean func_184585_cz() {
        return this.func_70638_az() != null && this.field_70718_bc <= 0 && this.func_184592_cb() != null && !this.func_184587_cr() && this.func_184592_cb().func_77973_b() == Items.field_185159_cQ && this.func_70068_e((Entity)this.func_70638_az()) < 16.0;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151033_d || this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151059_bz)) {
                entityIn.func_70015_d(12);
            }
            if (this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.5f) {
                entityIn.func_70015_d(5 * (int)f);
            }
            if (this.isHusk() && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).field_70181_x += 0.2;
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76438_s, 200 * (int)f));
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200));
                }
            }
        }
        return flag;
    }

    @Override
    public void performSpecialAttack() {
        this.setSpecialAttackTimer(700);
    }

    @Override
    protected boolean func_70610_aX() {
        return this.getSpecialAttackTimer() > 600;
    }

    @Override
    public void func_70636_d() {
        if (!(this instanceof EntityPigZombie)) {
            Object entity;
            int i1;
            List list;
            if (this.isHero() && this.getSpecialAttackTimer() > 600) {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
                if (list != null && !list.isEmpty()) {
                    for (i1 = 0; i1 < list.size(); ++i1) {
                        entity = (EntityLivingBase)list.get(i1);
                        if (entity == null || this.isOnSameTeam((EntityLivingBase)entity)) continue;
                        entity.field_70172_ad = 0;
                        if (!(entity instanceof EntityWitherStorm || entity instanceof EntityWitherStormHead || entity instanceof EntityWitherStormTentacle || entity instanceof EntityWitherStormTentacleDevourer)) {
                            entity.func_70097_a(DamageSource.field_82727_n, 0.05f);
                        } else {
                            entity.func_70097_a(DamageSource.field_82727_n, 1.0f);
                        }
                        if (entity.func_70089_S() || this.isWild()) continue;
                        this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was yelled at to death by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                    }
                }
            }
            if (this.isHero() && this.getSpecialAttackTimer() > 600 && this.getSpecialAttackTimer() < 640) {
                this.field_70125_A = -50.0f;
            }
            if (this.isHero() && this.getSpecialAttackTimer() == 600 && (list = this.field_70170_p.func_175647_a(EntityFriendlyCreature.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty()) {
                for (i1 = 0; i1 < list.size(); ++i1) {
                    entity = (EntityFriendlyCreature)list.get(i1);
                    if (entity == null || !this.isOnSameTeam((EntityLivingBase)entity)) continue;
                    this.moralRaisedTimer = 600;
                    entity.moralRaisedTimer = 600;
                }
            }
            if (this.isHero() && this.getSpecialAttackTimer() == 640) {
                if (this.func_70631_g_()) {
                    this.func_184185_a(ModSoundEvents.zombieSpecial, 10.0f, 1.5f);
                } else {
                    this.func_184185_a(ModSoundEvents.zombieSpecial, 10.0f, 1.0f);
                }
            }
            if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
                this.performSpecialAttack();
            }
        }
        if (this.helmetCount < 0) {
            this.helmetCount = 0;
        }
        if ((this instanceof EntityPigZombie || this.isHusk() || this.func_70631_g_() || this.isHero()) && this.helmetCount != 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a((Item)Items.field_151024_Q, 1);
            }
            --this.helmetCount;
        }
        if (!(!this.field_70170_p.func_72935_r() || this.field_70170_p.field_72995_K || this.func_70631_g_() || this.func_70045_F() || this.isHusk() || this.isHero())) {
            float f = this.func_70013_c(1.0f);
            BlockPos blockpos = new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                boolean flag = true;
                ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (itemstack != null) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_70669_a(itemstack);
                            this.func_184201_a(EntityEquipmentSlot.HEAD, null);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    if (this.helmetCount > 0) {
                        --this.helmetCount;
                        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151024_Q));
                        this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
                    } else {
                        this.func_70015_d(8);
                    }
                }
            }
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.isConverting()) {
            int i = this.getConversionTimeBoost();
            this.conversionTime -= i;
            if (this.conversionTime <= 0) {
                this.convertToVillager();
            }
        }
        super.func_70071_h_();
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
            entitycreature.field_70125_A = this.field_70125_A;
            entitycreature.field_70759_as = this.field_70759_as;
            if (this.func_70638_az() != null) {
                entitycreature.func_70624_b(this.func_70638_az());
            }
            if (this.field_70173_aa % 40 == 0) {
                this.field_70761_aq = this.field_70177_z = this.field_70759_as;
                if (this.func_70638_az() == null) {
                    entitycreature.func_70691_i(5.0f);
                } else {
                    entitycreature.func_70691_i(1.0f);
                }
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isHusk() ? SoundEvents.field_190022_cI : (this.isVillager() ? SoundEvents.field_187940_hn : SoundEvents.field_187899_gZ);
    }

    protected SoundEvent func_184601_bQ() {
        return this.isHusk() ? SoundEvents.field_190024_cK : (this.isVillager() ? SoundEvents.field_187944_hr : SoundEvents.field_187934_hh);
    }

    protected SoundEvent func_184615_bR() {
        return this.isHusk() ? SoundEvents.field_190023_cJ : (this.isVillager() ? SoundEvents.field_187943_hq : SoundEvents.field_187930_hd);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.isHusk() ? SoundEvents.field_190025_cL : (this.isVillager() ? SoundEvents.field_187946_ht : SoundEvents.field_187939_hm), 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return Items.field_151078_bh;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        super.func_70628_a(p_70628_1_, p_70628_2_);
        this.func_82160_b(true, 500);
        if (this.helmetCount > 0) {
            this.func_145779_a((Item)Items.field_151024_Q, this.helmetCount);
        }
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                this.func_145779_a(Items.field_151042_j, 1);
                break;
            }
            case 1: {
                this.func_145779_a(Items.field_151172_bF, 1);
                break;
            }
            case 2: {
                this.func_145779_a(Items.field_151174_bG, 1);
            }
        }
    }

    public boolean func_70662_br() {
        return true;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int i;
        if (this.field_70146_Z.nextFloat() < 0.75f) {
            float f;
            i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.75f : 0.5f;
            if (this.field_70146_Z.nextFloat() < 0.25f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.25f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.25f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (itemstack != null || (item = EntityZombie.func_184636_a((EntityEquipmentSlot)entityequipmentslot, (int)i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack(item));
            }
        }
        float f = this.field_70146_Z.nextFloat();
        float f3 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.5f : 0.1f;
        if (f < f3) {
            i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                if (this.func_70681_au().nextInt(2) > 0) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151040_l));
                }
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151037_a));
                if (this.func_70681_au().nextInt(2) > 0) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151037_a));
                }
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.func_70631_g_()) {
            tagCompound.func_74757_a("IsBaby", true);
        }
        if (this.isHusk()) {
            tagCompound.func_74757_a("IsHusk", true);
        }
        if (this.isVillager()) {
            tagCompound.func_74757_a("IsVillager", true);
            tagCompound.func_74768_a("VillagerProfession", this.getVillagerType());
        }
        tagCompound.func_74768_a("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (tagCompund.func_74767_n("IsHusk")) {
            this.setHusk(true);
        }
        if (tagCompund.func_74767_n("IsVillager")) {
            if (tagCompund.func_150297_b("VillagerProfession", 99)) {
                this.setVillagerType(tagCompund.func_74762_e("VillagerProfession"));
            } else {
                this.setVillagerType(this.field_70170_p.field_73012_v.nextInt(5));
            }
        }
        if (tagCompund.func_150297_b("ConversionTime", 99) && tagCompund.func_74762_e("ConversionTime") > -1) {
            this.startConversion(tagCompund.func_74762_e("ConversionTime"));
        }
    }

    @Override
    public void func_70074_a(EntityLivingBase entityLivingIn) {
        EntityZombie entityzombie;
        Object entityvillager;
        super.func_70074_a(entityLivingIn);
        if ((this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) && entityLivingIn instanceof EntityVillager) {
            entityvillager = (EntityVillager)entityLivingIn;
            entityzombie = new EntityZombie(this.field_70170_p);
            entityzombie.field_70125_A = ((EntityVillager)entityvillager).field_70125_A;
            entityzombie.field_70177_z = entityzombie.field_70759_as = ((EntityVillager)entityvillager).field_70759_as;
            entityzombie.field_70761_aq = entityzombie.field_70759_as;
            entityzombie.func_82149_j((Entity)entityLivingIn);
            this.field_70170_p.func_72900_e((Entity)entityLivingIn);
            entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), new GroupData(false, true));
            entityzombie.setVillagerType(entityvillager.func_70946_n());
            entityzombie.setChild(entityLivingIn.func_70631_g_());
            entityzombie.func_94061_f(entityvillager.func_175446_cd());
            if (!this.isWild()) {
                entityzombie.setOwnerId(this.func_184753_b());
            }
            if (entityvillager.func_145818_k_()) {
                entityzombie.func_96094_a(entityvillager.func_95999_t());
                entityzombie.func_174805_g(entityvillager.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entityzombie);
            this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
        }
        if (entityLivingIn instanceof net.minecraft.entity.helpful.tier2.EntityVillager) {
            entityvillager = (net.minecraft.entity.helpful.tier2.EntityVillager)entityLivingIn;
            entityzombie = new EntityZombie(this.field_70170_p);
            entityzombie.field_70125_A = ((net.minecraft.entity.helpful.tier2.EntityVillager)entityvillager).field_70125_A;
            entityzombie.field_70177_z = entityzombie.field_70759_as = ((net.minecraft.entity.helpful.tier2.EntityVillager)entityvillager).field_70759_as;
            entityzombie.field_70761_aq = entityzombie.field_70759_as;
            entityzombie.func_82149_j((Entity)entityLivingIn);
            this.field_70170_p.func_72900_e((Entity)entityLivingIn);
            entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), new GroupData(false, true));
            entityzombie.setVillagerType(((net.minecraft.entity.helpful.tier2.EntityVillager)entityvillager).getProfession());
            entityzombie.setChild(entityLivingIn.func_70631_g_());
            entityzombie.func_94061_f(entityvillager.func_175446_cd());
            if (!this.isWild()) {
                entityzombie.setOwnerId(this.func_184753_b());
            }
            if (entityvillager.func_145818_k_()) {
                entityzombie.func_96094_a(entityvillager.func_95999_t());
                entityzombie.func_174805_g(entityvillager.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entityzombie);
            this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
        }
    }

    public float func_70047_e() {
        return this.isHusk() ? (this.func_70631_g_() ? 0.97f : 1.83f) : (this.func_70631_g_() ? 0.93f : 1.74f);
    }

    protected boolean func_175448_a(ItemStack p_175448_1_) {
        return p_175448_1_.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH() ? false : super.func_175448_a(p_175448_1_);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        float f = difficulty.func_180170_c();
        if (livingdata == null) {
            livingdata = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance, this.field_70170_p.field_73012_v.nextFloat() < 0.05f);
        }
        if (livingdata instanceof GroupData) {
            GroupData groupdata = (GroupData)livingdata;
            Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
            if (biome instanceof BiomeDesert && this.field_70146_Z.nextInt(5) != 0) {
                this.setHusk(true);
                this.setToNotVillager();
            }
            if (groupdata.isVillager) {
                this.setVillagerType(this.field_70146_Z.nextInt(5));
            }
            if (groupdata.isChild) {
                this.setChild(true);
                if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    List list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntitySelectors.field_152785_b);
                    if (!list.isEmpty()) {
                        EntityChicken entitychicken = (EntityChicken)list.get(0);
                        entitychicken.setChickenJockey(true);
                        this.func_184220_m((Entity)entitychicken);
                        entitychicken.setOwnerId(this.func_184753_b());
                    }
                } else if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    EntityChicken entitychicken1 = new EntityChicken(this.field_70170_p);
                    entitychicken1.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    entitychicken1.func_180482_a(difficulty, null);
                    entitychicken1.setChickenJockey(true);
                    entitychicken1.setOwnerId(this.func_184753_b());
                    this.field_70170_p.func_72838_d((Entity)entitychicken1);
                    this.func_184220_m((Entity)entitychicken1);
                }
            }
        }
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.func_180483_b(difficulty);
        this.func_180483_b(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        return livingdata;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151153_ao && stack.func_77960_j() == 0 && this.isVillager() && this.func_70644_a(MobEffects.field_76437_t)) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.startConversion(800);
            }
            return true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151024_Q && this.isOnSameTeam((EntityLivingBase)player)) {
            ++this.helmetCount;
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.MAINHAND) == null && (EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.MAINHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() == Items.field_151031_f)) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.OFFHAND) == null && (EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.OFFHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() == Items.field_185167_i || stack.func_77973_b() == Items.field_185159_cQ)) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.HEAD) == null && EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD && stack.func_77973_b() != Items.field_151024_Q) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.HEAD, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184606_a_(stack);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.CHEST) == null && EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.CHEST, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184606_a_(stack);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.LEGS) == null && EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.LEGS, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184606_a_(stack);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.FEET) == null && EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.FEET) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.FEET, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184606_a_(stack);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player)) {
            this.dropEquipmentUndamaged();
            player.func_184609_a(p_184645_2_);
            return true;
        }
        return super.func_184645_a(player, p_184645_2_, stack);
    }

    protected void startConversion(int ticks) {
        this.conversionTime = ticks;
        this.func_184212_Q().func_187227_b(CONVERTING, (Object)true);
        this.func_184589_d(MobEffects.field_76437_t);
        this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, ticks, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.field_70170_p.func_72960_a((Entity)this, (byte)16);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 16) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187942_hp, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isConverting() {
        return (Boolean)this.func_184212_Q().func_187225_a(CONVERTING);
    }

    protected void convertToVillager() {
        net.minecraft.entity.helpful.tier2.EntityVillager entityvillager = new net.minecraft.entity.helpful.tier2.EntityVillager(this.field_70170_p);
        entityvillager.func_82149_j((Entity)this);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        this.field_70170_p.func_72900_e((Entity)this);
        entityvillager.func_94061_f(this.func_175446_cd());
        entityvillager.setProfession(this.getVillagerType());
        if (this.func_145818_k_()) {
            entityvillager.func_96094_a(this.func_95999_t());
            entityvillager.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_72838_d((Entity)entityvillager);
        entityvillager.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1027, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
    }

    protected int getConversionTimeBoost() {
        int i = 1;
        if (this.field_70146_Z.nextFloat() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.field_70165_t - 4; k < (int)this.field_70165_t + 4 && j < 14; ++k) {
                for (int l = (int)this.field_70163_u - 4; l < (int)this.field_70163_u + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.field_70161_v - 4; i1 < (int)this.field_70161_v + 4 && j < 14; ++i1) {
                        Block block = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k, l, i1)).func_177230_c();
                        if (block != Blocks.field_150411_aY && block != Blocks.field_150324_C) continue;
                        if (this.field_70146_Z.nextFloat() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.zombieWidth > 0.0f && this.zombieHeight > 0.0f;
        this.zombieWidth = width;
        this.zombieHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.zombieWidth * size, this.zombieHeight * size);
    }

    public double func_70033_W() {
        return super.func_70033_W();
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return this.func_70658_aO() >= 10 ? ModSoundEvents.metalHit : ModSoundEvents.fleshHit;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isChild = false;
        public boolean isVillager = false;

        private GroupData(boolean isBaby, boolean isVillagerZombie) {
            this.isChild = isBaby;
            this.isVillager = isVillagerZombie;
        }
    }
}

