/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EntitySpider
extends EntityFriendlyCreature {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntitySpider.class, (DataSerializer)DataSerializers.field_187191_a);
    protected float jumpPower;

    public EntitySpider(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 0.78f);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.1, 24.0f, 6.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.5f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER3;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
            if (this.func_184207_aI() && !this.field_70122_E && this.field_70173_aa % 10 == 0) {
                this.func_184185_a(SoundEvents.field_187817_fK, 1.0f, 1.5f);
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(4.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                if (list != null && !list.isEmpty() && this.jumpPower >= 1.0f) {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        EntityLivingBase entity1 = (EntityLivingBase)list.get(i1);
                        if (entity1 == null || !entity1.func_70089_S()) continue;
                        this.func_70652_k((Entity)entity1);
                    }
                }
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        super.func_70628_a(p_70628_1_, p_70628_2_);
        if (p_70628_1_ && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        Potion potion;
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextInt(100) == 0) {
            EntitySkeleton entityskeleton = new EntitySkeleton(this.field_70170_p);
            entityskeleton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityskeleton.func_180482_a(difficulty, null);
            this.field_70170_p.func_72838_d((Entity)entityskeleton);
            entityskeleton.func_184220_m((Entity)this);
        }
        if (livingdata == null) {
            livingdata = new GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((GroupData)livingdata).func_111104_a(this.field_70170_p.field_73012_v);
            }
        }
        if (livingdata instanceof GroupData && (potion = ((GroupData)livingdata).field_188478_a) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return livingdata;
    }

    public float func_70047_e() {
        return 0.65f;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (!(stack != null || this.field_70170_p.field_72995_K || this.isWild() || player != this.getOwner() && !player.func_184191_r((Entity)this))) {
            if (!player.func_70093_af()) {
                player.func_184220_m((Entity)this);
            } else {
                List list = this.field_70170_p.func_175647_a(EntitySkeleton.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
                if (list != null && !list.isEmpty() && !this.func_184207_aI()) {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        EntitySkeleton entity = (EntitySkeleton)list.get(i1);
                        if (entity == null || !this.isOnSameTeam((EntityLivingBase)entity) || entity.func_184218_aH()) continue;
                        entity.func_184220_m((Entity)this);
                        this.func_184185_a(SoundEvents.field_187817_fK, 1.0f, 1.5f);
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double d8 = -0.1;
            Vec3d vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            double dz = vec3.field_72449_c * d8;
            passenger.func_70107_b(this.field_70165_t + dx, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + dz);
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.7;
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityLivingBase;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 1024.0 && this.func_70068_e((Entity)this.func_70638_az()) > 64.0 && this.getSpecialAttackTimer() <= 0 && this.field_70122_E && this.isHero()) {
            this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 30.0f);
            this.performSpecialAttack();
        }
    }

    @Override
    public void performSpecialAttack() {
        double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
        double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
        float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
        double hor = (double)(f21 / 16.0f) * 1.3;
        double ver = 0.9;
        this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
        this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
        this.field_70181_x = ver;
        this.func_184185_a(SoundEvents.field_187817_fK, 1.0f, 1.5f);
        this.setSpecialAttackTimer(100);
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A - 30.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            this.field_70747_aH = 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
                this.setBesideClimbableBlock(this.field_70123_F);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (Keyboard.isKeyDown((int)57) && this.field_70122_E) {
                this.field_70181_x = 0.5;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.field_70160_al = true;
                float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                this.field_70159_w = -1.5f * f;
                this.field_70179_y = 1.5f * f1;
                this.jumpPower = 0.0f;
                ForgeHooks.onLivingJump((EntityLivingBase)this);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setJumpPower(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            if (jumpPowerIn >= 90) {
                this.jumpPower = 1.0f;
                this.func_184185_a(SoundEvents.field_187817_fK, 1.0f, 1.5f);
            } else {
                this.jumpPower = 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
            }
        }
    }

    public boolean canJump() {
        return this.func_184207_aI();
    }

    public void func_184775_b(int p_184775_1_) {
    }

    public void func_184777_r_() {
    }

    public void handleStartJump(int p_184775_1_) {
    }

    public void handleStopJump() {
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion field_188478_a;

        public void func_111104_a(Random rand) {
            int i = rand.nextInt(5);
            if (i <= 1) {
                this.field_188478_a = MobEffects.field_76424_c;
            } else if (i <= 2) {
                this.field_188478_a = MobEffects.field_76420_g;
            } else if (i <= 3) {
                this.field_188478_a = MobEffects.field_76428_l;
            } else if (i <= 4) {
                this.field_188478_a = MobEffects.field_76441_p;
            }
        }
    }
}

