/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier3.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EntitySlime
extends EntityFriendlyCreature {
    private static final DataParameter<Integer> SLIME_SIZE = EntityDataManager.func_187226_a(EntitySlime.class, (DataSerializer)DataSerializers.field_187192_b);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    protected float jumpPower;

    public EntitySlime(World worldIn) {
        super(worldIn);
        this.field_70765_h = new SlimeMoveHelper(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeFaceRandom());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLIME_SIZE, (Object)1);
    }

    @Override
    public int timesToConvert() {
        return 2 * this.getSlimeSize();
    }

    public boolean isSmallSlime() {
        return this.getSlimeSize() <= 1;
    }

    protected void setSlimeSize(int size) {
        this.field_70180_af.func_187227_b(SLIME_SIZE, (Object)size);
        this.func_70105_a(0.5f * (float)size, 0.5f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(size * size));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)(0.2f + 0.1f * (float)size));
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = size;
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER3;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(2) == 0 && super.func_70601_bi();
    }

    public int getSlimeSize() {
        return (Integer)this.field_70180_af.func_187225_a(SLIME_SIZE);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Size", this.getSlimeSize() - 1);
        tagCompound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public boolean func_189101_db() {
        return this.getSlimeSize() <= 1;
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        int i = tagCompund.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSlimeSize(i + 1);
        this.wasOnGround = tagCompund.func_74767_n("wasOnGround");
    }

    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.SLIME;
    }

    protected String getJumpSound() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    public void func_70071_h_() {
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAttackStrength());
        if (this.getOwner() != null && this.func_70068_e((Entity)this.getOwner()) > 64.0 * (double)this.getSlimeSize()) {
            this.func_70624_b(this.getOwner());
            if (this.func_70068_e((Entity)this.getOwner()) >= 2304.0) {
                this.func_70624_b(null);
                this.field_70173_aa = 0;
                this.func_70012_b(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v, this.field_70177_z, this.field_70125_A);
            }
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = this.getSlimeSize();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.field_70170_p;
                EnumParticleTypes enumparticletypes = this.getParticleType();
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                world.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.moralRaisedTimer > 200 ? this.field_70146_Z.nextInt(10) + 5 : this.field_70146_Z.nextInt(20) + 10;
    }

    protected EntitySlime createInstance() {
        return new EntitySlime(this.field_70170_p);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SLIME_SIZE.equals(key)) {
            int i = this.getSlimeSize();
            this.func_70105_a(0.5f * (float)i, 0.5f * (float)i);
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(key);
    }

    public void func_70106_y() {
        int i = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntitySlime entityslime = this.createInstance();
                if (this.func_145818_k_()) {
                    entityslime.func_96094_a(this.func_95999_t());
                }
                if (this.func_104002_bU()) {
                    entityslime.func_110163_bv();
                }
                if (this.getOwner() != null) {
                    entityslime.setOwnerId(this.getOwner().func_110124_au());
                }
                entityslime.setSlimeSize(i / 2);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
        super.func_70106_y();
    }

    @Override
    public void performSpecialAttack() {
        for (int k = 0; k < this.getSlimeSize(); ++k) {
            this.field_70181_x = 1.0;
        }
        this.func_184185_a(this.func_184710_cZ(), this.func_70599_aP(), ((this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 32.0 * (double)this.getSlimeSize() && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            List list;
            this.setSpecialAttackTimer(100 * this.getSlimeSize());
            this.func_184185_a(ModSoundEvents.golemSmash, 10.0f, 2.0f - (float)this.getSlimeSize() * 0.25f);
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u - (double)this.getSlimeSize(), this.field_70161_v, (float)this.getSlimeSize(), false);
            if (this.func_70638_az() != null && !this.isOnSameTeam(this.func_70638_az())) {
                double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
                float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
                double hor = (double)(f21 / 16.0f) * 1.25;
                this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
                this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
                this.field_70181_x = 0.6f;
                double dou = this.func_70068_e((Entity)this.func_70638_az());
                if (dou <= 16.0) {
                    this.func_175451_e(this.func_70638_az());
                }
            }
            if ((list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(8.0 * (double)this.getSlimeSize(), 8.0, 8.0 * (double)this.getSlimeSize()), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null) continue;
                    if (!this.isOnSameTeam(entity)) {
                        entity.field_70181_x += 0.75;
                        this.func_175451_e(entity);
                    }
                    if (entity.func_70089_S() || this.isWild()) continue;
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was blown up by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 32.0 * (double)this.getSlimeSize() && this.getSpecialAttackTimer() <= 0 && this.field_70122_E && this.isHero()) {
            this.performSpecialAttack();
        }
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (!this.func_184191_r(entityIn)) {
            this.func_175451_e((EntityLivingBase)entityIn);
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
        return flag;
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        this.func_175451_e((EntityLivingBase)entityIn);
    }

    protected void func_175451_e(EntityLivingBase p_175451_1_) {
        if (this.field_70173_aa > 20 && !this.isOnSameTeam(p_175451_1_) && this.func_70685_l((Entity)p_175451_1_) && this.func_70068_e((Entity)p_175451_1_) < (double)this.field_70130_N * 1.5 * ((double)this.field_70130_N * 1.5)) {
            this.func_70652_k((Entity)p_175451_1_);
        }
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityLivingBase;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            if ((this.func_70090_H() || this.func_180799_ab()) && this.func_70681_au().nextFloat() < 0.8f) {
                this.func_70664_aZ();
                this.func_184185_a(this.func_184710_cZ(), this.func_70599_aP(), ((this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            this.field_70747_aH = 0.05f;
            if (this.func_184186_bw()) {
                this.func_70659_e(0.0f);
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (Keyboard.isKeyDown((int)57) && this.field_70122_E) {
                this.jumpPower = 0.0f;
                this.func_70664_aZ();
                this.field_70181_x += 0.1;
                this.field_70160_al = true;
                ForgeHooks.onLivingJump((EntityLivingBase)this);
                this.func_184185_a(this.func_184710_cZ(), this.func_70599_aP(), ((this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setJumpPower(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean canJump() {
        return this.func_184207_aI();
    }

    public void func_184775_b(int p_184775_1_) {
    }

    public void func_184777_r_() {
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.getSlimeSize() < 4 && stack.func_77973_b() == (this instanceof EntityMagmaCube ? Items.field_151064_bs : Items.field_151123_aH)) {
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            this.setSlimeSize(this.getSlimeSize() + 1);
            int i = this.getSlimeSize();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.field_70170_p;
                EnumParticleTypes enumparticletypes = this.getParticleType();
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                world.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[0]);
            }
            return true;
        }
        if (!(stack != null || this.field_70170_p.field_72995_K || this.getSlimeSize() <= 1 || this.isWild() || player != this.getOwner() && !player.func_184191_r((Entity)this))) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    protected boolean canDamagePlayer() {
        return true;
    }

    protected int getAttackStrength() {
        return this.moralRaisedTimer > 200 ? this.getSlimeSize() * 2 : this.getSlimeSize();
    }

    protected SoundEvent func_184601_bQ() {
        return this.func_189101_db() ? SoundEvents.field_187898_fy : SoundEvents.field_187880_fp;
    }

    protected SoundEvent func_184615_bR() {
        return this.func_189101_db() ? SoundEvents.field_187896_fx : SoundEvents.field_187874_fm;
    }

    protected SoundEvent func_184709_cY() {
        return this.func_189101_db() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs;
    }

    protected Item func_146068_u() {
        return this.getSlimeSize() == 1 ? Items.field_151123_aH : null;
    }

    @Override
    protected float func_70599_aP() {
        return 0.25f * (float)this.getSlimeSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return true;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }

    protected void func_70664_aZ() {
        this.field_70181_x += 0.42;
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * (0.4 + (double)this.getSlimeSize() * 0.1);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f * difficulty.func_180170_c()) {
            ++i;
        }
        int j = 1 << i;
        if (this.field_70146_Z.nextInt(500) == 0) {
            this.setSlimeSize(8);
        } else {
            this.setSlimeSize(j);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    protected SoundEvent func_184710_cZ() {
        return this.func_189101_db() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    public void handleStartJump(int p_184775_1_) {
    }

    public void handleStopJump() {
    }

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float field_179922_g;
        private int field_179924_h;
        private EntitySlime slime;
        private boolean field_179923_j;

        public SlimeMoveHelper(EntitySlime slimeIn) {
            super((EntityLiving)slimeIn);
            this.slime = slimeIn;
            this.field_179922_g = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void func_179920_a(float p_179920_1_, boolean p_179920_2_) {
            this.field_179922_g = p_179920_1_;
            this.field_179923_j = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.field_179922_g, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_70657_f(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.field_179924_h-- <= 0) {
                        this.field_179924_h = this.slime.getJumpDelay();
                        if (this.field_179923_j) {
                            this.field_179924_h /= 3;
                        }
                        if (this.slime.isHero()) {
                            this.field_179924_h /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.func_184185_a(this.slime.func_184710_cZ(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.slime.field_70701_bs = 0.0f;
                        this.slime.field_70702_br = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private EntitySlime slime;

        public AISlimeHop(EntitySlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.slime.func_70638_az() != null) {
                ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.5);
            } else {
                ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
            }
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private EntitySlime slime;

        public AISlimeFloat(EntitySlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    class AISlimeFaceRandom
    extends EntityAIBase {
        private EntitySlime slime;
        private float field_179459_b;
        private int field_179460_c;

        public AISlimeFaceRandom() {
            this.slime = EntitySlime.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab());
        }

        public void func_75246_d() {
            if (--this.field_179460_c <= 0) {
                this.field_179460_c = 40 + this.slime.func_70681_au().nextInt(60);
                this.field_179459_b = this.slime.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).func_179920_a(this.field_179459_b, false);
        }
    }

    class AISlimeAttack
    extends EntityAIBase {
        private EntitySlime slime;
        private int field_179465_b;

        public AISlimeAttack() {
            this.slime = EntitySlime.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            return entitylivingbase == null ? false : entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.field_179465_b = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            return entitylivingbase != null && this.slime.func_184187_bx() == null;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 180.0f, 10.0f);
            ((SlimeMoveHelper)this.slime.func_70605_aq()).func_179920_a(this.slime.field_70177_z, true);
        }
    }
}

