/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Calendar;
import java.util.List;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIAttackRangedBowAlly;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier3.EntityTippedArrowOther;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.HorseType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeSnow;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySkeleton
extends EntityFriendlyCreature
implements IRangedAttackMob {
    private static final DataParameter<Integer> SKELETON_VARIANT = EntityDataManager.func_187226_a(EntitySkeleton.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntitySkeleton.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIAttackRangedBowAlly aiArrowAttack = new EntityAIAttackRangedBowAlly(this, 1.0, 5, 15.0f);
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee(this, 1.2, false){

        public void func_75251_c() {
            super.func_75251_c();
            EntitySkeleton.this.setAttacking(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntitySkeleton.this.setAttacking(true);
            ItemStack itemstack = EntitySkeleton.this.func_184586_b(EnumHand.MAIN_HAND);
            if ((itemstack == null || itemstack.func_77973_b() != Items.field_151031_f) && EntitySkeleton.this.func_184187_bx() != null && EntitySkeleton.this.func_184187_bx() instanceof EntityHorse && ((EntityHorse)EntitySkeleton.this.func_184187_bx()).func_184781_cZ() == HorseType.SKELETON) {
                ((EntityHorse)EntitySkeleton.this.func_184187_bx()).func_70661_as().func_75484_a(EntitySkeleton.this.func_70661_as().func_75494_a((Entity)EntitySkeleton.this.func_70638_az()), 1.2);
            }
        }
    };
    private int helmetCount = 1;

    public EntitySkeleton(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 32.0f, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
        if (this.getSkeletonType() == 1) {
            this.func_70105_a(0.6f, 2.39f);
        } else {
            this.func_70105_a(0.5f, 1.95f);
        }
        if (worldIn != null && !worldIn.field_72995_K) {
            this.setCombatTask();
        }
    }

    @Override
    public int timesToConvert() {
        return this.getSkeletonType() == 1 ? 27 : 13;
    }

    @Override
    public EnumEntityTier getTier() {
        return this.getSkeletonType() != 0 ? EnumEntityTier.TIER4 : EnumEntityTier.TIER3;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(2) == 0 && super.func_70601_bi();
    }

    @Override
    protected int getTimeBetweenSteps() {
        return this.aiAttackOnCollide != null ? 7 : 15;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityHorse && ((EntityHorse)this.func_184187_bx()).func_184781_cZ() == HorseType.SKELETON) {
            switch (this.getSkeletonType()) {
                case 1: {
                    return I18n.func_74838_a((String)"entity.ageofminecraft.WitherSkeletonHorsemanHelpful.name");
                }
                case 2: {
                    return I18n.func_74838_a((String)"entity.ageofminecraft.StrayHorsemanHelpful.name");
                }
            }
            return I18n.func_74838_a((String)"entity.ageofminecraft.SkeletonHorsemanHelpful.name");
        }
        switch (this.getSkeletonType()) {
            case 1: {
                return I18n.func_74838_a((String)"entity.ageofminecraft.WitherSkeletonHelpful.name");
            }
            case 2: {
                return I18n.func_74838_a((String)"entity.ageofminecraft.StrayHelpful.name");
            }
        }
        return I18n.func_74838_a((String)"entity.ageofminecraft.SkeletonHelpful.name");
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKELETON_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    protected SoundEvent func_184639_G() {
        switch (this.getSkeletonType()) {
            case 1: {
                return SoundEvents.field_190036_ha;
            }
            case 2: {
                return SoundEvents.field_190032_gu;
            }
        }
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ() {
        switch (this.getSkeletonType()) {
            case 1: {
                return SoundEvents.field_190038_hc;
            }
            case 2: {
                return SoundEvents.field_190034_gw;
            }
        }
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        switch (this.getSkeletonType()) {
            case 1: {
                return SoundEvents.field_190037_hb;
            }
            case 2: {
                return SoundEvents.field_190033_gv;
            }
        }
        return SoundEvents.field_187856_fd;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        switch (this.getSkeletonType()) {
            case 1: {
                this.func_184185_a(SoundEvents.field_190039_hd, this.func_70599_aP(), 1.0f);
            }
            case 2: {
                this.func_184185_a(SoundEvents.field_190035_gx, this.func_70599_aP(), 1.0f);
            }
        }
        this.func_184185_a(SoundEvents.field_187868_fj, this.func_70599_aP(), 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        switch (this.getSkeletonType()) {
            case 1: {
                return LootTableListEngender.ENTITIES_WITHER_SKELETON;
            }
            case 2: {
                return LootTableListEngender.ENTITIES_STRAY;
            }
        }
        return LootTableListEngender.ENTITIES_SKELETON;
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        if (super.func_70652_k(p_70652_1_)) {
            int i;
            if (this.getSkeletonType() == 1 && p_70652_1_ instanceof EntityLivingBase) {
                i = 6;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 15;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 40;
                }
                if (i > 0) {
                    ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(MobEffects.field_82731_v, i * 20, 0 + this.field_70170_p.func_175659_aa().func_151525_a()));
                }
            }
            if (this.getSkeletonType() == 2 && p_70652_1_ instanceof EntityLivingBase) {
                i = 12;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 25;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 50;
                }
                if (i > 0) {
                    ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(MobEffects.field_76421_d, i * 20, 0 + this.field_70170_p.func_175659_aa().func_151525_a()));
                }
            }
            if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151031_f) {
                this.func_184185_a(SoundEvents.field_187721_dT, this.func_70599_aP(), 1.0f);
                this.func_70653_a((Entity)this, 0.25f, MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180))), -MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180))));
                ((EntityLivingBase)p_70652_1_).func_70653_a((Entity)this, 1.0f, (double)MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180)))));
            }
            if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151033_d || this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151059_bz)) {
                p_70652_1_.func_70015_d(12);
            }
            this.setAttacking(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_82731_v && this.getSkeletonType() == 1 ? false : super.func_70687_e(potioneffectIn);
    }

    public boolean func_70662_br() {
        return true;
    }

    @Override
    public void performSpecialAttack() {
        if (this.func_184586_b(EnumHand.MAIN_HAND) != null && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151031_f) {
            this.setSpecialAttackTimer(500);
            this.func_184185_a(ModSoundEvents.skeletonSpecial, 10.0f, 1.0f);
        } else {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 5.0f);
            this.setSpecialAttackTimer(500);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.getSkeletonType() == 1) {
            this.func_70105_a(0.6f, 2.39f);
        } else {
            this.func_70105_a(0.5f, 1.95f);
        }
        ItemStack item = this.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack secitem = this.func_184586_b(EnumHand.OFF_HAND);
        if ((item == null || item != null && item.func_77973_b() != Items.field_151031_f) && this.func_70638_az() != null) {
            this.setAttacking(true);
        }
        if (item != null && secitem != null && item.func_77973_b() == Items.field_151031_f && secitem.func_77973_b() != Items.field_151031_f && secitem.func_77973_b() != Items.field_185167_i && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.func_70638_az().field_70163_u <= this.field_70163_u + 3.0) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, secitem);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, item);
        }
        if (item != null && secitem != null && secitem.func_77973_b() == Items.field_151031_f && item.func_77973_b() != Items.field_151031_f && item.func_77973_b() != Items.field_185167_i && this.func_70638_az() != null && (this.func_70068_e((Entity)this.func_70638_az()) > 256.0 || !this.func_70638_az().field_70122_E)) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, secitem);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, item);
        }
        if (item != null && item.func_77973_b() == Items.field_151031_f) {
            if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70068_e((Entity)this.func_70638_az()) < 512.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
                this.performSpecialAttack();
            }
            if (this.func_70638_az() != null && this.isHero() && this.getSpecialAttackTimer() < 490 && this.getSpecialAttackTimer() > 470) {
                this.func_82196_d(this.func_70638_az(), 2.0f);
            }
        } else if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70068_e((Entity)this.func_70638_az()) < 32.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityHorse && ((EntityHorse)this.func_184187_bx()).func_184781_cZ() == HorseType.SKELETON) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(18.0);
            if (this.func_70093_af()) {
                this.func_184187_bx().func_70095_a(true);
            } else {
                this.func_184187_bx().func_70095_a(false);
            }
            if (this.func_70051_ag()) {
                this.func_184187_bx().func_70031_b(true);
            } else {
                this.func_184187_bx().func_70031_b(false);
            }
        }
        if (this.field_70170_p.field_72995_K && this.getSkeletonType() == 1) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.helmetCount < 0) {
            this.helmetCount = 0;
        }
        if ((this.getSkeletonType() == 1 || this.isHero()) && this.helmetCount != 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a((Item)Items.field_151024_Q, 1);
            }
            --this.helmetCount;
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.getSkeletonType() != 1 && !this.isHero() && !this.func_70045_F()) {
            float f = this.func_70013_c(1.0f);
            BlockPos blockpos = new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                boolean flag = true;
                ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (itemstack != null) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_70669_a(itemstack);
                            this.func_184201_a(EntityEquipmentSlot.HEAD, null);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    if (this.helmetCount > 0) {
                        --this.helmetCount;
                        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151024_Q));
                        this.func_184185_a(SoundEvents.field_187702_cm, 1.0f, 1.0f);
                    } else {
                        this.func_70015_d(8);
                    }
                }
            }
        }
        super.func_70636_d();
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
            entitycreature.field_70125_A = this.field_70125_A;
            entitycreature.field_70759_as = this.field_70759_as;
            if (this.func_70638_az() != null) {
                entitycreature.func_70624_b(this.func_70638_az());
            }
            if (this.field_70173_aa % 40 == 0) {
                this.field_70761_aq = this.field_70177_z = this.field_70759_as;
                if (this.func_70638_az() == null) {
                    entitycreature.func_70691_i(5.0f);
                } else {
                    entitycreature.func_70691_i(1.0f);
                }
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76364_f() instanceof EntityArrow && cause.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)cause.func_76346_g();
            double d0 = entityplayer.field_70165_t - this.field_70165_t;
            double d1 = entityplayer.field_70161_v - this.field_70161_v;
            if (d0 * d0 + d1 * d1 >= 2500.0) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_187994_v);
            }
        } else if (cause.func_76346_g() instanceof EntityCreeper && ((EntityCreeper)cause.func_76346_g()).func_70830_n()) {
            ((EntityCreeper)cause.func_76346_g()).func_175493_co();
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, this.getSkeletonType() == 1 ? 1 : 0), 0.0f);
        }
    }

    protected Item func_146068_u() {
        return Items.field_151032_g;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        int j;
        this.func_82160_b(true, 500);
        if (this.getSkeletonType() == 1) {
            j = this.field_70146_Z.nextInt(3 + p_70628_2_) - 1;
            for (k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151044_h, 1);
            }
        }
        j = this.field_70146_Z.nextInt(3 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151032_g, 1);
        }
        j = this.field_70146_Z.nextInt(3 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151103_aS, 1);
        }
        if (this.helmetCount > 0) {
            this.func_145779_a((Item)Items.field_151024_Q, this.helmetCount);
        }
    }

    protected void addRandomArmor() {
        if (this.getSkeletonType() == 1) {
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 1), 0.0f);
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.field_70146_Z.nextFloat() < 0.75f) {
            float f;
            int i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.75f : 0.5f;
            if (this.field_70146_Z.nextFloat() < 0.25f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.25f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.25f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (itemstack != null || (item = EntitySkeleton.func_184636_a((EntityEquipmentSlot)entityequipmentslot, (int)i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack(item));
            }
        }
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        if (this.getSkeletonType() == 1) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
            if (this.func_70681_au().nextInt(2) > 0) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151052_q));
            }
        }
    }

    protected void func_184590_k(float p_184590_1_) {
        this.field_70718_bc = 40;
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
        this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 30, 1));
    }

    public boolean func_184585_cz() {
        return this.func_70638_az() != null && this.field_70718_bc <= 0 && this.func_184592_cb() != null && !this.func_184587_cr() && this.func_184592_cb().func_77973_b() == Items.field_185159_cQ && this.func_70068_e((Entity)this.func_70638_az()) < 16.0;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
        if (this.field_70170_p.field_73011_w instanceof WorldProviderHell && this.field_70146_Z.nextInt(5) != 0) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            this.setSkeletonType(1);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
            if (this.func_70681_au().nextInt(2) > 0) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151052_q));
            }
        } else if (biome instanceof BiomeSnow && this.field_70146_Z.nextInt(5) != 0) {
            this.setSkeletonType(2);
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        }
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.func_180483_b(difficulty);
        this.func_180483_b(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        return livingdata;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151031_f) {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        this.setAttacking(true);
        EntityTippedArrowOther entityarrow = new EntityTippedArrowOther(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.field_70163_u - 1.75 - this.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)this.func_70032_d((Entity)target) * 0.0125, d2, 1.4f, this.isHero() ? 1.0f : 4.0f);
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        if (this.func_184187_bx() != null) {
            entityarrow.func_70239_b((double)(p_82196_2_ * 3.0f) + this.field_70146_Z.nextGaussian() * 0.25 + 0.5);
        } else {
            entityarrow.func_70239_b((double)(p_82196_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + 0.5);
        }
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (this.func_184187_bx() != null) {
            j += 2;
            entityarrow.func_70243_d(true);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        if (this.getSkeletonType() == 2) {
            entityarrow.func_184558_a(new PotionEffect(MobEffects.field_76421_d, 600));
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this) > 0 || this.getSkeletonType() == 1) {
            entityarrow.func_70015_d(100);
        }
        if (this.func_184592_cb() != null && this.func_184592_cb().func_77973_b() == Items.field_185167_i) {
            entityarrow.func_184555_a(this.func_184592_cb());
        }
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    public boolean func_70027_ad() {
        return this.getSkeletonType() == 1 ? false : super.func_70027_ad();
    }

    public int getSkeletonType() {
        return (Integer)this.field_70180_af.func_187225_a(SKELETON_VARIANT);
    }

    public void setSkeletonType(int p_82201_1_) {
        this.field_70180_af.func_187227_b(SKELETON_VARIANT, (Object)p_82201_1_);
        boolean bl = this.field_70178_ae = p_82201_1_ == 1;
        if (p_82201_1_ == 1) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("SkeletonType", 99)) {
            byte i = tagCompund.func_74771_c("SkeletonType");
            this.setSkeletonType(i);
        }
        this.setCombatTask();
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74774_a("SkeletonType", (byte)this.getSkeletonType());
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public float func_70047_e() {
        return this.getSkeletonType() == 1 ? 2.088f : 1.74f;
    }

    public double func_70033_W() {
        if (this.getSkeletonType() == 1) {
            return super.func_70033_W() - 0.54;
        }
        return super.func_70033_W() - 0.45;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean p_184724_1_) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)p_184724_1_);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151024_Q && this.isOnSameTeam((EntityLivingBase)player)) {
            ++this.helmetCount;
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && player.func_70093_af() && this.func_184187_bx() == null) {
            List list = this.field_70170_p.func_175647_a(EntityHorse.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty() && !this.func_184207_aI()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityHorse entity = (EntityHorse)list.get(i1);
                    if (entity == null || entity.func_184207_aI() || entity.func_184781_cZ() != HorseType.SKELETON) continue;
                    this.func_184220_m((Entity)entity);
                    break;
                }
            }
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.MAINHAND) == null && (EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.MAINHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() == Items.field_151031_f)) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.OFFHAND) == null && (EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.OFFHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() == Items.field_185167_i || stack.func_77973_b() == Items.field_185159_cQ)) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.HEAD) == null && EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD && stack.func_77973_b() != Items.field_151024_Q) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.HEAD, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184606_a_(stack);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.CHEST) == null && EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.CHEST, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184606_a_(stack);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.LEGS) == null && EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.LEGS, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184606_a_(stack);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (stack != null && this.isOnSameTeam((EntityLivingBase)player) && this.func_184582_a(EntityEquipmentSlot.FEET) == null && EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.FEET) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack heldItem = new ItemStack(stack.func_77973_b());
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.FEET, heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            this.func_184606_a_(stack);
            player.func_184609_a(p_184645_2_);
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player)) {
            this.dropEquipmentUndamaged();
            player.func_184609_a(p_184645_2_);
            return true;
        }
        return super.func_184645_a(player, p_184645_2_, stack);
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return this.func_70658_aO() > 10 ? ModSoundEvents.metalHit : ModSoundEvents.woodHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.woodHitCrush;
    }
}

