/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAICreeperSwell;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCreeper
extends EntityFriendlyCreature {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private int field_175494_bm = 0;

    public EntityCreeper(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAICreeperSwell(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 24.0f, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
        this.func_70105_a(0.5f, 1.625f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    @Override
    public int timesToConvert() {
        return 13;
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER3;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(3) == 0 && super.func_70601_bi();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getPowered() ? I18n.func_74838_a((String)"entity.ageofminecraft.ChargedCreeperHelpful.name") : super.func_70005_c_();
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            tagCompound.func_74757_a("powered", true);
        }
        tagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        tagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        tagCompound.func_74757_a("ignited", this.hasIgnited());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_187227_b(POWERED, (Object)tagCompund.func_74767_n("powered"));
        if (tagCompund.func_150297_b("Fuse", 99)) {
            this.fuseTime = tagCompund.func_74765_d("Fuse");
        }
        if (tagCompund.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = tagCompund.func_74771_c("ExplosionRadius");
        }
        if (tagCompund.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, this.func_70599_aP(), 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            if (cause.func_76346_g() instanceof EntitySkeleton) {
                int i = Item.func_150891_b((Item)Items.field_151096_cd);
                int j = Item.func_150891_b((Item)Items.field_151084_co);
                int k = i + this.field_70146_Z.nextInt(j - i + 1);
                this.func_145779_a(Item.func_150899_d((int)k), 1);
            } else if (cause.func_76346_g() instanceof EntityCreeper && cause.func_76346_g() != this && ((EntityCreeper)cause.func_76346_g()).getPowered()) {
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            return true;
        }
        return super.func_70652_k(p_70652_1_);
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_CREEPER;
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(p_184645_2_);
            if (!this.field_70170_p.field_72995_K) {
                if (this.getOwner() != null && player == this.getOwner()) {
                    if (!this.getPowered()) {
                        if (this.field_70170_p.func_175710_j(this.func_180425_c())) {
                            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - 0.5, this.field_70163_u + 1.625, this.field_70161_v - 0.5, false));
                        } else {
                            this.func_70656_aK();
                        }
                    } else {
                        this.func_70691_i(1.0f);
                    }
                } else {
                    this.ignite();
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_184645_a(player, p_184645_2_, stack);
    }

    @Override
    public void performSpecialAttack() {
        this.ignite();
        this.func_184185_a(SoundEvents.field_187941_ho, 10.0f, 1.0f);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.getPowered() ? 2.0f : 1.0f;
            EntityCreeper entity = this;
            if (!this.isWild()) {
                entity = this.getOwner();
            }
            if (this.func_70638_az() != null && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
                List list1;
                this.field_70170_p.func_72876_a((Entity)entity, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 20.0f * f, flag);
                this.field_70180_af.func_187227_b(IGNITED, (Object)false);
                this.setCreeperState(-1);
                this.setSpecialAttackTimer(800);
                this.timeSinceIgnited = 0;
                this.field_70181_x = 0.0;
                if (this.getPowered()) {
                    this.field_70170_p.func_72876_a((Entity)entity, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 3.0f * f, flag);
                }
                if ((list1 = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(40.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list1.isEmpty()) {
                    for (int i1 = 0; i1 < list1.size(); ++i1) {
                        EntityLivingBase entity1 = (EntityLivingBase)list1.get(i1);
                        if (this.isOnSameTeam(entity1)) continue;
                        this.func_70652_k((Entity)entity1);
                    }
                }
            } else {
                this.timeSinceIgnited = 0;
                this.field_70180_af.func_187227_b(IGNITED, (Object)false);
                this.setCreeperState(-1);
                this.field_70170_p.func_72876_a((Entity)entity, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (float)this.explosionRadius * f, flag);
                List list1 = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(6.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                if (list1 != null && !list1.isEmpty()) {
                    for (int i1 = 0; i1 < list1.size(); ++i1) {
                        EntityLivingBase entity1 = (EntityLivingBase)list1.get(i1);
                        if (this.isOnSameTeam(entity1)) continue;
                        this.func_70652_k((Entity)entity1);
                    }
                }
            }
            if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                this.field_70729_aU = true;
                this.func_70106_y();
            } else {
                this.timeSinceIgnited = 0;
                this.field_70180_af.func_187227_b(IGNITED, (Object)false);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && !this.hasIgnited() && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public void func_175493_co() {
        ++this.field_175494_bm;
    }
}

