/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier2;

import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySnowman
extends EntityFriendlyCreature
implements IRangedAttackMob {
    private static final DataParameter<Byte> PUMPKIN_EQUIPPED = EntityDataManager.func_187226_a(EntitySnowman.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntitySnowman(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.9f);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 24.0f, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.25, 20, 10.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    @Override
    public int timesToConvert() {
        return 3;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PUMPKIN_EQUIPPED, (Object)0);
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER2;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.func_70026_G()) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.field_70170_p.func_180494_b(blockPos).func_180626_a(blockPos2) > 1.0f) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
            if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return;
            }
            for (int l = 0; l < 4; ++l) {
                i = MathHelper.func_76128_c((double)(this.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)(this.field_70161_v + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (this.field_70170_p.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a) continue;
                BlockPos blockPos3 = new BlockPos(i, 0, k);
                if (!(this.field_70170_p.func_180494_b(blockPos3).func_180626_a(blockpos) < 0.8f) || !Blocks.field_150431_aC.func_176196_c(this.field_70170_p, blockpos)) continue;
                this.field_70170_p.func_175656_a(blockpos, Blocks.field_150431_aC.func_176223_P());
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_SNOWMAN;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151097_aZ && !this.isPumpkinEquipped() && !this.field_70170_p.field_72995_K) {
            this.setPumpkinEquipped(true);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        return super.func_184645_a(player, p_184645_2_, stack);
    }

    public boolean isPumpkinEquipped() {
        return ((Byte)this.field_70180_af.func_187225_a(PUMPKIN_EQUIPPED) & 0x10) != 0;
    }

    public void setPumpkinEquipped(boolean p_184747_1_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(PUMPKIN_EQUIPPED);
        if (p_184747_1_) {
            this.field_70180_af.func_187227_b(PUMPKIN_EQUIPPED, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(PUMPKIN_EQUIPPED, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        EntitySnowball entitysnowball = new EntitySnowball(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.field_70165_t - this.field_70165_t;
        double d2 = d0 - entitysnowball.field_70163_u;
        double d3 = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        entitysnowball.func_70186_c(d1, d2 + (double)f, d3, 1.6f, this.isPumpkinEquipped() ? 45.0f : 9.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entitysnowball);
    }

    public float func_70047_e() {
        return 1.7f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187799_fB;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187803_fD;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187801_fC;
    }
}

