/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier2;

import java.util.Random;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySilverfish
extends EntityFriendlyCreature {
    private AISummonSilverfish summonSilverfish;

    public EntitySilverfish(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.3f);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.summonSilverfish = new AISummonSilverfish(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.summonSilverfish);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 24.0f, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    @Override
    public int timesToConvert() {
        return 3;
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER2;
    }

    public float func_70047_e() {
        return 0.1f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187852_fb, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_SILVERFISH;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if ((source instanceof EntityDamageSource || source == DamageSource.field_76376_m) && this.summonSilverfish != null) {
            this.summonSilverfish.func_179462_f();
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70071_h_() {
        this.field_70761_aq = this.field_70177_z;
        super.func_70071_h_();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public void performSpecialAttack() {
        this.setSpecialAttackTimer(400);
        this.func_184185_a(ModSoundEvents.bugSpecial, 10.0f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                EntitySilverfish endermite = new EntitySilverfish(this.field_70170_p);
                endermite.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)endermite);
                if (this.isWild()) continue;
                endermite.setOwnerId(this.func_184753_b());
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.field_70170_p.field_72995_K && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            float f2 = this.field_70761_aq * ((float)Math.PI / 180);
            float f19 = MathHelper.func_76126_a((float)f2);
            float f3 = MathHelper.func_76134_b((float)f2);
            for (int i = 0; i < 32; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.END_ROD, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O * 2.0, this.field_70161_v, (double)(f3 * 0.15f), 0.01, (double)(f19 * 0.15f), new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.END_ROD, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O * 2.0, this.field_70161_v, (double)(f3 * -0.15f), 0.01, (double)(f19 * -0.15f), new int[0]);
            }
        }
    }

    static class AISummonSilverfish
    extends EntityAIBase {
        private EntitySilverfish silverfish;
        private int field_179463_b;

        public AISummonSilverfish(EntitySilverfish silverfishIn) {
            this.silverfish = silverfishIn;
        }

        public void func_179462_f() {
            if (this.field_179463_b == 0) {
                this.field_179463_b = 20;
            }
        }

        public boolean func_75250_a() {
            return this.field_179463_b > 0;
        }

        public void func_75246_d() {
            --this.field_179463_b;
            if (this.field_179463_b <= 0) {
                World world = this.silverfish.field_70170_p;
                Random random = this.silverfish.func_70681_au();
                BlockPos blockpos = new BlockPos((Entity)this.silverfish);
                int i = 0;
                while (i <= 5 && i >= -5) {
                    int j = 0;
                    while (j <= 10 && j >= -10) {
                        int k = 0;
                        while (k <= 10 && k >= -10) {
                            BlockPos blockpos1 = blockpos.func_177982_a(j, i, k);
                            IBlockState iblockstate = world.func_180495_p(blockpos1);
                            if (iblockstate.func_177230_c() == Blocks.field_150418_aU) {
                                if (world.func_82736_K().func_82766_b("mobGriefing")) {
                                    world.func_175655_b(blockpos1, true);
                                } else {
                                    world.func_180501_a(blockpos1, ((BlockSilverfish.EnumType)iblockstate.func_177229_b((IProperty)BlockSilverfish.field_176378_a)).func_176883_d(), 3);
                                }
                                if (random.nextBoolean()) {
                                    return;
                                }
                            }
                            k = k <= 0 ? 1 - k : 0 - k;
                        }
                        j = j <= 0 ? 1 - j : 0 - j;
                    }
                    i = i <= 0 ? 1 - i : 0 - i;
                }
            }
        }
    }
}

