/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier1;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EntitySheep
extends EntityFriendlyCreature
implements IShearable {
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EntitySheep.class, (DataSerializer)DataSerializers.field_187191_a);
    private final InventoryCrafting inventoryCrafting = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }, 2, 1);
    private static final Map<EnumDyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(EnumDyeColor.class);
    private int sheepTimer;
    private EntityAIEatGrass entityAIEatGrass;

    public static float[] getDyeRgb(EnumDyeColor dyeColor) {
        return DYE_TO_RGB.get(dyeColor);
    }

    public EntitySheep(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.3f);
        this.inventoryCrafting.func_70299_a(0, new ItemStack(Items.field_151100_aR));
        this.inventoryCrafting.func_70299_a(1, new ItemStack(Items.field_151100_aR));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.25, 16.0f, 4.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.25, false));
        this.entityAIEatGrass = new EntityAIEatGrass((EntityLiving)this);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void func_70619_bc() {
        this.sheepTimer = this.entityAIEatGrass.func_151499_f();
        super.func_70619_bc();
    }

    @Override
    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        return this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150349_c && this.field_70170_p.func_175699_k(blockpos) > 8 && super.func_70601_bi();
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.getSheared()) {
            return LootTableListEngender.ENTITIES_SHEEP;
        }
        switch (this.getFleeceColor()) {
            default: {
                return LootTableListEngender.ENTITIES_SHEEP_WHITE;
            }
            case ORANGE: {
                return LootTableListEngender.ENTITIES_SHEEP_ORANGE;
            }
            case MAGENTA: {
                return LootTableListEngender.ENTITIES_SHEEP_MAGENTA;
            }
            case LIGHT_BLUE: {
                return LootTableListEngender.ENTITIES_SHEEP_LIGHT_BLUE;
            }
            case YELLOW: {
                return LootTableListEngender.ENTITIES_SHEEP_YELLOW;
            }
            case LIME: {
                return LootTableListEngender.ENTITIES_SHEEP_LIME;
            }
            case PINK: {
                return LootTableListEngender.ENTITIES_SHEEP_PINK;
            }
            case GRAY: {
                return LootTableListEngender.ENTITIES_SHEEP_GRAY;
            }
            case SILVER: {
                return LootTableListEngender.ENTITIES_SHEEP_SILVER;
            }
            case CYAN: {
                return LootTableListEngender.ENTITIES_SHEEP_CYAN;
            }
            case PURPLE: {
                return LootTableListEngender.ENTITIES_SHEEP_PURPLE;
            }
            case BLUE: {
                return LootTableListEngender.ENTITIES_SHEEP_BLUE;
            }
            case BROWN: {
                return LootTableListEngender.ENTITIES_SHEEP_BROWN;
            }
            case GREEN: {
                return LootTableListEngender.ENTITIES_SHEEP_GREEN;
            }
            case RED: {
                return LootTableListEngender.ENTITIES_SHEEP_RED;
            }
            case BLACK: 
        }
        return LootTableListEngender.ENTITIES_SHEEP_BLACK;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && stack == null && player == this.getOwner()) {
            player.func_184220_m((Entity)this);
            this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i());
            this.field_70170_p.func_175718_b(2001, this.func_180425_c(), Block.func_176210_f((IBlockState)Blocks.field_150325_L.func_176223_P()));
            return true;
        }
        return super.func_184645_a(player, p_184645_2_, stack);
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            this.field_70138_W = 1.0f;
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (Keyboard.isKeyDown((int)57) && this.field_70122_E) {
                this.func_70664_aZ();
                this.field_70160_al = true;
                ForgeHooks.onLivingJump((EntityLivingBase)this);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.1f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Sheared", this.getSheared());
        tagCompound.func_74774_a("Color", (byte)this.getFleeceColor().func_176765_a());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setSheared(tagCompund.func_74767_n("Sheared"));
        this.setFleeceColor(EnumDyeColor.func_176764_b((int)tagCompund.func_74771_c("Color")));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public EnumDyeColor getFleeceColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setFleeceColor(EnumDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public static EnumDyeColor getRandomSheepColor(Random random) {
        int i = random.nextInt(100);
        return random.nextInt(500) == 0 ? EnumDyeColor.PINK : (i < 18 ? EnumDyeColor.BROWN : (i < 15 ? EnumDyeColor.SILVER : (i < 10 ? EnumDyeColor.GRAY : (i < 5 ? EnumDyeColor.BLACK : EnumDyeColor.WHITE))));
    }

    public void func_70615_aA() {
        this.setSheared(false);
        this.func_70691_i(2.0f);
        this.func_145779_a(Items.field_151014_N, 2 + this.field_70146_Z.nextInt(3));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setFleeceColor(EntitySheep.getRandomSheepColor(this.field_70170_p.field_73012_v));
        return livingdata;
    }

    public float func_70047_e() {
        return 0.95f * this.field_70131_O;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getFleeceColor().func_176765_a()));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    static {
        DYE_TO_RGB.put(EnumDyeColor.WHITE, new float[]{1.0f, 1.0f, 1.0f});
        DYE_TO_RGB.put(EnumDyeColor.ORANGE, new float[]{0.85f, 0.5f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.MAGENTA, new float[]{0.7f, 0.3f, 0.85f});
        DYE_TO_RGB.put(EnumDyeColor.LIGHT_BLUE, new float[]{0.4f, 0.6f, 0.85f});
        DYE_TO_RGB.put(EnumDyeColor.YELLOW, new float[]{0.9f, 0.9f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.LIME, new float[]{0.5f, 0.8f, 0.1f});
        DYE_TO_RGB.put(EnumDyeColor.PINK, new float[]{0.95f, 0.5f, 0.65f});
        DYE_TO_RGB.put(EnumDyeColor.GRAY, new float[]{0.3f, 0.3f, 0.3f});
        DYE_TO_RGB.put(EnumDyeColor.SILVER, new float[]{0.6f, 0.6f, 0.6f});
        DYE_TO_RGB.put(EnumDyeColor.CYAN, new float[]{0.3f, 0.5f, 0.6f});
        DYE_TO_RGB.put(EnumDyeColor.PURPLE, new float[]{0.5f, 0.25f, 0.7f});
        DYE_TO_RGB.put(EnumDyeColor.BLUE, new float[]{0.2f, 0.3f, 0.7f});
        DYE_TO_RGB.put(EnumDyeColor.BROWN, new float[]{0.4f, 0.3f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.GREEN, new float[]{0.4f, 0.5f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.RED, new float[]{0.6f, 0.2f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.BLACK, new float[]{0.1f, 0.1f, 0.1f});
    }
}

