/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.blocks.BlockGuardBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndGateway;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.helpful.EntityPortal;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ITeamedMobs;
import net.minecraft.entity.helpful.ai.EntityAINearestAttackableTargetBox;
import net.minecraft.entity.helpful.tier2.EntityVillager;
import net.minecraft.entity.helpful.tier3.EntityPolarBear;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.entity.helpful.tier4.EntityGhast;
import net.minecraft.entity.helpful.tier4.EntityGuardian;
import net.minecraft.entity.helpful.tier4.EntityShulker;
import net.minecraft.entity.helpful.tier5.EntityIronGolem;
import net.minecraft.entity.helpful.tier5.EntityWither;
import net.minecraft.entity.helpful.tier6.EntityCommandBlockWither;
import net.minecraft.entity.helpful.tier6.EntityWitherStorm;
import net.minecraft.entity.helpful.tier6.EntityWitherStormHead;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacle;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacleDevourer;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityFriendlyCreature
extends EntityCreature
implements IEntityOwnable,
ITeamedMobs {
    private static final DataParameter<Boolean> HERO = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", 0.5, 1).func_111168_a(false);
    private static final UUID attackingBoostModifierUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier attackingBoostModifier = new AttributeModifier(attackingBoostModifierUUID, "Attacking boost", 0.5, 1).func_111168_a(false);
    private static final DataParameter<Integer> HEROSPECIALATTACKTIMER = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean isOffensive;
    public double randPosX;
    public double randPosY;
    public double randPosZ;
    public BlockPos guardBlock;
    public int moralRaisedTimer;
    private int nextStepDistance;
    public int convertionInt;

    public EntityFriendlyCreature(World worldIn) {
        super(worldIn);
        for (int i = 0; i < this.field_184655_bs.length; ++i) {
            this.field_184655_bs[i] = 1.0f;
        }
        for (int j = 0; j < this.field_82174_bp.length; ++j) {
            this.field_82174_bp[j] = 1.0f;
        }
        this.nextStepDistance = 1;
        this.field_70728_aV = 5;
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityFriendlyCreature.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityAgeable.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityGolem.class, 8.0f));
        this.field_70715_bh.func_75776_a(4, new EntityAINearestAttackableTargetBox<EntityLivingBase>(this, EntityLivingBase.class, 0, true, true, new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase p_apply_1_) {
                return p_apply_1_ != null && !(p_apply_1_ instanceof EntityAmbientCreature) && !(p_apply_1_ instanceof EntityAnimal) && !(p_apply_1_ instanceof EntityHorse) && !p_apply_1_.func_82150_aj() && !p_apply_1_.func_70093_af() && !EntityFriendlyCreature.this.func_70093_af() && !EntityFriendlyCreature.this.isOnSameTeam(p_apply_1_);
            }
        }));
        this.field_70715_bh.func_75776_a(5, new EntityAINearestAttackableTargetBox<EntityLivingBase>(this, EntityLivingBase.class, 0, true, true, new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_ instanceof IMob && !p_apply_1_.func_82150_aj() && !EntityFriendlyCreature.this.func_70093_af() && !EntityFriendlyCreature.this.isOnSameTeam(p_apply_1_);
            }
        }));
        this.func_174805_g(true);
        this.field_70158_ak = true;
    }

    public int timesToConvert() {
        if (this.getTier() == EnumEntityTier.TIER6) {
            return Integer.MAX_VALUE;
        }
        if (this.getTier() == EnumEntityTier.TIER5) {
            return 79;
        }
        if (this.getTier() == EnumEntityTier.TIER4) {
            return 23;
        }
        if (this.getTier() == EnumEntityTier.TIER3) {
            return 11;
        }
        if (this.getTier() == EnumEntityTier.TIER2) {
            return 5;
        }
        return 3;
    }

    public void incrementConversion(EntityPlayer player) {
        if (this.isWild()) {
            if (this.convertionInt >= this.timesToConvert()) {
                this.setOwnerId(player.func_110124_au());
                this.field_70173_aa = 1;
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                if (!this.isWild() && !this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_70005_c_() + " has been converted by " + player.func_70005_c_() + " (" + this.field_70165_t + ", " + this.field_70163_u + ", " + this.field_70161_v + ", )", new Object[0]));
                }
            } else {
                ++this.convertionInt;
                this.func_184185_a(ModSoundEvents.converting, 3.0f, 1.0f);
            }
        }
    }

    protected boolean func_70610_aX() {
        return this.func_184207_aI() ? true : super.func_70610_aX();
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        d0 = d0 * 128.0 * (double)this.field_70130_N;
        return this.field_70158_ak;
    }

    public boolean shouldAttackEntity(EntityLivingBase p_142018_1_, EntityLivingBase p_142018_2_) {
        return !(p_142018_1_ instanceof EntityPlayer) || !(p_142018_2_ instanceof EntityPlayer) || ((EntityPlayer)p_142018_2_).func_96122_a((EntityPlayer)p_142018_1_);
    }

    protected boolean func_70692_ba() {
        return this.isWild();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(this.field_70170_p.func_72912_H().func_76067_t() == WorldType.field_77138_c ? 1000 : 50) == 0 && super.func_70601_bi();
    }

    public boolean teleportTo_(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        this.func_70661_as().func_75499_g();
        return true;
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    protected void dropEquipmentUndamaged() {
        if (!this.field_70170_p.field_72995_K) {
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (itemstack == null) continue;
                this.func_184606_a_(itemstack);
                this.func_70099_a(itemstack, this.func_70047_e());
                this.func_184201_a(entityequipmentslot, null);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(HERO, (Object)false);
        this.field_70180_af.func_187214_a(HEROSPECIALATTACKTIMER, (Object)0);
    }

    public int getSpecialAttackTimer() {
        return (Integer)this.field_70180_af.func_187225_a(HEROSPECIALATTACKTIMER);
    }

    public void setSpecialAttackTimer(int p_82215_1_) {
        this.field_70180_af.func_187227_b(HEROSPECIALATTACKTIMER, (Object)p_82215_1_);
    }

    public void performSpecialAttack() {
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        String s = "";
        if (tagCompund.func_150297_b("OwnerUUID", 8)) {
            s = tagCompund.func_74779_i("OwnerUUID");
        } else {
            String s1 = tagCompund.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (s.length() > 0) {
            this.setOwnerId(UUID.fromString(s));
        }
        this.field_70180_af.func_187227_b(HERO, (Object)tagCompund.func_74767_n("Hero"));
        this.setSpecialAttackTimer(tagCompund.func_74762_e("SAT"));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.func_184753_b() == null) {
            tagCompound.func_74778_a("OwnerUUID", "");
        } else {
            tagCompound.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
        if (((Boolean)this.field_70180_af.func_187225_a(HERO)).booleanValue()) {
            tagCompound.func_74757_a("Hero", true);
        }
        tagCompound.func_74768_a("SAT", this.getSpecialAttackTimer());
    }

    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean isHero() {
        return (Boolean)this.field_70180_af.func_187225_a(HERO);
    }

    public void setIsHero(boolean bool) {
        this.field_70180_af.func_187227_b(HERO, (Object)bool);
    }

    public void becomeAHero() {
        this.setIsHero(true);
        this.func_184185_a(ModSoundEvents.hero, 100.0f, 1.0f);
        this.field_70173_aa = -20;
        if (this instanceof EntityWither) {
            ((EntityWither)this).func_82206_m();
        }
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.MASTER;
    }

    public BlockPos getGuardBlock() {
        return this.guardBlock;
    }

    public void setGuardBlock(BlockPos block) {
        this.guardBlock = block;
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    public boolean isWild() {
        return this.getOwner() == null;
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase = this.getOwner();
        if (!this.isWild()) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    @Override
    public boolean isOnSameTeam(EntityLivingBase otherEntity) {
        if (!this.isWild()) {
            if (otherEntity instanceof EntityHorse || otherEntity instanceof EntitySnowman || otherEntity instanceof EntityWaterMob || otherEntity instanceof EntityAnimal || otherEntity instanceof EntityTameable && ((EntityTameable)otherEntity).func_70902_q() == this.getOwner() || otherEntity instanceof EntityPlayer && (otherEntity == this.getOwner() || otherEntity != this.getOwner() && otherEntity.func_184191_r((Entity)this.getOwner())) || otherEntity instanceof EntityTameable && ((EntityTameable)otherEntity).func_70902_q() == this.getOwner() || otherEntity instanceof INpc && !(otherEntity instanceof EntityVillager) || otherEntity instanceof EntityFriendlyCreature && (((EntityFriendlyCreature)otherEntity).getOwner() == this.getOwner() || ((EntityFriendlyCreature)otherEntity).getOwner() != this.getOwner() && ((EntityFriendlyCreature)otherEntity).isOnSameTeam(this.getOwner())) || otherEntity instanceof net.minecraft.entity.monster.EntityIronGolem && ((net.minecraft.entity.monster.EntityIronGolem)otherEntity).func_70850_q()) {
                return true;
            }
            if (otherEntity instanceof EntityFriendlyCreature && ((EntityFriendlyCreature)otherEntity).convertionInt > 0) {
                return true;
            }
            if (otherEntity instanceof EntityPlayer && (otherEntity == this.getOwner() || this.getOwner().func_184191_r((Entity)otherEntity) || super.func_184191_r((Entity)otherEntity))) {
                return true;
            }
        } else if (this.isWild()) {
            if (otherEntity instanceof EntityFriendlyCreature && ((EntityFriendlyCreature)otherEntity).isWild()) {
                return true;
            }
            if (otherEntity instanceof net.minecraft.entity.passive.EntityVillager && !(this instanceof EntityZombie)) {
                return true;
            }
            if (otherEntity instanceof EntitySquid && !(this instanceof EntityGuardian)) {
                return true;
            }
            if (this.convertionInt > 0) {
                return true;
            }
        }
        return super.func_184191_r((Entity)otherEntity);
    }

    protected void func_70623_bb() {
        if (this.isWild() && this.func_184222_aU() && !(this instanceof EntityPortal)) {
            super.func_70623_bb();
        }
    }

    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : super.func_70599_aP();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isHero()) {
            amount *= 0.5f;
        }
        if (source.func_76352_a()) {
            this.func_184185_a(this.getPierceHurtSound(), 3.0f, 1.0f);
        } else if (amount >= 7.0f || source.func_94541_c() || source == DamageSource.field_82728_o || source.func_76357_e() || source.func_151517_h() || source.func_82725_o() || source == DamageSource.field_76379_h || source == DamageSource.field_76371_c) {
            this.func_184185_a(this.getCrushHurtSound(), 3.0f, 1.0f);
        } else {
            this.func_184185_a(this.getRegularHurtSound(), 3.0f, 1.0f);
        }
        Entity entity = source.func_76346_g();
        if (this.func_180431_b(source)) {
            return false;
        }
        if (entity instanceof EntityLivingBase && this.isOnSameTeam((EntityLivingBase)entity) || entity instanceof EntityCreeper) {
            if (entity != null && this.getOwner() != null && entity == this.getOwner()) {
                this.moralRaisedTimer = 240;
                this.func_70661_as().func_75499_g();
            }
            return false;
        }
        if (entity != null && entity instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        if (this.isHero() && entity != null && entity instanceof IMob) {
            amount *= 0.33333334f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this instanceof EntityPolarBear) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, 1.0f);
        }
        this.func_184609_a(EnumHand.MAIN_HAND);
        this.func_184609_a(EnumHand.OFF_HAND);
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (this.func_184592_cb() != null && this.func_184614_ca() != null) {
            f *= 2.0f;
        }
        if (this.isHero()) {
            f *= 1.5f;
            if (entityIn instanceof IMob) {
                f *= 4.5f;
            }
        }
        if (this instanceof EntityIronGolem) {
            f += this.field_70146_Z.nextFloat() * 15.0f;
        }
        if (entityIn instanceof EntityWitherStorm && (!this.func_184222_aU() || this instanceof EntityWitherStormHead || this instanceof EntityWitherStormTentacle || this instanceof EntityWitherStormTentacleDevourer)) {
            f *= 100.0f;
        }
        if (this.func_70093_af() && entityIn instanceof EntityLiving && ((EntityLiving)entityIn).func_70638_az() != this) {
            f *= 3.0f;
            i += 3;
        }
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
            if (this instanceof EntityWitherStormTentacle) {
                i += 9;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72876_a((Entity)this, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, 3.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                }
            }
            if (this instanceof EntityWitherStormTentacleDevourer) {
                i += 12;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72876_a((Entity)this, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, 6.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                }
            }
        }
        if (!this.isWild()) {
            entityIn.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.getOwner())), 0.0f);
            entityIn.field_70172_ad = 0;
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        if (this.func_70668_bt() == EnumCreatureAttribute.UNDEAD && entityIn instanceof net.minecraft.entity.boss.EntityWither) {
            flag = entityIn.func_70097_a(DamageSource.field_76376_m, f);
        }
        if (entityIn instanceof EntityDragon) {
            flag = ((EntityDragon)entityIn).func_70965_a(((EntityDragon)entityIn).field_70987_i, DamageSource.field_76377_j.func_94540_d(), f);
        }
        if (flag && !this.func_184191_r(entityIn) && (entityIn != this || !this.isWild() && entityIn != this.getOwner())) {
            int j;
            if (entityIn instanceof net.minecraft.entity.boss.EntityWither || entityIn instanceof net.minecraft.entity.monster.EntityShulker || entityIn instanceof net.minecraft.entity.monster.EntitySkeleton || entityIn instanceof EntitySkeleton || entityIn instanceof EntityWither || entityIn instanceof EntityCommandBlockWither || entityIn instanceof EntityPortal) {
                if (f >= 7.0f) {
                    entityIn.func_184185_a(ModSoundEvents.woodHitCrush, 3.0f, 1.0f);
                    if (this.field_70131_O > 7.0f) {
                        f *= 15.0f;
                    }
                } else {
                    entityIn.func_184185_a(ModSoundEvents.woodHit, 3.0f, 1.0f);
                }
            } else if (entityIn instanceof net.minecraft.entity.monster.EntityIronGolem || entityIn instanceof EntityBlaze) {
                if (f >= 7.0f) {
                    entityIn.func_184185_a(ModSoundEvents.metalHitCrush, 3.0f, 1.0f);
                } else {
                    entityIn.func_184185_a(ModSoundEvents.metalHit, 3.0f, 1.0f);
                }
            } else if (f >= 7.0f) {
                if (entityIn.field_70131_O >= 7.0f) {
                    entityIn.func_184185_a(ModSoundEvents.fleshHitCrushHeavy, 3.0f, 1.0f);
                    if (this.field_70131_O > 7.0f) {
                        f *= 4.0f;
                    }
                } else {
                    entityIn.func_184185_a(ModSoundEvents.fleshHitCrush, 3.0f, 1.0f);
                }
            } else {
                entityIn.func_184185_a(ModSoundEvents.fleshHit, 3.0f, 1.0f);
            }
            if (entityIn instanceof EntityLivingBase && !entityIn.func_70089_S() && !this.isWild()) {
                if (this.func_70093_af()) {
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entityIn.func_70005_c_() + " was assassinated by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                } else {
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entityIn.func_70005_c_() + " was slain by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
            if (entityIn instanceof EntityLivingBase) {
                entityIn.field_70181_x = (double)this.field_70131_O * 0.25;
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f + 0.3f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                if (itemstack != null && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return entityIn instanceof EntityLivingBase && this.isOnSameTeam((EntityLivingBase)entityIn) ? false : flag;
    }

    protected void func_70619_bc() {
        Block block;
        IBlockState iblockstate;
        BlockPos blockpos;
        int l;
        int k;
        int i3;
        int j;
        int l2;
        boolean flag;
        if (!(this.field_70170_p.field_72995_K || this instanceof EntityWitherStorm || this.func_70638_az() != null || this.field_70146_Z.nextInt(10) != 0 || this.func_70093_af())) {
            double d0 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(d0, d0, d0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity != null && entity.func_70089_S() && !entity.func_82150_aj() && !entity.func_70093_af() && this.func_70685_l((Entity)entity) && !this.isOnSameTeam(entity)) {
                        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75102_a) {
                            list.remove(entity);
                            continue;
                        }
                        this.func_70624_b(entity);
                        continue;
                    }
                    list.remove(entity);
                }
            }
        }
        if (this.func_70089_S() && this.func_70638_az() != null && !this.isOnSameTeam(this.func_70638_az()) && this.func_70068_e((Entity)this.func_70638_az()) < (double)this.field_70130_N + 4.0 && this.field_70173_aa % 10 == 0) {
            this.func_70652_k((Entity)this.func_70638_az());
        }
        if (this.getGuardBlock() != null) {
            IBlockState iblockstate2;
            Block block2;
            if (this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(10) == 0) {
                this.randPosX = (float)this.getGuardBlock().func_177958_n() + (this.field_70146_Z.nextFloat() * 24.0f - 12.0f);
                this.randPosY = (double)this.getGuardBlock().func_177956_o() + 1.0 + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f);
                this.randPosZ = (float)this.getGuardBlock().func_177952_p() + (this.field_70146_Z.nextFloat() * 24.0f - 12.0f);
            }
            if (this.field_70170_p.func_180495_p(new BlockPos(this.randPosX, this.randPosY, this.randPosZ)).func_177230_c() == Blocks.field_150350_a) {
                this.randPosY -= 1.0;
            }
            BlockPos blockPos = new BlockPos(this.randPosX, this.randPosY, this.randPosZ);
            if (this.func_174831_c(blockPos) > 4.0 && this.func_70638_az() == null) {
                this.func_70661_as().func_75492_a(this.randPosX, this.randPosY, this.randPosZ, 1.0);
                this.func_70671_ap().func_75650_a(this.randPosX, this.randPosY, this.randPosZ, 10.0f, 0.0f);
                BlockPos blockPos2 = new BlockPos(this.randPosX, this.randPosY, this.randPosZ);
                if (this.func_174831_c(blockPos2) > this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() * this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()) {
                    this.func_70107_b(this.randPosX, this.randPosY, this.randPosZ);
                    this.func_70664_aZ();
                    if (this.func_184218_aH()) {
                        this.func_184187_bx().func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    }
                }
            }
            if (!((block2 = (iblockstate2 = this.field_70170_p.func_180495_p(this.getGuardBlock())).func_177230_c()) instanceof BlockGuardBlock)) {
                this.setGuardBlock(null);
            }
        }
        if (this.getGuardBlock() == null && this.getTier() != EnumEntityTier.TIER6 && this.func_184222_aU() && !this.isWild() && this.field_70173_aa % 40 == 0 && this.field_70146_Z.nextInt(10) == 0) {
            int i11 = MathHelper.func_76128_c((double)this.field_70163_u);
            int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
            flag = false;
            for (int k2 = (int)(-this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()); k2 <= (int)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(); ++k2) {
                for (l2 = (int)(-this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()); l2 <= (int)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(); ++l2) {
                    for (j = (int)(-this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()); j <= (int)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(); ++j) {
                        i3 = l1 + k2;
                        k = i11 + j;
                        l = i2 + l2;
                        blockpos = new BlockPos(i3, k, l);
                        iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        block = iblockstate.func_177230_c();
                        if (!(block instanceof BlockGuardBlock)) continue;
                        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 0.0f, false, false);
                        this.setGuardBlock(blockpos);
                        this.randPosX = i3;
                        this.randPosY = k;
                        this.randPosZ = l;
                    }
                }
            }
        }
        if (this.field_70173_aa > 220 && this.func_70638_az() == null && this.getTier() != EnumEntityTier.TIER6 && !this.isWild()) {
            int i11 = MathHelper.func_76128_c((double)this.getOwner().field_70163_u);
            int l1 = MathHelper.func_76128_c((double)this.getOwner().field_70165_t);
            int i2 = MathHelper.func_76128_c((double)this.getOwner().field_70161_v);
            flag = false;
            for (int k2 = -2; k2 <= 2; ++k2) {
                for (l2 = -2; l2 <= 2; ++l2) {
                    for (j = -2; j <= 2; ++j) {
                        i3 = l1 + k2;
                        k = i11 + j;
                        l = i2 + l2;
                        blockpos = new BlockPos((double)i3 + 0.5, (double)k, (double)l + 0.5);
                        iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        block = iblockstate.func_177230_c();
                        if (!(block instanceof BlockEndGateway) && !(block instanceof BlockEndPortal) && !(block instanceof BlockPortal) || this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150350_a || this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) continue;
                        if (this instanceof EntityGhast) {
                            this.func_70605_aq().func_75642_a((double)i3, (double)k, (double)l, 1.0);
                        } else {
                            this.func_70661_as().func_75492_a((double)i3, (double)k, (double)l, 1.0);
                        }
                        if (!(this instanceof EntityGuardian) && !(this instanceof EntityShulker) && !(this instanceof EntityGhast) && !(this.func_174831_c(blockpos) < 4.0)) continue;
                        if (block instanceof BlockEndPortal && (!this.func_184222_aU() || this.func_184207_aI() || this.func_184218_aH())) {
                            this.func_184204_a(1);
                        }
                        if (block instanceof BlockPortal && (!this.func_184222_aU() || this.func_184207_aI() || this.func_184218_aH())) {
                            this.func_181015_d(blockpos);
                        }
                        this.func_70634_a((double)i3 + 0.5, k, (double)l + 0.5);
                        if (this instanceof EntityShulker) {
                            this.func_184185_a(SoundEvents.field_187791_eX, this.func_70599_aP(), 0.95f);
                        }
                        if (!(block instanceof BlockEndGateway)) continue;
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1));
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(2));
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1).func_177974_f());
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1).func_177978_c());
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1).func_177976_e());
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1).func_177968_d());
                    }
                }
            }
        }
        if (this.func_70660_b(MobEffects.field_76431_k) != null) {
            this.func_70624_b(null);
            this.field_70759_as += this.field_70146_Z.nextFloat() * 10.0f - 5.0f;
            this.field_70125_A += this.field_70146_Z.nextFloat() * 10.0f - 5.0f;
        }
        if (!this.field_70145_X && this.func_70094_T()) {
            this.field_70159_w += this.field_70146_Z.nextDouble() - 0.5;
            this.field_70179_y += this.field_70146_Z.nextDouble() - 0.5;
            this.field_70181_x += 0.5;
            this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
            if (this.func_184218_aH() && this.func_184187_bx().func_70094_T()) {
                this.func_184187_bx().field_70159_w += this.field_70146_Z.nextDouble() - 0.5;
                this.func_184187_bx().field_70179_y += this.field_70146_Z.nextDouble() - 0.5;
                this.func_184187_bx().field_70181_x += 0.5;
                this.func_184187_bx().func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
            }
        }
        if (this.field_70173_aa > 20 && this.func_70089_S()) {
            super.func_70619_bc();
        }
        if (this.moralRaisedTimer <= 0) {
            this.moralRaisedTimer = 0;
        }
        if (this.moralRaisedTimer > 0) {
            --this.moralRaisedTimer;
        }
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        Potion potion;
        return !this.func_70662_br() || (potion = potioneffectIn.func_188419_a()) != MobEffects.field_76428_l && potion != MobEffects.field_76436_u;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && !this.isWild() && this.getOwner() instanceof EntityPlayerMP) {
            this.getOwner().func_145747_a(this.func_110142_aN().func_151521_b());
        }
        super.func_70645_a(cause);
    }

    protected void func_82167_n(Entity p_82167_1_) {
        if (p_82167_1_ instanceof EntityLivingBase && !this.isOnSameTeam((EntityLivingBase)p_82167_1_)) {
            this.func_70624_b((EntityLivingBase)p_82167_1_);
        }
        super.func_82167_n(p_82167_1_);
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        this.func_70624_b(null);
    }

    protected void func_110159_bB() {
        if (this.func_110167_bD()) {
            if (!this.func_70089_S()) {
                this.func_110160_i(true, true);
            }
            if (this.func_110166_bE() == null || this.func_110166_bE().field_70128_L) {
                this.func_110160_i(true, true);
            }
        }
        if (this.func_110167_bD() && this.func_110166_bE() != null && this.func_110166_bE().field_70170_p == this.field_70170_p) {
            Entity entity = this.func_110166_bE();
            this.func_175449_a(new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v), 5);
            float f = this.func_70032_d(entity);
            this.func_142017_o(f);
            if (f > 6.0f) {
                this.func_70661_as().func_75497_a(entity, 1.0);
            }
            if (f > 8.0f) {
                double d0 = (entity.field_70165_t - this.field_70165_t) / (double)f;
                double d1 = (entity.field_70163_u - this.field_70163_u) / (double)f;
                double d2 = (entity.field_70161_v - this.field_70161_v) / (double)f;
                this.field_70159_w += d0 * Math.abs(d0) * 0.4;
                this.field_70181_x += d1 * Math.abs(d1) * 0.4;
                this.field_70179_y += d2 * Math.abs(d2) * 0.4;
            }
            if (f > 32.0f) {
                this.func_110160_i(true, true);
            }
        }
    }

    public void func_70636_d() {
        double d3;
        double d2;
        double d1;
        double d0;
        this.func_82168_bl();
        if (this.func_110167_bD() && !this.field_70122_E) {
            this.field_70143_R *= 0.0f;
        }
        if (this.isWild() && this.func_184207_aI() && this.func_184179_bs() instanceof EntityPlayer) {
            this.setOwnerId(((EntityPlayer)this.func_184179_bs()).func_110124_au());
        }
        if (this.getSpecialAttackTimer() > 0) {
            if (this.moralRaisedTimer > 200) {
                this.setSpecialAttackTimer(this.getSpecialAttackTimer() - 2);
            } else {
                this.setSpecialAttackTimer(this.getSpecialAttackTimer() - 1);
            }
        }
        if (this.func_70089_S() && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < (double)this.field_70130_N + 4.0 && this.field_70173_aa % 10 == 0) {
            this.func_70652_k((Entity)this.func_70638_az());
        }
        if (this.field_70146_Z.nextInt(2) == 0 && !this.isWild() && this.getOwner().func_70643_av() != null) {
            this.func_70624_b(this.getOwner().func_70643_av());
        }
        if (this.isWild()) {
            if (this.field_70170_p.field_72995_K) {
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d3 = 10.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.TOWN_AURA, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
            }
        } else {
            this.convertionInt = 0;
            if (this.isHero() && this.field_70170_p.field_72995_K) {
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d3 = 10.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
            }
        }
        if (this.func_70638_az() == null && this.field_70146_Z.nextInt(10) == 0) {
            d0 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(d0, d0, d0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (entity != null && entity.func_70089_S() && !(this instanceof EntityWitherStorm) && !this.func_70093_af() && this.func_70685_l(entity) && !this.isOnSameTeam((EntityLivingBase)entity)) {
                        this.func_70624_b((EntityLivingBase)entity);
                        continue;
                    }
                    list.remove(entity);
                }
            }
        }
        if (this.convertionInt > 0 && this.field_70170_p.field_72995_K) {
            d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d12 = this.field_70146_Z.nextGaussian() * 0.02;
            d2 = this.field_70146_Z.nextGaussian() * 0.02;
            d3 = 10.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d12 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, d12, d2, new int[0]);
        }
        if (this.field_70173_aa > 20) {
            super.func_70636_d();
        } else {
            if (this.field_70173_aa <= 20) {
                this.func_70095_a(true);
            }
            if (this.field_70173_aa <= 3) {
                this.func_70656_aK();
            }
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
            this.field_70125_A = 0.0f;
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            if (this.field_70173_aa == 0) {
                this.func_184185_a(ModSoundEvents.createMob, 5.0f, 1.0f);
            }
        }
        if (!this.func_184207_aI() && this.func_70089_S() && this.field_70122_E && this.func_70638_az() != null && this.func_70638_az().field_70163_u >= this.field_70163_u + 2.0 && this.field_70146_Z.nextInt(100) == 0) {
            this.field_70181_x = (double)this.func_175134_bD() + (double)0.2f;
            this.field_70160_al = true;
            ForgeHooks.onLivingJump((EntityLivingBase)this);
            d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d13 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d13 * d13));
            this.field_70159_w += d0 / (double)f * 0.5 * 0.5 + this.field_70159_w * 0.5;
            this.field_70179_y += d13 / (double)f * 0.5 * 0.5 + this.field_70179_y * 0.5;
            if (this.func_70068_e((Entity)this.func_70638_az()) < 8.0) {
                this.func_70652_k((Entity)this.func_70638_az());
            }
        }
        if (this.func_70638_az() != null && (!this.func_70638_az().func_70089_S() || this.isOnSameTeam(this.func_70638_az()))) {
            this.func_70624_b(null);
        }
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        IAttributeInstance iattributeinstanceattack = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (this.moralRaisedTimer > 590 && !iattributeinstance.func_180374_a(attackingSpeedBoostModifier) && !iattributeinstanceattack.func_180374_a(attackingBoostModifier)) {
            this.func_70031_b(true);
            int b0 = 20;
            this.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 20 * b0));
            this.func_184185_a(ModSoundEvents.battlecry, 10.0f, 1.0f);
            iattributeinstance.func_111121_a(attackingSpeedBoostModifier);
            iattributeinstanceattack.func_111121_a(attackingBoostModifier);
        }
        if (this.moralRaisedTimer < 200 && iattributeinstance.func_180374_a(attackingSpeedBoostModifier) && iattributeinstanceattack.func_180374_a(attackingBoostModifier)) {
            this.func_70031_b(false);
            iattributeinstance.func_111124_b(attackingSpeedBoostModifier);
            iattributeinstanceattack.func_111124_b(attackingBoostModifier);
        }
        if (!this.isWild() && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(20) == 0) {
            double d02 = this.field_70146_Z.nextGaussian() * 0.02;
            double d14 = this.field_70146_Z.nextGaussian() * 0.02;
            double d22 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d02, d14, d22, new int[0]);
        }
        if (this.field_70173_aa % 40 == 0) {
            if (this.field_70146_Z.nextInt(20) == 0) {
                this.func_70661_as().func_75499_g();
            }
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            if (this.func_70638_az() == null) {
                this.func_70691_i(5.0f);
            } else {
                this.func_70691_i(1.0f);
            }
        }
        if (this.func_70638_az() != null && this.field_70173_aa % 1 == 0 && (!this.func_70638_az().func_70089_S() || this.isOnSameTeam(this.func_70638_az()))) {
            this.func_70624_b(null);
        }
        if (this.isWild()) {
            this.func_174805_g(false);
        } else {
            this.func_174805_g(true);
        }
        if (!this.isWild() && this.getOwner().func_70051_ag()) {
            this.func_70031_b(true);
        } else {
            this.func_70031_b(false);
        }
        if (!this.isWild() && this.getOwner().func_70093_af()) {
            this.func_70095_a(true);
        } else {
            this.func_70095_a(false);
        }
    }

    protected int getTimeBetweenSteps() {
        return 10;
    }

    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.fleshHit;
    }

    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.fleshHitPierce;
    }

    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.fleshHitCrush;
    }
}

