/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.AgeOfMinecraft.models.ModelZombie;
import net.minecraft.AgeOfMinecraft.models.ModelZombieVillager;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerVillagerArmor;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderZombie
extends RenderBiped<EntityZombie> {
    private static final ResourceLocation ZOMBIE_VILLAGER_TEXTURES = new ResourceLocation("textures/entity/zombie_villager/zombie_villager.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_FARMER_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_farmer.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_LIBRARIAN_LOC = new ResourceLocation("textures/entity/zombie_villager/zombie_librarian.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PRIEST_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_priest.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_SMITH_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_smith.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_BUTCHER_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_butcher.png");
    private static final ResourceLocation ZOMBIE_TEXTURES = new ResourceLocation("textures/entity/zombie/zombie.png");
    private static final ResourceLocation HUSK_ZOMBIE_TEXTURES = new ResourceLocation("textures/entity/zombie/husk.png");
    private final ModelBiped defaultModel;
    private ModelZombieVillager zombieVillagerModel;
    private final List<LayerRenderer<EntityZombie>> field_177121_n;
    private final List<LayerRenderer<EntityZombie>> field_177122_o;

    public RenderZombie(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBiped)new ModelZombie(), 0.5f, 1.0f);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 1.0f));
        LayerRenderer layerrenderer = (LayerRenderer)this.field_177097_h.get(0);
        this.defaultModel = this.field_77071_a;
        this.zombieVillagerModel = new ModelZombieVillager();
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        LayerBipedArmor layerbipedarmor = new LayerBipedArmor((RenderLivingBase)this){

            protected void func_177177_a() {
                this.field_177189_c = new ModelZombie(0.5f, true);
                this.field_177186_d = new ModelZombie(1.0f, true);
            }
        };
        this.func_177094_a((LayerRenderer)layerbipedarmor);
        this.field_177122_o = Lists.newArrayList((Iterable)this.field_177097_h);
        if (layerrenderer instanceof LayerCustomHead) {
            this.func_177089_b(layerrenderer);
            this.func_177094_a((LayerRenderer)new LayerCustomHead(this.zombieVillagerModel.field_78116_c));
        }
        this.func_177089_b((LayerRenderer)layerbipedarmor);
        this.func_177094_a((LayerRenderer)new LayerVillagerArmor((RenderLivingBase<?>)this));
        this.field_177121_n = Lists.newArrayList((Iterable)this.field_177097_h);
    }

    protected void preRenderCallback(EntityZombie entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (entitylivingbaseIn.isHusk()) {
            float f = 1.0625f;
            GlStateManager.func_179152_a((float)1.0625f, (float)1.0625f, (float)1.0625f);
        }
        super.func_77041_b((EntityLivingBase)entitylivingbaseIn, partialTickTime);
    }

    public void doRender(EntityZombie entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.func_82427_a(entity);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityZombie entity) {
        if (entity.isHusk()) {
            return HUSK_ZOMBIE_TEXTURES;
        }
        if (entity.isVillager()) {
            switch (entity.getVillagerType()) {
                case 0: {
                    return ZOMBIE_VILLAGER_FARMER_LOCATION;
                }
                case 1: {
                    return ZOMBIE_VILLAGER_LIBRARIAN_LOC;
                }
                case 2: {
                    return ZOMBIE_VILLAGER_PRIEST_LOCATION;
                }
                case 3: {
                    return ZOMBIE_VILLAGER_SMITH_LOCATION;
                }
                case 4: {
                    return ZOMBIE_VILLAGER_BUTCHER_LOCATION;
                }
            }
            return ZOMBIE_VILLAGER_TEXTURES;
        }
        return ZOMBIE_TEXTURES;
    }

    private void func_82427_a(EntityZombie zombie) {
        if (zombie.isVillager()) {
            this.field_77045_g = this.zombieVillagerModel;
            this.field_177097_h = this.field_177121_n;
        } else {
            this.field_77045_g = this.defaultModel;
            this.field_177097_h = this.field_177122_o;
        }
        this.field_77071_a = (ModelBiped)this.field_77045_g;
    }

    protected void rotateCorpse(EntityZombie bat, float p_77043_2_, float p_77043_3_, float partialTicks) {
        if (bat.isConverting()) {
            p_77043_3_ += (float)(Math.cos((double)bat.field_70173_aa * 3.25) * Math.PI * 0.25);
        }
        super.func_77043_a((EntityLivingBase)bat, p_77043_2_, p_77043_3_, partialTicks);
    }
}

