/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.models.ModelWither;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerWitherAura;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.helpful.tier5.EntityWither;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWither
extends RenderLiving<EntityWither> {
    private static final ResourceLocation invulnerableWitherTextures = new ResourceLocation("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation witherTextures = new ResourceLocation("textures/entity/wither/wither.png");

    public RenderWither(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelWither(0.0f), 1.0f);
        this.func_177094_a(new LayerWitherAura(this));
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 0.5f));
    }

    protected ResourceLocation getEntityTexture(EntityWither entity) {
        int i = entity.getInvulTime();
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? invulnerableWitherTextures : witherTextures;
    }

    protected void preRenderCallback(EntityWither entitylivingbaseIn, float partialTickTime) {
        float f = 2.0f;
        int i = entitylivingbaseIn.getInvulTime();
        if (i > 0) {
            f -= ((float)i - partialTickTime) / 220.0f * 0.5f;
        }
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
        if (entitylivingbaseIn.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        }
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
    }
}

