/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.render.LayerSlimeGel;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.helpful.tier3.EntitySlime;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSlime
extends RenderLiving<EntitySlime> {
    private static final ResourceLocation slimeTextures = new ResourceLocation("textures/entity/slime/slime.png");
    private float scaledown = 1.0f;

    public RenderSlime(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelSlime(16), 0.25f);
        this.func_177094_a(new LayerSlimeGel(this));
    }

    public void doRender(EntitySlime entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_76989_e = 0.25f * (float)entity.getSlimeSize();
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void preRenderCallback(EntitySlime entitylivingbaseIn, float partialTickTime) {
        float f1 = entitylivingbaseIn.getSlimeSize();
        float f2 = (entitylivingbaseIn.prevSquishFactor + (entitylivingbaseIn.squishFactor - entitylivingbaseIn.prevSquishFactor) * partialTickTime) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        GlStateManager.func_179152_a((float)(f3 * f1), (float)(1.0f / f3 * f1), (float)(f3 * f1));
        this.scaledown = 1.0f / f1;
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
    }

    protected ResourceLocation getEntityTexture(EntitySlime entity) {
        return slimeTextures;
    }
}

