/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import java.util.Random;
import net.minecraft.AgeOfMinecraft.models.ModelShulker;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier4.EntityShulker;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderShulker
extends RenderLiving<EntityShulker> {
    private static final ResourceLocation field_188342_a = new ResourceLocation("textures/entity/shulker/endergolem.png");
    private int field_188343_b;

    public RenderShulker(RenderManager p_i46550_1_, ModelShulker p_i46550_2_) {
        super(p_i46550_1_, (ModelBase)p_i46550_2_, 1.0f);
        this.func_177094_a(new HeadLayer());
        this.field_188343_b = p_i46550_2_.func_187065_a();
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 1.0f));
    }

    public void doRender(EntityShulker entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int i;
        if (entity.field_70725_aQ > 0) {
            double d0 = 0.05;
            Random rnd = new Random();
            x += rnd.nextGaussian() * d0;
            z += rnd.nextGaussian() * d0;
        }
        if (this.field_188343_b != ((ModelShulker)this.field_77045_g).func_187065_a()) {
            this.field_77045_g = new ModelShulker();
            this.field_188343_b = ((ModelShulker)this.field_77045_g).func_187065_a();
        }
        if ((i = entity.func_184693_dc()) > 0 && entity.func_184697_de()) {
            BlockPos blockpos = entity.func_184699_da();
            BlockPos blockpos1 = entity.func_184692_dd();
            double d0 = (double)((float)i - partialTicks) / 6.0;
            d0 *= d0;
            double d1 = (double)(blockpos.func_177958_n() - blockpos1.func_177958_n()) * d0;
            double d2 = (double)(blockpos.func_177956_o() - blockpos1.func_177956_o()) * d0;
            double d3 = (double)(blockpos.func_177952_p() - blockpos1.func_177952_p()) * d0;
            super.func_76986_a((EntityLiving)entity, x - d1, y - d2, z - d3, entityYaw, partialTicks);
        } else {
            super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        }
    }

    public boolean shouldRender(EntityShulker livingEntity, ICamera camera, double camX, double camY, double camZ) {
        if (super.func_177071_a((EntityLiving)livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntity.func_184693_dc() > 0 && livingEntity.func_184697_de()) {
            BlockPos blockpos = livingEntity.func_184692_dd();
            BlockPos blockpos1 = livingEntity.func_184699_da();
            Vec3d vec3d = new Vec3d((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p());
            Vec3d vec3d1 = new Vec3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
            if (camera.func_78546_a(new AxisAlignedBB(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c))) {
                return true;
            }
        }
        return false;
    }

    protected ResourceLocation getEntityTexture(EntityShulker entity) {
        return field_188342_a;
    }

    protected void rotateCorpse(EntityShulker bat, float p_77043_2_, float p_77043_3_, float partialTicks) {
        super.func_77043_a((EntityLivingBase)bat, p_77043_2_, p_77043_3_, partialTicks);
        switch (bat.func_184696_cZ()) {
            default: {
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)-0.5f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    protected void preRenderCallback(EntityShulker entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    class HeadLayer
    implements LayerRenderer<EntityShulker> {
        private HeadLayer() {
        }

        public void doRenderLayer(EntityShulker entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            GlStateManager.func_179094_E();
            switch (entitylivingbaseIn.func_184696_cZ()) {
                default: {
                    break;
                }
                case EAST: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)1.0f, (float)-1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case NORTH: {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)1.0f);
                    break;
                }
                case UP: {
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-2.0f, (float)0.0f);
                }
            }
            ModelRenderer modelrenderer = ((ModelShulker)RenderShulker.this.func_177087_b()).field_187066_a;
            modelrenderer.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            modelrenderer.field_78795_f = headPitch * ((float)Math.PI / 180);
            RenderShulker.this.func_110776_a(field_188342_a);
            modelrenderer.func_78785_a(scale);
            GlStateManager.func_179121_F();
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

