/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import java.util.Random;
import net.minecraft.AgeOfMinecraft.models.ModelEnderman;
import net.minecraft.AgeOfMinecraft.render.LayerEndermanEyes;
import net.minecraft.AgeOfMinecraft.render.LayerHeldBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.helpful.tier4.EntityEnderman;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEnderman
extends RenderLiving<EntityEnderman> {
    private static final ResourceLocation endermanTextures = new ResourceLocation("textures/entity/enderman/enderman.png");
    private ModelEnderman endermanModel;
    private Random rnd = new Random();

    public RenderEnderman(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelEnderman(0.0f), 0.5f);
        this.endermanModel = (ModelEnderman)this.field_77045_g;
        this.func_177094_a(new LayerEndermanEyes(this));
        this.func_177094_a(new LayerHeldBlock(this));
    }

    public void doRender(EntityEnderman entity, double x, double y, double z, float entityYaw, float partialTicks) {
        IBlockState iblockstate = entity.getHeldBlockState();
        this.endermanModel.isCarrying = iblockstate != null || entity.func_184179_bs() != null;
        this.endermanModel.isAttacking = entity.isScreaming();
        if (entity.isScreaming()) {
            double d0 = 0.02;
            x += this.rnd.nextGaussian() * d0;
            z += this.rnd.nextGaussian() * d0;
        }
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void preRenderCallback(EntityEnderman entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)-0.75f);
        }
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
    }

    protected ResourceLocation getEntityTexture(EntityEnderman entity) {
        return endermanTextures;
    }
}

