/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.blocks;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.AgeOfMinecraft.SpawnerItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MobSpawnerRecipes {
    private static final MobSpawnerRecipes smeltingBase = new MobSpawnerRecipes();
    private Map smeltingList = Maps.newHashMap();
    private Map experienceList = Maps.newHashMap();

    public static MobSpawnerRecipes instance() {
        return smeltingBase;
    }

    private MobSpawnerRecipes() {
        this.addSmelting(SpawnerItems.fusionItem1, new ItemStack((Item)SpawnerItems.batItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem2, new ItemStack((Item)SpawnerItems.chickenItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem3, new ItemStack((Item)SpawnerItems.cowItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem4, new ItemStack((Item)SpawnerItems.mooshroomItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem5, new ItemStack((Item)SpawnerItems.pigItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem6, new ItemStack((Item)SpawnerItems.rabbitItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem7, new ItemStack((Item)SpawnerItems.sheepItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem8, new ItemStack((Item)SpawnerItems.ozelotItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem9, new ItemStack((Item)SpawnerItems.squidItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem10, new ItemStack((Item)SpawnerItems.villagerItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem11, new ItemStack((Item)SpawnerItems.snowmanItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItem12, new ItemStack((Item)SpawnerItems.silverfishItem), 15.0f);
        this.addSmelting(SpawnerItems.fusionItem13, new ItemStack((Item)SpawnerItems.endermiteItem), 18.0f);
        this.addSmelting(SpawnerItems.fusionItem14, new ItemStack((Item)SpawnerItems.wolfItem), 18.0f);
        this.addSmelting(SpawnerItems.fusionItem15, new ItemStack((Item)SpawnerItems.spiderItem), 20.0f);
        this.addSmelting(SpawnerItems.fusionItem16, new ItemStack((Item)SpawnerItems.zombieItem), 22.0f);
        this.addSmelting(SpawnerItems.fusionItem17, new ItemStack((Item)SpawnerItems.skeletonItem), 30.0f);
        this.addSmelting(SpawnerItems.fusionItem18, new ItemStack((Item)SpawnerItems.creeperItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItem19, new ItemStack((Item)SpawnerItems.slimeItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItem20, new ItemStack((Item)SpawnerItems.magmacubeItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItem21, new ItemStack((Item)SpawnerItems.spiderjockeyItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItem22, new ItemStack((Item)SpawnerItems.chickenjockeyItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItem23, new ItemStack((Item)SpawnerItems.blazeItem), 500.0f);
        this.addSmelting(SpawnerItems.fusionItem24, new ItemStack((Item)SpawnerItems.endermanItem), 400.0f);
        this.addSmelting(SpawnerItems.fusionItem25, new ItemStack((Item)SpawnerItems.cavespiderItem), 100.0f);
        this.addSmelting(SpawnerItems.fusionItem26, new ItemStack((Item)SpawnerItems.pigzombieItem), 200.0f);
        this.addSmelting(SpawnerItems.fusionItem27, new ItemStack((Item)SpawnerItems.guardianItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItem28, new ItemStack((Item)SpawnerItems.ghastItem), 700.0f);
        this.addSmelting(SpawnerItems.fusionItem29, new ItemStack((Item)SpawnerItems.witchItem), 600.0f);
        this.addSmelting(SpawnerItems.fusionItem30, new ItemStack((Item)SpawnerItems.witherskeletonItem), 180.0f);
        this.addSmelting(SpawnerItems.fusionItem31, new ItemStack((Item)SpawnerItems.killerrabbitItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItem32, new ItemStack((Item)SpawnerItems.elderguardianItem), 10000.0f);
        this.addSmelting(SpawnerItems.fusionItem33, new ItemStack((Item)SpawnerItems.giantItem), 8000.0f);
        this.addSmelting(SpawnerItems.fusionItem34, new ItemStack((Item)SpawnerItems.villagergolemItem), 8000.0f);
        this.addSmelting(SpawnerItems.fusionItem35, new ItemStack((Item)SpawnerItems.enderdragonItem), 160000.0f);
        this.addSmelting(SpawnerItems.fusionItem36, new ItemStack((Item)SpawnerItems.witherItem), 16000.0f);
        this.addSmelting(SpawnerItems.fusionItem37, new ItemStack((Item)SpawnerItems.shulkerItem), 300.0f);
        this.addSmelting(SpawnerItems.fusionItem38, new ItemStack((Item)SpawnerItems.the4horsemenItem), 12000.0f);
        this.addSmelting(SpawnerItems.fusionItem39, new ItemStack((Item)SpawnerItems.strayItem), 150.0f);
        this.addSmelting(SpawnerItems.fusionItem40, new ItemStack((Item)SpawnerItems.huskItem), 150.0f);
        this.addSmelting(SpawnerItems.fusionItem41, new ItemStack((Item)SpawnerItems.polarBearItem), 75.0f);
        this.addSmelting(SpawnerItems.fusionItemSpecial, new ItemStack((Item)SpawnerItems.witherStormItem), 6000000.0f);
    }

    public void addSmeltingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addSmelting(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addSmelting(Item input, ItemStack stack, float experience) {
        this.addSmeltingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addSmeltingRecipe(ItemStack input, ItemStack stack, float experience) {
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        Map.Entry entry;
        Iterator iterator = this.smeltingList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.compareItemStacks(stack, (ItemStack)(entry = iterator.next()).getKey()));
        return (ItemStack)entry.getValue();
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map getSmeltingList() {
        return this.smeltingList;
    }

    public float getSmeltingExperience(ItemStack stack) {
        Map.Entry entry;
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        Iterator iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.compareItemStacks(stack, (ItemStack)(entry = iterator.next()).getKey()));
        return ((Float)entry.getValue()).floatValue();
    }
}

