/*
 * Decompiled with CFR 0.152.
 */
package lc.tiles;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayDeque;
import java.util.List;
import lc.LCRuntime;
import lc.api.jit.Tag;
import lc.api.rendering.IBlockSkinnable;
import lc.api.rendering.ITileRenderInfo;
import lc.api.stargate.ITransportRingAccess;
import lc.client.animation.Animation;
import lc.client.render.animations.TransportRingMoveAnimation;
import lc.client.render.gfx.beam.GFXBeam;
import lc.common.LCLog;
import lc.common.base.multiblock.LCMultiblockTile;
import lc.common.base.multiblock.MultiblockState;
import lc.common.base.multiblock.StructureConfiguration;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.network.packets.LCTileSync;
import lc.common.network.packets.LCTransportRingsStatePacket;
import lc.common.util.data.ImmutablePair;
import lc.common.util.data.StateMap;
import lc.common.util.game.BlockFilter;
import lc.common.util.game.BlockHelper;
import lc.common.util.math.DimensionPos;
import lc.common.util.math.Matrix3;
import lc.common.util.math.Orientations;
import lc.common.util.math.Trans3;
import lc.common.util.math.Vector3;
import lc.server.world.TeleportationHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.chunk.Chunk;

public class TileTransportRing
extends LCMultiblockTile
implements ITransportRingAccess,
ITileRenderInfo,
IBlockSkinnable {
    public static final StructureConfiguration structure = new StructureConfiguration(){
        private final BlockFilter[] filters;
        {
            this.filters = new BlockFilter[]{new BlockFilter(LCRuntime.runtime.blocks().frameBlock.getBlock(), 0), new BlockFilter(LCRuntime.runtime.blocks().transporterBlock.getBlock(), 0)};
        }

        @Override
        public Vector3 getStructureDimensions() {
            return new Vector3(5.0, 1.0, 5.0);
        }

        @Override
        public Vector3 getStructureCenter() {
            return new Vector3(2.0, 0.0, 2.0);
        }

        @Override
        public int[][][] getStructureLayout() {
            return new int[][][]{new int[][]{{0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}}, new int[][]{{0, 0, 1, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}}};
        }

        @Override
        public BlockFilter[] getBlockMappings() {
            return this.filters;
        }
    };
    private ArrayDeque<TransportRingCommand> commandQueue = new ArrayDeque();
    private TransportRingCommand command;
    private double commandTimer = 0.0;
    private Block clientSkinBlock = null;
    private int clientSkinBlockMetadata;
    private StateMap clientRenderState = new StateMap();
    private ArrayDeque<Animation> clientAnimationQueue = new ArrayDeque();
    private Animation clientAnimation = null;
    private double clientAnimationCounter = 0.0;

    @Override
    public void configure(ComponentConfig c) {
    }

    @Override
    public StructureConfiguration getConfiguration() {
        return structure;
    }

    @Override
    public void thinkMultiblock() {
        if (this.getState() == MultiblockState.NONE) {
            if (structure.test(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, null)) {
                this.changeState(MultiblockState.FORMED);
                structure.apply(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, null, this);
            }
        } else if (!structure.test(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, null)) {
            this.changeState(MultiblockState.NONE);
            structure.apply(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, null, null);
        }
    }

    @Override
    public IInventory getInventory() {
        return null;
    }

    @Override
    public void thinkClient() {
        this.thinkClientRender();
    }

    private void thinkClientRender() {
        if (this.clientAnimation != null) {
            this.clientAnimationCounter += 1.0;
            if (this.clientAnimation.finished(this.clientAnimationCounter)) {
                if (this.clientAnimationQueue.peek() != null) {
                    this.thinkClientChangeAnimation(this.clientAnimationQueue.pop());
                } else {
                    this.thinkClientChangeAnimation(null);
                }
            }
        } else if (this.clientAnimationQueue.peek() != null) {
            this.thinkClientChangeAnimation(this.clientAnimationQueue.pop());
        }
    }

    private void thinkClientCommand(TransportRingCommand command) {
        LCLog.debug("thinkClientCommand: %s", command != null ? command.toString() : "[none]");
        switch (command.type) {
            case DISENGAGE: {
                for (int i = 0; i < 6; ++i) {
                    this.clientAnimationQueue.add(new TransportRingMoveAnimation(10.0, i, 0.0, null, null));
                }
                break;
            }
            case ENGAGE: {
                for (int i = 5; i >= 0; --i) {
                    this.clientAnimationQueue.add(new TransportRingMoveAnimation(10.0, i, (double)i * 0.5, null, null));
                }
                break;
            }
            case TRANSPORT: {
                if (command.args.length != 1) break;
                Vector3 destination = (Vector3)command.args[0];
                GFXBeam beam = new GFXBeam(this.func_145831_w(), this, destination.add(0.5, 1.5, 0.5), true, 0.55f, 16, 4, 12.5f);
                LCRuntime.runtime.hints().particles().placeParticle(this.func_145831_w(), (Object)beam);
            }
        }
    }

    private void thinkClientChangeAnimation(Animation next) {
        LCLog.debug("thinkChangeAnimation: %s => %s", this.clientAnimation != null ? this.clientAnimation.toString() : "[none]", next != null ? next.toString() : "[none]");
        if (this.clientAnimation != null) {
            this.clientAnimation.sampleProperties(this.tileRenderState());
            if (this.clientAnimation.doAfter != null) {
                this.clientAnimation.doAfter.run(this);
            }
        }
        this.clientAnimation = next;
        if (this.clientAnimation != null && this.clientAnimation.requiresResampling()) {
            this.clientAnimation.resampleProperties(this.tileRenderState());
        }
        if (this.clientAnimation != null && this.clientAnimation.doBefore != null) {
            this.clientAnimation.doBefore.run(this);
        }
        this.clientAnimationCounter = 0.0;
    }

    @Override
    public void thinkServer() {
        this.thinkServerTasks();
    }

    private void thinkServerTasks() {
        if (this.command != null) {
            this.commandTimer += 1.0;
            if (this.commandTimer >= this.command.duration) {
                if (this.commandQueue.peek() != null) {
                    this.thinkServerChangeCommand(this.commandQueue.pop());
                } else {
                    this.thinkServerChangeCommand(null);
                }
            }
        } else if (this.commandQueue.peek() != null) {
            this.thinkServerChangeCommand(this.commandQueue.pop());
        }
    }

    private void thinkServerChangeCommand(TransportRingCommand next) {
        LCLog.debug("thinkChangeCommand: %s => %s", this.command != null ? this.command.toString() : "[none]", next != null ? next.toString() : "[none]");
        this.command = next;
        boolean doCommand = false;
        if (this.command != null) {
            switch (this.command.type) {
                case TRANSPORT: {
                    doCommand = true;
                    if (this.command.args.length != 1) break;
                    TileTransportRing ring = (TileTransportRing)this.command.args[0];
                    ring.commandQueue.add(new TransportRingCommand(TransportRingCommandType.TRANSPORT, this.command.duration, new Object[0]));
                    this.thinkServerTransport(ring);
                    this.command = new TransportRingCommand(this.command.type, this.command.duration, new Vector3(ring));
                    break;
                }
                case DISENGAGE: {
                    doCommand = true;
                    if (this.command.args.length != 1) break;
                    TileTransportRing ring = (TileTransportRing)this.command.args[0];
                    ring.commandQueue.add(new TransportRingCommand(TransportRingCommandType.DISENGAGE, this.command.duration, new Object[0]));
                    this.command = new TransportRingCommand(this.command.type, this.command.duration, new Object[0]);
                    break;
                }
                case ENGAGE: {
                    doCommand = true;
                    if (this.command.args.length != 1) break;
                    TileTransportRing ring = (TileTransportRing)this.command.args[0];
                    ring.commandQueue.add(new TransportRingCommand(TransportRingCommandType.ENGAGE, this.command.duration, new Object[0]));
                    this.command = new TransportRingCommand(this.command.type, this.command.duration, new Object[0]);
                }
            }
        }
        if (doCommand) {
            this.thinkServerDispatchState(this.command);
            this.commandTimer = 0.0;
        } else if (this.command != null) {
            LCLog.debug("Skipping command %s, invalid state.", this.command);
            this.commandTimer += this.command.duration;
        }
    }

    private void thinkServerDispatchState(TransportRingCommand command) {
        LCLog.debug("thinkServerDispatchState: %s", command != null ? command.toString() : "[none]");
        if (command != null) {
            LCTransportRingsStatePacket packet = new LCTransportRingsStatePacket(new DimensionPos(this), command.type.ordinal(), command.duration, command.args);
            this.sendPacketToClients(packet);
        }
    }

    private TileTransportRing thinkServerFindSlave() {
        Chunk chunk = this.func_145831_w().func_72938_d(this.field_145851_c, this.field_145849_e);
        for (Object o : chunk.field_150816_i.values()) {
            TileTransportRing tile;
            if (!(o instanceof TileTransportRing) || (tile = (TileTransportRing)o).getState() != MultiblockState.FORMED || tile == this || tile.busy()) continue;
            LCLog.debug("Found Transport ring at [%s, %s, %s]", tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            return tile;
        }
        return null;
    }

    private void thinkServerTransport(TileTransportRing ring) {
        this.thinkServerDoDispatch(ring);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Vector3 dim = structure.getStructureDimensions();
        Vector3 min = new Vector3(this).sub(dim);
        Vector3 max = new Vector3(this).add(dim).add(0.0, 2.5, 0.0);
        return Vector3.makeAABB(min, max);
    }

    public double func_145833_n() {
        return 9.99999999E8;
    }

    private void thinkServerDoDispatch(TileEntity destination) {
        Matrix3 rotation = Orientations.from(this.getRotation()).rotation();
        Vector3 origin = new Vector3(this);
        Vector3 dim = structure.getStructureDimensions().mul(0.5);
        Vector3 p0 = rotation.mul(Vector3.zero.sub(dim));
        Vector3 p1 = rotation.mul(Vector3.zero.add(dim).add(0.0, 2.5, 0.0));
        AxisAlignedBB box = Vector3.makeAABB(p0.add(origin), p1.add(origin));
        List ents = this.field_145850_b.func_72872_a(Entity.class, box);
        for (Entity entity : ents) {
            if (entity.field_70128_L || entity.field_70154_o != null) continue;
            this.thinkServerDispatchEntity(entity, new Vector3(entity), destination);
        }
    }

    private void thinkServerDispatchEntity(Entity entity, Vector3 prevPos, TileEntity d) {
        if (!entity.field_70128_L) {
            while (entity.field_70154_o != null) {
                entity = entity.field_70154_o;
            }
            Trans3 dt = new Trans3(d.field_145851_c, d.field_145848_d, (double)d.field_145849_e);
            Trans3 t = new Trans3(this.field_145851_c, this.field_145848_d, (double)this.field_145849_e);
            this.thinkServerDispatchEntity(entity, t, dt, d);
        }
    }

    private void thinkServerDispatchEntity(Entity entity, Trans3 src, Trans3 dst, TileEntity destination) {
        TeleportationHelper.sendEntityToWorld(entity, src, dst, destination.func_145831_w().field_73011_w.field_76574_g);
    }

    protected boolean busy() {
        return this.commandQueue.size() != 0 || this.command != null;
    }

    @Override
    public void thinkPacket(LCPacket packet, EntityPlayer player) throws LCNetworkException {
        super.thinkPacket(packet, player);
        if (packet instanceof LCTileSync && this.func_145831_w().field_72995_K) {
            ImmutablePair<Block, Integer> data;
            boolean flag = false;
            if (this.compound != null && this.compound.func_74764_b("skin-block") && (data = BlockHelper.loadBlock(this.compound.func_74779_i("skin-block"))).getA() != null) {
                this.clientSkinBlock = data.getA();
                this.clientSkinBlockMetadata = data.getB();
                flag = true;
            }
            if (!flag) {
                this.clientSkinBlock = null;
                this.clientSkinBlockMetadata = 0;
            }
        }
        if (packet instanceof LCTransportRingsStatePacket) {
            LCTransportRingsStatePacket state = (LCTransportRingsStatePacket)packet;
            TransportRingCommand cmd = new TransportRingCommand(TransportRingCommandType.values()[state.type], state.duration, state.args);
            this.thinkClientCommand(cmd);
        }
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    public void save(NBTTagCompound compound) {
    }

    @Override
    public void load(NBTTagCompound compound) {
    }

    @Override
    public String[] debug(Side side) {
        return new String[]{String.format("Multiblock: %s", new Object[]{this.getState()})};
    }

    @Override
    public Block getSkinBlock() {
        return this.clientSkinBlock;
    }

    @Override
    public int getSkinBlockMetadata() {
        return this.clientSkinBlockMetadata;
    }

    @Override
    public void setSkinBlock(Block block, int metadata) {
        if (block == null) {
            if (this.compound != null && this.compound.func_74764_b("skin-block")) {
                this.compound.func_82580_o("skin-block");
                this.markNbtDirty();
            }
        } else {
            if (this.compound == null) {
                this.compound = new NBTTagCompound();
            }
            this.compound.func_74778_a("skin-block", BlockHelper.saveBlock(block, metadata));
            this.markNbtDirty();
        }
    }

    @Override
    public ITileRenderInfo renderInfoTile() {
        return this;
    }

    @Override
    public StateMap tileRenderState() {
        return this.clientRenderState;
    }

    @Override
    public Object tileAnimation() {
        return this.clientAnimation;
    }

    @Override
    public double tileAnimationProgress() {
        return this.clientAnimationCounter;
    }

    @Override
    @Tag(name="ComputerCallable")
    public void activate() {
        if (this.getState() != MultiblockState.FORMED) {
            return;
        }
        if (this.busy()) {
            return;
        }
        TileTransportRing slave = this.thinkServerFindSlave();
        if (slave != null) {
            this.commandQueue.add(new TransportRingCommand(TransportRingCommandType.ENGAGE, 50.0, slave));
            this.commandQueue.add(new TransportRingCommand(TransportRingCommandType.TRANSPORT, 20.0, slave));
            this.commandQueue.add(new TransportRingCommand(TransportRingCommandType.DISENGAGE, 50.0, slave));
        }
    }

    private class TransportRingCommand {
        public final TransportRingCommandType type;
        public final double duration;
        public final Object[] args;

        public TransportRingCommand(TransportRingCommandType type, double duration, Object ... args) {
            this.type = type;
            this.duration = duration;
            this.args = args;
        }

        public String toString() {
            StringBuilder zz = new StringBuilder();
            zz.append("TransportRingCommand{").append((Object)this.type).append(":").append(this.duration);
            if (this.args != null) {
                zz.append(", [");
                for (int i = 0; i < this.args.length; ++i) {
                    zz.append(this.args[i] != null ? this.args[i].toString() : "<null>").append(",");
                }
                zz.append("]");
            }
            return zz.append("}").toString();
        }
    }

    private static enum TransportRingCommandType {
        ENGAGE,
        TRANSPORT,
        DISENGAGE;

    }
}

