/*
 * Decompiled with CFR 0.152.
 */
package lc.tiles;

import cpw.mods.fml.relauncher.Side;
import lc.api.components.IntegrationType;
import lc.api.jit.DeviceDrivers;
import lc.api.rendering.IBlockSkinnable;
import lc.api.rendering.ITileRenderInfo;
import lc.common.base.multiblock.LCMultiblockTile;
import lc.common.base.multiblock.StructureConfiguration;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.network.packets.LCTileSync;
import lc.common.util.data.ImmutablePair;
import lc.common.util.game.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

@DeviceDrivers.DriverCandidate(types={IntegrationType.POWER})
public class TileStargateRing
extends LCMultiblockTile
implements IBlockSkinnable {
    private Block clientSkinBlock;
    private int clientSkinBlockMetadata;

    public TileStargateRing() {
        this.setSlave(true);
    }

    @Override
    public void configure(ComponentConfig c) {
    }

    @Override
    public StructureConfiguration getConfiguration() {
        return null;
    }

    @Override
    public void thinkMultiblock() {
    }

    @Override
    public IInventory getInventory() {
        return null;
    }

    @Override
    public void thinkClient() {
    }

    @Override
    public void thinkServer() {
    }

    @Override
    public boolean shouldRender() {
        return false;
    }

    @Override
    public void thinkPacket(LCPacket packet, EntityPlayer player) throws LCNetworkException {
        super.thinkPacket(packet, player);
        if (packet instanceof LCTileSync && this.func_145831_w().field_72995_K) {
            ImmutablePair<Block, Integer> data;
            boolean flag = false;
            if (this.compound != null && this.compound.func_74764_b("skin-block") && (data = BlockHelper.loadBlock(this.compound.func_74779_i("skin-block"))).getA() != null) {
                this.clientSkinBlock = data.getA();
                this.clientSkinBlockMetadata = data.getB();
                flag = true;
            }
            if (!flag) {
                this.clientSkinBlock = null;
                this.clientSkinBlockMetadata = 0;
            }
        }
    }

    @Override
    public String[] debug(Side side) {
        return new String[]{String.format("Multiblock: %s", new Object[]{this.getState()}), String.format("Ghost block: %s", this.clientSkinBlock != null ? this.clientSkinBlock.func_149739_a() : "null"), String.format("Ghost metadata: %s", this.clientSkinBlockMetadata)};
    }

    @Override
    public ITileRenderInfo renderInfoTile() {
        return null;
    }

    @Override
    public Block getSkinBlock() {
        return this.clientSkinBlock;
    }

    @Override
    public int getSkinBlockMetadata() {
        return this.clientSkinBlockMetadata;
    }

    @Override
    public void setSkinBlock(Block block, int metadata) {
        if (block == null) {
            if (this.compound != null && this.compound.func_74764_b("skin-block")) {
                this.compound.func_82580_o("skin-block");
                this.markNbtDirty();
            }
        } else {
            if (this.compound == null) {
                this.compound = new NBTTagCompound();
            }
            this.compound.func_74778_a("skin-block", BlockHelper.saveBlock(block, metadata));
            this.markNbtDirty();
        }
    }
}

