/*
 * Decompiled with CFR 0.152.
 */
package lc.tiles;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import lc.LCRuntime;
import lc.api.audio.channel.ChannelDescriptor;
import lc.api.components.IntegrationType;
import lc.api.jit.DeviceDrivers;
import lc.api.jit.Tag;
import lc.api.rendering.IBlockSkinnable;
import lc.api.rendering.ITileRenderInfo;
import lc.api.stargate.IStargateAccess;
import lc.api.stargate.IrisState;
import lc.api.stargate.IrisType;
import lc.api.stargate.MessagePayload;
import lc.api.stargate.StargateAddress;
import lc.api.stargate.StargateState;
import lc.api.stargate.StargateType;
import lc.api.world.IOControlBaton;
import lc.client.animation.Animation;
import lc.client.openal.StreamingSoundProperties;
import lc.client.render.animations.ChevronMoveAnimation;
import lc.client.render.animations.ChevronReleaseAnimation;
import lc.client.render.animations.IrisMoveAnimation;
import lc.client.render.animations.RingSpinAnimation;
import lc.common.LCLog;
import lc.common.base.LCBlock;
import lc.common.base.LCTile;
import lc.common.base.inventory.FilteredInventory;
import lc.common.base.multiblock.LCMultiblockTile;
import lc.common.base.multiblock.MultiblockState;
import lc.common.base.multiblock.StructureConfiguration;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.network.packets.LCRenderSuggestPacket;
import lc.common.network.packets.LCStargateConnectionPacket;
import lc.common.network.packets.LCStargateStatePacket;
import lc.common.network.packets.LCTileSync;
import lc.common.resource.ResourceAccess;
import lc.common.stargate.MessageStringPayload;
import lc.common.stargate.StargateCharsetHelper;
import lc.common.util.data.ImmutablePair;
import lc.common.util.data.PrimitiveHelper;
import lc.common.util.data.StateMap;
import lc.common.util.game.BlockFilter;
import lc.common.util.game.BlockHelper;
import lc.common.util.game.SlotFilter;
import lc.common.util.math.DimensionPos;
import lc.common.util.math.MathUtils;
import lc.common.util.math.Matrix3;
import lc.common.util.math.Orientations;
import lc.common.util.math.Trans3;
import lc.common.util.math.Vector3;
import lc.items.ItemIrisUpgrade;
import lc.server.HintProviderServer;
import lc.server.stargate.StargateConnection;
import lc.server.stargate.StargateManager;
import lc.server.world.TeleportationHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

@DeviceDrivers.DriverCandidate(types={IntegrationType.POWER, IntegrationType.COMPUTERS})
public class TileStargateBase
extends LCMultiblockTile
implements IBlockSkinnable,
IStargateAccess,
ITileRenderInfo {
    public static final StructureConfiguration milkyStructure;
    public static final StructureConfiguration atlStructure;
    private static final OuchDamageSource irisDamSrc;
    private static final OuchDamageSource unstableWholeDamSrc;
    private static final OuchDamageSource transDamSrc;
    private static final double stargateSpinTime = 20.0;
    private static final double stargateChevronMoveTime = 5.0;
    private static final double stargateConnectTimeout = 200.0;
    private static final double stargateEstablishedTimeout = 2400.0;
    private static final double stargateIrisSpeed = 40.0;
    private ArrayDeque<StargateCommand> commandQueue = new ArrayDeque();
    private StargateCommand command;
    private double commandTimer = 0.0;
    private char currentGlyph;
    private Stack<Character> engagedGlyphs = new Stack();
    private StargateConnection currentConnection = null;
    private ArrayList<TrackedEntity> trackedEntities = new ArrayList();
    private IrisState irisState;
    private double irisTimer = 0.0;
    private IOControlBaton irisBaton = IOControlBaton.NONE;
    private Block clientSkinBlock = null;
    private int clientSkinBlockMetadata;
    private static final int[] clientChevronQueue;
    private ArrayDeque<Animation> clientAnimationQueue = new ArrayDeque();
    private Animation clientAnimation = null;
    private double clientAnimationCounter = 0.0;
    private StateMap clientRenderState = new StateMap();
    private double[][][] clientGfxGrid = null;
    private Random clientRandomProvider = new Random();
    private char clientCurrentGlyph;
    private Stack<Character> clientEngagedGlyphs = new Stack();
    private boolean clientSeenState = true;
    private boolean clientSeenStargateData = false;
    private StargateState clientStargateState;
    private int clientEngagedChevrons;
    private boolean clientDiallingIsSource;
    private FilteredInventory inventory;

    public TileStargateBase() {
        this.inventory = new FilteredInventory(1){

            public void func_70295_k_() {
            }

            public void func_70305_f() {
            }

            public void func_70296_d() {
            }

            public boolean func_145818_k_() {
                return true;
            }

            public String func_145825_b() {
                return "Stargate";
            }
        }.setFilterRule(0, new SlotFilter(new ItemStack[]{LCRuntime.runtime.items().lanteaStargateIris.getStackOf(1)}, null, true, false));
    }

    @Override
    public void configure(ComponentConfig c) {
    }

    @Override
    public StructureConfiguration getConfiguration() {
        if (this.getStargateType() == StargateType.STANDARD) {
            return milkyStructure;
        }
        return atlStructure;
    }

    @Override
    public void thinkMultiblock() {
        if (this.getState() == MultiblockState.NONE) {
            Orientations rotation = Orientations.from(this.getRotation());
            if (this.getConfiguration().test(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, rotation)) {
                this.changeState(MultiblockState.FORMED);
                this.getConfiguration().apply(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, rotation, this);
            }
        } else {
            Orientations rotation = Orientations.from(this.getRotation());
            if (!this.getConfiguration().test(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, rotation)) {
                this.changeState(MultiblockState.NONE);
                this.getConfiguration().apply(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, rotation, null);
            }
        }
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void thinkClient() {
        if (!this.clientSeenStargateData) {
            LCRuntime.runtime.network().getPreferredPipe().sendToServer(new LCStargateConnectionPacket(new DimensionPos(this), StargateState.IDLE, 0, false));
        }
        this.thinkClientRender(!this.clientSeenState);
        this.thinkClientSound(!this.clientSeenState);
        this.clientSeenState = true;
    }

    private void thinkClientSound(boolean updated) {
    }

    private void thinkClientCommand(StargateCommand command) {
        switch (command.type) {
            case CONNECT: {
                for (int i = 0; i < 9; ++i) {
                    this.tileRenderState().set("chevron-dist-" + i, 0.125);
                    this.tileRenderState().set("chevron-light-" + i, 0.5);
                }
                break;
            }
            case DISCONNECT: {
                this.clientAnimationQueue.push(new ChevronReleaseAnimation(9, true));
                this.clientAnimationQueue.push(new RingSpinAnimation((Double)20.0, 0.0, 0.0, true));
                this.clientEngagedGlyphs.clear();
                break;
            }
            case DISENGAGE: {
                if (this.clientEngagedGlyphs.size() <= 0) break;
                this.clientAnimationQueue.push(new ChevronMoveAnimation(5.0, clientChevronQueue[this.clientEngagedGlyphs.size() - 1], 0.0, 0.0, true));
                this.clientEngagedGlyphs.remove(this.clientEngagedGlyphs.size() - 1);
                break;
            }
            case ENGAGE: {
                this.clientEngagedGlyphs.add(Character.valueOf(this.clientCurrentGlyph));
                this.clientAnimationQueue.push(new ChevronMoveAnimation(5.0, clientChevronQueue[this.clientEngagedGlyphs.size() - 1], 0.125, 0.5, true));
                break;
            }
            case SPIN: {
                this.clientCurrentGlyph = ((Character)command.args[0]).charValue();
                int symbolIndex = StargateCharsetHelper.singleton().index(this.clientCurrentGlyph);
                double symbolRotation = (double)symbolIndex * 9.473684210526315;
                double aangle = MathUtils.normaliseAngle(symbolRotation);
                this.clientAnimationQueue.push(new RingSpinAnimation((Double)20.0, 0.0, aangle, true));
                for (int i = 0; i < this.clientEngagedGlyphs.size() - 1; ++i) {
                    this.tileRenderState().set("chevron-dist-" + clientChevronQueue[i], 0.125);
                    this.tileRenderState().set("chevron-light-" + clientChevronQueue[i], 0.5);
                }
                break;
            }
            case CLOSEIRIS: {
                this.clientAnimationQueue.push(new IrisMoveAnimation(40.0, 1.0));
                break;
            }
            case OPENIRIS: {
                this.clientAnimationQueue.push(new IrisMoveAnimation(40.0, 0.0));
                break;
            }
        }
    }

    private void thinkClientRender(boolean updated) {
        if (this.clientAnimation != null) {
            this.clientAnimationCounter += 1.0;
            if (this.clientAnimation.finished(this.clientAnimationCounter)) {
                if (this.clientAnimationQueue.peek() != null) {
                    this.thinkClientChangeAnimation(this.clientAnimationQueue.pop());
                } else {
                    this.thinkClientChangeAnimation(null);
                }
            }
        } else if (this.clientAnimationQueue.peek() != null) {
            this.thinkClientChangeAnimation(this.clientAnimationQueue.pop());
        }
        if (updated) {
            switch (this.clientStargateState) {
                case CONNECTED: {
                    this.tileRenderState().set("event-horizon", true);
                    break;
                }
                case DIALLING: {
                    if (this.clientDiallingIsSource || this.clientEngagedChevrons != 8) break;
                    for (int i = 0; i < 9; ++i) {
                        this.clientAnimationQueue.push(new ChevronMoveAnimation(5.0, i, 0.125, 0.5, true));
                    }
                    break;
                }
                case DISCONNECTING: {
                    this.tileRenderState().set("event-horizon", false);
                    break;
                }
                case FAILED: {
                    break;
                }
                case IDLE: {
                    this.tileRenderState().set("event-horizon", false);
                    break;
                }
            }
        }
        if (this.inventory.func_70301_a(0) != null && this.inventory.func_70301_a((int)0).field_77994_a > 0) {
            this.renderInfoTile().tileRenderState().set("iris", true);
            ItemIrisUpgrade upgrade = (ItemIrisUpgrade)this.inventory.func_70301_a(0).func_77973_b();
            IrisType type = upgrade.getType(this.inventory.func_70301_a(0));
            this.renderInfoTile().tileRenderState().set("iris-type", type.getName());
        } else {
            this.renderInfoTile().tileRenderState().set("iris", false);
        }
        if (this.clientStargateState == StargateState.CONNECTED) {
            int j;
            int j2;
            int i;
            double[][][] grid = this.getGfxGrid();
            int m = 10;
            int n = 38;
            double[][] u = grid[0];
            double[][] v = grid[1];
            double dt = 1.0;
            double asq = 0.03;
            double d = 0.95;
            int r = this.clientRandomProvider.nextInt(9) + 1;
            int t = this.clientRandomProvider.nextInt(38) + 1;
            double[] dArray = v[t];
            int n2 = r;
            dArray[n2] = dArray[n2] + 0.05 * this.clientRandomProvider.nextGaussian();
            for (i = 1; i < 10; ++i) {
                for (j2 = 1; j2 <= 38; ++j2) {
                    double du_dr = 0.5 * (u[j2][i + 1] - u[j2][i - 1]);
                    double d2u_drsq = u[j2][i + 1] - 2.0 * u[j2][i] + u[j2][i - 1];
                    double d2u_dthsq = u[j2 + 1][i] - 2.0 * u[j2][i] + u[j2 - 1][i];
                    v[j2][i] = d * v[j2][i] + asq * dt * (d2u_drsq + du_dr / (double)i + d2u_dthsq / (double)(i * i));
                }
            }
            for (i = 1; i < 10; ++i) {
                for (j2 = 1; j2 <= 38; ++j2) {
                    double[] dArray2 = u[j2];
                    int n3 = i;
                    dArray2[n3] = dArray2[n3] + v[j2][i] * dt;
                }
            }
            double u0 = 0.0;
            double v0 = 0.0;
            for (j = 1; j <= 38; ++j) {
                u0 += u[j][1];
                v0 += v[j][1];
            }
            u0 /= 38.0;
            v0 /= 38.0;
            for (j = 1; j <= 38; ++j) {
                u[j][0] = u0;
                v[j][0] = v0;
            }
        }
    }

    private void thinkClientChangeAnimation(Animation next) {
        LCLog.debug("thinkChangeAnimation: %s => %s", this.clientAnimation != null ? this.clientAnimation.toString() : "[none]", next != null ? next.toString() : "[none]");
        if (this.clientAnimation != null) {
            this.clientAnimation.sampleProperties(this.tileRenderState());
            if (this.clientAnimation.doAfter != null) {
                this.clientAnimation.doAfter.run(this);
            }
        }
        this.clientAnimation = next;
        if (this.clientAnimation != null && this.clientAnimation.requiresResampling()) {
            this.clientAnimation.resampleProperties(this.tileRenderState());
        }
        if (this.clientAnimation != null && this.clientAnimation.doBefore != null) {
            this.clientAnimation.doBefore.run(this);
        }
        this.clientAnimationCounter = 0.0;
    }

    @Override
    public void thinkServer() {
        if (this.currentConnection != null) {
            this.thinkServerWormhole();
        }
        this.thinkServerTasks();
        this.thinkServerIris();
    }

    private void thinkServerWormhole() {
        if (this.currentConnection.tileFrom == this && this.currentConnection.state == StargateState.CONNECTED) {
            for (TrackedEntity trk : this.trackedEntities) {
                this.thinkServerEntityInWormhole(trk.entity, trk.lastPos);
            }
            this.trackedEntities.clear();
            Matrix3 rotation = Orientations.from(this.getRotation()).rotation();
            Vector3 origin = new Vector3(this);
            Vector3 p0 = rotation.mul(new Vector3(-2.5, 0.5, 0.0));
            Vector3 p1 = rotation.mul(new Vector3(2.5, 5.5, 1.0));
            AxisAlignedBB box = Vector3.makeAABB(p0.add(origin), p1.add(origin));
            List ents = this.field_145850_b.func_72872_a(Entity.class, box);
            for (Entity entity : ents) {
                if (entity.field_70128_L || entity.field_70154_o != null) continue;
                this.trackedEntities.add(new TrackedEntity(entity));
            }
        }
    }

    private void thinkServerEntityInWormhole(Entity entity, Vector3 prevPos) {
        if (!entity.field_70128_L) {
            TileStargateBase dte;
            Matrix3 rotation = Orientations.from(this.getRotation()).rotation();
            Vector3 or = new Vector3(this);
            Vector3 p1 = rotation.mul(new Vector3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).sub(or));
            Vector3 p0 = rotation.mul(new Vector3(2.0 * prevPos.x - entity.field_70165_t, 2.0 * prevPos.y - entity.field_70163_u, 2.0 * prevPos.z - entity.field_70161_v).sub(or));
            double z0 = 0.0;
            if (p0.z >= z0 && p1.z < z0 && (dte = this.currentConnection.tileTo) != null) {
                Trans3 dt = new Trans3(dte.field_145851_c, dte.field_145848_d, (double)dte.field_145849_e).rotate(Orientations.from(dte.getRotation().getOpposite()).rotation());
                while (entity.field_70154_o != null) {
                    entity = entity.field_70154_o;
                }
                Trans3 t = new Trans3(this.field_145851_c, this.field_145848_d, (double)this.field_145849_e).rotate(Orientations.from(this.getRotation()).rotation());
                this.thinkServerDispatchEntity(entity, t, dt, dte);
            }
        }
    }

    private void thinkServerDispatchEntity(Entity entity, Trans3 src, Trans3 dst, TileStargateBase destination) {
        boolean flag = destination.thinkServerAcceptEntity(entity, src, dst, this);
        if (flag) {
            TeleportationHelper.sendEntityToWorld(entity, src, dst, destination.func_145831_w().field_73011_w.field_76574_g);
        }
    }

    private boolean thinkServerAcceptEntity(Entity entity, Trans3 src, Trans3 dst, TileStargateBase source) {
        if (this.getIrisType() != null) {
            if (this.getIrisState() == IrisState.CLOSED) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (player.field_71075_bZ.field_75098_d || player.field_71075_bZ.field_75102_a || player.func_85032_ar()) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lc.interface.stargate.obstructed")));
                    } else {
                        if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                            player.field_71071_by.func_146027_a(null, -1);
                        }
                        player.func_70097_a((DamageSource)irisDamSrc, 999999.0f);
                    }
                } else {
                    entity.func_70106_y();
                }
                return false;
            }
            return true;
        }
        return true;
    }

    private void thinkServerTasks() {
        if (this.command != null) {
            this.commandTimer += 1.0;
            if (this.commandTimer >= this.command.duration) {
                if (this.commandQueue.peek() != null) {
                    this.thinkServerChangeCommand(this.commandQueue.pop());
                } else {
                    this.thinkServerChangeCommand(null);
                }
            }
        } else if (this.commandQueue.peek() != null) {
            this.thinkServerChangeCommand(this.commandQueue.pop());
        }
    }

    private void thinkServerChangeCommand(StargateCommand next) {
        LCLog.debug("thinkChangeCommand: %s => %s", this.command != null ? this.command.toString() : "[none]", next != null ? next.toString() : "[none]");
        this.command = next;
        boolean doCommand = false;
        if (this.command != null && this.getState() == MultiblockState.FORMED) {
            switch (this.command.type) {
                case CONNECT: {
                    if (this.currentConnection != null || this.engagedGlyphs.size() != 9) break;
                    HintProviderServer server = (HintProviderServer)LCRuntime.runtime.hints();
                    Character[] addr = this.engagedGlyphs.toArray(new Character[0]);
                    StargateAddress address = new StargateAddress(PrimitiveHelper.unbox(addr));
                    this.currentConnection = server.stargates().openConnection(this, address, 200, 2400);
                    if (this.currentConnection != null) {
                        LCTile.doCallbacksNow(this, "computerEvent", "connect", null);
                    } else {
                        this.engagedGlyphs.clear();
                        LCTile.doCallbacksNow(this, "computerEvent", "disconnect", null);
                        this.command = new StargateCommand(StargateCommandType.DISCONNECT, 20.0, new Object[0]);
                    }
                    doCommand = true;
                    break;
                }
                case DISCONNECT: {
                    boolean state;
                    if (this.currentConnection == null || this.currentConnection.state != StargateState.CONNECTED || !(state = this.currentConnection.closeConnection(this))) break;
                    this.engagedGlyphs.clear();
                    LCTile.doCallbacksNow(this, "computerEvent", "disconnect", null);
                    doCommand = true;
                    break;
                }
                case DISENGAGE: {
                    if (this.currentConnection != null || this.engagedGlyphs.size() <= 0) break;
                    this.engagedGlyphs.remove(this.engagedGlyphs.size() - 1);
                    LCTile.doCallbacksNow(this, "computerEvent", "disengageGlyph", null);
                    doCommand = true;
                    break;
                }
                case ENGAGE: {
                    if (this.currentConnection != null || this.engagedGlyphs.size() >= 9) break;
                    this.engagedGlyphs.add(Character.valueOf(this.currentGlyph));
                    LCTile.doCallbacksNow(this, "computerEvent", "engageGlyph", new Object[]{Character.valueOf(this.currentGlyph)});
                    doCommand = true;
                    break;
                }
                case SPIN: {
                    if (this.currentConnection != null || this.engagedGlyphs.size() >= 9) break;
                    this.currentGlyph = ((Character)this.command.args[0]).charValue();
                    LCTile.doCallbacksNow(this, "computerEvent", "spinToGlyph", new Object[]{Character.valueOf(this.currentGlyph)});
                    doCommand = true;
                    break;
                }
                case CLOSEIRIS: {
                    if (this.getIrisType() == null || this.getIrisState() != IrisState.OPEN) break;
                    this.irisTimer = 40.0;
                    this.irisState = IrisState.CLOSING;
                    LCTile.doCallbacksNow(this, "computerEvent", "irisClosing", null);
                    doCommand = true;
                    break;
                }
                case OPENIRIS: {
                    if (this.getIrisState() != IrisState.CLOSED) break;
                    this.irisTimer = 40.0;
                    this.irisState = IrisState.OPENING;
                    LCTile.doCallbacksNow(this, "computerEvent", "irisOpening", null);
                    doCommand = true;
                }
            }
        }
        if (doCommand) {
            this.thinkServerDispatchState(this.command);
            this.commandTimer = 0.0;
        } else if (this.command != null) {
            LCLog.debug("Skipping command %s, invalid state.", this.command);
            this.commandTimer += this.command.duration;
        }
    }

    private void thinkServerDispatchState(StargateCommand command) {
        LCLog.debug("thinkServerDispatchState: %s", command != null ? command.toString() : "[none]");
        if (command != null) {
            LCStargateStatePacket packet = new LCStargateStatePacket(new DimensionPos(this), command.type.ordinal(), command.duration, command.args);
            this.sendPacketToClients(packet);
        }
    }

    private void thinkServerIris() {
        if (this.inventory.func_70301_a(0) != null && this.inventory.func_70301_a((int)0).field_77994_a > 0) {
            if (this.irisState == null || this.irisState == IrisState.NONE) {
                this.irisState = IrisState.OPEN;
            }
            ItemStack stack = this.inventory.func_70301_a(0);
            ItemIrisUpgrade upgrade = (ItemIrisUpgrade)stack.func_77973_b();
            IrisState is = this.getIrisState();
            if (is == IrisState.OPENING || is == IrisState.CLOSING) {
                this.irisTimer -= 1.0;
                if (this.irisTimer <= 0.0) {
                    if (is == IrisState.OPENING) {
                        this.irisState = IrisState.OPEN;
                        LCTile.doCallbacksNow(this, "computerEvent", "irisOpened", null);
                    }
                    if (is == IrisState.CLOSING) {
                        this.irisState = IrisState.CLOSED;
                        LCTile.doCallbacksNow(this, "computerEvent", "irisClosed", null);
                    }
                }
            }
            if (upgrade.getIrisDamage(stack) > upgrade.getMaximumDamage(upgrade.getType(stack))) {
                this.inventory.func_70299_a(0, null);
                this.inventory.func_70296_d();
                LCTile.doCallbacksNow(this, "computerEvent", "irisDestroyed", null);
                this.irisState = IrisState.OPEN;
                this.suggestRenderStateVisible();
            } else {
                LCBlock block = (LCBlock)this.func_145838_q();
                boolean power = block.isGettingAnyInput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (power && this.getIrisType() != null & is == IrisState.OPEN) {
                    this.irisBaton = IOControlBaton.REDSTONE;
                    this.closeIris();
                }
                if (!power && this.irisBaton == IOControlBaton.REDSTONE && this.getIrisType() != null & is == IrisState.CLOSED) {
                    this.openIris();
                }
            }
        } else {
            this.irisState = IrisState.NONE;
        }
    }

    public Vector3[] getChevronBlocks() {
        Orientations rotation = Orientations.from(this.getRotation());
        return this.getConfiguration().mapType(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, rotation);
    }

    public double[][][] getGfxGrid() {
        if (this.clientGfxGrid == null) {
            int m = 10;
            int n = 38;
            this.clientGfxGrid = new double[2][n + 2][m + 1];
            for (int i = 0; i < 2; ++i) {
                this.clientGfxGrid[i][0] = this.clientGfxGrid[i][n];
                this.clientGfxGrid[i][n + 1] = this.clientGfxGrid[i][1];
            }
        }
        return this.clientGfxGrid;
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Vector3 dim = this.getConfiguration().getStructureDimensions();
        Vector3 min = new Vector3(this).sub(dim);
        Vector3 max = new Vector3(this).add(dim);
        return Vector3.makeAABB(min, max);
    }

    public double func_145833_n() {
        return 90000.0;
    }

    @Override
    public void sendPackets(List<LCPacket> packets) throws LCNetworkException {
        this.getStargateAddress();
        super.sendPackets(packets);
    }

    @Override
    public void thinkPacket(LCPacket packet, EntityPlayer player) throws LCNetworkException {
        super.thinkPacket(packet, player);
        if (packet instanceof LCTileSync && this.func_145831_w().field_72995_K) {
            ImmutablePair<Block, Integer> data;
            boolean flag = false;
            if (this.compound != null && this.compound.func_74764_b("skin-block") && (data = BlockHelper.loadBlock(this.compound.func_74779_i("skin-block"))).getA() != null) {
                this.clientSkinBlock = data.getA();
                this.clientSkinBlockMetadata = data.getB();
                flag = true;
            }
            if (!flag) {
                this.clientSkinBlock = null;
                this.clientSkinBlockMetadata = 0;
            }
        }
        if (packet instanceof LCStargateConnectionPacket) {
            if (this.func_145831_w().field_72995_K) {
                LCStargateConnectionPacket state = (LCStargateConnectionPacket)packet;
                this.clientSeenStargateData = true;
                this.clientStargateState = state.state;
                this.clientDiallingIsSource = state.isSource;
                this.clientSeenState = false;
            } else {
                this.notifyConnectionState(this.currentConnection);
                this.suggestRenderState(player);
            }
        }
        if (packet instanceof LCRenderSuggestPacket) {
            if (this.func_145831_w().field_72995_K) {
                this.handleRenderState((LCRenderSuggestPacket)packet);
            } else {
                LCLog.warn("Unexpected LCRenderSuggestPacket from client %s.", player);
            }
        }
        if (packet instanceof LCStargateStatePacket) {
            if (this.func_145831_w().field_72995_K) {
                LCStargateStatePacket state = (LCStargateStatePacket)packet;
                StargateCommand cmd = new StargateCommand(StargateCommandType.values()[state.type], state.duration, state.args);
                this.thinkClientCommand(cmd);
            } else {
                LCStargateStatePacket state = (LCStargateStatePacket)packet;
                this.commandQueue.add(new StargateCommand(StargateCommandType.values()[state.type], state.duration, state.args));
            }
        }
    }

    private void handleRenderState(LCRenderSuggestPacket packet) {
        StateMap suggest = packet.toStateMap();
        this.tileRenderState().set("iris", suggest.get("iris"));
        this.tileRenderState().set("event-horizon", suggest.get("event-horizon"));
        for (int i = 0; i < 9; ++i) {
            boolean flag = (Boolean)suggest.get("chevron-state-" + i);
            if (flag) {
                this.tileRenderState().set("chevron-dist-" + i, 0.125);
                this.tileRenderState().set("chevron-light-" + i, 0.5);
                continue;
            }
            this.tileRenderState().set("chevron-dist-" + i, 0.0);
            this.tileRenderState().set("chevron-light-" + i, 0.0);
        }
    }

    private void suggestRenderStateVisible() {
        for (Object o : this.func_145831_w().field_73010_i) {
            EntityPlayer player;
            double dt;
            if (!(o instanceof EntityPlayer) || !((dt = Math.pow((player = (EntityPlayer)o).func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e), 2.0)) < this.func_145833_n())) continue;
            this.suggestRenderState(player);
        }
    }

    private void suggestRenderState(EntityPlayer player) {
        HashMap<String, Object> interest = new HashMap<String, Object>();
        IrisState is = this.getIrisState();
        interest.put("iris", is == IrisState.CLOSING || is == IrisState.CLOSED);
        interest.put("event-horizon", this.hasConnectionState());
        for (int i = 0; i < 9; ++i) {
            interest.put("chevron-state-" + i, this.getActivatedChevrons() > i);
        }
        LCRenderSuggestPacket packet = new LCRenderSuggestPacket(new DimensionPos(this), interest);
        this.sendPacketToClient(packet, (EntityPlayerMP)player);
    }

    private void handleCommandDispatch(StargateCommand command) {
        if (this.func_145831_w().field_72995_K) {
            LCStargateStatePacket packet = new LCStargateStatePacket(new DimensionPos(this), command.type.ordinal(), command.duration, command.args);
            LCLog.debug(new Object[]{"sendCommandToServer: %s %s %s", command.type, command.duration, command.args});
            LCRuntime.runtime.network().getPreferredPipe().sendToServer(packet);
        } else {
            this.commandQueue.add(command);
        }
    }

    @Override
    public String[] debug(Side side) {
        return new String[]{String.format("Rotation: %s", this.getRotation()), String.format("Multiblock: %s", new Object[]{this.getState()})};
    }

    @Override
    public Block getSkinBlock() {
        return this.clientSkinBlock;
    }

    @Override
    public int getSkinBlockMetadata() {
        return this.clientSkinBlockMetadata;
    }

    @Override
    public void setSkinBlock(Block block, int metadata) {
        if (block == null) {
            if (this.compound != null && this.compound.func_74764_b("skin-block")) {
                this.compound.func_82580_o("skin-block");
                this.markNbtDirty();
            }
        } else {
            if (this.compound == null) {
                this.compound = new NBTTagCompound();
            }
            this.compound.func_74778_a("skin-block", BlockHelper.saveBlock(block, metadata));
            this.markNbtDirty();
        }
    }

    public boolean hasConnectionState() {
        if (!this.func_145831_w().field_72995_K) {
            return this.currentConnection != null;
        }
        return this.clientStargateState != null && this.clientStargateState != StargateState.IDLE;
    }

    public StargateConnection getConnectionState() {
        return this.currentConnection;
    }

    public void notifyConnectionState(StargateConnection connection) {
        LCStargateConnectionPacket state;
        if (connection == null || connection.dead || connection.state == null || connection.state == StargateState.IDLE) {
            if (this.currentConnection != null) {
                LCTile.doCallbacksNow(this, "computerEvent", "disconnect");
            }
            this.currentConnection = null;
            state = new LCStargateConnectionPacket(new DimensionPos(this), StargateState.IDLE, 0, false);
        } else {
            this.currentConnection = connection;
            state = new LCStargateConnectionPacket(new DimensionPos(this), this.currentConnection.state, this.currentConnection.stateTimeout, this.currentConnection.tileFrom == this);
        }
        this.sendPacketToClients(state);
    }

    @Override
    public ITileRenderInfo renderInfoTile() {
        return this;
    }

    @Override
    public StateMap tileRenderState() {
        return this.clientRenderState;
    }

    @Override
    public Object tileAnimation() {
        return this.clientAnimation;
    }

    @Override
    public double tileAnimationProgress() {
        return this.clientAnimationCounter;
    }

    @Override
    @Tag(name="ComputerCallable")
    public StargateType getStargateType() {
        return StargateType.fromOrdinal(this.func_145832_p());
    }

    @Override
    @Tag(name="ComputerCallable")
    public boolean isValid() {
        return this.getState() == MultiblockState.FORMED;
    }

    @Override
    public StargateAddress getStargateAddress() {
        if (this.field_145850_b.field_72995_K) {
            if (!this.compound.func_74764_b("stargate-address")) {
                this.markClientDataDirty();
                return StargateAddress.VOID_ADDRESS;
            }
            return new StargateAddress(this.compound, "stargate-address");
        }
        if (!this.compound.func_74764_b("stargate-address")) {
            HintProviderServer server = (HintProviderServer)LCRuntime.runtime.hints();
            StargateManager stargates = server.stargates();
            stargates.getStargateAddress(this).toNBT(this.compound, "stargate-address");
            this.markNbtDirty();
        }
        return new StargateAddress(this.compound, "stargate-address");
    }

    @Override
    @Tag(name="ComputerCallable")
    public String getStargateAddressString() {
        StargateAddress theAddress = this.getStargateAddress();
        return theAddress != null ? theAddress.getAddressString() : null;
    }

    @Override
    @Tag(name="ComputerCallable")
    public IrisType getIrisType() {
        ItemStack stack = this.getInventory().func_70301_a(0);
        if (stack == null || !(stack.func_77973_b() instanceof ItemIrisUpgrade)) {
            return null;
        }
        ItemIrisUpgrade item = (ItemIrisUpgrade)stack.func_77973_b();
        return item.getType(stack);
    }

    @Override
    @Tag(name="ComputerCallable")
    public IrisState getIrisState() {
        if (this.getIrisType() == null) {
            return IrisState.NONE;
        }
        return this.irisState;
    }

    @Override
    public void transmit(MessagePayload payload) {
        if (this.currentConnection != null) {
            this.currentConnection.transmit(this, payload);
        }
    }

    @Override
    public void receive(MessagePayload payload) {
        TileStargateBase.doCallbacksNow(this, "stargateMessage", this, payload);
    }

    @Tag(name="ComputerCallable")
    public void sendMessage(String data) {
        this.transmit(new MessageStringPayload(data));
    }

    @Override
    @Tag(name="ComputerCallable")
    public void selectGlyph(char glyph) {
        try {
            StargateCharsetHelper.singleton().index(glyph);
            StargateCommand cmd = new StargateCommand(StargateCommandType.SPIN, 20.0, Character.valueOf(glyph));
            this.handleCommandDispatch(cmd);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    @Tag(name="ComputerCallable")
    public void activateChevron() {
        this.handleCommandDispatch(new StargateCommand(StargateCommandType.ENGAGE, 5.0, new Object[0]));
    }

    @Override
    @Tag(name="ComputerCallable")
    public void deactivateChevron() {
        this.handleCommandDispatch(new StargateCommand(StargateCommandType.DISENGAGE, 5.0, new Object[0]));
    }

    @Override
    @Tag(name="ComputerCallable")
    public int getActivatedChevrons() {
        if (this.func_145831_w().field_72995_K) {
            return this.clientEngagedGlyphs.size();
        }
        return this.engagedGlyphs.size();
    }

    @Override
    @Tag(name="ComputerCallable")
    public String getActivatedGlyphs() {
        Character[] data = this.func_145831_w().field_72995_K ? this.clientEngagedGlyphs.toArray(new Character[0]) : this.engagedGlyphs.toArray(new Character[0]);
        return new String(PrimitiveHelper.unbox(data));
    }

    @Override
    @Tag(name="ComputerCallable")
    public void engageStargate() {
        this.handleCommandDispatch(new StargateCommand(StargateCommandType.CONNECT, 200.0, new Object[0]));
    }

    @Override
    @Tag(name="ComputerCallable")
    public void disengageStargate() {
        this.handleCommandDispatch(new StargateCommand(StargateCommandType.DISCONNECT, 20.0, new Object[0]));
    }

    @Override
    @Tag(name="ComputerCallable")
    public void openIris() {
        this.handleCommandDispatch(new StargateCommand(StargateCommandType.OPENIRIS, 40.0, new Object[0]));
    }

    @Override
    @Tag(name="ComputerCallable")
    public void closeIris() {
        this.handleCommandDispatch(new StargateCommand(StargateCommandType.CLOSEIRIS, 40.0, new Object[0]));
    }

    @Override
    @Tag(name="ComputerCallable")
    public double getIrisHealth() {
        return 0.0;
    }

    static {
        TileStargateBase.registerChannel(TileStargateBase.class, new ChannelDescriptor("spin", "stargate/milkyway/milkyway_roll.ogg", new StreamingSoundProperties()));
        TileStargateBase.registerChannel(TileStargateBase.class, new ChannelDescriptor("lock", "stargate/milkyway/milkyway_chevron_lock.ogg", new StreamingSoundProperties()));
        milkyStructure = new SGStructureConfig(new BlockFilter[]{new BlockFilter(Blocks.field_150350_a), new BlockFilter(LCRuntime.runtime.blocks().stargateRingBlock.getBlock(), 0), new BlockFilter(LCRuntime.runtime.blocks().stargateRingBlock.getBlock(), 1), new BlockFilter(LCRuntime.runtime.blocks().stargateBaseBlock.getBlock())});
        atlStructure = new SGStructureConfig(new BlockFilter[]{new BlockFilter(Blocks.field_150350_a), new BlockFilter(LCRuntime.runtime.blocks().stargateRingBlock.getBlock(), 2), new BlockFilter(LCRuntime.runtime.blocks().stargateRingBlock.getBlock(), 3), new BlockFilter(LCRuntime.runtime.blocks().stargateBaseBlock.getBlock(), 1)});
        irisDamSrc = new OuchDamageSource("iris");
        unstableWholeDamSrc = new OuchDamageSource("unstable_wormhole");
        transDamSrc = new OuchDamageSource("unstable_transient");
        clientChevronQueue = new int[]{8, 7, 6, 3, 2, 1, 5, 4, 0};
    }

    private static class OuchDamageSource
    extends DamageSource {
        public OuchDamageSource(String typeof) {
            super(ResourceAccess.getAssetKey() + ":" + typeof);
            this.func_76348_h();
            this.func_151518_m();
        }
    }

    private class StargateCommand {
        public final StargateCommandType type;
        public final double duration;
        public final Object[] args;

        public StargateCommand(StargateCommandType type, double duration, Object ... args) {
            this.type = type;
            this.duration = duration;
            this.args = args;
        }

        public String toString() {
            StringBuilder zz = new StringBuilder();
            zz.append("StargateCommand{").append((Object)this.type).append(":").append(this.duration);
            if (this.args != null) {
                zz.append(", [");
                for (int i = 0; i < this.args.length; ++i) {
                    zz.append(this.args[i] != null ? this.args[i].toString() : "<null>").append(",");
                }
                zz.append("]");
            }
            return zz.append("}").toString();
        }
    }

    private static enum StargateCommandType {
        SPIN,
        ENGAGE,
        DISENGAGE,
        CONNECT,
        DISCONNECT,
        OPENIRIS,
        CLOSEIRIS;

    }

    private class TrackedEntity {
        public Entity entity;
        public Vector3 lastPos;

        public TrackedEntity(Entity entity) {
            this.entity = entity;
            this.lastPos = new Vector3(entity);
        }
    }

    private static class SGStructureConfig
    extends StructureConfiguration {
        private BlockFilter[] filters;

        public SGStructureConfig(BlockFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public Vector3 getStructureDimensions() {
            return new Vector3(7.0, 7.0, 1.0);
        }

        @Override
        public Vector3 getStructureCenter() {
            return new Vector3(3.0, 0.0, 0.0);
        }

        @Override
        public int[][][] getStructureLayout() {
            return new int[][][]{new int[][]{{1}, {2}, {1}, {1}, {2}, {1}, {1}}, new int[][]{{2}, {0}, {0}, {0}, {0}, {0}, {2}}, new int[][]{{1}, {0}, {0}, {0}, {0}, {0}, {1}}, new int[][]{{3}, {0}, {0}, {0}, {0}, {0}, {2}}, new int[][]{{1}, {0}, {0}, {0}, {0}, {0}, {1}}, new int[][]{{2}, {0}, {0}, {0}, {0}, {0}, {2}}, new int[][]{{1}, {2}, {1}, {1}, {2}, {1}, {1}}};
        }

        @Override
        public BlockFilter[] getBlockMappings() {
            return this.filters;
        }
    }
}

