/*
 * Decompiled with CFR 0.152.
 */
package lc.tiles;

import cpw.mods.fml.relauncher.Side;
import lc.api.rendering.ITileRenderInfo;
import lc.common.LCLog;
import lc.common.base.LCTile;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.util.data.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLanteaDoor
extends LCTile
implements ITileRenderInfo {
    public boolean clientLastState;
    public int clientAnimation;

    @Override
    public void configure(ComponentConfig c) {
    }

    @Override
    public IInventory getInventory() {
        return null;
    }

    @Override
    public void thinkClient() {
        if (this.clientAnimation != 0) {
            --this.clientAnimation;
        }
    }

    @Override
    public void thinkServer() {
    }

    @Override
    public void thinkPacket(LCPacket packet, EntityPlayer player) throws LCNetworkException {
        if (this.field_145850_b.field_72995_K && this.clientLastState != this.getDoorState()) {
            this.clientLastState = this.getDoorState();
            this.clientAnimation += 20;
        }
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    public void save(NBTTagCompound compound) {
    }

    @Override
    public void load(NBTTagCompound compound) {
        this.recalculateState();
    }

    @Override
    public String[] debug(Side side) {
        return new String[]{String.format("hasBlockBelow: %s", this.compound == null || !this.compound.func_74764_b("hasBlockBelow") ? "??" : Boolean.valueOf(this.compound.func_74767_n("hasBlockBelow"))), String.format("isOpen: %s", this.compound == null || !this.compound.func_74764_b("isOpen") ? "??" : Boolean.valueOf(this.compound.func_74767_n("isOpen"))), String.format("hasBlockAbove: %s", this.compound == null || !this.compound.func_74764_b("hasBlockAbove") ? "??" : Boolean.valueOf(this.compound.func_74767_n("hasBlockAbove"))), String.format("getRotation: %s", this.getRotation())};
    }

    @Override
    public ITileRenderInfo renderInfoTile() {
        return this;
    }

    @Override
    public StateMap tileRenderState() {
        return null;
    }

    @Override
    public Object tileAnimation() {
        return null;
    }

    @Override
    public double tileAnimationProgress() {
        return 0.0;
    }

    private void recalculateState() {
        if (this.compound == null) {
            this.compound = new NBTTagCompound();
        }
        this.compound.func_74757_a("hasBlockBelow", this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileLanteaDoor);
        this.compound.func_74757_a("hasBlockAbove", this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileLanteaDoor);
        this.markNbtDirty();
    }

    @Override
    public void blockPlaced() {
        super.blockPlaced();
        this.recalculateState();
    }

    @Override
    public void neighborChanged() {
        super.neighborChanged();
        this.recalculateState();
    }

    public void openOrCloseDoor() {
        this.setDoorState(!this.getDoorState());
    }

    public void setDoorState(boolean state) {
        if (this.getDoorState() == state) {
            return;
        }
        if (this.compound == null) {
            this.compound = new NBTTagCompound();
        }
        this.compound.func_74757_a("isOpen", state);
        this.markNbtDirty();
        switch (this.getRotation()) {
            case NORTH: 
            case SOUTH: {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e);
                        if (!(tile instanceof TileLanteaDoor)) continue;
                        ((TileLanteaDoor)tile).setDoorState(state);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + y, this.field_145849_e + z);
                        if (!(tile instanceof TileLanteaDoor)) continue;
                        ((TileLanteaDoor)tile).setDoorState(state);
                    }
                }
                break;
            }
            default: {
                LCLog.fatal("Invalid door state rotation!");
            }
        }
    }

    public boolean getDoorState() {
        if (this.compound == null) {
            this.compound = new NBTTagCompound();
        }
        return this.compound.func_74764_b("isOpen") ? this.compound.func_74767_n("isOpen") : false;
    }

    public boolean hasBlockBelow() {
        if (this.compound == null) {
            this.compound = new NBTTagCompound();
        }
        return this.compound.func_74764_b("hasBlockBelow") ? this.compound.func_74767_n("hasBlockBelow") : false;
    }

    public boolean hasBlockAbove() {
        if (this.compound == null) {
            this.compound = new NBTTagCompound();
        }
        return this.compound.func_74764_b("hasBlockAbove") ? this.compound.func_74767_n("hasBlockAbove") : false;
    }

    public ForgeDirection getMotionDirection() {
        switch (this.getRotation()) {
            case NORTH: {
                return ForgeDirection.WEST;
            }
            case EAST: {
                return ForgeDirection.NORTH;
            }
            case SOUTH: {
                return ForgeDirection.EAST;
            }
            case WEST: {
                return ForgeDirection.SOUTH;
            }
        }
        LCLog.fatal("Invalid door state rotation!");
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBoundingBox(false);
    }

    public AxisAlignedBB getBoundingBox(boolean clip) {
        float w = 0.085f;
        float d0 = 0.5f - w;
        float d1 = 0.5f + w;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)-0.4, (double)-0.4, (double)-0.4, (double)1.4, (double)1.4, (double)1.4);
        if (this.clientAnimation != 0) {
            return clip ? null : AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + box.field_72340_a), (double)((double)this.field_145848_d + box.field_72338_b), (double)((double)this.field_145849_e + box.field_72339_c), (double)((double)this.field_145851_c + box.field_72336_d), (double)((double)this.field_145848_d + box.field_72337_e), (double)((double)this.field_145849_e + box.field_72334_f));
        }
        if (!this.getDoorState()) {
            switch (this.getRotation()) {
                case NORTH: 
                case SOUTH: {
                    box = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)d0, (double)1.0, (double)1.0, (double)d1);
                    break;
                }
                case EAST: 
                case WEST: {
                    box = AxisAlignedBB.func_72330_a((double)d0, (double)0.0, (double)0.0, (double)d1, (double)1.0, (double)1.0);
                    break;
                }
                default: {
                    LCLog.fatal("Invalid door state rotation!");
                    break;
                }
            }
        } else {
            switch (this.getRotation()) {
                case NORTH: {
                    box = AxisAlignedBB.func_72330_a((double)0.11, (double)0.0, (double)(0.11 - (double)d0), (double)0.28500000000000003, (double)1.0, (double)(0.11 + (double)d1));
                    break;
                }
                case SOUTH: {
                    box = AxisAlignedBB.func_72330_a((double)0.715, (double)0.0, (double)((double)d0 - 0.11), (double)0.89, (double)1.0, (double)((double)d1 + 0.711));
                    break;
                }
                case EAST: {
                    box = AxisAlignedBB.func_72330_a((double)((double)d0 - 0.11), (double)0.0, (double)0.11, (double)((double)d1 + 0.711), (double)1.0, (double)0.28500000000000003);
                    break;
                }
                case WEST: {
                    box = AxisAlignedBB.func_72330_a((double)(0.11 - (double)d0), (double)0.0, (double)0.715, (double)((double)d1 + 0.11), (double)1.0, (double)0.89);
                    break;
                }
                default: {
                    LCLog.fatal("Invalid door state rotation!");
                }
            }
        }
        if (!clip) {
            return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + box.field_72340_a), (double)((double)this.field_145848_d + box.field_72338_b), (double)((double)this.field_145849_e + box.field_72339_c), (double)((double)this.field_145851_c + box.field_72336_d), (double)((double)this.field_145848_d + box.field_72337_e), (double)((double)this.field_145849_e + box.field_72334_f));
        }
        return box;
    }

    public void setRedstoneState(int strength) {
        if (this.compound == null) {
            this.compound = new NBTTagCompound();
        }
        boolean flag0 = false;
        boolean flag1 = false;
        if (!this.compound.func_74764_b("redstoneSignal")) {
            flag0 = true;
            this.compound.func_74768_a("redstoneSignal", strength);
        } else {
            int what = this.compound.func_74762_e("redstoneSignal");
            if (what != strength) {
                flag0 = true;
                this.compound.func_74768_a("redstoneSignal", strength);
                boolean bl = flag1 = strength != 0;
            }
        }
        if (flag0) {
            this.setDoorState(flag1);
        }
    }
}

