/*
 * Decompiled with CFR 0.152.
 */
package lc.tiles;

import cpw.mods.fml.relauncher.Side;
import java.lang.ref.WeakReference;
import lc.LCRuntime;
import lc.api.audio.SoundPlaybackChannel;
import lc.api.audio.channel.ChannelDescriptor;
import lc.api.rendering.ITileRenderInfo;
import lc.api.stargate.IDHDAccess;
import lc.api.stargate.StargateType;
import lc.blocks.BlockDHD;
import lc.client.openal.StreamingSoundProperties;
import lc.common.base.LCTile;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.network.packets.LCDHDPacket;
import lc.common.util.ScanningHelper;
import lc.common.util.data.PrimitiveHelper;
import lc.common.util.math.DimensionPos;
import lc.tiles.TileStargateBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileDHD
extends LCTile
implements IDHDAccess {
    private WeakReference<TileStargateBase> stargate;
    private int scanTimeout = 0;

    @Override
    public void configure(ComponentConfig c) {
    }

    @Override
    public IInventory getInventory() {
        return null;
    }

    @Override
    public void thinkClient() {
        this.thinkAnySide();
    }

    @Override
    public void thinkServer() {
        this.thinkAnySide();
    }

    private void thinkAnySide() {
        if (this.stargate == null || this.stargate.get() == null) {
            --this.scanTimeout;
            if (this.scanTimeout <= 0) {
                AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)-7.0, (double)-7.0, (double)-7.0, (double)7.0, (double)7.0, (double)7.0);
                TileEntity tile = ScanningHelper.findNearestTileEntityOf(this.func_145831_w(), TileStargateBase.class, this.field_145851_c, this.field_145848_d, this.field_145849_e, box);
                if (tile != null && tile instanceof TileStargateBase) {
                    this.stargate = new WeakReference<TileStargateBase>((TileStargateBase)tile);
                }
                this.scanTimeout += 20;
            }
        }
    }

    @Override
    public void thinkPacket(LCPacket packet, EntityPlayer player) throws LCNetworkException {
        if (packet instanceof LCDHDPacket) {
            LCDHDPacket request = (LCDHDPacket)packet;
            if (this.stargate != null && this.stargate.get() != null) {
                TileStargateBase tile = (TileStargateBase)this.stargate.get();
                int whichButton = request.compound.func_74762_e("typedButton");
                char whatValue = (char)request.compound.func_74762_e("typedValue");
                if (whichButton == 0) {
                    tile.selectGlyph(whatValue);
                    tile.activateChevron();
                } else if (whichButton == 1) {
                    tile.deactivateChevron();
                } else if (whichButton == 2) {
                    if (!tile.hasConnectionState()) {
                        tile.engageStargate();
                    } else {
                        tile.disengageStargate();
                    }
                }
            }
        }
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    public void save(NBTTagCompound compound) {
    }

    @Override
    public void load(NBTTagCompound compound) {
    }

    @Override
    public String[] debug(Side side) {
        return new String[0];
    }

    @Override
    public ITileRenderInfo renderInfoTile() {
        return null;
    }

    @Override
    public StargateType getDHDType() {
        return ((BlockDHD)this.func_145838_q()).getDHDType(this.func_145832_p());
    }

    public Character[] clientAskEngagedGlpyhs() {
        if (this.stargate != null && this.stargate.get() != null) {
            TileStargateBase what = (TileStargateBase)this.stargate.get();
            return PrimitiveHelper.box(what.getActivatedGlyphs().toCharArray());
        }
        return new Character[0];
    }

    public boolean clientAskConnectionOpen() {
        if (this.stargate != null && this.stargate.get() != null) {
            TileStargateBase what = (TileStargateBase)this.stargate.get();
            return what.hasConnectionState();
        }
        return false;
    }

    public void clientDoPressedButton(int whichButton, char whatValue) {
        NBTTagCompound request = new NBTTagCompound();
        request.func_74768_a("typedButton", whichButton);
        request.func_74768_a("typedValue", (int)whatValue);
        LCDHDPacket packet = new LCDHDPacket(new DimensionPos(this), request);
        LCRuntime.runtime.network().getPreferredPipe().sendToServer(packet);
        this.mixer().replayChannel("click");
    }

    static {
        TileDHD.registerChannel(TileDHD.class, new ChannelDescriptor("click", "stargate/milkyway/milkyway_dhd_button.ogg", new StreamingSoundProperties(SoundPlaybackChannel.MASTER)));
    }
}

