/*
 * Decompiled with CFR 0.152.
 */
package lc.server.world;

import java.util.Iterator;
import lc.LCRuntime;
import lc.common.util.math.Facing3;
import lc.common.util.math.Trans3;
import lc.common.util.math.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.network.ForgeMessage;

public class TeleportationHelper {
    private static Vector3 yawVector(double yaw) {
        double a = Math.toRadians(yaw);
        return new Vector3(-Math.sin(a), 0.0, Math.cos(a));
    }

    private static Vector3 yawVector(Entity entity) {
        return TeleportationHelper.yawVector(entity.field_70177_z);
    }

    private static double yawAngle(Vector3 v) {
        return Math.toDegrees(Math.atan2(-v.x, v.z));
    }

    public static Entity sendEntityToWorld(Entity entity, Trans3 src, Trans3 dst, int dimension) {
        Vector3 lPos = src.ip(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vector3 lVel = src.iv(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        Vector3 lFac = src.iv(TeleportationHelper.yawVector(entity));
        Vector3 newPosition = dst.p(-lPos.x, lPos.y, -lPos.z);
        Vector3 newVelocity = dst.v(-lVel.x, lVel.y, -lVel.z);
        Vector3 gFac = dst.v(lFac.mul(-1.0));
        Facing3 newFacing = new Facing3(TeleportationHelper.yawAngle(gFac), entity.field_70125_A);
        Entity newEntity = TeleportationHelper.sendEntityToWorld(entity, dimension, newPosition, newFacing);
        TeleportationHelper.setVelocity(newEntity, newVelocity);
        return newEntity;
    }

    private static Entity sendEntityToWorld(Entity entity, int newDimension, Vector3 newPos, Facing3 newLook) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        Entity currentEntity = entity;
        if (entity.field_71093_bK != newDimension) {
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                ServerConfigurationManager scm = server.func_71203_ab();
                int oldDimension = player.field_71093_bK;
                player.field_71093_bK = newDimension;
                WorldServer oldWorld = server.func_71218_a(oldDimension);
                WorldServer newWorld = server.func_71218_a(newDimension);
                ForgeMessage.DimensionRegisterMessage packet = new ForgeMessage.DimensionRegisterMessage(newDimension, DimensionManager.getProviderType((int)newDimension));
                LCRuntime.runtime.network().getPreferredPipe().sendForgeMessageTo((ForgeMessage)packet, player);
                player.func_71053_j();
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                oldWorld.func_72973_f((Entity)player);
                player.field_70128_L = false;
                player.func_70012_b(newPos.x, newPos.y, newPos.z, (float)newLook.yaw, (float)newLook.pitch);
                newWorld.func_72838_d((Entity)player);
                player.func_70029_a((World)newWorld);
                scm.func_72375_a(player, oldWorld);
                player.field_71135_a.func_147364_a(newPos.x, newPos.y, newPos.z, (float)newLook.yaw, (float)newLook.pitch);
                player.field_71134_c.func_73080_a(newWorld);
                scm.func_72354_b(player, newWorld);
                scm.func_72385_f(player);
                Iterator var6 = player.func_70651_bq().iterator();
                while (var6.hasNext()) {
                    player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), (PotionEffect)var6.next()));
                }
                player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            } else {
                int oldDimension = entity.field_71093_bK;
                WorldServer oldWorld = server.func_71218_a(oldDimension);
                WorldServer newWorld = server.func_71218_a(newDimension);
                entity.field_71093_bK = newDimension;
                entity.field_70170_p.func_72900_e(entity);
                entity.field_70128_L = false;
                server.func_71203_ab().func_82448_a(entity, oldDimension, oldWorld, newWorld);
                currentEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)newWorld);
                if (currentEntity != null) {
                    currentEntity.func_82141_a(entity, true);
                    currentEntity.func_70012_b(newPos.x, newPos.y, newPos.z, (float)newLook.yaw, (float)newLook.pitch);
                    newWorld.func_72838_d(currentEntity);
                }
                entity.field_70128_L = true;
                oldWorld.func_82742_i();
                newWorld.func_82742_i();
            }
        } else {
            currentEntity.func_70012_b(newPos.x, newPos.y, newPos.z, (float)newLook.yaw, (float)newLook.pitch);
            if (currentEntity instanceof EntityPlayerMP) {
                EntityPlayerMP mpEnt = (EntityPlayerMP)currentEntity;
                mpEnt.field_70177_z = (float)newLook.yaw;
                mpEnt.func_70634_a(newPos.x, newPos.y, newPos.z);
                mpEnt.field_70170_p.func_72866_a(entity, false);
            }
        }
        return currentEntity;
    }

    private static void setVelocity(Entity entity, Vector3 v) {
        entity.field_70159_w = v.x;
        entity.field_70181_x = v.y;
        entity.field_70179_y = v.z;
    }
}

