/*
 * Decompiled with CFR 0.152.
 */
package lc.server.world;

import java.util.ArrayList;
import lc.LanteaCraft;
import lc.common.LCLog;
import lc.common.util.math.ChunkPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class LCLoadedChunkManager {
    private ArrayList<LCChunkTicket> tickets = new ArrayList();

    public LCChunkTicket requestTicket(World world) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)LanteaCraft.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            LCLog.fatal("Too many open chunk tickets.");
        }
        LCChunkTicket wrapper = new LCChunkTicket(ticket);
        this.tickets.add(wrapper);
        return wrapper;
    }

    public void closeTicket(LCChunkTicket ticket) {
        ticket.unload();
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket.ticket);
        this.tickets.remove(ticket);
    }

    public static class LCChunkTicket {
        protected final ForgeChunkManager.Ticket ticket;
        protected final ArrayList<ChunkPos> loaded;

        public LCChunkTicket(ForgeChunkManager.Ticket ticket) {
            this.ticket = ticket;
            this.loaded = new ArrayList();
        }

        public void loadChunk(ChunkPos chunk) {
            LCLog.debug("Forcing chunk: [%s, %s]", chunk.cx, chunk.cz);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(chunk.cx, chunk.cz));
            this.loaded.add(chunk);
        }

        public void loadChunkRange(ChunkPos origin, int ix, int iz, int mx, int mz) {
            for (int x = ix; x <= mx; ++x) {
                for (int z = iz; z <= mz; ++z) {
                    this.loadChunk(new ChunkPos(origin.cx + x, origin.cz + z));
                }
            }
        }

        public void unload() {
            LCLog.debug("Releasing all forced chunks");
            for (ChunkPos chunk : this.loaded) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(chunk.cx, chunk.cz));
            }
            this.loaded.clear();
        }
    }
}

