/*
 * Decompiled with CFR 0.152.
 */
package lc.server.stargate;

import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import lc.api.stargate.StargateAddress;
import lc.common.LCLog;
import lc.common.stargate.StargateCharsetHelper;
import lc.common.util.math.ChunkPos;
import lc.server.stargate.RecordIO;
import lc.server.stargate.StargateRecord;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;

public class UniverseManager {
    private static final int ADDRESS_WIDTH = 9;
    private final RecordIO jsonAgent;
    private File workFile;
    private Random worldRandom;
    private ArrayList<StargateRecord> recordHeap = new ArrayList();
    private ArrayList<Long> characterMap = new ArrayList();

    public UniverseManager() {
        this.jsonAgent = new RecordIO();
    }

    public void loadUniverse(FMLServerStartingEvent event) {
        WorldServer overworld = event.getServer().func_71218_a(0);
        File cwd = overworld.func_72860_G().func_75765_b();
        File dataDir = new File(cwd, "lanteacraft");
        LCLog.debug("Mounting universe storage: %s", dataDir);
        if (!dataDir.exists()) {
            dataDir.mkdir();
        }
        this.workFile = new File(dataDir, "addresses.json");
        if (this.workFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.workFile);
                this.recordHeap.clear();
                this.recordHeap = this.jsonAgent.readMap(fis);
                LCLog.debug("Read %s existing address entries.", this.recordHeap.size());
                fis.close();
            }
            catch (IOException ioex) {
                LCLog.fatal("Problem reading Stargate address database.", ioex);
            }
        }
        this.worldRandom = new Random(System.currentTimeMillis());
        this.buildIndex();
    }

    public void unloadUniverse(FMLServerStoppingEvent event) {
        if (this.workFile == null) {
            LCLog.debug("Can't unload: no open work file!");
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.workFile);
            LCLog.debug("Writing %s address entries to file.", this.recordHeap.size());
            this.jsonAgent.writeMap(fos, this.recordHeap);
            this.recordHeap.clear();
            fos.close();
            this.workFile = null;
        }
        catch (IOException ioex) {
            LCLog.fatal("Problem saving Stargate address database.", ioex);
        }
    }

    public void loadGalaxy(WorldEvent.Load load) {
    }

    public void unloadGalaxy(WorldEvent.Unload unload) {
    }

    public void autosaveGalaxy(WorldEvent.Save save) {
        if (this.workFile == null) {
            LCLog.debug("Can't autosave: no open work file!");
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.workFile);
            LCLog.debug("Auto-saving %s address entries to file.", this.recordHeap.size());
            this.jsonAgent.writeMap(fos, this.recordHeap);
            fos.close();
        }
        catch (IOException ioex) {
            LCLog.fatal("Problem saving Stargate address database.", ioex);
        }
    }

    public void buildIndex() {
        LCLog.debug("Rebuilding the record index...");
        this.characterMap.clear();
        for (StargateRecord record : this.recordHeap) {
            this.characterMap.add(record.address.getILongValue());
        }
        LCLog.debug("Record index rebuilt.");
    }

    public boolean isAddressAllocated(StargateAddress address) {
        return this.characterMap.contains(address.getILongValue());
    }

    public StargateAddress putAddress(StargateAddress address, int dimension, ChunkPos chunk) {
        StargateRecord record = new StargateRecord();
        record.address = address;
        record.dimension = dimension;
        record.chunk = chunk;
        this.recordHeap.add(record);
        this.characterMap.add(address.getILongValue());
        return address;
    }

    public StargateAddress findAddress(int dimension, ChunkPos chunk) {
        for (StargateRecord record : this.recordHeap) {
            if (!record.chunk.equals(chunk)) continue;
            return record.address;
        }
        return this.putAddress(this.getFreeAddress(9), dimension, chunk);
    }

    public StargateAddress getFreeAddress(int width) {
        StargateAddress addr;
        ArrayList<Character> address = new ArrayList<Character>();
        while (true) {
            if (address.size() < width) {
                char z = StargateCharsetHelper.singleton().index(this.worldRandom.nextInt(36));
                if (address.contains(Character.valueOf(z))) continue;
                address.add(Character.valueOf(z));
                continue;
            }
            addr = new StargateAddress(address.toArray(new Character[0]));
            if (!this.isAddressAllocated(addr)) break;
        }
        return addr;
    }

    public StargateRecord findRecord(StargateAddress address) {
        if (!this.isAddressAllocated(address)) {
            return null;
        }
        for (StargateRecord record : this.recordHeap) {
            if (!record.address.equals(address)) continue;
            return record;
        }
        return null;
    }
}

