/*
 * Decompiled with CFR 0.152.
 */
package lc.server.stargate;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import lc.LCRuntime;
import lc.api.event.ITickEventHandler;
import lc.api.stargate.StargateAddress;
import lc.api.stargate.StargateConnectionType;
import lc.common.LCLog;
import lc.common.util.math.ChunkPos;
import lc.server.stargate.StargateConnection;
import lc.server.stargate.StargateRecord;
import lc.server.stargate.UniverseManager;
import lc.tiles.TileStargateBase;

public class StargateManager
implements ITickEventHandler {
    private final UniverseManager universeMgr;
    private final HashMap<Integer, ArrayList<StargateConnection>> connections;

    public StargateManager(UniverseManager universeMgr) {
        this.universeMgr = universeMgr;
        this.connections = new HashMap();
        LCRuntime.runtime.ticks().register(this);
    }

    public StargateAddress getStargateAddress(TileStargateBase tile) {
        return this.universeMgr.findAddress(tile.func_145831_w().field_73011_w.field_76574_g, new ChunkPos(tile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StargateConnection openConnection(TileStargateBase tile, StargateAddress address, int connectTimeout, int establishedTimeout) {
        StargateRecord what = this.universeMgr.findRecord(address);
        if (what == null) {
            LCLog.debug("No such address found: " + address);
            return null;
        }
        StargateConnectionType type = what.server != null ? StargateConnectionType.SERVERTOSERVER : StargateConnectionType.LOCAL;
        StargateConnection connection = new StargateConnection(type, tile, what, connectTimeout, establishedTimeout);
        HashMap<Integer, ArrayList<StargateConnection>> hashMap = this.connections;
        synchronized (hashMap) {
            if (!this.connections.containsKey(tile.func_145831_w().field_73011_w.field_76574_g)) {
                this.connections.put(tile.func_145831_w().field_73011_w.field_76574_g, new ArrayList());
            }
            this.connections.get(tile.func_145831_w().field_73011_w.field_76574_g).add(connection);
        }
        connection.openConnection();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnectionsIn(int dimensionId) {
        LCLog.info("Closing connections in dimension %s.", dimensionId);
        ArrayList<StargateConnection> dc = null;
        HashMap<Integer, ArrayList<StargateConnection>> hashMap = this.connections;
        synchronized (hashMap) {
            dc = this.connections.remove(dimensionId);
        }
        if (dc != null) {
            Iterator<StargateConnection> iter = dc.iterator();
            while (iter.hasNext()) {
                iter.next().deleteConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnections(boolean now) {
        HashMap<Integer, ArrayList<StargateConnection>> hashMap = this.connections;
        synchronized (hashMap) {
            Iterator<Integer> dimensions = this.connections.keySet().iterator();
            while (dimensions.hasNext()) {
                int dimension = dimensions.next();
                ArrayList<StargateConnection> dc = this.connections.get(dimension);
                Iterator<StargateConnection> iter = dc.iterator();
                while (iter.hasNext()) {
                    iter.next().deleteConnection();
                }
                dimensions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void think(Side what) {
        if (what == Side.SERVER) {
            HashMap<Integer, ArrayList<StargateConnection>> hashMap = this.connections;
            synchronized (hashMap) {
                for (int dimension : this.connections.keySet()) {
                    ArrayList<StargateConnection> dc = this.connections.get(dimension);
                    Iterator<StargateConnection> iter = dc.iterator();
                    while (iter.hasNext()) {
                        StargateConnection conn = iter.next();
                        conn.think();
                        if (!conn.dead) continue;
                        LCLog.debug("Removing dead connection %s.", conn);
                        iter.remove();
                    }
                }
            }
        }
    }
}

