/*
 * Decompiled with CFR 0.152.
 */
package lc.server.stargate;

import lc.LCRuntime;
import lc.api.stargate.MessagePayload;
import lc.api.stargate.StargateAddress;
import lc.api.stargate.StargateConnectionType;
import lc.api.stargate.StargateState;
import lc.common.LCLog;
import lc.common.base.multiblock.MultiblockState;
import lc.common.util.java.DestructableReferenceQueue;
import lc.common.util.math.ChunkPos;
import lc.server.HintProviderServer;
import lc.server.stargate.StargateRecord;
import lc.server.world.LCLoadedChunkManager;
import lc.tiles.TileStargateBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class StargateConnection {
    public final StargateConnectionType type;
    public final StargateAddress source;
    public final StargateRecord dest;
    private int maxConnectionAge;
    private int maxTimeout;
    public TileStargateBase tileFrom;
    public TileStargateBase tileTo;
    public LCLoadedChunkManager.LCChunkTicket ticketFrom;
    public LCLoadedChunkManager.LCChunkTicket ticketTo;
    public StargateState state;
    public int stateTimeout = 0;
    public boolean dead = false;

    public StargateConnection(StargateConnectionType type, TileStargateBase tileFrom, StargateRecord what, int timeout, int maxAge) {
        this.type = type;
        this.tileFrom = tileFrom;
        this.source = tileFrom.getStargateAddress();
        this.dest = what;
        this.state = StargateState.IDLE;
        this.ticketFrom = ((HintProviderServer)LCRuntime.runtime.hints()).chunkLoaders().requestTicket(tileFrom.func_145831_w());
        this.maxConnectionAge = maxAge;
        this.maxTimeout = timeout;
        ChunkPos origin = new ChunkPos(tileFrom);
        this.ticketFrom.loadChunkRange(origin, -1, -1, 1, 1);
    }

    public void think() {
        if (this.dead) {
            return;
        }
        switch (this.state) {
            case DIALLING: {
                this.thinkPerformConnection();
                break;
            }
            case CONNECTED: {
                this.thinkConnection();
                break;
            }
            case DISCONNECTING: 
            case FAILED: {
                this.thinkSpinDown();
                break;
            }
            case IDLE: {
                this.thinkIdle();
            }
        }
    }

    private void thinkConnection() {
        --this.stateTimeout;
        if (this.tileFrom == null || this.tileTo == null) {
            this.stateTimeout = 0;
        }
        if (DestructableReferenceQueue.queued(this.tileFrom) || DestructableReferenceQueue.queued(this.tileTo)) {
            this.stateTimeout = 0;
        }
        if (this.tileFrom != null && this.tileTo != null) {
            if (this.tileFrom.getState() != MultiblockState.FORMED) {
                this.stateTimeout = 0;
            }
            if (this.tileTo.getState() != MultiblockState.FORMED) {
                this.stateTimeout = 0;
            }
        }
        if (this.stateTimeout <= 0) {
            this.changeState(StargateState.DISCONNECTING, 60);
        }
    }

    private void thinkFindTile() {
        if (this.tileTo != null) {
            return;
        }
        try {
            Chunk chunk;
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(this.dest.dimension);
            if (world == null) {
                LCLog.debug("Can't find world %s", this.dest.dimension);
                return;
            }
            if (this.ticketTo == null) {
                this.ticketTo = ((HintProviderServer)LCRuntime.runtime.hints()).chunkLoaders().requestTicket((World)world);
                this.ticketTo.loadChunkRange(this.dest.chunk, -1, -1, 1, 1);
            }
            if ((chunk = world.func_72964_e(this.dest.chunk.cx, this.dest.chunk.cz)) == null) {
                LCLog.debug("Can't find chunk [%s, %s]", this.dest.chunk.cx, this.dest.chunk.cz);
                return;
            }
            for (Object o : chunk.field_150816_i.values()) {
                TileStargateBase tile;
                if (!(o instanceof TileStargateBase) || (tile = (TileStargateBase)o).getState() != MultiblockState.FORMED || tile.hasConnectionState()) continue;
                LCLog.debug("Found Stargate in chunk [%s, %s]", this.dest.chunk.cx, this.dest.chunk.cz);
                this.tileTo = tile;
                return;
            }
            LCLog.debug("Failed to find Stargate in chunk [%s, %s]", this.dest.chunk.cx, this.dest.chunk.cz);
        }
        catch (Exception e) {
            LCLog.warn("Problem scanning for Stargate.", e);
        }
    }

    private void thinkSpinDown() {
        --this.stateTimeout;
        if (this.stateTimeout <= 0) {
            this.changeState(StargateState.IDLE, 0);
        }
    }

    private void thinkIdle() {
        this.deleteConnection();
    }

    private void thinkPerformConnection() {
        --this.stateTimeout;
        this.thinkFindTile();
        try {
            if (this.tileFrom != null && this.tileTo != null) {
                if (this.tileFrom.getConnectionState() != null && this.tileFrom.getConnectionState() != this) {
                    throw new IllegalStateException("Source Stargate is busy with non-self connection.");
                }
                if (this.tileTo.getConnectionState() != null && this.tileTo.getConnectionState() != this) {
                    throw new IllegalStateException("Destination Stargate is busy with non-self connection.");
                }
                this.changeState(StargateState.CONNECTED, this.maxConnectionAge);
            }
        }
        catch (Exception e) {
            LCLog.debug("Can't connect to Stargate.", e);
        }
        if (this.stateTimeout <= 0) {
            this.changeState(StargateState.FAILED, 60);
        }
    }

    private void changeState(StargateState state, int stateTimeout) {
        this.state = state;
        this.stateTimeout = stateTimeout;
        LCLog.debug(new Object[]{"Going to state %s (timeout %s)", state, stateTimeout});
        this.sendUpdates();
    }

    public void sendUpdates() {
        if (this.tileFrom != null) {
            this.tileFrom.notifyConnectionState(this);
        }
        if (this.tileTo != null) {
            this.tileTo.notifyConnectionState(this);
        }
    }

    public void deleteConnection() {
        if (this.tileFrom != null) {
            this.tileFrom.notifyConnectionState(null);
        }
        if (this.tileTo != null) {
            this.tileTo.notifyConnectionState(null);
        }
        this.tileFrom = null;
        this.tileTo = null;
        if (this.ticketTo != null) {
            this.ticketTo.unload();
            ((HintProviderServer)LCRuntime.runtime.hints()).chunkLoaders().closeTicket(this.ticketTo);
            this.ticketTo = null;
        }
        if (this.ticketFrom != null) {
            this.ticketFrom.unload();
            ((HintProviderServer)LCRuntime.runtime.hints()).chunkLoaders().closeTicket(this.ticketFrom);
            this.ticketFrom = null;
        }
        LCLog.debug("Connection closed!");
        this.dead = true;
    }

    public void openConnection() {
        if (this.state != StargateState.IDLE) {
            return;
        }
        this.changeState(StargateState.DIALLING, this.maxTimeout);
    }

    public boolean closeConnection(TileStargateBase source) {
        if (this.state != StargateState.CONNECTED) {
            return false;
        }
        if (source == this.tileFrom) {
            this.changeState(StargateState.DISCONNECTING, 60);
            return true;
        }
        return false;
    }

    public void shutdown() {
        this.state = StargateState.IDLE;
        this.deleteConnection();
    }

    public void transmit(TileStargateBase source, MessagePayload payload) {
        if (source == this.tileFrom) {
            this.tileTo.receive(payload);
        }
        if (source == this.tileTo) {
            this.tileFrom.receive(payload);
        }
    }
}

