/*
 * Decompiled with CFR 0.152.
 */
package lc.server;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import lc.LCRuntime;
import lc.common.base.generation.LCChunkData;
import lc.common.base.generation.LCWorldData;
import lc.server.HintProviderServer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ServerEventHooks {
    private final HintProviderServer serverHints;

    public ServerEventHooks(HintProviderServer serverHints) {
        this.serverHints = serverHints;
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        this.serverHints.universeMgr.loadUniverse(event);
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.serverHints.universeMgr.unloadUniverse(event);
        this.serverHints.stargateMgr.closeAllConnections(true);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        LCWorldData.forWorld(event.world);
        this.serverHints.universeMgr.loadGalaxy(event);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        LCWorldData.forWorld(event.world).func_76185_a();
        this.serverHints.universeMgr.unloadGalaxy(event);
        this.serverHints.stargateMgr.closeConnectionsIn(event.world.field_73011_w.field_76574_g);
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        this.serverHints.universeMgr.autosaveGalaxy(event);
    }

    @SubscribeEvent
    public void onInitMapGen(InitMapGenEvent e) {
        this.serverHints.initMapGen(e);
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        LCRuntime.runtime.network().serverShutdown();
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void beforeServerStarted(FMLServerAboutToStartEvent event) {
        this.serverHints.trustChain.purge();
    }

    @SubscribeEvent
    public void onPlayerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        LCRuntime.runtime.network().playerConnected((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onPlayerDisconnected(PlayerEvent.PlayerLoggedOutEvent event) {
        LCRuntime.runtime.network().playerDisconnected((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        LCChunkData.onChunkLoad(event);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        LCChunkData.onChunkSave(event);
    }
}

