/*
 * Decompiled with CFR 0.152.
 */
package lc.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import lc.LCRuntime;
import lc.LanteaCraft;
import lc.api.audio.ISoundController;
import lc.api.components.ComponentType;
import lc.api.components.DriverMap;
import lc.api.components.IConfigurationProvider;
import lc.api.defs.IContainerDefinition;
import lc.api.defs.IRecipeDefinition;
import lc.api.rendering.IParticleMachine;
import lc.common.IHintProvider;
import lc.common.LCLog;
import lc.common.base.generation.LCMasterWorldGen;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.crypto.KeyTrustRegistry;
import lc.common.util.BeaconStreamThread;
import lc.common.util.StatsProvider;
import lc.server.ServerEventHooks;
import lc.server.openal.VoidSoundController;
import lc.server.stargate.StargateManager;
import lc.server.stargate.UniverseManager;
import lc.server.world.LCChunkLoadCallback;
import lc.server.world.LCLoadedChunkManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;

public class HintProviderServer
implements IHintProvider {
    ServerEventHooks serverHookBus;
    LCChunkLoadCallback chunkLoadCallback;
    LCLoadedChunkManager chunkLoadManager;
    BeaconStreamThread beaconMgr;
    UniverseManager universeMgr;
    StargateManager stargateMgr;
    KeyTrustRegistry trustChain;
    LCMasterWorldGen worldGenerator;
    ComponentConfig renderConfiguration;

    public HintProviderServer() {
        LCLog.debug("HintProviderServer providing server-side hints");
    }

    @Override
    public void preInit() {
        LCLog.debug("Providing base initialization helpers.");
        this.serverHookBus = new ServerEventHooks(this);
        this.beaconMgr = new BeaconStreamThread(this);
        this.universeMgr = new UniverseManager();
        this.stargateMgr = new StargateManager(this.universeMgr);
        this.trustChain = new KeyTrustRegistry();
        this.chunkLoadCallback = new LCChunkLoadCallback();
        this.chunkLoadManager = new LCLoadedChunkManager();
        this.renderConfiguration = LCRuntime.runtime.config().config(ComponentType.CLIENT);
        FMLCommonHandler.instance().bus().register((Object)this.serverHookBus);
        MinecraftForge.EVENT_BUS.register((Object)this.serverHookBus);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.serverHookBus);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)LanteaCraft.instance, (ForgeChunkManager.LoadingCallback)this.chunkLoadCallback);
    }

    @Override
    public void init() {
        LCLog.debug("Providing base initialization.");
        this.worldGenerator = new LCMasterWorldGen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.worldGenerator, (int)0);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.worldGenerator);
        DriverMap.trySpinUpAll();
    }

    @Override
    public void postInit() {
        HashMap<String, String> stats = new HashMap<String, String>();
        StatsProvider.generateStats(stats);
        this.beaconMgr.beacon(stats);
    }

    @Override
    public void provideHints(IContainerDefinition definition) {
    }

    @Override
    public void provideHints(IRecipeDefinition definition) {
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        this.serverHookBus.onServerStarting(event);
    }

    @Override
    public void serverStopping(FMLServerStoppingEvent event) {
        this.serverHookBus.onServerStopping(event);
    }

    public StargateManager stargates() {
        return this.stargateMgr;
    }

    public LCLoadedChunkManager chunkLoaders() {
        return this.chunkLoadManager;
    }

    public LCMasterWorldGen generator() {
        return this.worldGenerator;
    }

    public BeaconStreamThread stats() {
        return this.beaconMgr;
    }

    @Override
    public ISoundController audio() {
        return VoidSoundController.controller;
    }

    @Override
    public IConfigurationProvider config() {
        return this.renderConfiguration;
    }

    public KeyTrustRegistry getTrustChain() {
        return this.trustChain;
    }

    @Override
    public void signatureViolation(FMLFingerprintViolationEvent event) {
    }

    @Override
    public void receiveIMC(FMLInterModComms.IMCEvent event) {
    }

    @Override
    public void serverStopped(FMLServerStoppedEvent event) {
        this.serverHookBus.onServerStopped(event);
    }

    @Override
    public void serverStarted(FMLServerStartedEvent event) {
        this.serverHookBus.onServerStarted(event);
    }

    @Override
    public void beforeServerStarting(FMLServerAboutToStartEvent event) {
        this.serverHookBus.beforeServerStarted(event);
    }

    @Override
    public IParticleMachine particles() {
        throw new RuntimeException("Particles not permitted on server.");
    }

    @Override
    public void initMapGen(InitMapGenEvent event) {
    }
}

