/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.vm;

import lc.repack.se.krka.kahlua.vm.Coroutine;
import lc.repack.se.krka.kahlua.vm.JavaFunction;
import lc.repack.se.krka.kahlua.vm.KahluaTable;
import lc.repack.se.krka.kahlua.vm.KahluaThread;
import lc.repack.se.krka.kahlua.vm.LuaClosure;
import lc.repack.se.krka.kahlua.vm.Platform;
import lc.repack.se.krka.kahlua.vm.UpValue;

public class LuaCallFrame {
    private final Platform platform;
    public final Coroutine coroutine;
    public LuaClosure closure;
    public JavaFunction javaFunction;
    public int pc;
    public int localBase;
    int returnBase;
    public int nArguments;
    boolean fromLua;
    public boolean canYield;
    boolean restoreTop;

    public LuaCallFrame(Coroutine coroutine) {
        this.coroutine = coroutine;
        this.platform = coroutine.getPlatform();
    }

    public final void set(int index, Object o) {
        this.coroutine.objectStack[this.localBase + index] = o;
    }

    public final Object get(int index) {
        return this.coroutine.objectStack[this.localBase + index];
    }

    public int push(Object x) {
        int top = this.getTop();
        this.setTop(top + 1);
        this.set(top, x);
        return 1;
    }

    public int push(Object x, Object y) {
        int top = this.getTop();
        this.setTop(top + 2);
        this.set(top, x);
        this.set(top + 1, y);
        return 2;
    }

    public int pushNil() {
        return this.push(null);
    }

    public final void stackCopy(int startIndex, int destIndex, int len) {
        this.coroutine.stackCopy(this.localBase + startIndex, this.localBase + destIndex, len);
    }

    public void stackClear(int startIndex, int endIndex) {
        while (startIndex <= endIndex) {
            this.coroutine.objectStack[this.localBase + startIndex] = null;
            ++startIndex;
        }
    }

    public void clearFromIndex(int index) {
        if (this.getTop() < index) {
            this.setTop(index);
        }
        this.stackClear(index, this.getTop() - 1);
    }

    public final void setTop(int index) {
        this.coroutine.setTop(this.localBase + index);
    }

    public void closeUpvalues(int a) {
        this.coroutine.closeUpvalues(this.localBase + a);
    }

    public UpValue findUpvalue(int b) {
        return this.coroutine.findUpvalue(this.localBase + b);
    }

    public int getTop() {
        return this.coroutine.getTop() - this.localBase;
    }

    public void init() {
        if (this.isLua()) {
            this.pc = 0;
            if (this.closure.prototype.isVararg) {
                this.localBase += this.nArguments;
                this.setTop(this.closure.prototype.maxStacksize);
                int toCopy = Math.min(this.nArguments, this.closure.prototype.numParams);
                this.stackCopy(-this.nArguments, 0, toCopy);
            } else {
                this.setTop(this.closure.prototype.maxStacksize);
                this.stackClear(this.closure.prototype.numParams, this.nArguments);
            }
        }
    }

    public void setPrototypeStacksize() {
        if (this.isLua()) {
            this.setTop(this.closure.prototype.maxStacksize);
        }
    }

    public void pushVarargs(int index, int n) {
        int nParams = this.closure.prototype.numParams;
        int nVarargs = this.nArguments - nParams;
        if (nVarargs < 0) {
            nVarargs = 0;
        }
        if (n == -1) {
            n = nVarargs;
            this.setTop(index + n);
        }
        if (nVarargs > n) {
            nVarargs = n;
        }
        this.stackCopy(-this.nArguments + nParams, index, nVarargs);
        int numNils = n - nVarargs;
        if (numNils > 0) {
            this.stackClear(index + nVarargs, index + n - 1);
        }
    }

    public KahluaTable getEnvironment() {
        if (this.isLua()) {
            return this.closure.env;
        }
        return this.coroutine.environment;
    }

    public boolean isJava() {
        return !this.isLua();
    }

    public boolean isLua() {
        return this.closure != null;
    }

    public String toString() {
        if (this.closure != null) {
            return "Callframe at: " + this.closure.toString();
        }
        if (this.javaFunction != null) {
            return "Callframe at: " + this.javaFunction.toString();
        }
        return super.toString();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    void setup(LuaClosure closure, JavaFunction javaFunction, int localBase, int returnBase, int nArguments, boolean fromLua, boolean insideCoroutine) {
        this.localBase = localBase;
        this.returnBase = returnBase;
        this.nArguments = nArguments;
        this.fromLua = fromLua;
        this.canYield = insideCoroutine;
        this.closure = closure;
        this.javaFunction = javaFunction;
    }

    public KahluaThread getThread() {
        return this.coroutine.getThread();
    }
}

