/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.vm;

import java.io.PrintStream;
import lc.repack.se.krka.kahlua.stdlib.BaseLib;
import lc.repack.se.krka.kahlua.vm.Coroutine;
import lc.repack.se.krka.kahlua.vm.JavaFunction;
import lc.repack.se.krka.kahlua.vm.KahluaException;
import lc.repack.se.krka.kahlua.vm.KahluaTable;
import lc.repack.se.krka.kahlua.vm.KahluaUtil;
import lc.repack.se.krka.kahlua.vm.LuaCallFrame;
import lc.repack.se.krka.kahlua.vm.LuaClosure;
import lc.repack.se.krka.kahlua.vm.Platform;
import lc.repack.se.krka.kahlua.vm.Prototype;
import lc.repack.se.krka.kahlua.vm.UpValue;

public class KahluaThread {
    private static final int FIELDS_PER_FLUSH = 50;
    private static final int OP_MOVE = 0;
    private static final int OP_LOADK = 1;
    private static final int OP_LOADBOOL = 2;
    private static final int OP_LOADNIL = 3;
    private static final int OP_GETUPVAL = 4;
    private static final int OP_GETGLOBAL = 5;
    private static final int OP_GETTABLE = 6;
    private static final int OP_SETGLOBAL = 7;
    private static final int OP_SETUPVAL = 8;
    private static final int OP_SETTABLE = 9;
    private static final int OP_NEWTABLE = 10;
    private static final int OP_SELF = 11;
    private static final int OP_ADD = 12;
    private static final int OP_SUB = 13;
    private static final int OP_MUL = 14;
    private static final int OP_DIV = 15;
    private static final int OP_MOD = 16;
    private static final int OP_POW = 17;
    private static final int OP_UNM = 18;
    private static final int OP_NOT = 19;
    private static final int OP_LEN = 20;
    private static final int OP_CONCAT = 21;
    private static final int OP_JMP = 22;
    private static final int OP_EQ = 23;
    private static final int OP_LT = 24;
    private static final int OP_LE = 25;
    private static final int OP_TEST = 26;
    private static final int OP_TESTSET = 27;
    private static final int OP_CALL = 28;
    private static final int OP_TAILCALL = 29;
    private static final int OP_RETURN = 30;
    private static final int OP_FORLOOP = 31;
    private static final int OP_FORPREP = 32;
    private static final int OP_TFORLOOP = 33;
    private static final int OP_SETLIST = 34;
    private static final int OP_CLOSE = 35;
    private static final int OP_CLOSURE = 36;
    private static final int OP_VARARG = 37;
    private static final int MAX_INDEX_RECURSION = 100;
    private static final String[] meta_ops = new String[38];
    private final Coroutine rootCoroutine;
    public Coroutine currentCoroutine;
    private final PrintStream out;
    private final Platform platform;

    public KahluaThread(Platform platform, KahluaTable environment) {
        this(System.out, platform, environment);
    }

    public KahluaThread(PrintStream stream, Platform platform, KahluaTable environment) {
        this.platform = platform;
        this.out = stream;
        this.currentCoroutine = this.rootCoroutine = new Coroutine(platform, environment, this);
    }

    public int call(int nArguments) {
        int top = this.currentCoroutine.getTop();
        int base = top - nArguments - 1;
        Object o = this.currentCoroutine.objectStack[base];
        if (o == null) {
            throw new RuntimeException("tried to call nil");
        }
        if (o instanceof JavaFunction) {
            return this.callJava((JavaFunction)o, base + 1, base, nArguments);
        }
        if (!(o instanceof LuaClosure)) {
            throw new RuntimeException("tried to call a non-function");
        }
        LuaCallFrame callFrame = this.currentCoroutine.pushNewCallFrame((LuaClosure)o, null, base + 1, base, nArguments, false, false);
        callFrame.init();
        this.luaMainloop();
        int nReturnValues = this.currentCoroutine.getTop() - base;
        this.currentCoroutine.stackTrace = "";
        return nReturnValues;
    }

    private int callJava(JavaFunction f, int localBase, int returnBase, int nArguments) {
        Coroutine coroutine = this.currentCoroutine;
        LuaCallFrame callFrame = coroutine.pushNewCallFrame(null, f, localBase, returnBase, nArguments, false, false);
        int nReturnValues = f.call(callFrame, nArguments);
        int top = callFrame.getTop();
        int actualReturnBase = top - nReturnValues;
        int diff = returnBase - localBase;
        callFrame.stackCopy(actualReturnBase, diff, nReturnValues);
        callFrame.setTop(nReturnValues + diff);
        coroutine.popCallFrame();
        return nReturnValues;
    }

    private final Object prepareMetatableCall(Object o) {
        if (o instanceof JavaFunction || o instanceof LuaClosure) {
            return o;
        }
        Object f = this.getMetaOp(o, "__call");
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void luaMainloop() {
        LuaCallFrame callFrame = this.currentCoroutine.currentCallFrame();
        LuaClosure closure = callFrame.closure;
        Prototype prototype = closure.prototype;
        int[] opcodes = prototype.code;
        int returnBase = callFrame.returnBase;
        block39: while (true) {
            try {
                while (true) {
                    int op = opcodes[callFrame.pc++];
                    int opcode = op & 0x3F;
                    switch (opcode) {
                        case 0: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            callFrame.set(a, callFrame.get(b));
                            break;
                        }
                        case 1: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getBx(op);
                            callFrame.set(a, prototype.constants[b]);
                            break;
                        }
                        case 2: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            Boolean bool = b == 0 ? Boolean.FALSE : Boolean.TRUE;
                            callFrame.set(a, bool);
                            if (c == 0) break;
                            ++callFrame.pc;
                            break;
                        }
                        case 3: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            callFrame.stackClear(a, b);
                            break;
                        }
                        case 4: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            UpValue uv = closure.upvalues[b];
                            callFrame.set(a, uv.getValue());
                            break;
                        }
                        case 5: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getBx(op);
                            Object res = this.tableGet(closure.env, prototype.constants[b]);
                            callFrame.set(a, res);
                            break;
                        }
                        case 6: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            Object bObj = callFrame.get(b);
                            Object key = this.getRegisterOrConstant(callFrame, c, prototype);
                            Object res = this.tableGet(bObj, key);
                            callFrame.set(a, res);
                            break;
                        }
                        case 7: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getBx(op);
                            Object value = callFrame.get(a);
                            Object key = prototype.constants[b];
                            this.tableSet(closure.env, key, value);
                            break;
                        }
                        case 8: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            UpValue uv = closure.upvalues[b];
                            uv.setValue(callFrame.get(a));
                            break;
                        }
                        case 9: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            Object aObj = callFrame.get(a);
                            Object key = this.getRegisterOrConstant(callFrame, b, prototype);
                            Object value = this.getRegisterOrConstant(callFrame, c, prototype);
                            this.tableSet(aObj, key, value);
                            break;
                        }
                        case 10: {
                            int a = KahluaThread.getA8(op);
                            KahluaTable t = this.platform.newTable();
                            callFrame.set(a, t);
                            break;
                        }
                        case 11: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            Object key = this.getRegisterOrConstant(callFrame, c, prototype);
                            Object bObj = callFrame.get(b);
                            Object fun = this.tableGet(bObj, key);
                            callFrame.set(a, fun);
                            callFrame.set(a + 1, bObj);
                            break;
                        }
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            Object bo = this.getRegisterOrConstant(callFrame, b, prototype);
                            Object co = this.getRegisterOrConstant(callFrame, c, prototype);
                            Double bd = null;
                            Double cd = null;
                            Object res = null;
                            bd = KahluaUtil.rawTonumber(bo);
                            if (bd == null || (cd = KahluaUtil.rawTonumber(co)) == null) {
                                String meta_op = meta_ops[opcode];
                                Object metafun = this.getBinMetaOp(bo, co, meta_op);
                                if (metafun == null) {
                                    KahluaUtil.fail(meta_op + " not defined for operands");
                                }
                                res = this.call(metafun, bo, co, null);
                            } else {
                                res = this.primitiveMath(bd, cd, opcode);
                            }
                            callFrame.set(a, res);
                            break;
                        }
                        case 18: {
                            Object res;
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            Object aObj = callFrame.get(b);
                            Double aDouble = KahluaUtil.rawTonumber(aObj);
                            if (aDouble != null) {
                                res = KahluaUtil.toDouble(-KahluaUtil.fromDouble(aDouble));
                            } else {
                                Object metafun = this.getMetaOp(aObj, "__unm");
                                res = this.call(metafun, aObj, null, null);
                            }
                            callFrame.set(a, res);
                            break;
                        }
                        case 19: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            Object aObj = callFrame.get(b);
                            callFrame.set(a, KahluaUtil.toBoolean(!KahluaUtil.boolEval(aObj)));
                            break;
                        }
                        case 20: {
                            Object res;
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            Object o = callFrame.get(b);
                            if (o instanceof KahluaTable) {
                                KahluaTable t = (KahluaTable)o;
                                res = KahluaUtil.toDouble(t.len());
                            } else if (o instanceof String) {
                                String s = (String)o;
                                res = KahluaUtil.toDouble(s.length());
                            } else {
                                Object f = this.getMetaOp(o, "__len");
                                KahluaUtil.luaAssert(f != null, "__len not defined for operand");
                                res = this.call(f, o, null, null);
                            }
                            callFrame.set(a, res);
                            break;
                        }
                        case 21: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            int first = b;
                            int last = c;
                            Object res = callFrame.get(last);
                            --last;
                            while (first <= last) {
                                String resStr = KahluaUtil.rawTostring(res);
                                if (resStr != null) {
                                    int nStrings = 0;
                                    int pos = last;
                                    while (first <= pos) {
                                        Object o = callFrame.get(pos);
                                        --pos;
                                        if (KahluaUtil.rawTostring(o) == null) break;
                                        ++nStrings;
                                    }
                                    if (nStrings > 0) {
                                        StringBuffer concatBuffer = new StringBuffer();
                                        for (int firstString = last - nStrings + 1; firstString <= last; ++firstString) {
                                            concatBuffer.append(KahluaUtil.rawTostring(callFrame.get(firstString)));
                                        }
                                        concatBuffer.append(resStr);
                                        res = concatBuffer.toString();
                                        last -= nStrings;
                                    }
                                }
                                if (first > last) continue;
                                Object leftConcat = callFrame.get(last);
                                Object metafun = this.getBinMetaOp(leftConcat, res, "__concat");
                                if (metafun == null) {
                                    KahluaUtil.fail("__concat not defined for operands: " + leftConcat + " and " + res);
                                }
                                res = this.call(metafun, leftConcat, res, null);
                                --last;
                            }
                            callFrame.set(a, res);
                            break;
                        }
                        case 22: {
                            callFrame.pc += KahluaThread.getSBx(op);
                            break;
                        }
                        case 23: 
                        case 24: 
                        case 25: {
                            boolean resBool;
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            Object bo = this.getRegisterOrConstant(callFrame, b, prototype);
                            Object co = this.getRegisterOrConstant(callFrame, c, prototype);
                            if (bo instanceof Double && co instanceof Double) {
                                double bd_primitive = KahluaUtil.fromDouble(bo);
                                double cd_primitive = KahluaUtil.fromDouble(co);
                                if (opcode == 23) {
                                    if (bd_primitive == cd_primitive != (a == 0)) continue block39;
                                    ++callFrame.pc;
                                    break;
                                }
                                if (opcode == 24) {
                                    if (bd_primitive < cd_primitive != (a == 0)) continue block39;
                                    ++callFrame.pc;
                                    break;
                                }
                                if (bd_primitive <= cd_primitive != (a == 0)) continue block39;
                                ++callFrame.pc;
                                break;
                            }
                            if (bo instanceof String && co instanceof String) {
                                if (opcode == 23) {
                                    if (bo.equals(co) != (a == 0)) break;
                                    ++callFrame.pc;
                                    break;
                                }
                                String bs = (String)bo;
                                String cs = (String)co;
                                int cmp = bs.compareTo(cs);
                                if (opcode == 24) {
                                    if (cmp < 0 != (a == 0)) continue block39;
                                    ++callFrame.pc;
                                    break;
                                }
                                if (cmp <= 0 != (a == 0)) continue block39;
                                ++callFrame.pc;
                                break;
                            }
                            if (bo == co && opcode == 23) {
                                resBool = true;
                            } else {
                                boolean invert = false;
                                String meta_op = meta_ops[opcode];
                                Object metafun = this.getCompMetaOp(bo, co, meta_op);
                                if (metafun == null && opcode == 25) {
                                    metafun = this.getCompMetaOp(bo, co, "__lt");
                                    Object tmp = bo;
                                    bo = co;
                                    co = tmp;
                                    invert = true;
                                }
                                if (metafun == null && opcode == 23) {
                                    resBool = BaseLib.luaEquals(bo, co);
                                } else {
                                    if (metafun == null) {
                                        KahluaUtil.fail(meta_op + " not defined for operand");
                                    }
                                    Object res = this.call(metafun, bo, co, null);
                                    resBool = KahluaUtil.boolEval(res);
                                }
                                if (invert) {
                                    resBool = !resBool;
                                }
                            }
                            if (resBool != (a == 0)) continue block39;
                            ++callFrame.pc;
                            break;
                        }
                        case 26: {
                            int a = KahluaThread.getA8(op);
                            int c = KahluaThread.getC9(op);
                            Object value = callFrame.get(a);
                            if (KahluaUtil.boolEval(value) != (c == 0)) break;
                            ++callFrame.pc;
                            break;
                        }
                        case 27: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            Object value = callFrame.get(b);
                            if (KahluaUtil.boolEval(value) != (c == 0)) {
                                callFrame.set(a, value);
                                break;
                            }
                            ++callFrame.pc;
                            break;
                        }
                        case 28: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            int nArguments2 = b - 1;
                            if (nArguments2 != -1) {
                                callFrame.setTop(a + nArguments2 + 1);
                            } else {
                                nArguments2 = callFrame.getTop() - a - 1;
                            }
                            callFrame.restoreTop = c != 0;
                            int base = callFrame.localBase;
                            int localBase2 = base + a + 1;
                            int returnBase2 = base + a;
                            Object funObject = callFrame.get(a);
                            KahluaUtil.luaAssert(funObject != null, "Tried to call nil");
                            Object fun = this.prepareMetatableCall(funObject);
                            if (fun == null) {
                                KahluaUtil.fail("Object " + funObject + " did not have __call metatable set");
                            }
                            if (fun != funObject) {
                                localBase2 = returnBase2;
                                ++nArguments2;
                            }
                            if (fun instanceof LuaClosure) {
                                LuaCallFrame newCallFrame = this.currentCoroutine.pushNewCallFrame((LuaClosure)fun, null, localBase2, returnBase2, nArguments2, true, callFrame.canYield);
                                newCallFrame.init();
                                callFrame = newCallFrame;
                                closure = newCallFrame.closure;
                                prototype = closure.prototype;
                                opcodes = prototype.code;
                                returnBase = callFrame.returnBase;
                                break;
                            }
                            if (!(fun instanceof JavaFunction)) throw new RuntimeException("Tried to call a non-function: " + fun);
                            this.callJava((JavaFunction)fun, localBase2, returnBase2, nArguments2);
                            callFrame = this.currentCoroutine.currentCallFrame();
                            if (callFrame == null || callFrame.isJava()) {
                                return;
                            }
                            closure = callFrame.closure;
                            prototype = closure.prototype;
                            opcodes = prototype.code;
                            returnBase = callFrame.returnBase;
                            if (!callFrame.restoreTop) break;
                            callFrame.setTop(prototype.maxStacksize);
                            break;
                        }
                        case 29: {
                            int base = callFrame.localBase;
                            this.currentCoroutine.closeUpvalues(base);
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int nArguments2 = b - 1;
                            if (nArguments2 == -1) {
                                nArguments2 = callFrame.getTop() - a - 1;
                            }
                            callFrame.restoreTop = false;
                            Object funObject = callFrame.get(a);
                            KahluaUtil.luaAssert(funObject != null, "Tried to call nil");
                            Object fun = this.prepareMetatableCall(funObject);
                            if (fun == null) {
                                KahluaUtil.fail("Object " + funObject + " did not have __call metatable set");
                            }
                            int localBase2 = returnBase + 1;
                            if (fun != funObject) {
                                localBase2 = returnBase;
                                ++nArguments2;
                            }
                            this.currentCoroutine.stackCopy(base + a, returnBase, nArguments2 + 1);
                            this.currentCoroutine.setTop(returnBase + nArguments2 + 1);
                            if (fun instanceof LuaClosure) {
                                callFrame.localBase = localBase2;
                                callFrame.nArguments = nArguments2;
                                callFrame.closure = (LuaClosure)fun;
                                callFrame.init();
                            } else {
                                if (!(fun instanceof JavaFunction)) {
                                    KahluaUtil.fail("Tried to call a non-function: " + fun);
                                }
                                Coroutine oldCoroutine = this.currentCoroutine;
                                this.callJava((JavaFunction)fun, localBase2, returnBase, nArguments2);
                                callFrame = this.currentCoroutine.currentCallFrame();
                                oldCoroutine.popCallFrame();
                                if (oldCoroutine != this.currentCoroutine) {
                                    if (oldCoroutine.isDead() && oldCoroutine != this.rootCoroutine && this.currentCoroutine.getParent() == oldCoroutine) {
                                        this.currentCoroutine.resume(oldCoroutine.getParent());
                                        oldCoroutine.destroy();
                                        this.currentCoroutine.getParent().currentCallFrame().push(Boolean.TRUE);
                                    }
                                    if ((callFrame = this.currentCoroutine.currentCallFrame()).isJava()) {
                                        return;
                                    }
                                } else {
                                    if (!callFrame.fromLua) {
                                        return;
                                    }
                                    callFrame = this.currentCoroutine.currentCallFrame();
                                    if (callFrame.restoreTop) {
                                        callFrame.setTop(callFrame.closure.prototype.maxStacksize);
                                    }
                                }
                            }
                            closure = callFrame.closure;
                            prototype = closure.prototype;
                            opcodes = prototype.code;
                            returnBase = callFrame.returnBase;
                            break;
                        }
                        case 30: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op) - 1;
                            int base = callFrame.localBase;
                            this.currentCoroutine.closeUpvalues(base);
                            if (b == -1) {
                                b = callFrame.getTop() - a;
                            }
                            this.currentCoroutine.stackCopy(callFrame.localBase + a, returnBase, b);
                            this.currentCoroutine.setTop(returnBase + b);
                            if (callFrame.fromLua) {
                                if (callFrame.canYield && this.currentCoroutine.atBottom()) {
                                    callFrame.localBase = callFrame.returnBase;
                                    Coroutine coroutine = this.currentCoroutine;
                                    Coroutine.yieldHelper(callFrame, callFrame, b);
                                    coroutine.popCallFrame();
                                    callFrame = this.currentCoroutine.currentCallFrame();
                                    if (callFrame == null || callFrame.isJava()) {
                                        return;
                                    }
                                } else {
                                    this.currentCoroutine.popCallFrame();
                                }
                                callFrame = this.currentCoroutine.currentCallFrame();
                                closure = callFrame.closure;
                                prototype = closure.prototype;
                                opcodes = prototype.code;
                                returnBase = callFrame.returnBase;
                                if (!callFrame.restoreTop) break;
                                callFrame.setTop(prototype.maxStacksize);
                                break;
                            }
                            this.currentCoroutine.popCallFrame();
                            return;
                        }
                        case 32: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getSBx(op);
                            double iter = KahluaUtil.fromDouble(callFrame.get(a));
                            double step = KahluaUtil.fromDouble(callFrame.get(a + 2));
                            callFrame.set(a, KahluaUtil.toDouble(iter - step));
                            callFrame.pc += b;
                            break;
                        }
                        case 31: {
                            int b;
                            int a = KahluaThread.getA8(op);
                            double iter = KahluaUtil.fromDouble(callFrame.get(a));
                            double end = KahluaUtil.fromDouble(callFrame.get(a + 1));
                            double step = KahluaUtil.fromDouble(callFrame.get(a + 2));
                            Double iterDouble = KahluaUtil.toDouble(iter += step);
                            callFrame.set(a, iterDouble);
                            if (step > 0.0 ? iter <= end : iter >= end) {
                                b = KahluaThread.getSBx(op);
                                callFrame.pc += b;
                                callFrame.set(a + 3, iterDouble);
                                break;
                            }
                            callFrame.clearFromIndex(a);
                            break;
                        }
                        case 33: {
                            int a = KahluaThread.getA8(op);
                            int c = KahluaThread.getC9(op);
                            callFrame.setTop(a + 6);
                            callFrame.stackCopy(a, a + 3, 3);
                            this.call(2);
                            callFrame.clearFromIndex(a + 3 + c);
                            callFrame.setPrototypeStacksize();
                            Object aObj3 = callFrame.get(a + 3);
                            if (aObj3 != null) {
                                callFrame.set(a + 2, aObj3);
                                break;
                            }
                            ++callFrame.pc;
                            break;
                        }
                        case 34: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op);
                            int c = KahluaThread.getC9(op);
                            if (b == 0) {
                                b = callFrame.getTop() - a - 1;
                            }
                            if (c == 0) {
                                c = opcodes[callFrame.pc++];
                            }
                            int offset = (c - 1) * 50;
                            KahluaTable t = (KahluaTable)callFrame.get(a);
                            int i = 1;
                            while (true) {
                                if (i > b) continue block39;
                                Double key = KahluaUtil.toDouble(offset + i);
                                Object value = callFrame.get(a + i);
                                t.rawset(key, value);
                                ++i;
                            }
                        }
                        case 35: {
                            int a = KahluaThread.getA8(op);
                            callFrame.closeUpvalues(a);
                            break;
                        }
                        case 36: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getBx(op);
                            Prototype newPrototype = prototype.prototypes[b];
                            LuaClosure newClosure = new LuaClosure(newPrototype, closure.env);
                            callFrame.set(a, newClosure);
                            int numUpvalues = newPrototype.numUpvalues;
                            int i = 0;
                            while (true) {
                                if (i >= numUpvalues) continue block39;
                                op = opcodes[callFrame.pc++];
                                opcode = op & 0x3F;
                                b = KahluaThread.getB9(op);
                                switch (opcode) {
                                    case 0: {
                                        newClosure.upvalues[i] = callFrame.findUpvalue(b);
                                        break;
                                    }
                                    case 4: {
                                        newClosure.upvalues[i] = closure.upvalues[b];
                                        break;
                                    }
                                }
                                ++i;
                            }
                        }
                        case 37: {
                            int a = KahluaThread.getA8(op);
                            int b = KahluaThread.getB9(op) - 1;
                            callFrame.pushVarargs(a, b);
                            break;
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                while ((callFrame = this.currentCoroutine.currentCallFrame()) != null && !callFrame.isLua()) {
                    this.currentCoroutine.addStackTrace(callFrame);
                    this.currentCoroutine.popCallFrame();
                }
                boolean rethrow = true;
                do {
                    if ((callFrame = this.currentCoroutine.currentCallFrame()) == null) {
                        Coroutine parent = this.currentCoroutine.getParent();
                        if (parent == null) break;
                        LuaCallFrame nextCallFrame = parent.currentCallFrame();
                        nextCallFrame.push(Boolean.FALSE);
                        nextCallFrame.push(e.getMessage());
                        nextCallFrame.push(this.currentCoroutine.stackTrace);
                        this.currentCoroutine.destroy();
                        this.currentCoroutine = parent;
                        callFrame = this.currentCoroutine.currentCallFrame();
                        closure = callFrame.closure;
                        prototype = closure.prototype;
                        opcodes = prototype.code;
                        returnBase = callFrame.returnBase;
                        rethrow = false;
                        break;
                    }
                    this.currentCoroutine.addStackTrace(callFrame);
                    this.currentCoroutine.popCallFrame();
                } while (callFrame.fromLua);
                if (callFrame != null) {
                    callFrame.closeUpvalues(0);
                }
                if (rethrow) throw e;
                continue;
            }
            break;
        }
    }

    protected Object getMetaOp(Object o, String meta_op) {
        KahluaTable meta = (KahluaTable)this.getmetatable(o, true);
        if (meta == null) {
            return null;
        }
        return meta.rawget(meta_op);
    }

    private final Object getCompMetaOp(Object a, Object b, String meta_op) {
        Object meta_operator2;
        KahluaTable meta1 = (KahluaTable)this.getmetatable(a, true);
        KahluaTable meta2 = (KahluaTable)this.getmetatable(b, true);
        if (meta1 == null || meta2 == null) {
            return null;
        }
        Object meta_operator1 = meta1.rawget(meta_op);
        if (meta_operator1 != (meta_operator2 = meta2.rawget(meta_op)) || meta_operator1 == null) {
            return null;
        }
        return meta_operator1;
    }

    private final Object getBinMetaOp(Object a, Object b, String meta_op) {
        Object op = this.getMetaOp(a, meta_op);
        if (op != null) {
            return op;
        }
        return this.getMetaOp(b, meta_op);
    }

    private final Object getRegisterOrConstant(LuaCallFrame callFrame, int index, Prototype prototype) {
        int cindex = index - 256;
        if (cindex < 0) {
            return callFrame.get(index);
        }
        return prototype.constants[cindex];
    }

    private static final int getA8(int op) {
        return op >>> 6 & 0xFF;
    }

    private static final int getC9(int op) {
        return op >>> 14 & 0x1FF;
    }

    private static final int getB9(int op) {
        return op >>> 23 & 0x1FF;
    }

    private static final int getBx(int op) {
        return op >>> 14;
    }

    private static final int getSBx(int op) {
        return (op >>> 14) - 131071;
    }

    private Double primitiveMath(Double x, Double y, int opcode) {
        double v1 = KahluaUtil.fromDouble(x);
        double v2 = KahluaUtil.fromDouble(y);
        double res = 0.0;
        switch (opcode) {
            case 12: {
                res = v1 + v2;
                break;
            }
            case 13: {
                res = v1 - v2;
                break;
            }
            case 14: {
                res = v1 * v2;
                break;
            }
            case 15: {
                res = v1 / v2;
                break;
            }
            case 16: {
                if (v2 == 0.0) {
                    res = Double.NaN;
                    break;
                }
                int ipart = (int)(v1 / v2);
                res = v1 - (double)ipart * v2;
                break;
            }
            case 17: {
                res = this.platform.pow(v1, v2);
                break;
            }
        }
        return KahluaUtil.toDouble(res);
    }

    public Object call(Object fun, Object arg1, Object arg2, Object arg3) {
        int oldTop = this.currentCoroutine.getTop();
        int argslen = 3;
        this.currentCoroutine.setTop(oldTop + 1 + 3);
        this.currentCoroutine.objectStack[oldTop] = fun;
        this.currentCoroutine.objectStack[oldTop + 1] = arg1;
        this.currentCoroutine.objectStack[oldTop + 2] = arg2;
        this.currentCoroutine.objectStack[oldTop + 3] = arg3;
        int nReturnValues = this.call(3);
        Object ret = null;
        if (nReturnValues >= 1) {
            ret = this.currentCoroutine.objectStack[oldTop];
        }
        this.currentCoroutine.setTop(oldTop);
        return ret;
    }

    public Object call(Object fun, Object[] args) {
        int oldTop = this.currentCoroutine.getTop();
        int argslen = args == null ? 0 : args.length;
        this.currentCoroutine.setTop(oldTop + 1 + argslen);
        this.currentCoroutine.objectStack[oldTop] = fun;
        for (int i = 1; i <= argslen; ++i) {
            this.currentCoroutine.objectStack[oldTop + i] = args[i - 1];
        }
        int nReturnValues = this.call(argslen);
        Object ret = null;
        if (nReturnValues >= 1) {
            ret = this.currentCoroutine.objectStack[oldTop];
        }
        this.currentCoroutine.setTop(oldTop);
        return ret;
    }

    public Object tableGet(Object table, Object key) {
        Object curObj = table;
        for (int i = 100; i > 0; --i) {
            KahluaTable t;
            Object res;
            boolean isTable = curObj instanceof KahluaTable;
            if (isTable && (res = (t = (KahluaTable)curObj).rawget(key)) != null) {
                return res;
            }
            Object metaOp = this.getMetaOp(curObj, "__index");
            if (metaOp == null) {
                if (isTable) {
                    return null;
                }
                throw new RuntimeException("attempted index of non-table: " + curObj);
            }
            if (metaOp instanceof JavaFunction || metaOp instanceof LuaClosure) {
                res = this.call(metaOp, table, key, null);
                return res;
            }
            curObj = metaOp;
        }
        throw new RuntimeException("loop in gettable");
    }

    public void tableSet(Object table, Object key, Object value) {
        Object curObj = table;
        for (int i = 100; i > 0; --i) {
            Object metaOp;
            if (curObj instanceof KahluaTable) {
                KahluaTable t = (KahluaTable)curObj;
                if (t.rawget(key) != null) {
                    t.rawset(key, value);
                    return;
                }
                metaOp = this.getMetaOp(curObj, "__newindex");
                if (metaOp == null) {
                    t.rawset(key, value);
                    return;
                }
            } else {
                metaOp = this.getMetaOp(curObj, "__newindex");
                KahluaUtil.luaAssert(metaOp != null, "attempted index of non-table");
            }
            if (metaOp instanceof JavaFunction || metaOp instanceof LuaClosure) {
                this.call(metaOp, table, key, value);
                return;
            }
            curObj = metaOp;
        }
        throw new RuntimeException("loop in settable");
    }

    public void setmetatable(Object o, KahluaTable metatable) {
        KahluaUtil.luaAssert(o != null, "Can't set metatable for nil");
        if (o instanceof KahluaTable) {
            KahluaTable t = (KahluaTable)o;
            t.setMetatable(metatable);
        } else {
            KahluaUtil.fail("Could not set metatable for object");
        }
    }

    public Object getmetatable(Object o, boolean raw) {
        Object meta2;
        if (o == null) {
            return null;
        }
        KahluaTable metatable = null;
        if (o instanceof KahluaTable) {
            KahluaTable t = (KahluaTable)o;
            metatable = t.getMetatable();
        } else if (metatable == null) {
            KahluaTable metatables = KahluaUtil.getClassMetatables(this.platform, this.getEnvironment());
            metatable = (KahluaTable)this.tableGet(metatables, o.getClass());
        }
        if (!raw && metatable != null && (meta2 = metatable.rawget("__metatable")) != null) {
            return meta2;
        }
        return metatable;
    }

    public Object[] pcall(Object fun, Object[] args) {
        int nArgs = args == null ? 0 : args.length;
        Coroutine coroutine = this.currentCoroutine;
        int oldTop = coroutine.getTop();
        coroutine.setTop(oldTop + 1 + nArgs);
        coroutine.objectStack[oldTop] = fun;
        if (nArgs > 0) {
            System.arraycopy(args, 0, coroutine.objectStack, oldTop + 1, nArgs);
        }
        int nRet = this.pcall(nArgs);
        KahluaUtil.luaAssert(coroutine == this.currentCoroutine, "Internal Kahlua error - coroutine changed in pcall");
        Object[] ret = new Object[nRet];
        System.arraycopy(coroutine.objectStack, oldTop, ret, 0, nRet);
        coroutine.setTop(oldTop);
        return ret;
    }

    public Object[] pcall(Object fun) {
        return this.pcall(fun, null);
    }

    public int pcall(int nArguments) {
        Object errorMessage;
        Throwable exception;
        Coroutine coroutine = this.currentCoroutine;
        LuaCallFrame currentCallFrame = coroutine.currentCallFrame();
        coroutine.stackTrace = "";
        int oldBase = coroutine.getTop() - nArguments - 1;
        try {
            int oldCallframetop = coroutine.getCallframeTop();
            int nValues = this.call(nArguments);
            int newCallframeTop = coroutine.getCallframeTop();
            KahluaUtil.luaAssert(oldCallframetop == newCallframeTop, "error - call stack depth changed.");
            int newTop = oldBase + nValues + 1;
            coroutine.setTop(newTop);
            coroutine.stackCopy(oldBase, oldBase + 1, nValues);
            coroutine.objectStack[oldBase] = Boolean.TRUE;
            return 1 + nValues;
        }
        catch (KahluaException e) {
            exception = e;
            errorMessage = e.errorMessage;
        }
        catch (Throwable e) {
            exception = e;
            errorMessage = e.getMessage();
        }
        KahluaUtil.luaAssert(coroutine == this.currentCoroutine, "Internal Kahlua error - coroutine changed in pcall");
        if (currentCallFrame != null) {
            currentCallFrame.closeUpvalues(0);
        }
        coroutine.cleanCallFrames(currentCallFrame);
        if (errorMessage instanceof String) {
            errorMessage = (String)errorMessage;
        }
        coroutine.setTop(oldBase + 4);
        coroutine.objectStack[oldBase] = Boolean.FALSE;
        coroutine.objectStack[oldBase + 1] = errorMessage;
        coroutine.objectStack[oldBase + 2] = coroutine.stackTrace;
        coroutine.objectStack[oldBase + 3] = exception;
        coroutine.stackTrace = "";
        return 4;
    }

    public KahluaTable getEnvironment() {
        return this.currentCoroutine.environment;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    static {
        KahluaThread.meta_ops[12] = "__add";
        KahluaThread.meta_ops[13] = "__sub";
        KahluaThread.meta_ops[14] = "__mul";
        KahluaThread.meta_ops[15] = "__div";
        KahluaThread.meta_ops[16] = "__mod";
        KahluaThread.meta_ops[17] = "__pow";
        KahluaThread.meta_ops[23] = "__eq";
        KahluaThread.meta_ops[24] = "__lt";
        KahluaThread.meta_ops[25] = "__le";
    }
}

