/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.vm;

import java.util.Vector;
import lc.repack.se.krka.kahlua.vm.JavaFunction;
import lc.repack.se.krka.kahlua.vm.KahluaTable;
import lc.repack.se.krka.kahlua.vm.KahluaThread;
import lc.repack.se.krka.kahlua.vm.KahluaUtil;
import lc.repack.se.krka.kahlua.vm.LuaCallFrame;
import lc.repack.se.krka.kahlua.vm.LuaClosure;
import lc.repack.se.krka.kahlua.vm.Platform;
import lc.repack.se.krka.kahlua.vm.UpValue;

public class Coroutine {
    private final Platform platform;
    private KahluaThread thread;
    private Coroutine parent;
    public KahluaTable environment;
    public String stackTrace = "";
    private final Vector liveUpvalues = new Vector();
    private static final int MAX_STACK_SIZE = 1000;
    private static final int INITIAL_STACK_SIZE = 10;
    private static final int MAX_CALL_FRAME_STACK_SIZE = 100;
    private static final int INITIAL_CALL_FRAME_STACK_SIZE = 10;
    public Object[] objectStack;
    private int top;
    private LuaCallFrame[] callFrameStack;
    private int callFrameTop;

    public Coroutine() {
        this.platform = null;
    }

    public Coroutine(Platform platform, KahluaTable environment, KahluaThread thread) {
        this.platform = platform;
        this.environment = environment;
        this.thread = thread;
        this.objectStack = new Object[10];
        this.callFrameStack = new LuaCallFrame[10];
    }

    public Coroutine(Platform platform, KahluaTable environment) {
        this(platform, environment, null);
    }

    public final LuaCallFrame pushNewCallFrame(LuaClosure closure, JavaFunction javaFunction, int localBase, int returnBase, int nArguments, boolean fromLua, boolean insideCoroutine) {
        this.setCallFrameStackTop(this.callFrameTop + 1);
        LuaCallFrame callFrame = this.currentCallFrame();
        callFrame.setup(closure, javaFunction, localBase, returnBase, nArguments, fromLua, insideCoroutine);
        return callFrame;
    }

    public void popCallFrame() {
        if (this.isDead()) {
            throw new RuntimeException("Stack underflow");
        }
        this.setCallFrameStackTop(this.callFrameTop - 1);
    }

    private final void ensureCallFrameStackSize(int index) {
        int oldSize;
        int newSize;
        if (index > 100) {
            throw new RuntimeException("Stack overflow");
        }
        for (newSize = oldSize = this.callFrameStack.length; newSize <= index; newSize = 2 * newSize) {
        }
        if (newSize > oldSize) {
            LuaCallFrame[] newStack = new LuaCallFrame[newSize];
            System.arraycopy(this.callFrameStack, 0, newStack, 0, oldSize);
            this.callFrameStack = newStack;
        }
    }

    public final void setCallFrameStackTop(int newTop) {
        if (newTop > this.callFrameTop) {
            this.ensureCallFrameStackSize(newTop);
        } else {
            this.callFrameStackClear(newTop, this.callFrameTop - 1);
        }
        this.callFrameTop = newTop;
    }

    private void callFrameStackClear(int startIndex, int endIndex) {
        while (startIndex <= endIndex) {
            LuaCallFrame callFrame = this.callFrameStack[startIndex];
            if (callFrame != null) {
                this.callFrameStack[startIndex].closure = null;
                this.callFrameStack[startIndex].javaFunction = null;
            }
            ++startIndex;
        }
    }

    private final void ensureStacksize(int index) {
        int oldSize;
        int newSize;
        if (index > 1000) {
            throw new RuntimeException("Stack overflow");
        }
        for (newSize = oldSize = this.objectStack.length; newSize <= index; newSize = 2 * newSize) {
        }
        if (newSize > oldSize) {
            Object[] newStack = new Object[newSize];
            System.arraycopy(this.objectStack, 0, newStack, 0, oldSize);
            this.objectStack = newStack;
        }
    }

    public final void setTop(int newTop) {
        if (this.top < newTop) {
            this.ensureStacksize(newTop);
        } else {
            this.stackClear(newTop, this.top - 1);
        }
        this.top = newTop;
    }

    public final void stackCopy(int startIndex, int destIndex, int len) {
        if (len > 0 && startIndex != destIndex) {
            System.arraycopy(this.objectStack, startIndex, this.objectStack, destIndex, len);
        }
    }

    public final void stackClear(int startIndex, int endIndex) {
        while (startIndex <= endIndex) {
            this.objectStack[startIndex] = null;
            ++startIndex;
        }
    }

    public final void closeUpvalues(int closeIndex) {
        int loopIndex = this.liveUpvalues.size();
        while (--loopIndex >= 0) {
            UpValue uv = (UpValue)this.liveUpvalues.elementAt(loopIndex);
            if (uv.getIndex() < closeIndex) {
                return;
            }
            uv.close();
            this.liveUpvalues.removeElementAt(loopIndex);
        }
    }

    public final UpValue findUpvalue(int scanIndex) {
        UpValue uv;
        int loopIndex = this.liveUpvalues.size();
        while (--loopIndex >= 0) {
            uv = (UpValue)this.liveUpvalues.elementAt(loopIndex);
            int index = uv.getIndex();
            if (index == scanIndex) {
                return uv;
            }
            if (index >= scanIndex) continue;
            break;
        }
        uv = new UpValue(this, scanIndex);
        this.liveUpvalues.insertElementAt(uv, loopIndex + 1);
        return uv;
    }

    public final LuaCallFrame currentCallFrame() {
        if (this.isDead()) {
            return null;
        }
        LuaCallFrame callFrame = this.callFrameStack[this.callFrameTop - 1];
        if (callFrame == null) {
            this.callFrameStack[this.callFrameTop - 1] = callFrame = new LuaCallFrame(this);
        }
        return callFrame;
    }

    public int getTop() {
        return this.top;
    }

    public LuaCallFrame getParent(int level) {
        KahluaUtil.luaAssert(level >= 0, "Level must be non-negative");
        int index = this.callFrameTop - level - 1;
        KahluaUtil.luaAssert(index >= 0, "Level too high");
        return this.callFrameStack[index];
    }

    public String getCurrentStackTrace(int level, int count, int haltAt) {
        if (level < 0) {
            level = 0;
        }
        if (count < 0) {
            count = 0;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = this.callFrameTop - 1 - level; i >= haltAt && count-- > 0; --i) {
            buffer.append(this.getStackTrace(this.callFrameStack[i]));
        }
        return buffer.toString();
    }

    public void cleanCallFrames(LuaCallFrame callerFrame) {
        LuaCallFrame frame;
        while ((frame = this.currentCallFrame()) != null && frame != callerFrame) {
            this.addStackTrace(frame);
            this.popCallFrame();
        }
    }

    public void addStackTrace(LuaCallFrame frame) {
        this.stackTrace = this.stackTrace + this.getStackTrace(frame);
    }

    private String getStackTrace(LuaCallFrame frame) {
        if (frame.isLua()) {
            int pc;
            int[] lines = frame.closure.prototype.lines;
            if (lines != null && (pc = frame.pc - 1) >= 0 && pc < lines.length) {
                return "at " + frame.closure.prototype + ":" + lines[pc] + "\n";
            }
        } else {
            return "at " + frame.javaFunction + "\n";
        }
        return "";
    }

    public boolean isDead() {
        return this.callFrameTop == 0;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getStatus() {
        if (this.parent == null) {
            if (this.isDead()) {
                return "dead";
            }
            return "suspended";
        }
        return "normal";
    }

    public boolean atBottom() {
        return this.callFrameTop == 1;
    }

    public int getCallframeTop() {
        return this.callFrameTop;
    }

    public LuaCallFrame[] getCallframeStack() {
        return this.callFrameStack;
    }

    public LuaCallFrame getCallFrame(int index) {
        if (index < 0) {
            index += this.callFrameTop;
        }
        return this.callFrameStack[index];
    }

    public static void yieldHelper(LuaCallFrame callFrame, LuaCallFrame argsCallFrame, int nArguments) {
        KahluaUtil.luaAssert(callFrame.canYield, "Can not yield outside of a coroutine");
        Coroutine coroutine = callFrame.coroutine;
        KahluaThread thread = coroutine.getThread();
        Coroutine parent = coroutine.parent;
        KahluaUtil.luaAssert(parent != null, "Internal error, coroutine must be running");
        KahluaUtil.luaAssert(coroutine == thread.currentCoroutine, "Internal error, must yield current thread");
        coroutine.destroy();
        LuaCallFrame nextCallFrame = parent.currentCallFrame();
        if (nextCallFrame == null) {
            parent.setTop(nArguments + 1);
            parent.objectStack[0] = Boolean.TRUE;
            for (int i = 0; i < nArguments; ++i) {
                parent.objectStack[i + 1] = argsCallFrame.get(i);
            }
        } else {
            nextCallFrame.push(Boolean.TRUE);
            for (int i = 0; i < nArguments; ++i) {
                Object value = argsCallFrame.get(i);
                nextCallFrame.push(value);
            }
        }
        thread.currentCoroutine = parent;
    }

    public void resume(Coroutine parent) {
        this.parent = parent;
        this.thread = parent.thread;
    }

    public KahluaThread getThread() {
        return this.thread;
    }

    public Coroutine getParent() {
        return this.parent;
    }

    public void destroy() {
        this.parent = null;
        this.thread = null;
    }
}

