/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.stdlib;

import lc.repack.se.krka.kahlua.vm.JavaFunction;
import lc.repack.se.krka.kahlua.vm.KahluaArray;
import lc.repack.se.krka.kahlua.vm.KahluaTable;
import lc.repack.se.krka.kahlua.vm.KahluaTableIterator;
import lc.repack.se.krka.kahlua.vm.KahluaThread;
import lc.repack.se.krka.kahlua.vm.KahluaUtil;
import lc.repack.se.krka.kahlua.vm.LuaCallFrame;
import lc.repack.se.krka.kahlua.vm.Platform;

public final class TableLib
implements JavaFunction {
    private static final int CONCAT = 0;
    private static final int INSERT = 1;
    private static final int REMOVE = 2;
    private static final int NEWARRAY = 3;
    private static final int PAIRS = 4;
    private static final int ISEMPTY = 5;
    private static final int WIPE = 6;
    private static final int NUM_FUNCTIONS = 7;
    private static final String[] names = new String[7];
    private static final TableLib[] functions;
    private final int index;

    public TableLib(int index) {
        this.index = index;
    }

    public static void register(Platform platform, KahluaTable environment) {
        KahluaTable table = platform.newTable();
        for (int i = 0; i < 7; ++i) {
            table.rawset(names[i], (Object)functions[i]);
        }
        environment.rawset("table", (Object)table);
    }

    public String toString() {
        if (this.index < names.length) {
            return "table." + names[this.index];
        }
        return super.toString();
    }

    @Override
    public int call(LuaCallFrame callFrame, int nArguments) {
        switch (this.index) {
            case 0: {
                return TableLib.concat(callFrame, nArguments);
            }
            case 1: {
                return TableLib.insert(callFrame, nArguments);
            }
            case 2: {
                return TableLib.remove(callFrame, nArguments);
            }
            case 3: {
                return this.newarray(callFrame, nArguments);
            }
            case 4: {
                return this.pairs(callFrame, nArguments);
            }
            case 5: {
                return this.isempty(callFrame, nArguments);
            }
            case 6: {
                return this.wipe(callFrame, nArguments);
            }
        }
        return 0;
    }

    private int wipe(LuaCallFrame callFrame, int nArguments) {
        KahluaTable table = TableLib.getTable(callFrame, nArguments);
        table.wipe();
        return 0;
    }

    private int isempty(LuaCallFrame callFrame, int nArguments) {
        KahluaTable table = TableLib.getTable(callFrame, nArguments);
        return callFrame.push(KahluaUtil.toBoolean(table.isEmpty()));
    }

    private int pairs(LuaCallFrame callFrame, int nArguments) {
        KahluaUtil.luaAssert(nArguments >= 1, "Not enough arguments");
        Object o = callFrame.get(0);
        KahluaUtil.luaAssert(o instanceof KahluaTable, "Expected a table");
        KahluaTable t = (KahluaTable)o;
        return callFrame.push(t.iterator());
    }

    private int newarray(LuaCallFrame callFrame, int arguments) {
        Object param = KahluaUtil.getOptionalArg(callFrame, 1);
        KahluaArray ret = new KahluaArray();
        if (param instanceof KahluaTable && arguments == 1) {
            int n;
            KahluaTable t = (KahluaTable)param;
            for (int i = n = t.len(); i >= 1; --i) {
                ret.rawset(i, t.rawget(i));
            }
        } else {
            for (int i = arguments; i >= 1; --i) {
                ret.rawset(i, callFrame.get(i - 1));
            }
        }
        return callFrame.push(ret);
    }

    private static int concat(LuaCallFrame callFrame, int nArguments) {
        int last;
        KahluaTable table = TableLib.getTable(callFrame, nArguments);
        String separator = "";
        if (nArguments >= 2) {
            separator = KahluaUtil.rawTostring(callFrame.get(1));
        }
        int first = 1;
        if (nArguments >= 3) {
            Double firstDouble = KahluaUtil.rawTonumber(callFrame.get(2));
            first = firstDouble.intValue();
        }
        if (nArguments >= 4) {
            Double lastDouble = KahluaUtil.rawTonumber(callFrame.get(3));
            last = lastDouble.intValue();
        } else {
            last = table.len();
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = first; i <= last; ++i) {
            if (i > first) {
                buffer.append(separator);
            }
            Double key = KahluaUtil.toDouble(i);
            Object value = table.rawget(key);
            buffer.append(KahluaUtil.rawTostring(value));
        }
        return callFrame.push(buffer.toString());
    }

    public static void insert(KahluaThread state, KahluaTable table, Object element) {
        TableLib.append(state, table, element);
    }

    public static void append(KahluaThread state, KahluaTable table, Object element) {
        int position = 1 + table.len();
        state.tableSet(table, KahluaUtil.toDouble(position), element);
    }

    public static void rawappend(KahluaTable table, Object element) {
        int position = 1 + table.len();
        table.rawset(KahluaUtil.toDouble(position), element);
    }

    public static void insert(KahluaThread state, KahluaTable table, int position, Object element) {
        int len;
        for (int i = len = table.len(); i >= position; --i) {
            state.tableSet(table, KahluaUtil.toDouble(i + 1), state.tableGet(table, KahluaUtil.toDouble(i)));
        }
        state.tableSet(table, KahluaUtil.toDouble(position), element);
    }

    public static void rawinsert(KahluaTable table, int position, Object element) {
        int len = table.len();
        if (position <= len) {
            Double dest = KahluaUtil.toDouble(len + 1);
            for (int i = len; i >= position; --i) {
                Double src = KahluaUtil.toDouble(i);
                table.rawset(dest, table.rawget(src));
                dest = src;
            }
            table.rawset(dest, element);
        } else {
            table.rawset(KahluaUtil.toDouble(position), element);
        }
    }

    private static int insert(LuaCallFrame callFrame, int nArguments) {
        Object elem;
        KahluaUtil.luaAssert(nArguments >= 2, "Not enough arguments");
        KahluaTable t = (KahluaTable)callFrame.get(0);
        int pos = t.len() + 1;
        if (nArguments > 2) {
            pos = KahluaUtil.rawTonumber(callFrame.get(1)).intValue();
            elem = callFrame.get(2);
        } else {
            elem = callFrame.get(1);
        }
        TableLib.insert(callFrame.getThread(), t, pos, elem);
        return 0;
    }

    public static Object remove(KahluaThread state, KahluaTable table) {
        return TableLib.remove(state, table, table.len());
    }

    public static Object remove(KahluaThread thread, KahluaTable table, int position) {
        Object ret = thread.tableGet(table, KahluaUtil.toDouble(position));
        int len = table.len();
        for (int i = position; i < len; ++i) {
            thread.tableSet(table, KahluaUtil.toDouble(i), thread.tableGet(table, KahluaUtil.toDouble(i + 1)));
        }
        thread.tableSet(table, KahluaUtil.toDouble(len), null);
        return ret;
    }

    private static int remove(LuaCallFrame callFrame, int nArguments) {
        KahluaTable t = TableLib.getTable(callFrame, nArguments);
        int pos = t.len();
        if (nArguments > 1) {
            pos = KahluaUtil.rawTonumber(callFrame.get(1)).intValue();
        }
        callFrame.push(TableLib.remove(callFrame.getThread(), t, pos));
        return 1;
    }

    public static Object rawremove(KahluaTable table, int position) {
        Object ret = table.rawget(KahluaUtil.toDouble(position));
        int len = table.len();
        for (int i = position; i <= len; ++i) {
            table.rawset(KahluaUtil.toDouble(i), table.rawget(KahluaUtil.toDouble(i + 1)));
        }
        return ret;
    }

    private static KahluaTable getTable(LuaCallFrame callFrame, int nArguments) {
        KahluaUtil.luaAssert(nArguments >= 1, "expected table, got no arguments");
        KahluaTable t = (KahluaTable)callFrame.get(0);
        return t;
    }

    public static void removeItem(KahluaTable table, Object item) {
        if (item == null) {
            return;
        }
        KahluaTableIterator it = table.iterator();
        while (it.advance()) {
            Object key = it.getKey();
            if (!item.equals(it.getValue())) continue;
            if (key instanceof Double) {
                int i;
                double k = (Double)key;
                if (k == (double)(i = (int)k)) {
                    TableLib.rawremove(table, i);
                }
            } else {
                table.rawset(key, null);
            }
            return;
        }
    }

    public static Object find(KahluaTable table, Object item) {
        if (item == null) {
            return null;
        }
        KahluaTableIterator i = table.iterator();
        while (i.advance()) {
            if (!item.equals(i.getValue())) continue;
            return i.getKey();
        }
        return null;
    }

    public static boolean contains(KahluaTable table, Object item) {
        return TableLib.find(table, item) != null;
    }

    static {
        TableLib.names[0] = "concat";
        TableLib.names[1] = "insert";
        TableLib.names[2] = "remove";
        TableLib.names[3] = "newarray";
        TableLib.names[4] = "pairs";
        TableLib.names[5] = "isempty";
        TableLib.names[6] = "wipe";
        functions = new TableLib[7];
        for (int i = 0; i < 7; ++i) {
            TableLib.functions[i] = new TableLib(i);
        }
    }
}

