/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.profiler;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lc.repack.se.krka.kahlua.profiler.StacktraceCounter;
import lc.repack.se.krka.kahlua.profiler.StacktraceElement;

public class StacktraceNode {
    private final long time;
    private final StacktraceElement element;
    private final List<StacktraceNode> children;

    public StacktraceNode(StacktraceElement element, List<StacktraceNode> children, long time) {
        this.element = element;
        this.children = children;
        this.time = time;
    }

    public static StacktraceNode createFrom(StacktraceCounter counter, StacktraceElement element, int maxDepth, double minTimeRatio, int maxChildren) {
        StacktraceNode returnValue = new StacktraceNode(element, new ArrayList<StacktraceNode>(), counter.getTime());
        if (maxDepth > 0) {
            Map<StacktraceElement, StacktraceCounter> map = counter.getChildren();
            ArrayList<Map.Entry<StacktraceElement, StacktraceCounter>> childArray = new ArrayList<Map.Entry<StacktraceElement, StacktraceCounter>>(map.entrySet());
            Collections.sort(childArray, new Comparator<Map.Entry<StacktraceElement, StacktraceCounter>>(){

                @Override
                public int compare(Map.Entry<StacktraceElement, StacktraceCounter> o1, Map.Entry<StacktraceElement, StacktraceCounter> o2) {
                    return Long.signum(o2.getValue().getTime() - o1.getValue().getTime());
                }
            });
            for (int i = childArray.size() - 1; i >= maxChildren; --i) {
                childArray.remove(i);
            }
            for (Map.Entry entry : childArray) {
                StacktraceElement e = (StacktraceElement)entry.getKey();
                StacktraceCounter childCounter = (StacktraceCounter)entry.getValue();
                if (!((double)childCounter.getTime() >= minTimeRatio * (double)counter.getTime())) continue;
                StacktraceNode childNode = StacktraceNode.createFrom(childCounter, e, maxDepth - 1, minTimeRatio, maxChildren);
                returnValue.children.add(childNode);
            }
        }
        return returnValue;
    }

    public void output(PrintWriter writer) {
        this.output(writer, "", this.time, this.time);
    }

    public void output(PrintWriter writer, String indent, long parentTime, long rootTime) {
        writer.println(String.format("%-40s   %4d ms   %5.1f%% of parent    %5.1f%% of total", indent + this.element.name() + " (" + this.element.type() + ")", this.time, 100.0 * (double)this.time / (double)parentTime, 100.0 * (double)this.time / (double)rootTime));
        String nextIndent = indent + "  ";
        for (StacktraceNode child : this.children) {
            child.output(writer, nextIndent, this.time, rootTime);
        }
    }
}

