/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.profiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import lc.repack.se.krka.kahlua.profiler.JavaStacktraceElement;
import lc.repack.se.krka.kahlua.profiler.LuaStacktraceElement;
import lc.repack.se.krka.kahlua.profiler.Profiler;
import lc.repack.se.krka.kahlua.profiler.Sample;
import lc.repack.se.krka.kahlua.profiler.StacktraceElement;
import lc.repack.se.krka.kahlua.vm.Coroutine;
import lc.repack.se.krka.kahlua.vm.JavaFunction;
import lc.repack.se.krka.kahlua.vm.KahluaThread;
import lc.repack.se.krka.kahlua.vm.LuaCallFrame;
import lc.repack.se.krka.kahlua.vm.LuaClosure;

public class Sampler {
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    private final KahluaThread thread;
    private final Timer timer;
    private final long period;
    private final Profiler profiler;

    public Sampler(KahluaThread thread, long period, Profiler profiler) {
        this.thread = thread;
        this.period = period;
        this.profiler = profiler;
        this.timer = new Timer("Kahlua Sampler-" + NEXT_ID.incrementAndGet(), true);
    }

    public void start() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ArrayList<StacktraceElement> list = new ArrayList<StacktraceElement>();
                Sampler.this.appendList(list, ((Sampler)Sampler.this).thread.currentCoroutine);
                Sampler.this.profiler.getSample(new Sample(list, Sampler.this.period));
            }
        };
        this.timer.scheduleAtFixedRate(timerTask, 0L, this.period);
    }

    private void appendList(List<StacktraceElement> list, Coroutine coroutine) {
        while (coroutine != null) {
            LuaCallFrame[] stack = coroutine.getCallframeStack();
            int top = Math.min(stack.length, coroutine.getCallframeTop());
            for (int i = top - 1; i >= 0; --i) {
                LuaCallFrame frame = stack[i];
                int pc = frame.pc - 1;
                LuaClosure closure = frame.closure;
                JavaFunction javaFunction = frame.javaFunction;
                if (closure != null) {
                    list.add(new LuaStacktraceElement(pc, closure.prototype));
                    continue;
                }
                if (javaFunction == null) continue;
                list.add(new JavaStacktraceElement(javaFunction));
            }
            coroutine = coroutine.getParent();
        }
    }

    public void stop() {
        this.timer.cancel();
    }
}

