/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.profiler;

import lc.repack.se.krka.kahlua.profiler.FakeStacktraceElement;
import lc.repack.se.krka.kahlua.profiler.Profiler;
import lc.repack.se.krka.kahlua.profiler.Sample;
import lc.repack.se.krka.kahlua.profiler.StacktraceCounter;
import lc.repack.se.krka.kahlua.profiler.StacktraceElement;
import lc.repack.se.krka.kahlua.profiler.StacktraceNode;

public class AggregatingProfiler
implements Profiler {
    private final StacktraceCounter root = new StacktraceCounter();

    @Override
    public synchronized void getSample(Sample sample) {
        this.root.addTime(sample.getTime());
        StacktraceCounter counter = this.root;
        for (int n = sample.getList().size() - 1; n >= 0; --n) {
            StacktraceElement childElement = sample.getList().get(n);
            StacktraceCounter childCounter = counter.getOrCreateChild(childElement);
            childCounter.addTime(sample.getTime());
            counter = childCounter;
        }
    }

    public StacktraceNode toTree(int maxDepth, double minTimeRatio, int maxChildren) {
        return StacktraceNode.createFrom(this.root, new FakeStacktraceElement("Root", "root"), maxDepth, minTimeRatio, maxChildren);
    }
}

