/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.j2se;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import lc.repack.se.krka.kahlua.j2se.KahluaTableImpl;
import lc.repack.se.krka.kahlua.j2se.MathLib;
import lc.repack.se.krka.kahlua.luaj.compiler.LuaCompiler;
import lc.repack.se.krka.kahlua.stdlib.BaseLib;
import lc.repack.se.krka.kahlua.stdlib.CoroutineLib;
import lc.repack.se.krka.kahlua.stdlib.OsLib;
import lc.repack.se.krka.kahlua.stdlib.RandomLib;
import lc.repack.se.krka.kahlua.stdlib.StringLib;
import lc.repack.se.krka.kahlua.stdlib.TableLib;
import lc.repack.se.krka.kahlua.test.UserdataArray;
import lc.repack.se.krka.kahlua.threading.BlockingKahluaThread;
import lc.repack.se.krka.kahlua.vm.KahluaTable;
import lc.repack.se.krka.kahlua.vm.KahluaThread;
import lc.repack.se.krka.kahlua.vm.KahluaUtil;
import lc.repack.se.krka.kahlua.vm.LuaClosure;
import lc.repack.se.krka.kahlua.vm.Platform;

public class J2SEPlatform
implements Platform {
    private static J2SEPlatform INSTANCE = new J2SEPlatform();

    public static J2SEPlatform getInstance() {
        return INSTANCE;
    }

    @Override
    public double pow(double x, double y) {
        return Math.pow(x, y);
    }

    @Override
    public KahluaTable newTable() {
        return new KahluaTableImpl(new ConcurrentHashMap<Object, Object>());
    }

    @Override
    public KahluaTable newEnvironment() {
        KahluaTable env = this.newTable();
        this.setupEnvironment(env);
        return env;
    }

    @Override
    public void setupEnvironment(KahluaTable env) {
        env.wipe();
        env.rawset("_G", (Object)env);
        env.rawset("_VERSION", (Object)"Kahlua kahlua.major.kahlua.minor.kahlua.fix for Lua lua.version (J2SE)");
        MathLib.register(this, env);
        BaseLib.register(env);
        RandomLib.register(this, env);
        UserdataArray.register(this, env);
        StringLib.register(this, env);
        CoroutineLib.register(this, env);
        OsLib.register(this, env);
        TableLib.register(this, env);
        LuaCompiler.register(env);
        KahluaThread workerThread = this.setupWorkerThread(env);
        KahluaUtil.setupLibrary(env, workerThread, "/stdlib");
        try {
            LuaClosure closure = LuaCompiler.loadis(this.getClass().getResourceAsStream("/serialize.lua"), "serialize.lua", env);
            workerThread.call(closure, null, null, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private KahluaThread setupWorkerThread(KahluaTable env) {
        BlockingKahluaThread thread = new BlockingKahluaThread(this, env);
        KahluaUtil.setWorkerThread(env, thread);
        return thread;
    }
}

