/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.integration.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lc.repack.se.krka.kahlua.integration.annotations.LuaConstructor;
import lc.repack.se.krka.kahlua.integration.annotations.LuaMethod;
import lc.repack.se.krka.kahlua.integration.processor.ClassParameterInformation;
import lc.repack.se.krka.kahlua.integration.processor.DescriptorUtil;
import lc.repack.se.krka.kahlua.integration.processor.MethodParameterInformation;

public class LuaDebugDataProcessor
implements Processor,
ElementVisitor<Void, Void> {
    private HashMap<String, ClassParameterInformation> classes;
    private Filer filer;

    @Override
    public Iterable<? extends Completion> getCompletions(Element arg0, AnnotationMirror arg1, ExecutableElement arg2, String arg3) {
        return new HashSet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(LuaMethod.class.getName());
        hashSet.add(LuaConstructor.class.getName());
        return hashSet;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public void init(ProcessingEnvironment arg0) {
        this.filer = arg0.getFiler();
        this.classes = new HashMap();
    }

    @Override
    public boolean process(Set<? extends TypeElement> arg0, RoundEnvironment arg1) {
        for (TypeElement typeElement : arg0) {
            Set<? extends Element> set = arg1.getElementsAnnotatedWith(typeElement);
            for (Element element : set) {
                element.accept(this, null);
            }
        }
        if (arg1.processingOver()) {
            try {
                this.store();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public Void visit(Element arg0) {
        return null;
    }

    @Override
    public Void visit(Element arg0, Void arg1) {
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement element, Void arg1) {
        String className = this.findClass(element);
        String packageName = this.findPackage(element);
        ClassParameterInformation classParameterInfo = this.getOrCreate(this.classes, className, packageName, this.findSimpleClassName(element));
        String methodName = element.getSimpleName().toString();
        String descriptor = DescriptorUtil.getDescriptor(methodName, element.getParameters());
        ArrayList<String> parameterInfoList = new ArrayList<String>();
        for (VariableElement variableElement : element.getParameters()) {
            parameterInfoList.add(variableElement.getSimpleName().toString());
        }
        MethodParameterInformation methodInfo = new MethodParameterInformation(parameterInfoList);
        classParameterInfo.methods.put(descriptor, methodInfo);
        return null;
    }

    private ClassParameterInformation getOrCreate(HashMap<String, ClassParameterInformation> classes, String className, String packageName, String simpleClassName) {
        ClassParameterInformation value = classes.get(className);
        if (value == null) {
            value = new ClassParameterInformation(packageName, simpleClassName);
            classes.put(className, value);
        }
        return value;
    }

    private String findClass(Element arg0) {
        if (arg0.getKind() == ElementKind.CLASS) {
            return arg0.toString();
        }
        return this.findClass(arg0.getEnclosingElement());
    }

    private String findSimpleClassName(Element arg0) {
        if (arg0.getKind() == ElementKind.CLASS) {
            String simpleName = arg0.getSimpleName().toString();
            if (arg0.getEnclosingElement().getKind() == ElementKind.CLASS) {
                return this.findSimpleClassName(arg0.getEnclosingElement()) + "_" + simpleName;
            }
            return simpleName;
        }
        return this.findSimpleClassName(arg0.getEnclosingElement());
    }

    private String findPackage(Element arg0) {
        if (arg0.getKind() == ElementKind.PACKAGE) {
            return arg0.toString();
        }
        return this.findPackage(arg0.getEnclosingElement());
    }

    @Override
    public Void visitPackage(PackageElement arg0, Void arg1) {
        return null;
    }

    @Override
    public Void visitType(TypeElement arg0, Void arg1) {
        return null;
    }

    @Override
    public Void visitVariable(VariableElement e, Void aVoid) {
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterElement arg0, Void arg1) {
        return null;
    }

    @Override
    public Void visitUnknown(Element arg0, Void arg1) {
        return null;
    }

    private void store() throws IOException {
        for (Map.Entry<String, ClassParameterInformation> entry : this.classes.entrySet()) {
            ClassParameterInformation classParameterInfo = entry.getValue();
            Element[] elements = null;
            FileObject fileObject = this.filer.createResource(StandardLocation.CLASS_OUTPUT, classParameterInfo.getPackageName(), classParameterInfo.getSimpleClassName() + ".luadebugdata", elements);
            OutputStream stream = fileObject.openOutputStream();
            classParameterInfo.saveToStream(stream);
            stream.close();
        }
    }
}

