/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.integration.expose.caller;

import lc.repack.se.krka.kahlua.integration.expose.ReturnValues;
import lc.repack.se.krka.kahlua.integration.expose.caller.Caller;

public abstract class AbstractCaller
implements Caller {
    protected final Class<?>[] parameters;
    protected final boolean needsMultipleReturnValues;
    protected final Class<?> varargType;

    protected AbstractCaller(Class<?>[] parameters) {
        boolean needsMultipleReturnValues = false;
        Class<?> varargType = null;
        if (parameters.length > 0) {
            Class<?> lastType;
            Class<?> firstType = parameters[0];
            if (firstType == ReturnValues.class) {
                needsMultipleReturnValues = true;
            }
            if ((lastType = parameters[parameters.length - 1]).isArray()) {
                varargType = lastType.getComponentType();
            }
        }
        this.needsMultipleReturnValues = needsMultipleReturnValues;
        this.varargType = varargType;
        int from = needsMultipleReturnValues ? 1 : 0;
        int to = parameters.length - (varargType == null ? 0 : 1);
        int len = to - from;
        this.parameters = new Class[len];
        System.arraycopy(parameters, from, this.parameters, 0, len);
    }

    @Override
    public final Class<?>[] getParameterTypes() {
        return this.parameters;
    }

    @Override
    public final Class<?> getVarargType() {
        return this.varargType;
    }

    @Override
    public final boolean hasVararg() {
        return this.varargType != null;
    }

    @Override
    public final boolean needsMultipleReturnValues() {
        return this.needsMultipleReturnValues;
    }
}

