/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.integration.expose;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lc.repack.se.krka.kahlua.integration.expose.LuaJavaInvoker;
import lc.repack.se.krka.kahlua.integration.expose.MethodArguments;
import lc.repack.se.krka.kahlua.vm.JavaFunction;
import lc.repack.se.krka.kahlua.vm.LuaCallFrame;

public class MultiLuaJavaInvoker
implements JavaFunction {
    private final List<LuaJavaInvoker> invokers = new ArrayList<LuaJavaInvoker>();
    private static final Comparator<? super LuaJavaInvoker> COMPARATOR = new Comparator<LuaJavaInvoker>(){

        @Override
        public int compare(LuaJavaInvoker o1, LuaJavaInvoker o2) {
            return o2.getNumMethodParams() - o1.getNumMethodParams();
        }
    };

    @Override
    public int call(LuaCallFrame callFrame, int nArguments) {
        MethodArguments methodArguments = null;
        for (LuaJavaInvoker invoker : this.invokers) {
            methodArguments = invoker.prepareCall(callFrame, nArguments);
            if (!methodArguments.isValid()) continue;
            return invoker.call(methodArguments);
        }
        if (methodArguments != null) {
            methodArguments.assertValid();
        }
        throw new RuntimeException("No implementation found");
    }

    public void addInvoker(LuaJavaInvoker invoker) {
        if (!this.invokers.contains(invoker)) {
            this.invokers.add(invoker);
            Collections.sort(this.invokers, COMPARATOR);
        }
    }

    public List<LuaJavaInvoker> getInvokers() {
        return this.invokers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiLuaJavaInvoker that = (MultiLuaJavaInvoker)o;
        return this.invokers.equals(that.invokers);
    }

    public int hashCode() {
        return this.invokers.hashCode();
    }
}

