/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.integration.expose;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lc.repack.se.krka.kahlua.converter.KahluaConverterManager;
import lc.repack.se.krka.kahlua.integration.annotations.Desc;
import lc.repack.se.krka.kahlua.integration.annotations.LuaConstructor;
import lc.repack.se.krka.kahlua.integration.annotations.LuaMethod;
import lc.repack.se.krka.kahlua.integration.expose.AnnotationUtil;
import lc.repack.se.krka.kahlua.integration.expose.ClassDebugInformation;
import lc.repack.se.krka.kahlua.integration.expose.LuaJavaInvoker;
import lc.repack.se.krka.kahlua.integration.expose.MethodDebugInformation;
import lc.repack.se.krka.kahlua.integration.expose.MultiLuaJavaInvoker;
import lc.repack.se.krka.kahlua.integration.expose.caller.ConstructorCaller;
import lc.repack.se.krka.kahlua.integration.expose.caller.MethodCaller;
import lc.repack.se.krka.kahlua.integration.processor.ClassParameterInformation;
import lc.repack.se.krka.kahlua.vm.JavaFunction;
import lc.repack.se.krka.kahlua.vm.KahluaTable;
import lc.repack.se.krka.kahlua.vm.KahluaUtil;
import lc.repack.se.krka.kahlua.vm.LuaCallFrame;
import lc.repack.se.krka.kahlua.vm.Platform;

public class LuaJavaClassExposer {
    private static final Object DEBUGINFO_KEY = new Object();
    private final KahluaConverterManager manager;
    private final Platform platform;
    private final KahluaTable environment;
    private final KahluaTable classMetatables;
    private final Set<Type> visitedTypes = new HashSet<Type>();
    private final KahluaTable autoExposeBase;
    private final Map<Class<?>, Boolean> shouldExposeCache = new HashMap();

    public LuaJavaClassExposer(KahluaConverterManager manager, Platform platform, KahluaTable environment) {
        this(manager, platform, environment, null);
    }

    public LuaJavaClassExposer(KahluaConverterManager manager, Platform platform, KahluaTable environment, KahluaTable autoExposeBase) {
        this.manager = manager;
        this.platform = platform;
        this.environment = environment;
        this.autoExposeBase = autoExposeBase;
        this.classMetatables = KahluaUtil.getClassMetatables(platform, environment);
        if (this.classMetatables.getMetatable() == null) {
            KahluaTable mt = platform.newTable();
            mt.rawset("__index", (Object)new JavaFunction(){

                @Override
                public int call(LuaCallFrame callFrame, int nArguments) {
                    Object t = callFrame.get(0);
                    Object key = callFrame.get(1);
                    if (t != LuaJavaClassExposer.this.classMetatables) {
                        throw new IllegalArgumentException("Expected classmetatables as the first argument to __index");
                    }
                    if (key == null || !(key instanceof Class)) {
                        return callFrame.pushNil();
                    }
                    Class clazz = (Class)key;
                    if (!LuaJavaClassExposer.this.isExposed(clazz) && LuaJavaClassExposer.this.shouldExpose(clazz)) {
                        LuaJavaClassExposer.this.exposeClass(clazz);
                        return callFrame.push(LuaJavaClassExposer.this.classMetatables.rawget(clazz));
                    }
                    return callFrame.pushNil();
                }
            });
            this.classMetatables.setMetatable(mt);
        }
    }

    public Map<Class<?>, ClassDebugInformation> getClassDebugInformation() {
        HashMap classMap = this.environment.rawget(DEBUGINFO_KEY);
        if (classMap == null || !(classMap instanceof Map)) {
            classMap = new HashMap();
            this.environment.rawset(DEBUGINFO_KEY, classMap);
        }
        return classMap;
    }

    public void exposeClass(Class<?> clazz) {
        if (clazz != null && !this.isExposed(clazz)) {
            this.shouldExposeCache.clear();
            this.readDebugData(clazz);
            this.setupMetaTables(clazz);
            this.populateMethods(clazz);
        }
    }

    public void exposeClassUsingJavaEquals(Class<?> clazz) {
        this.exposeClass(clazz);
        this.addJavaEquals(this.getMetaTable(clazz));
    }

    private KahluaTable getMetaTable(Class<?> clazz) {
        return (KahluaTable)this.classMetatables.rawget(clazz);
    }

    private KahluaTable getIndexTable(KahluaTable metaTable) {
        if (metaTable == null) {
            return null;
        }
        Object indexObject = metaTable.rawget("__index");
        if (indexObject == null) {
            return null;
        }
        if (indexObject instanceof KahluaTable) {
            return (KahluaTable)indexObject;
        }
        return null;
    }

    public void exposeGlobalObjectFunction(KahluaTable environment, Object owner, Method method) {
        this.exposeGlobalObjectFunction(environment, owner, method, method.getName());
    }

    public void exposeGlobalObjectFunction(KahluaTable environment, Object owner, Method method, String methodName) {
        Class<?> clazz = owner.getClass();
        this.readDebugData(clazz);
        LuaJavaInvoker invoker = this.getMethodInvoker(clazz, method, methodName, owner, false);
        this.addInvoker(environment, methodName, invoker);
    }

    public void exposeGlobalClassFunction(KahluaTable environment, Class<?> clazz, Constructor<?> constructor, String methodName) {
        this.readDebugData(clazz);
        LuaJavaInvoker invoker = this.getConstructorInvoker(clazz, constructor, methodName);
        this.addInvoker(environment, methodName, invoker);
    }

    private LuaJavaInvoker getMethodInvoker(Class<?> clazz, Method method, String methodName, Object owner, boolean hasSelf) {
        return new LuaJavaInvoker(this, this.manager, clazz, methodName, new MethodCaller(method, owner, hasSelf));
    }

    private LuaJavaInvoker getConstructorInvoker(Class<?> clazz, Constructor<?> constructor, String methodName) {
        return new LuaJavaInvoker(this, this.manager, clazz, methodName, new ConstructorCaller(constructor));
    }

    private LuaJavaInvoker getMethodInvoker(Class<?> clazz, Method method, String methodName) {
        return this.getMethodInvoker(clazz, method, methodName, null, true);
    }

    private LuaJavaInvoker getGlobalInvoker(Class<?> clazz, Method method, String methodName) {
        return this.getMethodInvoker(clazz, method, methodName, null, false);
    }

    public void exposeGlobalClassFunction(KahluaTable environment, Class<?> clazz, Method method, String methodName) {
        this.readDebugData(clazz);
        if (Modifier.isStatic(method.getModifiers())) {
            this.addInvoker(environment, methodName, this.getGlobalInvoker(clazz, method, methodName));
        }
    }

    public void exposeMethod(Class<?> clazz, Method method) {
        this.exposeMethod(clazz, method, method.getName());
    }

    public void exposeMethod(Class<?> clazz, Method method, String methodName) {
        this.readDebugData(clazz);
        if (!this.isExposed(clazz)) {
            this.setupMetaTables(clazz);
        }
        KahluaTable metaTable = this.getMetaTable(clazz);
        KahluaTable indexTable = this.getIndexTable(metaTable);
        LuaJavaInvoker newInvoker = this.getMethodInvoker(clazz, method, methodName);
        this.addInvoker(indexTable, methodName, newInvoker);
    }

    private void addInvoker(KahluaTable indexTable, String methodName, LuaJavaInvoker invoker) {
        Object current = indexTable.rawget(methodName);
        if (current != null) {
            if (current instanceof LuaJavaInvoker) {
                if (current.equals(invoker)) {
                    return;
                }
                MultiLuaJavaInvoker multiInvoker = new MultiLuaJavaInvoker();
                multiInvoker.addInvoker((LuaJavaInvoker)current);
                multiInvoker.addInvoker(invoker);
                indexTable.rawset(methodName, (Object)multiInvoker);
            } else if (current instanceof MultiLuaJavaInvoker) {
                ((MultiLuaJavaInvoker)current).addInvoker(invoker);
            }
        } else {
            indexTable.rawset(methodName, (Object)invoker);
        }
    }

    public boolean shouldExpose(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        Boolean bool = this.shouldExposeCache.get(clazz);
        if (bool != null) {
            return bool;
        }
        if (this.autoExposeBase != null) {
            this.exposeLikeJavaRecursively(clazz, this.autoExposeBase);
            return true;
        }
        if (this.isExposed(clazz)) {
            this.shouldExposeCache.put(clazz, Boolean.TRUE);
            return true;
        }
        if (this.shouldExpose(clazz.getSuperclass())) {
            this.shouldExposeCache.put(clazz, Boolean.TRUE);
            return true;
        }
        for (Class<?> sub : clazz.getInterfaces()) {
            if (!this.shouldExpose(sub)) continue;
            this.shouldExposeCache.put(clazz, Boolean.TRUE);
            return true;
        }
        this.shouldExposeCache.put(clazz, Boolean.FALSE);
        return false;
    }

    private void setupMetaTables(Class<?> clazz) {
        Class<?> superClazz = clazz.getSuperclass();
        this.exposeClass(superClazz);
        KahluaTable superMetaTable = this.getMetaTable(superClazz);
        KahluaTable metatable = this.platform.newTable();
        KahluaTable indexTable = this.platform.newTable();
        metatable.rawset("__index", (Object)indexTable);
        if (superMetaTable != null) {
            metatable.rawset("__newindex", superMetaTable.rawget("__newindex"));
        }
        indexTable.setMetatable(superMetaTable);
        this.classMetatables.rawset(clazz, (Object)metatable);
    }

    private void addJavaEquals(KahluaTable metatable) {
        metatable.rawset("__eq", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame callFrame, int nArguments) {
                boolean equals = callFrame.get(0).equals(callFrame.get(1));
                callFrame.push(equals);
                return 1;
            }
        });
    }

    public void exposeGlobalFunctions(Object object) {
        Class<?> clazz = object.getClass();
        this.readDebugData(clazz);
        for (Method method : clazz.getMethods()) {
            LuaMethod luaMethod = AnnotationUtil.getAnnotation(method, LuaMethod.class);
            if (luaMethod == null) continue;
            String methodName = luaMethod.name().equals("") ? method.getName() : luaMethod.name();
            if (!luaMethod.global()) continue;
            this.exposeGlobalObjectFunction(this.environment, object, method, methodName);
        }
    }

    public void exposeLikeJava(Class clazz) {
        this.exposeLikeJava(clazz, this.autoExposeBase);
    }

    public void exposeLikeJava(Class clazz, KahluaTable staticBase) {
        if (clazz == null || this.isExposed(clazz)) {
            return;
        }
        this.setupMetaTables(clazz);
        this.exposeMethods(clazz);
        if (!(clazz.isSynthetic() || clazz.isAnonymousClass() || clazz.isPrimitive() || Proxy.isProxyClass(clazz) || clazz.getSimpleName().startsWith("$"))) {
            this.exposeStatics(clazz, staticBase);
        }
    }

    private void exposeStatics(Class clazz, KahluaTable staticBase) {
        String name;
        String[] packageStructure = clazz.getName().split("\\.");
        KahluaTable container = this.createTableStructure(staticBase, packageStructure);
        container.rawset("class", (Object)clazz);
        if (staticBase.rawget(clazz.getSimpleName()) == null) {
            staticBase.rawset(clazz.getSimpleName(), (Object)container);
        }
        for (Method method : clazz.getMethods()) {
            name = method.getName();
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            this.exposeGlobalClassFunction(container, clazz, method, name);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            name = ((Field)accessibleObject).getName();
            if (!Modifier.isPublic(((Field)accessibleObject).getModifiers()) || !Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            try {
                container.rawset(name, ((Field)accessibleObject).get(clazz));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : clazz.getConstructors()) {
            int modifiers = ((Constructor)accessibleObject).getModifiers();
            if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers)) continue;
            this.addInvoker(container, "new", this.getConstructorInvoker(clazz, (Constructor<?>)accessibleObject, "new"));
        }
    }

    private void exposeMethods(Class clazz) {
        for (Method method : clazz.getMethods()) {
            String name = method.getName();
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            this.exposeMethod(clazz, method, name);
        }
    }

    private KahluaTable createTableStructure(KahluaTable base, String[] structure) {
        for (String s : structure) {
            base = KahluaUtil.getOrCreateTable(this.platform, base, s);
        }
        return base;
    }

    private void populateMethods(Class<?> clazz) {
        String methodName;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            LuaConstructor annotation = constructor.getAnnotation(LuaConstructor.class);
            if (annotation == null) continue;
            methodName = annotation.name();
            this.exposeGlobalClassFunction(this.environment, clazz, constructor, methodName);
        }
        for (Executable executable : clazz.getMethods()) {
            LuaMethod luaMethod = AnnotationUtil.getAnnotation((Method)executable, LuaMethod.class);
            if (luaMethod == null) continue;
            methodName = luaMethod.name().equals("") ? ((Method)executable).getName() : luaMethod.name();
            if (luaMethod.global()) {
                if (!Modifier.isStatic(((Method)executable).getModifiers())) continue;
                this.exposeGlobalClassFunction(this.environment, clazz, (Method)executable, methodName);
                continue;
            }
            this.exposeMethod(clazz, (Method)executable, methodName);
        }
    }

    public boolean isExposed(Class<?> clazz) {
        return clazz != null && this.getMetaTable(clazz) != null;
    }

    ClassDebugInformation getDebugdata(Class<?> clazz) {
        return this.getClassDebugInformation().get(clazz);
    }

    private void readDebugData(Class<?> clazz) {
        if (this.getDebugdata(clazz) == null) {
            ClassParameterInformation parameterInfo = null;
            try {
                parameterInfo = ClassParameterInformation.getFromStream(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (parameterInfo == null) {
                parameterInfo = new ClassParameterInformation(clazz);
            }
            ClassDebugInformation debugInfo = new ClassDebugInformation(clazz, parameterInfo);
            Map<Class<?>, ClassDebugInformation> information = this.getClassDebugInformation();
            information.put(clazz, debugInfo);
        }
    }

    @LuaMethod(global=true, name="definition")
    @Desc(value="returns a string that describes the object")
    public String getDefinition(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LuaJavaInvoker) {
            MethodDebugInformation data = ((LuaJavaInvoker)obj).getMethodDebugData();
            return data.toString();
        }
        if (obj instanceof MultiLuaJavaInvoker) {
            StringBuilder builder = new StringBuilder();
            for (LuaJavaInvoker invoker : ((MultiLuaJavaInvoker)obj).getInvokers()) {
                builder.append(invoker.getMethodDebugData().toString());
            }
            return builder.toString();
        }
        return KahluaUtil.tostring(obj, KahluaUtil.getWorkerThread(this.platform, this.environment));
    }

    public void exposeLikeJavaRecursively(Type type) {
        this.exposeLikeJavaRecursively(type, this.autoExposeBase);
    }

    public void exposeLikeJavaRecursively(Type type, KahluaTable staticBase) {
        this.exposeLikeJava(staticBase, this.visitedTypes, type);
    }

    private void exposeLikeJava(KahluaTable staticBase, Set<Type> visited, Type type) {
        if (type == null) {
            return;
        }
        if (visited.contains(type)) {
            return;
        }
        visited.add(type);
        if (type instanceof Class) {
            this.exposeLikeJavaByClass(staticBase, visited, (Class)type);
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            this.exposeList(staticBase, visited, wildcardType.getLowerBounds());
            this.exposeList(staticBase, visited, wildcardType.getUpperBounds());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.exposeLikeJava(staticBase, visited, parameterizedType.getRawType());
            this.exposeLikeJava(staticBase, visited, parameterizedType.getOwnerType());
            this.exposeList(staticBase, visited, parameterizedType.getActualTypeArguments());
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            this.exposeList(staticBase, visited, typeVariable.getBounds());
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            this.exposeLikeJava(staticBase, visited, genericArrayType.getGenericComponentType());
        }
    }

    private void exposeList(KahluaTable staticBase, Set<Type> visited, Type[] types) {
        for (Type t : types) {
            this.exposeLikeJava(staticBase, visited, t);
        }
    }

    private void exposeLikeJavaByClass(KahluaTable staticBase, Set<Type> visited, Class<?> clazz) {
        this.exposeList(staticBase, visited, clazz.getInterfaces());
        this.exposeLikeJava(staticBase, visited, clazz.getGenericSuperclass());
        if (clazz.isArray()) {
            this.exposeLikeJavaByClass(staticBase, visited, clazz.getComponentType());
        } else {
            this.exposeLikeJava(clazz, staticBase);
        }
        for (Method method : clazz.getDeclaredMethods()) {
            this.exposeList(staticBase, visited, method.getGenericParameterTypes());
            this.exposeList(staticBase, visited, method.getGenericExceptionTypes());
            this.exposeLikeJava(staticBase, visited, method.getGenericReturnType());
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            this.exposeLikeJava(staticBase, visited, ((Field)accessibleObject).getGenericType());
        }
        for (AccessibleObject accessibleObject : clazz.getConstructors()) {
            this.exposeList(staticBase, visited, ((Constructor)accessibleObject).getParameterTypes());
            this.exposeList(staticBase, visited, ((Constructor)accessibleObject).getExceptionTypes());
        }
    }
}

