/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.converter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lc.repack.se.krka.kahlua.converter.JavaToLuaConverter;
import lc.repack.se.krka.kahlua.converter.KahluaConverterManager;
import lc.repack.se.krka.kahlua.converter.LuaToJavaConverter;
import lc.repack.se.krka.kahlua.vm.KahluaTable;
import lc.repack.se.krka.kahlua.vm.KahluaTableIterator;
import lc.repack.se.krka.kahlua.vm.Platform;

public class KahluaTableConverter {
    private final Platform platform;

    public KahluaTableConverter(Platform platform) {
        this.platform = platform;
    }

    public void install(final KahluaConverterManager manager) {
        manager.addJavaConverter(new CollectionToLuaConverter<Collection>(manager, Collection.class));
        manager.addLuaConverter(new CollectionToJavaConverter(Collection.class));
        manager.addJavaConverter(new JavaToLuaConverter<Map>(){

            @Override
            public Object fromJavaToLua(Map javaObject) {
                Map map = javaObject;
                KahluaTable t = KahluaTableConverter.this.platform.newTable();
                for (Map.Entry entry : map.entrySet()) {
                    Object key = manager.fromJavaToLua(entry.getKey());
                    Object value = manager.fromJavaToLua(entry.getValue());
                    t.rawset(key, value);
                }
                return t;
            }

            @Override
            public Class<Map> getJavaType() {
                return Map.class;
            }
        });
        manager.addLuaConverter(new LuaToJavaConverter<KahluaTable, Map>(){

            @Override
            public Map fromLuaToJava(KahluaTable luaObject, Class<Map> javaClass) throws IllegalArgumentException {
                KahluaTableIterator iterator = luaObject.iterator();
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                while (iterator.advance()) {
                    Object key = iterator.getKey();
                    Object value = iterator.getValue();
                    map.put(key, value);
                }
                return map;
            }

            @Override
            public Class<Map> getJavaType() {
                return Map.class;
            }

            @Override
            public Class<KahluaTable> getLuaType() {
                return KahluaTable.class;
            }
        });
        manager.addJavaConverter(new JavaToLuaConverter<Object>(){

            @Override
            public Object fromJavaToLua(Object javaObject) {
                if (javaObject.getClass().isArray()) {
                    KahluaTable t = KahluaTableConverter.this.platform.newTable();
                    int n = Array.getLength(javaObject);
                    for (int i = 0; i < n; ++i) {
                        Object value = Array.get(javaObject, i);
                        t.rawset(i + 1, manager.fromJavaToLua(value));
                    }
                    return t;
                }
                return null;
            }

            @Override
            public Class<Object> getJavaType() {
                return Object.class;
            }
        });
        manager.addLuaConverter(new LuaToJavaConverter<KahluaTable, Object>(){

            @Override
            public Object fromLuaToJava(KahluaTable luaObject, Class<Object> javaClass) throws IllegalArgumentException {
                if (javaClass.isArray()) {
                    List list = manager.fromLuaToJava(luaObject, List.class);
                    return list.toArray();
                }
                return null;
            }

            @Override
            public Class<Object> getJavaType() {
                return Object.class;
            }

            @Override
            public Class<KahluaTable> getLuaType() {
                return KahluaTable.class;
            }
        });
    }

    private static class CollectionToJavaConverter<T>
    implements LuaToJavaConverter<KahluaTable, T> {
        private final Class<T> javaClass;

        private CollectionToJavaConverter(Class<T> javaClass) {
            this.javaClass = javaClass;
        }

        @Override
        public T fromLuaToJava(KahluaTable luaObject, Class<T> javaClass) throws IllegalArgumentException {
            int n = luaObject.len();
            ArrayList<Object> list = new ArrayList<Object>(n);
            for (int i = 1; i <= n; ++i) {
                Object value = luaObject.rawget(i);
                list.add(value);
            }
            return (T)list;
        }

        @Override
        public Class<T> getJavaType() {
            return this.javaClass;
        }

        @Override
        public Class<KahluaTable> getLuaType() {
            return KahluaTable.class;
        }
    }

    private class CollectionToLuaConverter<T extends Iterable>
    implements JavaToLuaConverter<T> {
        private final Class<T> clazz;
        private final KahluaConverterManager manager;

        public CollectionToLuaConverter(KahluaConverterManager manager, Class<T> clazz) {
            this.manager = manager;
            this.clazz = clazz;
        }

        @Override
        public Object fromJavaToLua(T javaObject) {
            KahluaTable t = KahluaTableConverter.this.platform.newTable();
            int i = 0;
            for (Object o : javaObject) {
                t.rawset(++i, this.manager.fromJavaToLua(o));
            }
            return t;
        }

        @Override
        public Class<T> getJavaType() {
            return this.clazz;
        }
    }
}

