/*
 * Decompiled with CFR 0.152.
 */
package lc.repack.se.krka.kahlua.converter;

import lc.repack.se.krka.kahlua.converter.JavaToLuaConverter;
import lc.repack.se.krka.kahlua.converter.KahluaConverterManager;
import lc.repack.se.krka.kahlua.converter.LuaToJavaConverter;

public class KahluaEnumConverter {
    private KahluaEnumConverter() {
    }

    public static void install(KahluaConverterManager manager) {
        manager.addJavaConverter(new JavaToLuaConverter<Enum>(){

            @Override
            public Object fromJavaToLua(Enum javaObject) {
                return javaObject.name();
            }

            @Override
            public Class<Enum> getJavaType() {
                return Enum.class;
            }
        });
        manager.addLuaConverter(new LuaToJavaConverter<String, Enum>(){

            @Override
            public Enum fromLuaToJava(String luaObject, Class<Enum> javaClass) throws IllegalArgumentException {
                return Enum.valueOf(javaClass, luaObject);
            }

            @Override
            public Class<Enum> getJavaType() {
                return Enum.class;
            }

            @Override
            public Class<String> getLuaType() {
                return String.class;
            }
        });
    }
}

